/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.project.ui.notifications;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.CidrWorkspaceBundle;
import com.jetbrains.cidr.lang.daemon.OCFileScopeProvider;
import com.jetbrains.cidr.project.ui.ProjectStatusHelperKt;
import com.jetbrains.cidr.project.ui.notifications.EditorNotificationWarningProvider;
import com.jetbrains.cidr.project.ui.notifications.NotificationType;
import com.jetbrains.cidr.project.ui.notifications.ProjectNotification;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/jetbrains/cidr/project/ui/notifications/DefaultEditorNotificationWarningProvider;", "Lcom/jetbrains/cidr/project/ui/notifications/EditorNotificationWarningProvider;", "()V", "getProjectNotification", "Lcom/jetbrains/cidr/project/ui/notifications/ProjectNotification;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.cidr.workspaceModel"})
public final class DefaultEditorNotificationWarningProvider
implements EditorNotificationWarningProvider {
    @Override
    @Nullable
    public ProjectNotification getProjectNotification(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (ProjectStatusHelperKt.isProjectAwareFile(file, project) && OCFileScopeProvider.Companion.getProjectSourceLocationKind(project, file).isOutProject()) {
            String string = CidrWorkspaceBundle.message("project.status.notification.file.no.project", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return new ProjectNotification(NotificationType.Warning, string);
        }
        return null;
    }
}

