/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.workspace.CidrProjectActivity;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceImpl;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceImplUtilKt;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceInitializationWaiter;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceLoadingWaiter;
import com.jetbrains.cidr.lang.workspace.RunAfterOCWorkspaceIsInitialized;
import com.jetbrains.cidr.lang.workspace.RunAfterOCWorkspaceIsLoaded;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u0001\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\r\u001a\n\u0010\u000e\u001a\u00020\f*\u00020\b\u001a\n\u0010\u000f\u001a\u00020\f*\u00020\b\u001a \u0010\u0010\u001a\u00020\u0006*\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014\u001a \u0010\u0015\u001a\u00020\u0006*\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"INITIALIZED_EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/jetbrains/cidr/lang/workspace/RunAfterOCWorkspaceIsInitialized;", "LOADED_EP_NAME", "Lcom/jetbrains/cidr/lang/workspace/RunAfterOCWorkspaceIsLoaded;", "runCidrActivities", "", "project", "Lcom/intellij/openapi/project/Project;", "epName", "Lcom/jetbrains/cidr/lang/workspace/CidrProjectActivity;", "isNotEmpty", "", "Lcom/jetbrains/cidr/lang/workspace/OCWorkspace;", "isOCWorkspaceInitialized", "isOCWorkspaceNotEmpty", "runWhenOrIfOCWorkspaceIsInitialized", "disposable", "Lcom/intellij/openapi/Disposable;", "block", "Lkotlin/Function0;", "runWhenOrIfOCWorkspaceIsLoaded", "intellij.cidr.projectModel"})
@JvmName(name="OCWorkspaceInitializationUtil")
public final class OCWorkspaceInitializationUtil {
    @NotNull
    private static final ExtensionPointName<RunAfterOCWorkspaceIsInitialized> INITIALIZED_EP_NAME = ExtensionPointName.Companion.create("cidr.projectModel.runAfterOCWorkspaceIsInitialized");
    @NotNull
    private static final ExtensionPointName<RunAfterOCWorkspaceIsLoaded> LOADED_EP_NAME = ExtensionPointName.Companion.create("cidr.projectModel.runAfterOCWorkspaceIsLoaded");

    public static final void runWhenOrIfOCWorkspaceIsInitialized(@NotNull Project $this$runWhenOrIfOCWorkspaceIsInitialized, @NotNull Disposable disposable, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$runWhenOrIfOCWorkspaceIsInitialized, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        new OCWorkspaceInitializationWaiter(block, $this$runWhenOrIfOCWorkspaceIsInitialized).waitForInitialization(disposable);
    }

    public static final void runWhenOrIfOCWorkspaceIsLoaded(@NotNull Project $this$runWhenOrIfOCWorkspaceIsLoaded, @NotNull Disposable disposable, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$runWhenOrIfOCWorkspaceIsLoaded, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        new OCWorkspaceLoadingWaiter(block, $this$runWhenOrIfOCWorkspaceIsLoaded).waitForInitialization(disposable);
    }

    public static final boolean isOCWorkspaceInitialized(@NotNull Project $this$isOCWorkspaceInitialized) {
        Intrinsics.checkNotNullParameter((Object)$this$isOCWorkspaceInitialized, (String)"<this>");
        return OCWorkspaceImpl.Companion.getInstanceImpl($this$isOCWorkspaceInitialized).getInitialized();
    }

    public static final boolean isOCWorkspaceNotEmpty(@NotNull Project $this$isOCWorkspaceNotEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$isOCWorkspaceNotEmpty, (String)"<this>");
        OCWorkspace oCWorkspace = OCWorkspace.getInstance($this$isOCWorkspaceNotEmpty);
        Intrinsics.checkNotNullExpressionValue((Object)oCWorkspace, (String)"getInstance(...)");
        return OCWorkspaceInitializationUtil.isNotEmpty(oCWorkspace);
    }

    public static final boolean isNotEmpty(@NotNull OCWorkspace $this$isNotEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$isNotEmpty, (String)"<this>");
        List<OCResolveConfiguration> list = $this$isNotEmpty.getConfigurations();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getConfigurations(...)");
        return !((Collection)list).isEmpty();
    }

    public static final void runCidrActivities(@NotNull Project project, @NotNull ExtensionPointName<? extends CidrProjectActivity> epName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(epName, (String)"epName");
        for (CidrProjectActivity activity : epName.getExtensionList()) {
            try {
                activity.runActivity(project);
            }
            catch (Throwable e) {
                if (e instanceof ControlFlowException) {
                    throw e;
                }
                OCWorkspaceImplUtilKt.getLOG().error(e);
            }
        }
    }

    public static final /* synthetic */ ExtensionPointName access$getINITIALIZED_EP_NAME$p() {
        return INITIALIZED_EP_NAME;
    }

    public static final /* synthetic */ ExtensionPointName access$getLOADED_EP_NAME$p() {
        return LOADED_EP_NAME;
    }
}

