/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.settings;

import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.lang.settings.NamingConventionStyle;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(message="Preserved only for backward compatibility with 2019.1 settings. Use NamingConventionRule instead.")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0004B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0003\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\u000e\u0010 \u001a\u00020!2\u0006\u0010\u0003\u001a\u00020\u0000J\u000e\u0010\"\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0006J\u0012\u0010#\u001a\u00020!2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\t\u0010&\u001a\u00020\u0006H\u00d6\u0001J\u0012\u0010'\u001a\u00020!2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\t\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\f\"\u0004\b\u0010\u0010\u000eR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006("}, d2={"Lcom/jetbrains/cidr/lang/settings/NamingConvention;", "Lcom/intellij/openapi/util/JDOMExternalizable;", "()V", "other", "(Lcom/jetbrains/cidr/lang/settings/NamingConvention;)V", "customPrefix", "", "namingConventionStyle", "Lcom/jetbrains/cidr/lang/settings/NamingConventionStyle;", "customSuffix", "(Ljava/lang/String;Lcom/jetbrains/cidr/lang/settings/NamingConventionStyle;Ljava/lang/String;)V", "getCustomPrefix", "()Ljava/lang/String;", "setCustomPrefix", "(Ljava/lang/String;)V", "getCustomSuffix", "setCustomSuffix", "getNamingConventionStyle", "()Lcom/jetbrains/cidr/lang/settings/NamingConventionStyle;", "setNamingConventionStyle", "(Lcom/jetbrains/cidr/lang/settings/NamingConventionStyle;)V", "apply", "name", "component1", "component2", "component3", "copy", "equals", "", "", "hashCode", "", "initFrom", "", "match", "readExternal", "element", "Lorg/jdom/Element;", "toString", "writeExternal", "intellij.cidr.lang.base"})
public final class NamingConvention
implements JDOMExternalizable {
    @NotNull
    private String customPrefix;
    @NotNull
    private NamingConventionStyle namingConventionStyle;
    @NotNull
    private String customSuffix;

    public NamingConvention(@NotNull String customPrefix, @NotNull NamingConventionStyle namingConventionStyle, @NotNull String customSuffix) {
        Intrinsics.checkNotNullParameter((Object)customPrefix, (String)"customPrefix");
        Intrinsics.checkNotNullParameter((Object)((Object)namingConventionStyle), (String)"namingConventionStyle");
        Intrinsics.checkNotNullParameter((Object)customSuffix, (String)"customSuffix");
        this.customPrefix = customPrefix;
        this.namingConventionStyle = namingConventionStyle;
        this.customSuffix = customSuffix;
    }

    @NotNull
    public final String getCustomPrefix() {
        return this.customPrefix;
    }

    public final void setCustomPrefix(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.customPrefix = string;
    }

    @NotNull
    public final NamingConventionStyle getNamingConventionStyle() {
        return this.namingConventionStyle;
    }

    public final void setNamingConventionStyle(@NotNull NamingConventionStyle namingConventionStyle) {
        Intrinsics.checkNotNullParameter((Object)((Object)namingConventionStyle), (String)"<set-?>");
        this.namingConventionStyle = namingConventionStyle;
    }

    @NotNull
    public final String getCustomSuffix() {
        return this.customSuffix;
    }

    public final void setCustomSuffix(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.customSuffix = string;
    }

    public NamingConvention() {
        this("", NamingConventionStyle.CAMEL_CASE, "");
    }

    public NamingConvention(@NotNull NamingConvention other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this(other.customPrefix, other.namingConventionStyle, other.customSuffix);
    }

    public void readExternal(@Nullable Element element) {
        if (element == null) {
            return;
        }
        String string = element.getAttributeValue("prefix");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttributeValue(...)");
        this.customPrefix = string;
        this.namingConventionStyle = NamingConventionStyle.Companion.byName(element.getAttributeValue("style"));
        String string2 = element.getAttributeValue("suffix");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAttributeValue(...)");
        this.customSuffix = string2;
    }

    public void writeExternal(@Nullable Element element) {
        if (element == null) {
            return;
        }
        element.setAttribute("prefix", this.customPrefix);
        element.setAttribute("style", this.namingConventionStyle.name());
        element.setAttribute("suffix", this.customSuffix);
    }

    @NotNull
    public final String apply(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String nameWithoutPrefixAndSuffix = name;
        if (StringUtil.startsWith((CharSequence)name, (CharSequence)this.customPrefix)) {
            String string = nameWithoutPrefixAndSuffix.substring(this.customPrefix.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            nameWithoutPrefixAndSuffix = string;
        }
        if (StringsKt.endsWith$default((String)name, (String)this.customSuffix, (boolean)false, (int)2, null)) {
            String string = nameWithoutPrefixAndSuffix.substring(0, nameWithoutPrefixAndSuffix.length() - this.customSuffix.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            nameWithoutPrefixAndSuffix = string;
        }
        return this.customPrefix + this.namingConventionStyle.apply(nameWithoutPrefixAndSuffix) + this.customSuffix;
    }

    public final boolean match(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return Intrinsics.areEqual((Object)name, (Object)this.apply(name));
    }

    public final void initFrom(@NotNull NamingConvention other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.customPrefix = other.customPrefix;
        this.namingConventionStyle = other.namingConventionStyle;
        this.customSuffix = other.customSuffix;
    }

    @NotNull
    public final String component1() {
        return this.customPrefix;
    }

    @NotNull
    public final NamingConventionStyle component2() {
        return this.namingConventionStyle;
    }

    @NotNull
    public final String component3() {
        return this.customSuffix;
    }

    @NotNull
    public final NamingConvention copy(@NotNull String customPrefix, @NotNull NamingConventionStyle namingConventionStyle, @NotNull String customSuffix) {
        Intrinsics.checkNotNullParameter((Object)customPrefix, (String)"customPrefix");
        Intrinsics.checkNotNullParameter((Object)((Object)namingConventionStyle), (String)"namingConventionStyle");
        Intrinsics.checkNotNullParameter((Object)customSuffix, (String)"customSuffix");
        return new NamingConvention(customPrefix, namingConventionStyle, customSuffix);
    }

    public static /* synthetic */ NamingConvention copy$default(NamingConvention namingConvention, String string, NamingConventionStyle namingConventionStyle, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = namingConvention.customPrefix;
        }
        if ((n & 2) != 0) {
            namingConventionStyle = namingConvention.namingConventionStyle;
        }
        if ((n & 4) != 0) {
            string2 = namingConvention.customSuffix;
        }
        return namingConvention.copy(string, namingConventionStyle, string2);
    }

    @NotNull
    public String toString() {
        return "NamingConvention(customPrefix=" + this.customPrefix + ", namingConventionStyle=" + this.namingConventionStyle + ", customSuffix=" + this.customSuffix + ")";
    }

    public int hashCode() {
        int result2 = this.customPrefix.hashCode();
        result2 = result2 * 31 + this.namingConventionStyle.hashCode();
        result2 = result2 * 31 + this.customSuffix.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NamingConvention)) {
            return false;
        }
        NamingConvention namingConvention = (NamingConvention)other;
        if (!Intrinsics.areEqual((Object)this.customPrefix, (Object)namingConvention.customPrefix)) {
            return false;
        }
        if (this.namingConventionStyle != namingConvention.namingConventionStyle) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.customSuffix, (Object)namingConvention.customSuffix);
    }
}

