/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search.scopes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public final class OCExplicitSourcesSearchScope {
    private static final Key<CachedValue<Collection<VirtualFile>>> EXPLICIT_PROJECT_SOURCE_FILES = Key.create((String)"EXPLICIT_PROJECT_SOURCE_FILES");

    @NotNull
    public static Collection<VirtualFile> getExplicitlySpecifiedProjectSourceFiles(@NotNull Project project) {
        if (project == null) {
            OCExplicitSourcesSearchScope.$$$reportNull$$$0(0);
        }
        Collection collection = (Collection)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, EXPLICIT_PROJECT_SOURCE_FILES, () -> {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            final HashSet result2 = new HashSet();
            ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)project);
            final ProjectFileIndex index = rootManager.getFileIndex();
            final FileTypeRegistry typeRegistry = FileTypeRegistry.getInstance();
            for (VirtualFile eachSourceRoot : rootManager.getContentSourceRoots()) {
                ProgressManager.checkCanceled();
                VfsUtilCore.visitChildrenRecursively((VirtualFile)eachSourceRoot, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

                    public boolean visitFile(@NotNull VirtualFile each) {
                        if (each == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        ProgressManager.checkCanceled();
                        if (index.isExcluded(each) || typeRegistry.isFileIgnored(each)) {
                            return false;
                        }
                        if (!each.isDirectory() && OCExplicitSourcesSearchScope.isInExplicitProjectSources(index, each)) {
                            result2.add(each);
                        }
                        return true;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "each", "com/jetbrains/cidr/lang/search/scopes/OCExplicitSourcesSearchScope$1", "visitFile"));
                    }
                });
            }
            return CachedValueProvider.Result.create(Collections.unmodifiableCollection(result2), (Object[])OCExplicitSourcesSearchScope.getProjectSourcesCacheDependenciesExplicitRootsOnly(project));
        }, false);
        if (collection == null) {
            OCExplicitSourcesSearchScope.$$$reportNull$$$0(1);
        }
        return collection;
    }

    public static boolean isInExplicitProjectSources(@NotNull ProjectFileIndex index, @NotNull VirtualFile file) {
        if (index == null) {
            OCExplicitSourcesSearchScope.$$$reportNull$$$0(2);
        }
        if (file == null) {
            OCExplicitSourcesSearchScope.$$$reportNull$$$0(3);
        }
        return index.isInSourceContent(file) && !index.isInLibrary(file);
    }

    public static ModificationTracker @NotNull [] getProjectSourcesCacheDependenciesExplicitRootsOnly(@NotNull Project project) {
        if (project == null) {
            OCExplicitSourcesSearchScope.$$$reportNull$$$0(4);
        }
        ModificationTracker[] modificationTrackerArray = new ModificationTracker[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS, ProjectRootManager.getInstance((Project)project)};
        if (modificationTrackerArray == null) {
            OCExplicitSourcesSearchScope.$$$reportNull$$$0(5);
        }
        return modificationTrackerArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/search/scopes/OCExplicitSourcesSearchScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/search/scopes/OCExplicitSourcesSearchScope";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExplicitlySpecifiedProjectSourceFiles";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectSourcesCacheDependenciesExplicitRootsOnly";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getExplicitlySpecifiedProjectSourceFiles";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isInExplicitProjectSources";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getProjectSourcesCacheDependenciesExplicitRootsOnly";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5 -> new IllegalStateException(string);
        };
    }
}

