/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.fus;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004H\u0002J\b\u0010#\u001a\u00020\bH\u0016J\u001c\u0010$\u001a\u00020%2\u0006\u0010\"\u001a\u00020\u00042\n\b\u0002\u0010&\u001a\u0004\u0018\u00010'H\u0007J\u001c\u0010(\u001a\u00020%2\u0006\u0010\"\u001a\u00020\u00042\n\b\u0002\u0010&\u001a\u0004\u0018\u00010'H\u0007J,\u0010)\u001a\u00020%2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\u001d2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010'H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R(\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u0013\u0012\u0004\u0012\u00020\u00140\u00118\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00188\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00188\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001c\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d0\u00118\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/jetbrains/cidr/fus/CidrWorkspaceUsageCounterCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "()V", "CMAKE", "", "COMP_DB", "GRADLE", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getGROUP", "()Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "KNOWN_PROJECT_KINDS", "", "KNOWN_PROJECT_KINDS_MAP", "", "MAKEFILE", "MAKEFILE_RESOLVER_ERROR", "Lcom/intellij/internal/statistic/eventLog/events/EventId3;", "", "Ljava/lang/Class;", "", "MESON", "PLATFORMIO", "PROJECT_CREATED", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "PROJECT_KINDS_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "PROJECT_LINKED", "PROJECT_RESOLVED", "", "SWIFT_PM", "UNKNOWN_PROJECT_KIND", "XCODE", "checkProjectKind", "projectKind", "getGroup", "logProjectCreated", "", "project", "Lcom/intellij/openapi/project/Project;", "logProjectLinked", "logProjectResolved", "isSuccess", "isCancelled", "intellij.cidr.workspaceModel"})
public final class CidrWorkspaceUsageCounterCollector
extends CounterUsagesCollector {
    @NotNull
    public static final CidrWorkspaceUsageCounterCollector INSTANCE = new CidrWorkspaceUsageCounterCollector();
    @NotNull
    private static final String UNKNOWN_PROJECT_KIND = "Unknown";
    @NotNull
    public static final String CMAKE = "CMake";
    @NotNull
    public static final String XCODE = "Xcode";
    @NotNull
    private static final String MAKEFILE = "Makefile";
    @NotNull
    private static final String MESON = "Meson";
    @NotNull
    private static final String COMP_DB = "CompDB";
    @NotNull
    private static final String SWIFT_PM = "SwiftPM";
    @NotNull
    private static final String GRADLE = "Gradle";
    @NotNull
    private static final String PLATFORMIO = "PlatformIO";
    @NotNull
    private static final List<String> KNOWN_PROJECT_KINDS;
    @NotNull
    private static final StringEventField PROJECT_KINDS_FIELD;
    @NotNull
    private static final EventLogGroup GROUP;
    @JvmField
    @NotNull
    public static final EventId1<String> PROJECT_CREATED;
    @JvmField
    @NotNull
    public static final EventId1<String> PROJECT_LINKED;
    @JvmField
    @NotNull
    public static final EventId3<String, Boolean, Boolean> PROJECT_RESOLVED;
    @JvmField
    @NotNull
    public static final EventId3<Long, Class<?>, Integer> MAKEFILE_RESOLVER_ERROR;
    @NotNull
    private static final Map<String, String> KNOWN_PROJECT_KINDS_MAP;

    private CidrWorkspaceUsageCounterCollector() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    public final EventLogGroup getGROUP() {
        return GROUP;
    }

    @JvmStatic
    public static final void logProjectCreated(@NotNull String projectKind, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)projectKind, (String)"projectKind");
        PROJECT_CREATED.log(project, (Object)INSTANCE.checkProjectKind(projectKind));
    }

    public static /* synthetic */ void logProjectCreated$default(String string, Project project, int n, Object object) {
        if ((n & 2) != 0) {
            project = null;
        }
        CidrWorkspaceUsageCounterCollector.logProjectCreated(string, project);
    }

    @JvmStatic
    public static final void logProjectLinked(@NotNull String projectKind, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)projectKind, (String)"projectKind");
        PROJECT_LINKED.log(project, (Object)INSTANCE.checkProjectKind(projectKind));
    }

    public static /* synthetic */ void logProjectLinked$default(String string, Project project, int n, Object object) {
        if ((n & 2) != 0) {
            project = null;
        }
        CidrWorkspaceUsageCounterCollector.logProjectLinked(string, project);
    }

    @JvmStatic
    public static final void logProjectResolved(@NotNull String projectKind, boolean isSuccess, boolean isCancelled, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)projectKind, (String)"projectKind");
        PROJECT_RESOLVED.log(project, (Object)INSTANCE.checkProjectKind(projectKind), (Object)isSuccess, (Object)isCancelled);
    }

    public static /* synthetic */ void logProjectResolved$default(String string, boolean bl, boolean bl2, Project project, int n, Object object) {
        if ((n & 8) != 0) {
            project = null;
        }
        CidrWorkspaceUsageCounterCollector.logProjectResolved(string, bl, bl2, project);
    }

    private final String checkProjectKind(String projectKind) {
        String string = projectKind.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String knownProjectKind = KNOWN_PROJECT_KINDS_MAP.get(string);
        String string2 = knownProjectKind;
        if (string2 == null) {
            string2 = UNKNOWN_PROJECT_KIND;
        }
        return string2;
    }

    static {
        Object[] objectArray = new String[]{CMAKE, XCODE, MAKEFILE, MESON, COMP_DB, SWIFT_PM, GRADLE, PLATFORMIO, UNKNOWN_PROJECT_KIND};
        KNOWN_PROJECT_KINDS = CollectionsKt.listOf((Object[])objectArray);
        PROJECT_KINDS_FIELD = EventFields.String((String)"projectKind", (List)CollectionsKt.toList((Iterable)KNOWN_PROJECT_KINDS));
        GROUP = new EventLogGroup("cidr.workspace.events", 7, null, 4, null);
        PROJECT_CREATED = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"project.created", (EventField)((EventField)PROJECT_KINDS_FIELD), null, (int)4, null);
        PROJECT_LINKED = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"project.linked", (EventField)((EventField)PROJECT_KINDS_FIELD), null, (int)4, null);
        PROJECT_RESOLVED = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"project.resolved", (EventField)((EventField)PROJECT_KINDS_FIELD), (EventField)((EventField)EventFields.Boolean((String)"success")), (EventField)((EventField)EventFields.Boolean((String)"cancelled")), null, (int)16, null);
        MAKEFILE_RESOLVER_ERROR = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"makefile.resolver.errors", (EventField)((EventField)EventFields.Long$default((String)"session_id", null, (int)2, null)), (EventField)((EventField)EventFields.Class((String)"error_type")), (EventField)((EventField)EventFields.Int((String)"count")), null, (int)16, null);
        objectArray = new Pair[11];
        String string = CMAKE.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        objectArray[0] = TuplesKt.to((Object)string, (Object)CMAKE);
        String string2 = XCODE.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        objectArray[1] = TuplesKt.to((Object)string2, (Object)XCODE);
        String string3 = MAKEFILE.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        objectArray[2] = TuplesKt.to((Object)string3, (Object)MAKEFILE);
        String string4 = MESON.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        objectArray[3] = TuplesKt.to((Object)string4, (Object)MESON);
        String string5 = COMP_DB.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
        objectArray[4] = TuplesKt.to((Object)string5, (Object)COMP_DB);
        objectArray[5] = TuplesKt.to((Object)"compilation database", (Object)COMP_DB);
        String string6 = SWIFT_PM.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toLowerCase(...)");
        objectArray[6] = TuplesKt.to((Object)string6, (Object)SWIFT_PM);
        objectArray[7] = TuplesKt.to((Object)"spm", (Object)SWIFT_PM);
        objectArray[8] = TuplesKt.to((Object)"swift package manager", (Object)SWIFT_PM);
        String string7 = GRADLE.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toLowerCase(...)");
        objectArray[9] = TuplesKt.to((Object)string7, (Object)GRADLE);
        String string8 = PLATFORMIO.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toLowerCase(...)");
        objectArray[10] = TuplesKt.to((Object)string8, (Object)PLATFORMIO);
        KNOWN_PROJECT_KINDS_MAP = MapsKt.hashMapOf((Pair[])objectArray);
    }
}

