/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Processor;
import com.jetbrains.cidr.CidrExecutionBundle;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.BuildTargetData;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildConfigurationWithSources;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkDetector;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestScopeService;
import com.jetbrains.cidr.execution.testing.Trie;
import com.jetbrains.cidr.execution.testing.TrieNode;
import com.jetbrains.cidr.project.workspace.CidrWorkspace;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\u00020\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u0013H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u0010H\u0002J(\u0010\u001b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0010H\u0002J\u0010\u0010\u001f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/cidr/execution/testing/CidrCreateTestScope;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "KEY_LAST_NOTIFICATION", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/notification/Notification;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createOrUpdateTestScope", "project", "Lcom/intellij/openapi/project/Project;", "contentRoot", "", "createTestScopePatternFromSources", "testSources", "", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getCommonTail", "getContentRoot", "getCurrentTestScopePattern", "preparePatternAsMultiline", "filePattern", "showNotification", "newFilePattern", "oldFilePattern", "report", "update", "intellij.cidr.execution"})
@SourceDebugExtension(value={"SMAP\nCidrCreateTestScope.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrCreateTestScope.kt\ncom/jetbrains/cidr/execution/testing/CidrCreateTestScope\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,305:1\n187#2,3:306\n*S KotlinDebug\n*F\n+ 1 CidrCreateTestScope.kt\ncom/jetbrains/cidr/execution/testing/CidrCreateTestScope\n*L\n151#1:306,3\n*E\n"})
public final class CidrCreateTestScope
extends DumbAwareAction {
    @NotNull
    private final Key<Notification> KEY_LAST_NOTIFICATION;

    public CidrCreateTestScope() {
        Key key = Key.create((String)"clion.test.scope.notification");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        this.KEY_LAST_NOTIFICATION = key;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(AnAction.getEventProject((AnActionEvent)e) != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = AnAction.getEventProject((AnActionEvent)e);
        if (project == null) {
            return;
        }
        Project project2 = project;
        String contentRoot = this.getContentRoot(project2);
        if (contentRoot == null) {
            return;
        }
        String string = CidrExecutionBundle.message("test.scope.creation.progress.title", new Object[0]);
        Task.Backgroundable task2 = new Task.Backgroundable(project2, this, contentRoot, string){
            final /* synthetic */ Project $project;
            final /* synthetic */ CidrCreateTestScope this$0;
            final /* synthetic */ String $contentRoot;
            {
                this.$project = $project;
                this.this$0 = $receiver;
                this.$contentRoot = $contentRoot;
                super($project, $super_call_param$1);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                CidrCreateTestScope.access$createOrUpdateTestScope(this.this$0, this.$project, this.$contentRoot);
            }
        };
        ProgressManager.getInstance().run((Task)task2);
    }

    private final void createOrUpdateTestScope(Project project, String contentRoot) {
        Ref.ObjectRef targetReport = new Ref.ObjectRef();
        targetReport.element = "";
        RunManager runManager = RunManager.Companion.getInstance(project);
        List allSettings = runManager.getAllSettings();
        HashSet<BuildTargetData> testTargets = new HashSet<BuildTargetData>();
        HashSet<String> testSources = new HashSet<String>();
        for (RunnerAndConfigurationSettings setting : allSettings) {
            List buildConfigurations;
            CidrBuildConfigurationHelper helper;
            BuildTargetAndConfigurationData targetAndConfigurationData;
            RunConfiguration configuration;
            ProgressManager.checkCanceled();
            Intrinsics.checkNotNullExpressionValue((Object)setting.getConfiguration(), (String)"getConfiguration(...)");
            if (!(configuration instanceof CidrTestRunConfiguration) || !(configuration instanceof CidrRunConfiguration)) continue;
            BuildTargetAndConfigurationData buildTargetAndConfigurationData = targetAndConfigurationData = ((CidrRunConfiguration)configuration).getTargetAndConfigurationData();
            if ((buildTargetAndConfigurationData != null ? buildTargetAndConfigurationData.target : null) == null) continue;
            BuildTargetData buildTargetData = targetAndConfigurationData.target;
            Intrinsics.checkNotNull((Object)buildTargetData);
            if (testTargets.contains(buildTargetData)) continue;
            BuildTargetData buildTargetData2 = targetAndConfigurationData.target;
            Intrinsics.checkNotNull((Object)buildTargetData2);
            testTargets.add(buildTargetData2);
            Intrinsics.checkNotNullExpressionValue((Object)((CidrRunConfiguration)configuration).getHelper(), (String)"getHelper(...)");
            CidrBuildTarget testTarget = helper.findTarget(targetAndConfigurationData.target);
            if (testTarget == null) continue;
            if (((CharSequence)targetReport.element).length() == 0) {
                targetReport.element = targetReport.element + "Found test target(s):\n";
            }
            targetReport.element = targetReport.element + "  " + testTarget.getName() + "\n";
            Intrinsics.checkNotNullExpressionValue((Object)testTarget.getBuildConfigurations(), (String)"getBuildConfigurations(...)");
            for (CidrBuildConfiguration bc : buildConfigurations) {
                ProgressManager.checkCanceled();
                if (bc instanceof CidrBuildConfigurationWithSources) {
                    CidrTestFrameworkDetector.fastFilterTestSource(((CidrBuildConfigurationWithSources)bc).getSources(), Integer.MAX_VALUE, Integer.MAX_VALUE, (Processor<? super File>)((Processor)arg_0 -> CidrCreateTestScope.createOrUpdateTestScope$lambda$0((Function1)new Function1<File, Boolean>(testSources, (Ref.ObjectRef<String>)targetReport){
                        final /* synthetic */ HashSet<String> $testSources;
                        final /* synthetic */ Ref.ObjectRef<String> $targetReport;
                        {
                            this.$testSources = $testSources;
                            this.$targetReport = $targetReport;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(File it) {
                            String string = it.getCanonicalPath();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalPath(...)");
                            String canonicalTestSource = StringsKt.replace$default((String)string, (String)"\\", (String)"/", (boolean)false, (int)4, null);
                            if (!this.$testSources.contains(canonicalTestSource)) {
                                this.$targetReport.element = this.$targetReport.element + "   " + canonicalTestSource + "\n";
                                this.$testSources.add(canonicalTestSource);
                            } else {
                                this.$targetReport.element = this.$targetReport.element + "  -" + canonicalTestSource + "\n";
                            }
                            return true;
                        }
                    }, arg_0)));
                }
                targetReport.element = targetReport.element + "\n";
            }
        }
        if (((CharSequence)targetReport.element).length() == 0) {
            targetReport.element = targetReport.element + "No test targets were found\n";
        }
        String newFilePattern = this.createTestScopePatternFromSources(contentRoot, (Set<String>)testSources);
        String oldFilePattern = this.getCurrentTestScopePattern(project);
        this.showNotification(project, newFilePattern, oldFilePattern, (String)targetReport.element);
    }

    private final String getCurrentTestScopePattern(Project project) {
        NamedScope testScope = CidrTestScopeService.Companion.getInstance(project).getTestScope();
        if (testScope == null || testScope.getValue() == null) {
            return "";
        }
        PackageSet packageSet = testScope.getValue();
        Intrinsics.checkNotNull((Object)packageSet);
        String string = packageSet.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private final String getContentRoot(Project project) {
        VirtualFile contentRoot;
        List<CidrWorkspace> list = CidrWorkspace.getInitializedWorkspaces(project);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getInitializedWorkspaces(...)");
        List<CidrWorkspace> workspaces = list;
        if (!workspaces.isEmpty() && (contentRoot = workspaces.get(0).getEffectiveContentRoot()) != null) {
            return contentRoot.getPath();
        }
        return project.getBasePath();
    }

    private final String createTestScopePatternFromSources(String contentRoot, Set<String> testSources) {
        Trie trie = new Trie();
        for (String path : testSources) {
            trie.insert(path);
        }
        trie.getRoot().compress();
        List testRoots = new ArrayList();
        trie.getRoot().visit((Processor<TrieNode>)((Processor)arg_0 -> CidrCreateTestScope.createTestScopePatternFromSources$lambda$2(testRoots, arg_0)));
        String commonTail = Registry.is((String)"cidr.test.check.common.tail") ? this.getCommonTail(testSources) : "";
        return CollectionsKt.joinToString$default((Iterable)testRoots, (CharSequence)"||", null, null, (int)0, null, (Function1)((Function1)new Function1<TrieNode, CharSequence>(contentRoot, commonTail){
            final /* synthetic */ String $contentRoot;
            final /* synthetic */ String $commonTail;
            {
                this.$contentRoot = $contentRoot;
                this.$commonTail = $commonTail;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull TrieNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String commonParent = FileUtil.getRelativePath((String)this.$contentRoot, (String)it.getPath(), (char)'/');
                return commonParent == null || Intrinsics.areEqual((Object)commonParent, (Object)".") ? (CharSequence)("file:*" + this.$commonTail) : (CharSequence)("file:" + commonParent + "//*" + this.$commonTail);
            }
        }), (int)30, null);
    }

    private final String getCommonTail(Set<String> testSources) {
        Object ret = "";
        if (testSources.size() < 2) {
            return ret;
        }
        int i = 1;
        char ch = ' ';
        while (true) {
            boolean first = true;
            for (String testSource : testSources) {
                if (i >= testSource.length()) {
                    return ((Object)StringsKt.reversed((CharSequence)((CharSequence)ret))).toString();
                }
                int pos = testSource.length() - i;
                if (first) {
                    first = false;
                    ch = testSource.charAt(pos);
                    continue;
                }
                if (testSource.charAt(pos) == ch) continue;
                return ((Object)StringsKt.reversed((CharSequence)((CharSequence)ret))).toString();
            }
            ret = (String)ret + ch;
            ++i;
        }
    }

    private final void showNotification(Project project, String newFilePattern, String oldFilePattern, String report) {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Test Frameworks");
        String string = Intrinsics.areEqual((Object)newFilePattern, (Object)oldFilePattern) ? CidrExecutionBundle.message("test.scope.result.notification.content.same", new Object[0]) : CidrExecutionBundle.message("test.scope.result.notification.content.diff", new Object[0]);
        Intrinsics.checkNotNull((Object)string);
        Notification notification2 = notificationGroup.createNotification(string, NotificationType.INFORMATION).setListener((NotificationListener)new NotificationListener.Adapter(report, project, this, oldFilePattern, newFilePattern){
            final /* synthetic */ String $report;
            final /* synthetic */ Project $project;
            final /* synthetic */ CidrCreateTestScope this$0;
            final /* synthetic */ String $oldFilePattern;
            final /* synthetic */ String $newFilePattern;
            {
                this.$report = $report;
                this.$project = $project;
                this.this$0 = $receiver;
                this.$oldFilePattern = $oldFilePattern;
                this.$newFilePattern = $newFilePattern;
            }

            protected void hyperlinkActivated(@NotNull Notification notification2, @NotNull HyperlinkEvent e) {
                Intrinsics.checkNotNullParameter((Object)notification2, (String)"notification");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                String string = e.getDescription();
                if (Intrinsics.areEqual((Object)string, (Object)"#report")) {
                    LightVirtualFile cfOptions = new LightVirtualFile(CidrExecutionBundle.message("test.scope.report.title", new Object[0]), (FileType)PlainTextFileType.INSTANCE, (CharSequence)this.$report);
                    cfOptions.setWritable(false);
                    OpenFileAction.Companion.openFile((VirtualFile)cfOptions, this.$project);
                    DiffContentFactory diffContentFactory = DiffContentFactory.getInstance();
                    Intrinsics.checkNotNullExpressionValue((Object)diffContentFactory, (String)"getInstance(...)");
                    DiffContentFactory diffCF = diffContentFactory;
                    DiffManager.getInstance().showDiff(this.$project, (DiffRequest)new SimpleDiffRequest(CidrExecutionBundle.message("test.scope.diff.tittle", new Object[0]), (DiffContent)diffCF.create(CidrCreateTestScope.access$preparePatternAsMultiline(this.this$0, this.$oldFilePattern)), (DiffContent)diffCF.create(CidrCreateTestScope.access$preparePatternAsMultiline(this.this$0, this.$newFilePattern)), CidrExecutionBundle.message("test.scope.diff.old.pattern", new Object[0]), CidrExecutionBundle.message("test.scope.diff.new.pattern", new Object[0])), DiffDialogHints.NON_MODAL);
                } else if (Intrinsics.areEqual((Object)string, (Object)"#apply")) {
                    CidrTestScopeService.Companion.getInstance(this.$project).updateTestScope(this.$newFilePattern);
                    ShowSettingsUtil.getInstance().showSettingsDialog(this.$project, IdeBundle.message((String)"scope.view.title", (Object[])new Object[0]));
                }
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)notification2, (String)"setListener(...)");
        Notification notification3 = notification2;
        Notification notification4 = (Notification)this.KEY_LAST_NOTIFICATION.get((UserDataHolder)project);
        if (notification4 != null) {
            notification4.expire();
        }
        notification3.notify(project);
        this.KEY_LAST_NOTIFICATION.set((UserDataHolder)project, (Object)notification3);
    }

    private final String preparePatternAsMultiline(String filePattern) {
        return StringsKt.replace$default((String)filePattern, (String)"||", (String)"\n", (boolean)false, (int)4, null);
    }

    private static final boolean createOrUpdateTestScope$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean createTestScopePatternFromSources$lambda$2(List $testRoots, TrieNode node) {
        boolean bl;
        boolean bl2;
        block5: {
            Intrinsics.checkNotNullParameter((Object)$testRoots, (String)"$testRoots");
            Map<String, TrieNode> $this$any$iv = node.getChildren();
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl2 = false;
            } else {
                Iterator<Map.Entry<String, TrieNode>> iterator = $this$any$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, TrieNode> element$iv;
                    Map.Entry<String, TrieNode> it = element$iv = iterator.next();
                    boolean bl3 = false;
                    if (!it.getValue().isLeaf()) continue;
                    bl2 = true;
                    break block5;
                }
                bl2 = false;
            }
        }
        if (bl2) {
            Intrinsics.checkNotNull((Object)node);
            $testRoots.add(node);
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    public static final /* synthetic */ void access$createOrUpdateTestScope(CidrCreateTestScope $this, Project project, String contentRoot) {
        $this.createOrUpdateTestScope(project, contentRoot);
    }

    public static final /* synthetic */ String access$preparePatternAsMultiline(CidrCreateTestScope $this, String filePattern) {
        return $this.preparePatternAsMultiline(filePattern);
    }
}

