/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.text.ReverseCharSequence;
import com.jetbrains.cidr.execution.DimmableFilter;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrPathConsoleFilter
implements Filter,
DumbAware,
DimmableFilter {
    public static final long MAX_TIME_PER_LINE_MILLIS = 250L;
    @Language(value="RegExp")
    @NonNls
    private static final String LINE_NUMBER = "\\d{1,5}";
    @Language(value="RegExp")
    @NonNls
    private static final String COLUMN_NUMBER = "\\d{1,5}";
    private static final String PATH_SEPARATOR = SystemInfo.isWindows ? "[/\\\\]" : "/";
    private static final Pattern ABSOLUTE_WIN_PATH_PREFIX = Pattern.compile("^(?:/|[A-Za-z]:" + PATH_SEPARATOR + ").*");
    private static final Pattern PARENT_DIRS_PREFIX = Pattern.compile("^(?:[.](?:" + PATH_SEPARATOR + ")+)?(?:[.]{2}(?:" + PATH_SEPARATOR + ")+)+");
    @Language(value="RegExp")
    @NonNls
    private static final String MSVC_LINE_GROUP = "msvcLine";
    @Language(value="RegExp")
    @NonNls
    private static final String MSVC_COLUMN_GROUP = "msvcColumn";
    @Language(value="RegExp")
    @NonNls
    private static final String LINE_GROUP = "line";
    @Language(value="RegExp")
    @NonNls
    private static final String COLUMN_GROUP = "column";
    @Language(value="RegExp")
    @NonNls
    public static final String LINE_PATTERN_TEXT = " ?\\((?<msvcLine>\\d{1,5})(?:,(?<msvcColumn>\\d{1,5}))?\\)|:(?<line>\\d{1,5})";
    private static final Pattern LINE_NUMBER_PATTERN = Pattern.compile("[^:](?: ?\\((?<msvcLine>\\d{1,5})(?:,(?<msvcColumn>\\d{1,5}))?\\)|:(?<line>\\d{1,5})(?::(?<column>\\d{1,5}))?(?::?\\b|_))");
    @Language(value="RegExp")
    private static final String STARTING_CHARS = "-+\\p{LC}\\d~._|@";
    @NonNls
    private static final String FILE_CHARS = "-+\\p{LC}\\d~._|@\\{\\}\\(\\)\\[\\]";
    @Language(value="RegExp")
    @NonNls
    private static final String WS = "\\t ";
    private static final String FILE_CHARS_CLASS = "[-+\\p{LC}\\d~._|@\\{\\}\\(\\)\\[\\]]";
    private static final String FILE_CHARS_WS_CLASS = "[-+\\p{LC}\\d~._|@\\{\\}\\(\\)\\[\\]\\t ]";
    private static final String STARTING_CHARS_CLASS = "[-+\\p{LC}\\d~._|@]";
    private static final String WS_CLASS = "[\\t ]";
    private static final String REVERSE_ABSOLUTE_PATH_PREFIX = SystemInfo.isWindows ? "(?::[A-Za-z])?" : "";
    private static final String SINGLE_WORD_PATH_COMPONENT = "[-+\\p{LC}\\d~._|@\\{\\}\\(\\)\\[\\]]*[-+\\p{LC}\\d~._|@]";
    private static final String MULTI_WORD_PATH_COMPONENT = "(?:[-+\\p{LC}\\d~._|@\\{\\}\\(\\)\\[\\]][-+\\p{LC}\\d~._|@\\{\\}\\(\\)\\[\\]\\t ]*|)[-+\\p{LC}\\d~._|@][\\t ]*" + PATH_SEPARATOR + "+";
    private static final String PATH_COMPONENT = MULTI_WORD_PATH_COMPONENT + "|[-+\\p{LC}\\d~._|@\\{\\}\\(\\)\\[\\]]*[-+\\p{LC}\\d~._|@]";
    private static final String REVERSE_RELATIVE_PATH = "^(?:" + PATH_COMPONENT + ")+";
    private static final Pattern REVERSE_FILE_PATH_PATTERN = Pattern.compile(REVERSE_RELATIVE_PATH + REVERSE_ABSOLUTE_PATH_PREFIX);
    @NotNull
    protected final Project myProject;
    @Nullable
    private final CidrToolEnvironment myEnvironment;
    @Nullable
    private final Path myBaseDir;
    private boolean myDimHighlighting;

    public CidrPathConsoleFilter(@NotNull Project project, @Nullable CidrToolEnvironment environment, @Nullable Path baseDir) {
        if (project == null) {
            CidrPathConsoleFilter.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myEnvironment = environment;
        this.myBaseDir = baseDir;
    }

    @Override
    public void dimHighlighting() {
        this.myDimHighlighting = true;
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        if (line == null) {
            CidrPathConsoleFilter.$$$reportNull$$$0(1);
        }
        if (!StringUtil.containsAnyChar((String)line, (String)":(")) {
            return null;
        }
        CharSequence expiringLine = CidrPathConsoleFilter.timeLimitedSequence(line);
        Matcher cm = LINE_NUMBER_PATTERN.matcher(expiringLine);
        Matcher fm = null;
        List results = null;
        int lineNumberSearchPosition = 0;
        int pathSearchPosition = 0;
        int lineStart = entireLength - line.length();
        try {
            while (cm.find(lineNumberSearchPosition)) {
                Matcher pm;
                int columnNumber;
                Integer lineNumber;
                int hyperlinkEndPosition;
                boolean msvcMode;
                block12: {
                    msvcMode = cm.group(MSVC_LINE_GROUP) != null;
                    String lineNumberGroup = msvcMode ? MSVC_LINE_GROUP : LINE_GROUP;
                    lineNumberSearchPosition = cm.start(lineNumberGroup);
                    hyperlinkEndPosition = cm.end(lineNumberGroup);
                    lineNumber = CidrPathConsoleFilter.zeroBased(CidrPathConsoleFilter.groupValueAsInt(cm, lineNumberGroup));
                    if (lineNumber == null) continue;
                    String columnNumberGroup = msvcMode ? MSVC_COLUMN_GROUP : COLUMN_GROUP;
                    String columnNumberRaw = cm.group(columnNumberGroup);
                    if (columnNumberRaw != null) {
                        try {
                            columnNumber = CidrPathConsoleFilter.zeroBased(Integer.parseInt(columnNumberRaw));
                            lineNumberSearchPosition = cm.start(columnNumberGroup);
                            hyperlinkEndPosition = cm.end(columnNumberGroup);
                            break block12;
                        }
                        catch (NumberFormatException ignore) {
                            continue;
                        }
                    }
                    columnNumber = 0;
                }
                if (msvcMode) {
                    ++hyperlinkEndPosition;
                }
                if (fm == null) {
                    fm = REVERSE_FILE_PATH_PATTERN.matcher((CharSequence)new ReverseCharSequence(expiringLine));
                }
                fm.region(line.length() - cm.start() - 1, line.length() - pathSearchPosition);
                if (!fm.find()) continue;
                int pathStart = line.length() - fm.end();
                String filename = line.substring(pathStart, line.length() - fm.start());
                HyperlinkInfo link = this.processMatch(filename, lineNumber, columnNumber);
                if (link == null && !filename.isEmpty() && filename.charAt(0) == '.' && (pm = PARENT_DIRS_PREFIX.matcher(filename)).find()) {
                    link = this.processMatch(filename.substring(pm.end()), lineNumber, columnNumber);
                }
                if (link == null) continue;
                if (results == null) {
                    results = new SmartList();
                }
                results.add(new Filter.ResultItem(lineStart + pathStart, lineStart + hyperlinkEndPosition, link, this.myDimHighlighting));
                pathSearchPosition = lineNumberSearchPosition;
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
        return results == null || results.isEmpty() ? null : new Filter.Result(results);
    }

    @Contract(pure=true)
    @Nullable
    private static Integer groupValueAsInt(@NotNull Matcher matcher, @NotNull @NonNls String groupName) {
        String rawValue;
        if (matcher == null) {
            CidrPathConsoleFilter.$$$reportNull$$$0(2);
        }
        if (groupName == null) {
            CidrPathConsoleFilter.$$$reportNull$$$0(3);
        }
        if ((rawValue = matcher.group(groupName)) == null) {
            return null;
        }
        try {
            return Integer.parseInt(rawValue);
        }
        catch (NumberFormatException ignore) {
            return null;
        }
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    @Nullable
    private static Integer zeroBased(@Nullable Integer oneBasedValue) {
        return oneBasedValue == null ? null : Integer.valueOf(Math.max(0, oneBasedValue - 1));
    }

    private static CharSequence timeLimitedSequence(String line) {
        final long expirationTimeMillis = System.currentTimeMillis() + 250L;
        return new StringUtil.BombedCharSequence(line){

            protected void checkCanceled() {
                if (System.currentTimeMillis() > expirationTimeMillis) {
                    throw new ProcessCanceledException();
                }
            }
        };
    }

    @Nullable
    protected HyperlinkInfo processMatch(@NotNull String matchedPath, int line, int column) {
        if (matchedPath == null) {
            CidrPathConsoleFilter.$$$reportNull$$$0(4);
        }
        boolean isAbsolute = SystemInfo.isWindows ? ABSOLUTE_WIN_PATH_PREFIX.matcher(matchedPath).matches() : matchedPath.startsWith("/");
        boolean isHomePath = !isAbsolute && !SystemInfo.isWindows && matchedPath.startsWith("~");
        boolean hasSeparator = !isHomePath && (matchedPath.contains(File.separator) || SystemInfo.isWindows && matchedPath.contains("/"));
        VirtualFile file = null;
        if (this.myEnvironment != null && this.myBaseDir != null && (isAbsolute || hasSeparator)) {
            String localPath = this.myEnvironment.toLocalPath(this.myBaseDir.toFile(), matchedPath);
            file = this.processLocalPath(localPath, true, false, hasSeparator);
        }
        if (file == null) {
            file = this.processLocalPath(matchedPath, isAbsolute, isHomePath, hasSeparator);
        }
        return file == null ? null : this.createHyperlinkInfo(file, line, column);
    }

    @Nullable
    protected VirtualFile processLocalPath(@NotNull String localPath, boolean isAbsolute, boolean isHomePath, boolean hasSeparator) {
        VirtualFile file;
        if (localPath == null) {
            CidrPathConsoleFilter.$$$reportNull$$$0(5);
        }
        if (isAbsolute) {
            file = CidrPathConsoleFilter.fileByIOFile(new File(localPath));
        } else if (isHomePath) {
            String userHome = System.getProperty("user.home");
            file = CidrPathConsoleFilter.fileByIOFile(new File(userHome, localPath.substring(1)));
        } else {
            if (this.myBaseDir == null) {
                file = null;
            } else {
                String absolutePath;
                try {
                    absolutePath = this.myBaseDir.resolve(localPath).toString();
                }
                catch (InvalidPathException e) {
                    return null;
                }
                file = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)absolutePath));
            }
            if (file == null && !hasSeparator) {
                file = this.findFirstFileByName(localPath);
            }
        }
        return file;
    }

    @NotNull
    protected HyperlinkInfo createHyperlinkInfo(@NotNull VirtualFile file, int line, int column) {
        if (file == null) {
            CidrPathConsoleFilter.$$$reportNull$$$0(6);
        }
        return new OpenFileHyperlinkInfo(this.myProject, file, line, column);
    }

    @Nullable
    private static VirtualFile fileByIOFile(@NotNull File ioFile) {
        if (ioFile == null) {
            CidrPathConsoleFilter.$$$reportNull$$$0(7);
        }
        return LocalFileSystem.getInstance().findFileByPath(ioFile.getAbsolutePath());
    }

    @Nullable
    private VirtualFile findFirstFileByName(@NotNull String name) {
        if (name == null) {
            CidrPathConsoleFilter.$$$reportNull$$$0(8);
        }
        try {
            CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
            FilenameIndex.processFilesByName((String)name, (boolean)true, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)this.myProject), (Processor)processor);
            return (VirtualFile)processor.getFoundValue();
        }
        catch (IndexNotReadyException ignore) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = LINE_GROUP;
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchedPath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ioFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/execution/CidrPathConsoleFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "applyFilter";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "groupValueAsInt";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processMatch";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "processLocalPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createHyperlinkInfo";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "fileByIOFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "findFirstFileByName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

