/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.translateCode;

import com.intellij.cidr.translateCode.GasFileDirective;
import com.intellij.cidr.translateCode.GasLocDirective;
import com.intellij.cidr.translateCode.UtilKt;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/cidr/translateCode/GasLocationTracker;", "", "srcFilePath", "", "(Ljava/lang/String;)V", "matchingPaths", "", "", "srcFileNos", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "isSourceFileLocation", "loc", "Lcom/intellij/cidr/translateCode/GasLocDirective;", "processFileDirective", "", "fileDirective", "Lcom/intellij/cidr/translateCode/GasFileDirective;", "intellij.cidr.translateCode"})
public final class GasLocationTracker {
    @NotNull
    private final String srcFilePath;
    @NotNull
    private final HashSet<Integer> srcFileNos;
    @NotNull
    private final Map<String, Boolean> matchingPaths;

    public GasLocationTracker(@NotNull String srcFilePath) {
        Intrinsics.checkNotNullParameter((Object)srcFilePath, (String)"srcFilePath");
        this.srcFilePath = srcFilePath;
        this.srcFileNos = new HashSet();
        this.matchingPaths = new LinkedHashMap();
    }

    public final void processFileDirective(@NotNull GasFileDirective fileDirective) {
        Intrinsics.checkNotNullParameter((Object)fileDirective, (String)"fileDirective");
        if (fileDirective.getFile() == null) {
            return;
        }
        if (fileDirective.getPath2() == null) {
            Boolean bl = this.matchingPaths.computeIfAbsent(fileDirective.getPath1(), arg_0 -> GasLocationTracker.processFileDirective$lambda$0((Function1)new Function1<String, Boolean>(this, fileDirective){
                final /* synthetic */ GasLocationTracker this$0;
                final /* synthetic */ GasFileDirective $fileDirective;
                {
                    this.this$0 = $receiver;
                    this.$fileDirective = $fileDirective;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return UtilKt.isSameFile(GasLocationTracker.access$getSrcFilePath$p(this.this$0), this.$fileDirective.getPath1());
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"computeIfAbsent(...)");
            boolean matchesSrcFile2 = bl;
            if (matchesSrcFile2) {
                this.srcFileNos.add(fileDirective.getFile());
            }
        } else {
            Path path;
            Path path2 = UtilKt.pathOrNull(fileDirective.getPath2(), new String[0]);
            if (path2 == null) {
                return;
            }
            Path path22 = path2;
            if (path22.isAbsolute()) {
                path = path22;
            } else {
                String[] stringArray = new String[]{fileDirective.getPath2()};
                path = UtilKt.pathOrNull(fileDirective.getPath1(), stringArray);
                if (path == null) {
                    return;
                }
            }
            Path combinedPath = path;
            Boolean bl = this.matchingPaths.computeIfAbsent(((Object)combinedPath).toString(), arg_0 -> GasLocationTracker.processFileDirective$lambda$1((Function1)new Function1<String, Boolean>(this, combinedPath){
                final /* synthetic */ GasLocationTracker this$0;
                final /* synthetic */ Path $combinedPath;
                {
                    this.this$0 = $receiver;
                    this.$combinedPath = $combinedPath;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return UtilKt.isSameFile(GasLocationTracker.access$getSrcFilePath$p(this.this$0), ((Object)this.$combinedPath).toString());
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"computeIfAbsent(...)");
            boolean matchesSrcFile3 = bl;
            if (matchesSrcFile3) {
                this.srcFileNos.add(fileDirective.getFile());
            }
        }
    }

    public final boolean isSourceFileLocation(@NotNull GasLocDirective loc) {
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        return this.srcFileNos.contains(loc.getFile());
    }

    private static final Boolean processFileDirective$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Boolean processFileDirective$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ String access$getSrcFilePath$p(GasLocationTracker $this) {
        return $this.srcFilePath;
    }
}

