/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.translateCode;

import com.intellij.cidr.translateCode.GasFileDirective;
import com.intellij.cidr.translateCode.GasLocDirective;
import com.intellij.cidr.translateCode.GasSectionDirective;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/intellij/cidr/translateCode/Gas;", "", "()V", "Companion", "intellij.cidr.translateCode"})
public final class Gas {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Pattern filePattern = Pattern.compile("[ \t]*\\.file[ \t]+(?:(?<file>[0-9]+)[ \\t]+)?\"(?<path1>[^\"]+)\"(?:[ \\t]+\"(?<path2>[^\"]+)\")?.*");
    private static final Pattern locPattern = Pattern.compile("[ \t]*.loc[ \t]+(?<file>[0-9]+)[ \t]+(?<line>[0-9]+)[ \t]+.*");
    private static final Pattern cvFilePattern = Pattern.compile("[ \t]*\\.cv_file[ \t]+(?:(?<file>[0-9]+)[ \\t]+)?\"(?<path>[^\"]+)\".*");
    private static final Pattern cvLocPattern = Pattern.compile("[ \t]*.cv_loc[ \t]+[0-9]+[ \t]+(?<file>[0-9]+)[ \t]+(?<line>[0-9]+)[ \t]+.*");
    private static final Pattern sectionPattern = Pattern.compile("[ \t]*.section[ \t]+(?<text>.*)");
    @NotNull
    private static final HashSet<String> skipDirectivePrefixes;
    private static final Pattern archDirectivePattern;
    @NotNull
    private static final HashSet<String> x86Arches;

    static {
        Object[] objectArray = new String[]{"cfi_", "seh_", "def", "endef", "globl", "size", "set", "align", "p2align", "build_version", "type", "weak", "loc", "private_extern", "section", "cv_", "scl", "text", "intel_syntax", "comm"};
        skipDirectivePrefixes = SetsKt.hashSetOf((Object[])objectArray);
        archDirectivePattern = Pattern.compile("[ \t]*\\.arch[ \t](?<archName>.*)");
        objectArray = new String[]{"x86-64", "x86-64-v2", "x86-64-v3", "x86-64-v4", "i386", "i486", "i586", "pentium", "lakemont", "pentium-mmx", "pentiumpro", "i686", "pentium2", "pentium3", "pentium3m", "pentium-m", "pentium4", "pentium4m", "prescott", "nocona", "core2", "nehalem", "westmere", "sandybridge", "ivybridge", "haswell", "broadwell", "skylake", "bonnell", "silvermont", "goldmont", "goldmont-plus", "tremont", "sierraforest", "grandridge", "clearwaterforest", "knl", "knm", "skylake-avx512", "cannonlake", "icelake-client", "icelake-server", "cascadelake", "cooperlake", "tigerlake", "sapphirerapids", "alderlake", "rocketlake", "graniterapids", "graniterapids-d", "arrowlake", "arrowlake-s", "pantherlake", "k6", "k6-2", "k6-3", "athlon", "athlon-tbird", "athlon-4", "athlon-xp", "athlon-mp", "k8", "opteron", "athlon64", "athlon-fx", "k8-sse3", "opteron-sse3", "athlon64-sse3", "amdfam10", "barcelona", "bdver1", "bdver2", "bdver3", "bdver4", "znver1", "znver2", "znver3", "znver4", "btver1", "btver2", "winchip-c6", "winchip2", "c3", "c3-2", "c7", "samuel-2", "nehemiah", "esther", "eden-x2", "eden-x4", "nano", "nano-1000", "nano-2000", "nano-3000", "nano-x2", "nano-x4", "lujiazui", "yongfeng", "geode"};
        x86Arches = SetsKt.hashSetOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\rJ\u0010\u0010\u001c\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0013\u001a\u00020\u0014J\u001c\u0010#\u001a\u00020$2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\r0&J\u0018\u0010'\u001a\u00020(2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010)\u001a\u00020(H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006*"}, d2={"Lcom/intellij/cidr/translateCode/Gas$Companion;", "", "()V", "archDirectivePattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "cvFilePattern", "cvLocPattern", "filePattern", "locPattern", "sectionPattern", "skipDirectivePrefixes", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "x86Arches", "getX86Arches", "()Ljava/util/HashSet;", "getLabelName", "line", "", "isDirectiveToSkip", "", "isLabelCharacter", "c", "", "isLocalLabelName", "labelName", "parseArchDirective", "parseFileDirective", "Lcom/intellij/cidr/translateCode/GasFileDirective;", "parseLocDirective", "Lcom/intellij/cidr/translateCode/GasLocDirective;", "parseSectionDirective", "Lcom/intellij/cidr/translateCode/GasSectionDirective;", "possibleLabelRefs", "", "dst", "", "skipNonLabelCharacters", "", "start", "intellij.cidr.translateCode"})
    @SourceDebugExtension(value={"SMAP\nGas.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Gas.kt\ncom/intellij/cidr/translateCode/Gas$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,580:1\n1747#2,3:581\n*S KotlinDebug\n*F\n+ 1 Gas.kt\ncom/intellij/cidr/translateCode/Gas$Companion\n*L\n129#1:581,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HashSet<String> getX86Arches() {
            return x86Arches;
        }

        @Nullable
        public final GasFileDirective parseFileDirective(@NotNull CharSequence line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            Matcher matcher = filePattern.matcher(line);
            if (matcher.matches()) {
                String string = matcher.group("file");
                Integer file = string != null ? StringsKt.toIntOrNull((String)string) : null;
                String string2 = matcher.group("path1");
                if (string2 == null) {
                    return null;
                }
                String path1 = string2;
                String path2 = matcher.group("path2");
                return new GasFileDirective(file, path1, path2);
            }
            matcher = cvFilePattern.matcher(line);
            if (matcher.matches()) {
                String string = matcher.group("file");
                Integer file = string != null ? StringsKt.toIntOrNull((String)string) : null;
                String string3 = matcher.group("path");
                if (string3 == null) {
                    return null;
                }
                String path = string3;
                return new GasFileDirective(file, path, null);
            }
            return null;
        }

        @Nullable
        public final GasLocDirective parseLocDirective(@NotNull CharSequence line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            Matcher matcher = locPattern.matcher(line);
            if (!matcher.matches() && !(matcher = cvLocPattern.matcher(line)).matches()) {
                return null;
            }
            String string = matcher.group("file");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            Integer n = StringsKt.toIntOrNull((String)string);
            if (n == null) {
                return null;
            }
            int fileNo = n;
            String string2 = matcher.group("line");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
            Integer n2 = StringsKt.toIntOrNull((String)string2);
            if (n2 == null) {
                return null;
            }
            int lineNum = n2;
            if (lineNum == 0) {
                return null;
            }
            return new GasLocDirective(fileNo, lineNum);
        }

        public final boolean isDirectiveToSkip(@NotNull CharSequence line) {
            boolean bl;
            block4: {
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                CharSequence trimmed = StringsKt.trimStart((CharSequence)line);
                if (!StringsKt.startsWith$default((CharSequence)trimmed, (CharSequence)".", (boolean)false, (int)2, null)) {
                    return false;
                }
                CharSequence charSequence = trimmed;
                int n = 1;
                int n2 = charSequence.length();
                String name = ((Object)charSequence.subSequence(n, n2)).toString();
                Iterable $this$any$iv = skipDirectivePrefixes;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.startsWith$default((String)name, (String)it, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        @Nullable
        public final GasSectionDirective parseSectionDirective(@NotNull CharSequence line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            Matcher matcher = sectionPattern.matcher(line);
            if (!matcher.matches()) {
                return null;
            }
            String string = matcher.group("text");
            if (string == null) {
                return null;
            }
            String text = string;
            return new GasSectionDirective(((Object)StringsKt.trim((CharSequence)text)).toString());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isLabelCharacter(char c) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            if ('a' <= c) {
                if (c < '{') {
                    return true;
                }
                bl3 = false;
            } else {
                bl3 = false;
            }
            if (bl3) return true;
            if ('A' <= c) {
                if (c < '[') {
                    return true;
                }
                bl2 = false;
            } else {
                bl2 = false;
            }
            if (bl2) return true;
            if ('0' <= c) {
                if (c < ':') {
                    return true;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) return true;
            if (c == '_') return true;
            if (c == '@') return true;
            if (c == '.') return true;
            if (c == '?') return true;
            if (c == '$') return true;
            if (c != '\"') return false;
            return true;
        }

        @Nullable
        public final String getLabelName(@NotNull CharSequence line) {
            char c;
            int idx;
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            if (line.length() == 0) {
                return null;
            }
            for (idx = StringsKt.getLastIndex((CharSequence)line); idx >= 0 && ((c = line.charAt(idx)) == ' ' || c == '\t'); --idx) {
            }
            if (idx <= 0 || line.charAt(idx) != ':') {
                return null;
            }
            int colonIdx = idx--;
            while (idx >= 0 && this.isLabelCharacter(line.charAt(idx)) && idx != 0) {
                --idx;
            }
            if (idx == 0) {
                return StringsKt.substring((CharSequence)line, (IntRange)RangesKt.until((int)0, (int)colonIdx));
            }
            return null;
        }

        private final int skipNonLabelCharacters(CharSequence line, int start) {
            for (int idx = start; idx < line.length(); ++idx) {
                if (!this.isLabelCharacter(line.charAt(idx))) continue;
                return idx;
            }
            return line.length();
        }

        public final void possibleLabelRefs(@NotNull CharSequence line, @NotNull List<String> dst) {
            int start;
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            Intrinsics.checkNotNullParameter(dst, (String)"dst");
            int idx = 0;
            while (idx < line.length() && (start = this.skipNonLabelCharacters(line, idx)) < line.length()) {
                int end;
                for (end = start + 1; end < line.length() && this.isLabelCharacter(line.charAt(end)); ++end) {
                }
                dst.add(StringsKt.substring((CharSequence)line, (IntRange)RangesKt.until((int)start, (int)end)));
                idx = end;
            }
        }

        public final boolean isLocalLabelName(@NotNull String labelName) {
            Intrinsics.checkNotNullParameter((Object)labelName, (String)"labelName");
            return StringsKt.startsWith$default((String)labelName, (String)".L", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)labelName, (String)"L", (boolean)false, (int)2, null) || StringsKt.toIntOrNull((String)labelName) != null;
        }

        @Nullable
        public final String parseArchDirective(@NotNull CharSequence line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            Matcher matcher = archDirectivePattern.matcher(line);
            if (!matcher.matches()) {
                return null;
            }
            String string = matcher.group("archName");
            if (string == null) {
                return null;
            }
            String text = string;
            return ((Object)StringsKt.trim((CharSequence)text)).toString();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

