/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionSerializer
extends Serializer<Collection> {
    private boolean elementsCanBeNull = true;
    private Serializer serializer;
    private Class elementClass;
    private Class genericType;

    public CollectionSerializer() {
    }

    public CollectionSerializer(Class elementClass, Serializer serializer2) {
        this.setElementClass(elementClass, serializer2);
    }

    public CollectionSerializer(Class elementClass, Serializer serializer2, boolean elementsCanBeNull) {
        this.setElementClass(elementClass, serializer2);
        this.elementsCanBeNull = elementsCanBeNull;
    }

    public void setElementsCanBeNull(boolean elementsCanBeNull) {
        this.elementsCanBeNull = elementsCanBeNull;
    }

    public void setElementClass(Class elementClass, Serializer serializer2) {
        this.elementClass = elementClass;
        this.serializer = serializer2;
    }

    @Override
    public void setGenerics(Kryo kryo, Class[] generics) {
        this.genericType = null;
        if (generics != null && generics.length > 0 && kryo.isFinal(generics[0])) {
            this.genericType = generics[0];
        }
    }

    @Override
    public void write(Kryo kryo, Output output, Collection collection) {
        int length = collection.size();
        output.writeVarInt(length, true);
        Serializer serializer2 = this.serializer;
        if (this.genericType != null) {
            if (serializer2 == null) {
                serializer2 = kryo.getSerializer(this.genericType);
            }
            this.genericType = null;
        }
        if (serializer2 != null) {
            if (this.elementsCanBeNull) {
                for (Object element : collection) {
                    kryo.writeObjectOrNull(output, element, serializer2);
                }
            } else {
                for (Object element : collection) {
                    kryo.writeObject(output, element, serializer2);
                }
            }
        } else {
            for (Object element : collection) {
                kryo.writeClassAndObject(output, element);
            }
        }
    }

    protected Collection create(Kryo kryo, Input input, Class<Collection> type) {
        return kryo.newInstance(type);
    }

    @Override
    public Collection read(Kryo kryo, Input input, Class<Collection> type) {
        Collection collection = this.create(kryo, input, type);
        kryo.reference(collection);
        int length = input.readVarInt(true);
        if (collection instanceof ArrayList) {
            ((ArrayList)collection).ensureCapacity(length);
        }
        Class elementClass = this.elementClass;
        Serializer serializer2 = this.serializer;
        if (this.genericType != null) {
            if (serializer2 == null) {
                elementClass = this.genericType;
                serializer2 = kryo.getSerializer(this.genericType);
            }
            this.genericType = null;
        }
        if (serializer2 != null) {
            if (this.elementsCanBeNull) {
                for (int i = 0; i < length; ++i) {
                    collection.add(kryo.readObjectOrNull(input, elementClass, serializer2));
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    collection.add(kryo.readObject(input, elementClass, serializer2));
                }
            }
        } else {
            for (int i = 0; i < length; ++i) {
                collection.add(kryo.readClassAndObject(input));
            }
        }
        return collection;
    }

    protected Collection createCopy(Kryo kryo, Collection original) {
        return (Collection)kryo.newInstance(original.getClass());
    }

    @Override
    public Collection copy(Kryo kryo, Collection original) {
        Collection copy = this.createCopy(kryo, original);
        kryo.reference(copy);
        for (Object element : original) {
            copy.add(kryo.copy(element));
        }
        return copy;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface BindCollection {
        public Class<? extends Serializer> elementSerializer() default Serializer.class;

        public Class<?> elementClass() default Object.class;

        public boolean elementsCanBeNull() default true;
    }
}

