/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.scripts;

import com.intellij.icons.AllIcons;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.scripts.FileInfo;
import com.intellij.javascript.debugger.scripts.ScriptDirectoryInfo;
import com.intellij.javascript.debugger.scripts.ScriptDirectoryInfoKt;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Script;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0014\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00120\u001bH\u0014J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u0005H\u0016R\u0012\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000f0\u000ej\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001f"}, d2={"Lcom/intellij/javascript/debugger/scripts/RootsDirectoryInfo;", "Lcom/intellij/javascript/debugger/scripts/ScriptDirectoryInfo;", "name", "", "url", "Lcom/intellij/util/Url;", "icon", "Ljavax/swing/Icon;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "weight", "", "(Ljava/lang/String;Lcom/intellij/util/Url;Ljavax/swing/Icon;Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;I)V", "pendingScripts", "Ljava/util/HashMap;", "Lorg/jetbrains/debugger/Script;", "Lkotlin/collections/HashMap;", "singleChild", "Lcom/intellij/javascript/debugger/scripts/FileInfo;", "getSingleChild", "()Lcom/intellij/javascript/debugger/scripts/FileInfo;", "getWeight", "()I", "addChild", "", "script", "computeAndGetChildren", "", "hasChildren", "", "removeChild", "intellij.javascript.debugger"})
public final class RootsDirectoryInfo
extends ScriptDirectoryInfo {
    @NotNull
    private final JavaScriptDebugProcess<?> debugProcess;
    private final int weight;
    @NotNull
    private final HashMap<Url, Script> pendingScripts;

    public RootsDirectoryInfo(@NotNull String name, @NotNull Url url, @NotNull Icon icon, @NotNull JavaScriptDebugProcess<?> debugProcess, int weight) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
        super(name, url, icon);
        this.debugProcess = debugProcess;
        this.weight = weight;
        this.pendingScripts = new HashMap();
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasChildren() {
        if (super.hasChildren()) {
            return true;
        }
        HashMap<Url, Script> hashMap = this.pendingScripts;
        synchronized (hashMap) {
            boolean bl = false;
            boolean bl2 = !this.pendingScripts.isEmpty();
            return bl2;
        }
    }

    @Override
    @Nullable
    public FileInfo getSingleChild() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChild(@NotNull Script script, @NotNull Url url) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        HashMap<Url, Script> hashMap = this.pendingScripts;
        synchronized (hashMap) {
            boolean bl = false;
            ((Map)this.pendingScripts).put(url, script);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeChild(@NotNull Url url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        HashMap<Url, Script> hashMap = this.pendingScripts;
        synchronized (hashMap) {
            boolean bl = false;
            if (this.pendingScripts.remove(url) != null) {
                return;
            }
            Unit unit = Unit.INSTANCE;
        }
        super.removeChild(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected Map<String, FileInfo> computeAndGetChildren() {
        HashMap<Url, Script> hashMap = this.pendingScripts;
        synchronized (hashMap) {
            block7: {
                boolean bl = false;
                if (!this.pendingScripts.isEmpty()) break block7;
                Map<String, FileInfo> map = this.getChildNameToInfo();
                return map;
            }
            JSLibraryManager jSLibraryManager = JSLibraryManager.getInstance((Project)this.debugProcess.getSession().getProject());
            Intrinsics.checkNotNullExpressionValue((Object)jSLibraryManager, (String)"getInstance(...)");
            JSLibraryManager jsLibraryManager = jSLibraryManager;
            for (Map.Entry entry : ((Map)this.pendingScripts).entrySet()) {
                ScriptingLibraryModel library;
                Url url = (Url)entry.getKey();
                Script script = (Script)entry.getValue();
                VirtualFile file2 = Intrinsics.areEqual((Object)"vm", (Object)url.getScheme()) ? null : JavaScriptDebugProcess.findFile$default(this.debugProcess, url, false, null, 6, null);
                ScriptDirectoryInfo parent = this;
                if (file2 != null && (library = jsLibraryManager.findLibrary(file2)) != null) {
                    String libraryName;
                    Intrinsics.checkNotNullExpressionValue((Object)library.getName(), (String)"getName(...)");
                    FileInfo fileInfo = this.getChildNameToInfo().get(libraryName);
                    ScriptDirectoryInfo scriptDirectoryInfo = parent = fileInfo instanceof ScriptDirectoryInfo ? (ScriptDirectoryInfo)fileInfo : null;
                    if (parent == null) {
                        Url url2 = Urls.newUri((String)"specialNode", (String)libraryName);
                        Icon icon = AllIcons.Nodes.PpLibFolder;
                        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"PpLibFolder");
                        parent = new ScriptDirectoryInfo(libraryName, url2, icon);
                        this.getChildNameToInfo().put(libraryName, parent);
                    }
                }
                ScriptDirectoryInfo scriptDirectoryInfo = parent;
                Intrinsics.checkNotNull((Object)scriptDirectoryInfo);
                ScriptDirectoryInfoKt.addEntry(script, url, scriptDirectoryInfo, file2);
            }
            this.pendingScripts.clear();
            Unit unit = Unit.INSTANCE;
        }
        return this.getChildNameToInfo();
    }
}

