/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.scripts;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.scripts.AnonymousNode;
import com.intellij.javascript.debugger.scripts.FileInfo;
import com.intellij.javascript.debugger.scripts.ScriptsKt;
import com.intellij.javascript.debugger.scripts.VmScriptFileSystemKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.CachingSimpleNode;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.Url;
import java.awt.event.InputEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B3\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0014\u00a2\u0006\u0002\u0010\u0013J\u0013\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u0011H\u0016\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0006\u0010 \u001a\u00020\u0019J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006$"}, d2={"Lcom/intellij/javascript/debugger/scripts/FileNode;", "Lcom/intellij/ui/treeStructure/CachingSimpleNode;", "_name", "", "fileInfo", "Lcom/intellij/javascript/debugger/scripts/FileInfo;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "parent", "Lcom/intellij/ide/util/treeView/NodeDescriptor;", "", "(Ljava/lang/String;Lcom/intellij/javascript/debugger/scripts/FileInfo;Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;Lcom/intellij/ide/util/treeView/NodeDescriptor;)V", "getDebugProcess", "()Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "getFileInfo", "()Lcom/intellij/javascript/debugger/scripts/FileInfo;", "buildChildren", "", "Lcom/intellij/ui/treeStructure/SimpleNode;", "()[Lcom/intellij/ui/treeStructure/SimpleNode;", "getEqualityObjects", "()[Ljava/lang/Object;", "getWeight", "", "handleDoubleClickOrEnter", "", "tree", "Lcom/intellij/ui/treeStructure/SimpleTree;", "inputEvent", "Ljava/awt/event/InputEvent;", "isAlwaysLeaf", "", "navigateToSource", "update", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "intellij.javascript.debugger"})
public class FileNode
extends CachingSimpleNode {
    @NotNull
    private final String _name;
    @NotNull
    private final FileInfo fileInfo;
    @NotNull
    private final JavaScriptDebugProcess<?> debugProcess;

    public FileNode(@NlsSafe @NotNull String _name, @NotNull FileInfo fileInfo, @NotNull JavaScriptDebugProcess<?> debugProcess, @Nullable NodeDescriptor<Object> parent) {
        Intrinsics.checkNotNullParameter((Object)_name, (String)"_name");
        Intrinsics.checkNotNullParameter((Object)fileInfo, (String)"fileInfo");
        Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
        super(debugProcess.getSession().getProject(), parent);
        this._name = _name;
        this.fileInfo = fileInfo;
        this.debugProcess = debugProcess;
    }

    @NotNull
    public final FileInfo getFileInfo() {
        return this.fileInfo;
    }

    @NotNull
    protected final JavaScriptDebugProcess<?> getDebugProcess() {
        return this.debugProcess;
    }

    protected void update(@NotNull PresentationData presentation) {
        List<Script> scripts;
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        presentation.addText(this._name, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (this.fileInfo.isFile() && ((scripts = this.fileInfo.getScripts()).size() > 1 || scripts.get(0).getUrl() != this.fileInfo.getUrl())) {
            presentation.addText(" (", SimpleTextAttributes.GRAY_ATTRIBUTES);
            for (Script script : scripts) {
                String trimmedUrl;
                Intrinsics.checkNotNullExpressionValue((Object)StringUtil.trimMiddle((String)script.getUrl().toDecodedForm(), (int)60), (String)"trimMiddle(...)");
                presentation.addText(trimmedUrl, SimpleTextAttributes.GRAY_ATTRIBUTES);
                presentation.addText(script == scripts.get(scripts.size() - 1) ? ")" : ", ", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
        }
        presentation.setIcon(this.fileInfo.getIcon());
    }

    public boolean isAlwaysLeaf() {
        return this.fileInfo.isFile();
    }

    public int getWeight() {
        return this.fileInfo.getWeight();
    }

    @NotNull
    public Object[] getEqualityObjects() {
        Object[] objectArray = new Object[]{this.fileInfo.getUrl()};
        return objectArray;
    }

    @NotNull
    protected SimpleNode[] buildChildren() {
        List<FileInfo> children = this.fileInfo.getChildren$intellij_javascript_debugger();
        if (children.isEmpty()) {
            Intrinsics.checkNotNullExpressionValue((Object)SimpleNode.NO_CHILDREN, (String)"NO_CHILDREN");
            return SimpleNode.NO_CHILDREN;
        }
        int n = children.size();
        SimpleNode[] simpleNodeArray = new SimpleNode[n];
        for (int i = 0; i < n; ++i) {
            CachingSimpleNode cachingSimpleNode;
            int n2 = i;
            SimpleNode[] simpleNodeArray2 = simpleNodeArray;
            int n3 = n2;
            FileInfo child = children.get(n2);
            if (child == null) {
                cachingSimpleNode = new AnonymousNode((SimpleNode)this);
            } else {
                FileNode fileNode;
                FileInfo next;
                StringBuilder nameBuilder = new StringBuilder();
                nameBuilder.append(child.getName());
                int n4 = n3;
                SimpleNode[] simpleNodeArray3 = simpleNodeArray2;
                while ((next = child.getSingleChild()) != null && !next.isFile()) {
                    nameBuilder.append('/').append(next.getName());
                    child = next;
                }
                String string = nameBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                FileNode fileNode2 = fileNode = new FileNode(string, child, this.debugProcess, (NodeDescriptor<Object>)((NodeDescriptor)this));
                boolean bl = false;
                nameBuilder.setLength(0);
                Unit unit = Unit.INSTANCE;
                simpleNodeArray2 = simpleNodeArray3;
                n3 = n4;
                cachingSimpleNode = fileNode;
            }
            simpleNodeArray2[n3] = cachingSimpleNode;
        }
        return simpleNodeArray;
    }

    public void handleDoubleClickOrEnter(@NotNull SimpleTree tree, @NotNull InputEvent inputEvent) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)inputEvent, (String)"inputEvent");
        if (this.fileInfo.isFile()) {
            this.navigateToSource();
        }
    }

    public final void navigateToSource() {
        block12: {
            Navigatable navigatable;
            block11: {
                Project project;
                block10: {
                    int sourceIndex;
                    String sourceContent;
                    Url url;
                    Script script;
                    block9: {
                        VirtualFile virtualFile;
                        script = this.fileInfo.getFirstScript();
                        url = this.fileInfo.getUrl();
                        Project project2 = this.debugProcess.getSession().getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                        project = project2;
                        navigatable = this.debugProcess.getFinder().findNavigatable(url, project);
                        if (navigatable == null) break block9;
                        Navigatable navigatable2 = navigatable;
                        OpenFileDescriptor openFileDescriptor = navigatable2 instanceof OpenFileDescriptor ? (OpenFileDescriptor)navigatable2 : null;
                        Object object = openFileDescriptor != null ? openFileDescriptor.getFile() : null;
                        if (object == null) {
                            object = navigatable;
                        }
                        VirtualFile virtualFile2 = (virtualFile = object) instanceof VirtualFile ? virtualFile : null;
                        boolean bl = virtualFile2 != null ? virtualFile2.isDirectory() : false;
                        if (!bl) break block10;
                    }
                    Vm vm = this.debugProcess.getVm();
                    if (Intrinsics.areEqual((Object)url, (Object)script.getUrl()) && vm != null) {
                        VirtualFile virtualFile = this.debugProcess.findFileOrCreateVm(script);
                        if (virtualFile == null) {
                            virtualFile = (VirtualFile)VmScriptFileSystemKt.getVmFile(script);
                        }
                        VirtualFile virtualFile3 = virtualFile;
                        ApplicationManager.getApplication().invokeLater(() -> FileNode.navigateToSource$lambda$1(project, virtualFile3));
                        return;
                    }
                    VirtualFile file2 = null;
                    SourceMap sourceMap = script.getSourceMap();
                    if (url != script.getUrl() && sourceMap != null && (sourceContent = sourceMap.getSourceContent(sourceIndex = sourceMap.getSourceResolver().getSourceIndex(url))) != null) {
                        file2 = ScriptsKt.createVmFile(url, (UserDataHolder)script, sourceContent, sourceIndex);
                    }
                    if (file2 == null) {
                        file2 = ScriptsKt.findRemoteFile(script, url);
                    }
                    if (file2 != null) {
                        navigatable = (Navigatable)new OpenFileDescriptor(project, file2);
                    }
                }
                if (!(navigatable instanceof OpenFileDescriptor)) break block11;
                ((OpenFileDescriptor)navigatable).navigateInEditor(project, true);
                break block12;
            }
            Navigatable navigatable3 = navigatable;
            if (navigatable3 == null) break block12;
            navigatable3.navigate(true);
        }
    }

    private static final void navigateToSource$lambda$1(Project $project, VirtualFile $virtualFile) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$virtualFile, (String)"$virtualFile");
        new OpenFileDescriptor($project, $virtualFile).navigateInEditor($project, true);
    }
}

