/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.execution;

import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.runners.AsyncProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.DebuggableFileFinderImpl;
import com.intellij.javascript.debugger.JavaScriptDebugEngine;
import com.intellij.javascript.debugger.JavaScriptDebugEngineKt;
import com.intellij.javascript.debugger.RemoteDebuggingFileFinder;
import com.intellij.javascript.debugger.RemoteDebuggingFileFinderKt;
import com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration;
import com.intellij.javascript.debugger.execution.JavaScriptDebugSettingsEditor;
import com.intellij.javascript.debugger.execution.RemoteUrlMappingBean;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0007H\u0016J,\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/intellij/javascript/debugger/execution/JavaScriptDebugRunner;", "Lcom/intellij/execution/runners/AsyncProgramRunner;", "Lcom/intellij/execution/configurations/RunnerSettings;", "()V", "canRun", "", "executorId", "", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "execute", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/execution/ui/RunContentDescriptor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "state", "Lcom/intellij/execution/configurations/RunProfileState;", "getRunnerId", "startSession", "project", "Lcom/intellij/openapi/project/Project;", "engineAndBrowser", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/javascript/debugger/JavaScriptDebugEngine;", "Lcom/intellij/ide/browsers/WebBrowser;", "Companion", "intellij.javascript.debugger"})
@SourceDebugExtension(value={"SMAP\nJavaScriptDebugRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaScriptDebugRunner.kt\ncom/intellij/javascript/debugger/execution/JavaScriptDebugRunner\n+ 2 DebuggableProgramRunner.kt\ncom/intellij/javascript/debugger/execution/DebuggableProgramRunnerKt\n*L\n1#1,89:1\n40#2,7:90\n*S KotlinDebug\n*F\n+ 1 JavaScriptDebugRunner.kt\ncom/intellij/javascript/debugger/execution/JavaScriptDebugRunner\n*L\n86#1:90,7\n*E\n"})
public class JavaScriptDebugRunner
extends AsyncProgramRunner<RunnerSettings> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return profile instanceof JavaScriptDebugConfiguration && (Intrinsics.areEqual((Object)executorId, (Object)"Debug") || Intrinsics.areEqual((Object)executorId, (Object)"Run"));
    }

    @NotNull
    public String getRunnerId() {
        return "JavascriptDebugRunner";
    }

    @NotNull
    protected Promise<RunContentDescriptor> execute(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        RunProfile runProfile = environment.getRunProfile();
        Intrinsics.checkNotNull((Object)runProfile, (String)"null cannot be cast to non-null type com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration");
        JavaScriptDebugConfiguration configuration = (JavaScriptDebugConfiguration)runProfile;
        boolean isRun = Intrinsics.areEqual((Object)environment.getExecutor().getId(), (Object)"Run");
        Pair<JavaScriptDebugEngine, WebBrowser> engineAndBrowser = Companion.findEngineAndBrowser(configuration.getEngineId());
        if (isRun) {
            BrowserLauncher browserLauncher = BrowserLauncher.Companion.getInstance();
            String string = configuration.getUri();
            Intrinsics.checkNotNull((Object)string);
            browserLauncher.browse(string, (WebBrowser)engineAndBrowser.second, environment.getProject());
            return Promises.resolvedPromise();
        }
        JavaScriptDebugEngine javaScriptDebugEngine = (JavaScriptDebugEngine)engineAndBrowser.first;
        Project project = environment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Object object = engineAndBrowser.second;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"second");
        Promise promise2 = javaScriptDebugEngine.prepareDebugger(project, (WebBrowser)object).then(arg_0 -> JavaScriptDebugRunner.execute$lambda$0((Function1)new Function1<Unit, RunContentDescriptor>(this, environment, engineAndBrowser){
            final /* synthetic */ JavaScriptDebugRunner this$0;
            final /* synthetic */ ExecutionEnvironment $environment;
            final /* synthetic */ Pair<JavaScriptDebugEngine, WebBrowser> $engineAndBrowser;
            {
                this.this$0 = $receiver;
                this.$environment = $environment;
                this.$engineAndBrowser = $engineAndBrowser;
                super(1);
            }

            @Nullable
            public final RunContentDescriptor invoke(Unit it) {
                FileDocumentManager.getInstance().saveAllDocuments();
                Project project = this.$environment.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                return JavaScriptDebugRunner.access$startSession(this.this$0, project, this.$environment, this.$engineAndBrowser);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"then(...)");
        return promise2;
    }

    private final RunContentDescriptor startSession(Project project, ExecutionEnvironment environment, Pair<JavaScriptDebugEngine, WebBrowser> engineAndBrowser) {
        RunProfile runProfile = environment.getRunProfile();
        Intrinsics.checkNotNull((Object)runProfile, (String)"null cannot be cast to non-null type com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration");
        JavaScriptDebugConfiguration configuration = (JavaScriptDebugConfiguration)runProfile;
        String string = configuration.getUri();
        Intrinsics.checkNotNull((Object)string);
        Url url = Urls.newFromIdea((CharSequence)string);
        DebuggableFileFinderImpl defaultFileFinder = new DebuggableFileFinderImpl(project, url);
        DebuggableFileFinder fileFinder = null;
        if (url.isInLocalFileSystem()) {
            fileFinder = defaultFileFinder;
        } else {
            List<RemoteUrlMappingBean> list = configuration.getMappings();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getMappings(...)");
            fileFinder = new RemoteDebuggingFileFinder(RemoteDebuggingFileFinderKt.createUrlToLocalMap(list), defaultFileFinder);
        }
        boolean $i$f$startSession = false;
        boolean $i$f$xDebugProcessStarter = false;
        XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)environment.getProject()).startSession(environment, new XDebugProcessStarter(engineAndBrowser, fileFinder, url){
            final /* synthetic */ Pair $engineAndBrowser$inlined;
            final /* synthetic */ DebuggableFileFinder $fileFinder$inlined;
            final /* synthetic */ Url $url$inlined;
            {
                this.$engineAndBrowser$inlined = pair;
                this.$fileFinder$inlined = debuggableFileFinder;
                this.$url$inlined = url;
            }

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session2) {
                Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
                XDebugSession it = session2;
                boolean bl = false;
                JavaScriptDebugEngine javaScriptDebugEngine = (JavaScriptDebugEngine)this.$engineAndBrowser$inlined.first;
                Object object = this.$engineAndBrowser$inlined.second;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"second");
                return javaScriptDebugEngine.createDebugProcess(it, (WebBrowser)object, this.$fileFinder$inlined, this.$url$inlined, null, true);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"startSession(...)");
        RunContentDescriptor runContentDescriptor = xDebugSession.getRunContentDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)runContentDescriptor, (String)"getRunContentDescriptor(...)");
        return runContentDescriptor;
    }

    private static final RunContentDescriptor execute$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (RunContentDescriptor)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ RunContentDescriptor access$startSession(JavaScriptDebugRunner $this, Project project, ExecutionEnvironment environment, Pair engineAndBrowser) {
        return $this.startSession(project, environment, (Pair<JavaScriptDebugEngine, WebBrowser>)engineAndBrowser);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/javascript/debugger/execution/JavaScriptDebugRunner$Companion;", "", "()V", "findEngineAndBrowser", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/javascript/debugger/JavaScriptDebugEngine;", "Lcom/intellij/ide/browsers/WebBrowser;", "browserIdOrNameOrEngineId", "", "intellij.javascript.debugger"})
    @SourceDebugExtension(value={"SMAP\nJavaScriptDebugRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaScriptDebugRunner.kt\ncom/intellij/javascript/debugger/execution/JavaScriptDebugRunner$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n1#2:90\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pair<JavaScriptDebugEngine, WebBrowser> findEngineAndBrowser(@Nullable String browserIdOrNameOrEngineId) {
            WebBrowser webBrowser;
            JavaScriptDebugEngine debugEngine;
            Pair<JavaScriptDebugEngine, WebBrowser> info;
            String string = browserIdOrNameOrEngineId;
            if (string != null) {
                String it = string;
                boolean bl = false;
                v1 = JavaScriptDebugEngine.Companion.findByBrowserIdOrName(it);
            } else {
                v1 = info = null;
            }
            if (info != null) {
                return info;
            }
            String string2 = browserIdOrNameOrEngineId;
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                v3 = JavaScriptDebugEngineKt.findByBrowserIdOrNameOrEngineId(it);
            } else {
                v3 = debugEngine = null;
            }
            if (debugEngine == null) {
                List list = WebBrowserManager.getInstance().getBrowsers(JavaScriptDebugSettingsEditor.BROWSER_CONDITION);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getBrowsers(...)");
                WebBrowser defaultBrowser = (WebBrowser)CollectionsKt.firstOrNull((List)list);
                if (defaultBrowser == null) {
                    debugEngine = (JavaScriptDebugEngine)CollectionsKt.first(JavaScriptDebugEngineKt.getEngines());
                } else {
                    debugEngine = JavaScriptDebugEngine.Companion.findByBrowser(defaultBrowser);
                    Pair pair = Pair.create((Object)debugEngine, (Object)defaultBrowser);
                    Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(...)");
                    return pair;
                }
            }
            if ((webBrowser = debugEngine.getBrowser()) == null) {
                WebBrowser webBrowser2 = WebBrowserManager.getInstance().getFirstBrowser(debugEngine.getBrowserFamily());
                webBrowser = webBrowser2;
                Intrinsics.checkNotNullExpressionValue((Object)webBrowser2, (String)"getFirstBrowser(...)");
            }
            WebBrowser notNullBrowser = webBrowser;
            Pair pair = Pair.create((Object)debugEngine, (Object)notNullBrowser);
            Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(...)");
            return pair;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

