/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.console.legacy;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.console.ConsoleMessageBuilder;
import com.intellij.javascript.debugger.console.MessageType;
import com.intellij.javascript.debugger.console.legacy.Annotation;
import com.intellij.javascript.debugger.console.legacy.EditorConsoleGutterProvider;
import com.intellij.javascript.debugger.console.legacy.EditorConsoleMessageBuilder;
import com.intellij.javascript.debugger.console.legacy.LineAnnotation;
import com.intellij.javascript.debugger.console.legacy.LineAnnotationMaps;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.LazyRangeMarkerFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.xdebugger.frame.XValue;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.ScriptDebuggerUrls;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.wip.protocol.runtime.CallFrameValue;
import org.jetbrains.wip.protocol.runtime.StackTraceValue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J<\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0017\u001a\u00020\n2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0010H\u0016J<\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0017\u001a\u00020\n2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0010H\u0016J\"\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u001f\u001a\u00020\u000eH\u0016J\b\u0010 \u001a\u00020\u000eH\u0002J\b\u0010!\u001a\u00020\u000eH\u0016J\b\u0010\"\u001a\u00020\u000eH\u0016J\b\u0010#\u001a\u00020\u000eH\u0016J\u0018\u0010$\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\nH\u0016J\b\u0010'\u001a\u00020\u000eH\u0016J*\u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020\nH\u0016J\u0010\u0010-\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\b\u0010.\u001a\u00020\u000eH\u0002J\u001a\u0010/\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u00100\u001a\u0004\u0018\u000101H\u0016J\u0018\u00102\u001a\u00020\u000e2\u0006\u0010)\u001a\u0002032\u0006\u0010,\u001a\u00020\nH\u0016J\"\u00104\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u00105\u001a\u0002062\b\u00107\u001a\u0004\u0018\u00010\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/intellij/javascript/debugger/console/legacy/EditorConsoleMessageBuilder;", "Lcom/intellij/javascript/debugger/console/ConsoleMessageBuilder;", "consoleView", "Lcom/intellij/execution/ui/ConsoleView;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "gutterProvider", "Lcom/intellij/javascript/debugger/console/legacy/EditorConsoleGutterProvider;", "(Lcom/intellij/execution/ui/ConsoleView;Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;Lcom/intellij/javascript/debugger/console/legacy/EditorConsoleGutterProvider;)V", "hasNewLines", "", "indentLevel", "", "addHyperLink", "", "hyperlinkText", "", "info", "Lcom/intellij/execution/filters/HyperlinkInfo;", "url", "suggestedLine", "suggestedColumn", "functionName", "resolveToScript", "scriptId", "addMessageLink", "append", "text", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "style", "clear", "doPrintIndent", "endMessage", "flush", "groupEnd", "groupStart", "groupName", "collapsed", "increaseLastMessageRepeatCount", "printAndStoreValueToInspect", "value", "Lorg/jetbrains/debugger/values/Value;", "expression", "xmlView", "printBrowserLink", "printIndent", "printStackTrace", "stackTrace", "Lorg/jetbrains/wip/protocol/runtime/StackTraceValue;", "printValue", "Lcom/intellij/xdebugger/frame/XValue;", "startMessage", "type", "Lcom/intellij/javascript/debugger/console/MessageType;", "source", "intellij.javascript.debugger"})
@SourceDebugExtension(value={"SMAP\nEditorConsoleGutterProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorConsoleGutterProvider.kt\ncom/intellij/javascript/debugger/console/legacy/EditorConsoleMessageBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,534:1\n1#2:535\n13#3:536\n13#3:537\n1855#4,2:538\n*S KotlinDebug\n*F\n+ 1 EditorConsoleGutterProvider.kt\ncom/intellij/javascript/debugger/console/legacy/EditorConsoleMessageBuilder\n*L\n391#1:536\n396#1:537\n421#1:538,2\n*E\n"})
public final class EditorConsoleMessageBuilder
extends ConsoleMessageBuilder {
    @NotNull
    private final ConsoleView consoleView;
    @NotNull
    private final EditorConsoleGutterProvider gutterProvider;
    private boolean hasNewLines;
    private int indentLevel;

    public EditorConsoleMessageBuilder(@NotNull ConsoleView consoleView, @NotNull JavaScriptDebugProcess<?> debugProcess, @NotNull EditorConsoleGutterProvider gutterProvider) {
        Intrinsics.checkNotNullParameter((Object)consoleView, (String)"consoleView");
        Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)((Object)gutterProvider), (String)"gutterProvider");
        super(debugProcess);
        this.consoleView = consoleView;
        this.gutterProvider = gutterProvider;
    }

    @Override
    public void startMessage(@NotNull ConsoleViewContentType contentType, @NotNull MessageType type, @Nullable String source) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
    }

    @Override
    public void endMessage() {
        this.newLine();
    }

    @Override
    public void printAndStoreValueToInspect(@NotNull Value value, @Nullable String expression, @NotNull ConsoleViewContentType contentType, boolean xmlView) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        this.getTasks().add(new Function0<Unit>(this, value, expression, contentType){
            final /* synthetic */ EditorConsoleMessageBuilder this$0;
            final /* synthetic */ Value $value;
            final /* synthetic */ String $expression;
            final /* synthetic */ ConsoleViewContentType $contentType;
            {
                this.this$0 = $receiver;
                this.$value = $value;
                this.$expression = $expression;
                this.$contentType = $contentType;
                super(0);
            }

            public final void invoke() {
                this.this$0.getDebugProcess().getGlobalEvaluator().printAndStoreValueToInspect(this.$value, this.$expression, this.$contentType, EditorConsoleMessageBuilder.access$getConsoleView$p(this.this$0));
            }
        });
    }

    @Override
    public void printValue(@NotNull XValue value, boolean xmlView) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        throw new UnsupportedOperationException();
    }

    @Override
    public void append(@NotNull String text, @NotNull ConsoleViewContentType contentType, @Nullable String style) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        this.getTasks().add(new Function0<Unit>(text, this){
            final /* synthetic */ String $text;
            final /* synthetic */ EditorConsoleMessageBuilder this$0;
            {
                this.$text = $text;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                if (this.$text.length() > 1 && StringsKt.contains$default((CharSequence)this.$text, (char)'\n', (boolean)false, (int)2, null)) {
                    EditorConsoleMessageBuilder.access$setHasNewLines$p(this.this$0, true);
                }
                AnsiEscapeDecoder decoder = new AnsiEscapeDecoder();
                decoder.escapeText(this.$text, ProcessOutputTypes.STDOUT, (arg_0, arg_1) -> append.1.invoke$lambda$0(this.this$0, arg_0, arg_1));
            }

            private static final void invoke$lambda$0(EditorConsoleMessageBuilder this$0, String textChunk, Key attributes) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)textChunk, (String)"textChunk");
                Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.getConsoleViewType((Key)attributes);
                Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"getConsoleViewType(...)");
                ConsoleViewContentType chunkContentType = consoleViewContentType;
                EditorConsoleMessageBuilder.access$getConsoleView$p(this$0).print(textChunk, chunkContentType);
            }
        });
    }

    @Override
    public void increaseLastMessageRepeatCount() {
    }

    @Override
    public void clear() {
        this.gutterProvider.doClear$intellij_javascript_debugger();
        this.consoleView.clear();
    }

    @Override
    public void printStackTrace(@NotNull ConsoleViewContentType contentType, @Nullable StackTraceValue stackTrace) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        if (stackTrace == null) {
            return;
        }
        if (stackTrace.callFrames().isEmpty() || Intrinsics.areEqual((Object)"undefined", (Object)((CallFrameValue)CollectionsKt.first((List)stackTrace.callFrames())).url())) {
            return;
        }
        this.newLine();
        int n = this.indentLevel;
        this.indentLevel = n + 1;
        for (StackTraceValue currentStackTrace = stackTrace; currentStackTrace != null; currentStackTrace = currentStackTrace.getParent()) {
            if (!Intrinsics.areEqual((Object)currentStackTrace, (Object)stackTrace)) {
                ConsoleMessageBuilder.append$default(this, "Async call from " + currentStackTrace.getDescription(), contentType, null, 4, null);
                this.newLine();
            }
            for (CallFrameValue frame : currentStackTrace.callFrames()) {
                CharSequence charSequence;
                this.printIndent();
                ConsoleMessageBuilder consoleMessageBuilder = this;
                CharSequence charSequence2 = frame.functionName();
                if (charSequence2.length() == 0) {
                    ConsoleMessageBuilder consoleMessageBuilder2 = consoleMessageBuilder;
                    boolean bl = false;
                    charSequence = "(anonymous function)";
                    consoleMessageBuilder = consoleMessageBuilder2;
                } else {
                    charSequence = charSequence2;
                }
                ConsoleMessageBuilder.append$default(consoleMessageBuilder, (String)charSequence, contentType, null, 4, null);
                ConsoleMessageBuilder.append$default(this, "\t", contentType, null, 4, null);
                this.addHyperLink(frame.url(), frame.getLineNumber(), frame.getColumnNumber(), frame.functionName(), true, frame.scriptId());
                this.newLine();
            }
        }
        int n2 = this.indentLevel;
        this.indentLevel = n2 + -1;
    }

    @Override
    public void groupStart(@NotNull String groupName, boolean collapsed) {
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        this.getTasks().add(new Function0<Unit>(this, groupName){
            final /* synthetic */ EditorConsoleMessageBuilder this$0;
            final /* synthetic */ String $groupName;
            {
                this.this$0 = $receiver;
                this.$groupName = $groupName;
                super(0);
            }

            public final void invoke() {
                EditorConsoleMessageBuilder editorConsoleMessageBuilder = this.this$0;
                int n = EditorConsoleMessageBuilder.access$getIndentLevel$p(editorConsoleMessageBuilder);
                EditorConsoleMessageBuilder.access$setIndentLevel$p(editorConsoleMessageBuilder, n + 1);
                EditorConsoleMessageBuilder.access$getConsoleView$p(this.this$0).print("> " + this.$groupName, ConsoleViewContentType.SYSTEM_OUTPUT);
            }
        });
    }

    @Override
    public void groupEnd() {
        this.getTasks().add(new Function0<Unit>(this){
            final /* synthetic */ EditorConsoleMessageBuilder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                EditorConsoleMessageBuilder editorConsoleMessageBuilder = this.this$0;
                int n = EditorConsoleMessageBuilder.access$getIndentLevel$p(editorConsoleMessageBuilder);
                EditorConsoleMessageBuilder.access$setIndentLevel$p(editorConsoleMessageBuilder, n + -1);
                if (EditorConsoleMessageBuilder.access$getIndentLevel$p(this.this$0) < 0) {
                    EditorConsoleMessageBuilder.access$setIndentLevel$p(this.this$0, 0);
                }
                EditorConsoleMessageBuilder.access$getConsoleView$p(this.this$0).print("<", ConsoleViewContentType.SYSTEM_OUTPUT);
            }
        });
    }

    @Override
    public void addMessageLink(@NotNull String url, int suggestedLine, int suggestedColumn, @Nullable String functionName, boolean resolveToScript, @Nullable String scriptId) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.addHyperLink(url, suggestedLine, suggestedColumn, functionName, resolveToScript, scriptId);
    }

    @Override
    public void addHyperLink(@NotNull String url, int suggestedLine, int suggestedColumn, @Nullable String functionName, boolean resolveToScript, @Nullable String scriptId) {
        SourceInfo sourceInfo;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        int line = 0;
        line = suggestedLine;
        int column = 0;
        column = suggestedColumn;
        if (resolveToScript) {
            Vm vm = this.getDebugProcess().getActiveOrMainVm();
            if (vm != null) {
                Vm vm2 = vm;
                boolean bl = false;
                sourceInfo = this.getDebugProcess().getSourceInfo(vm2, scriptId, url, functionName, line, column);
            } else {
                sourceInfo = null;
            }
        } else {
            sourceInfo = null;
        }
        SourceInfo sourceInfo2 = sourceInfo;
        VirtualFile file2 = null;
        Url parsedUrl = null;
        if (sourceInfo2 == null) {
            parsedUrl = ScriptDebuggerUrls.parse((String)url, (boolean)true);
            file2 = parsedUrl == null ? null : JavaScriptDebugProcess.findFile$default(this.getDebugProcess(), parsedUrl, false, null, 6, null);
        } else {
            file2 = sourceInfo2.getFile();
            line = sourceInfo2.getLine();
            column = sourceInfo2.getColumn();
            parsedUrl = null;
        }
        Project project = this.getDebugProcess().getSession().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Annotation annotation = null;
        if (file2 == null) {
            Url url2 = parsedUrl;
            if (url2 == null) {
                url2 = Urls.newUnparsable((String)url);
            }
            annotation = new Annotation(url2, line, column);
        } else {
            annotation = line < 0 ? new Annotation(file2, line, column, null) : new Annotation(file2, line, column, LazyRangeMarkerFactory.getInstance((Project)project2).createRangeMarker(file2, line, column, false));
        }
        this.getTasks().add(new Function0<Unit>(annotation, this){
            final /* synthetic */ Annotation $annotation;
            final /* synthetic */ EditorConsoleMessageBuilder this$0;
            {
                this.$annotation = $annotation;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                int annoLine = this.$annotation.getLine();
                VirtualFile annoFile = this.$annotation.getFile();
                Annotation existingAnno = annoLine >= 0 && annoFile != null ? EditorConsoleMessageBuilder.access$getGutterProvider$p(this.this$0).getLineToAnnotation$intellij_javascript_debugger().find(annoFile, annoLine, this.$annotation.getColumn()) : null;
                LineAnnotationMaps lineAnnotationMaps = EditorConsoleMessageBuilder.access$getGutterProvider$p(this.this$0).getLineToAnnotation$intellij_javascript_debugger();
                int n = EditorConsoleMessageBuilder.access$getConsoleView$p(this.this$0).getContentSize();
                Annotation annotation = existingAnno;
                if (annotation == null) {
                    annotation = this.$annotation;
                }
                lineAnnotationMaps.add(n, new LineAnnotation(annotation, 0), existingAnno == null);
            }
        });
    }

    @Override
    public void addHyperLink(@NotNull String hyperlinkText, @Nullable HyperlinkInfo info) {
        Intrinsics.checkNotNullParameter((Object)hyperlinkText, (String)"hyperlinkText");
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(EditorConsoleGutterProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.warn("Not supported by legacy console");
    }

    @Override
    public void printBrowserLink(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(EditorConsoleGutterProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.warn("Not supported by legacy console");
    }

    private final void printIndent() {
        this.getTasks().add(new Function0<Unit>(this){
            final /* synthetic */ EditorConsoleMessageBuilder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                EditorConsoleMessageBuilder.access$doPrintIndent(this.this$0);
            }
        });
    }

    private final void doPrintIndent() {
        int l = this.indentLevel;
        while (l-- > 0) {
            this.consoleView.print("  ", ConsoleViewContentType.SYSTEM_OUTPUT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        int startOffset = this.consoleView.getContentSize();
        this.hasNewLines = false;
        try {
            if (this.indentLevel != 0) {
                this.doPrintIndent();
            }
            Iterable $this$forEach$iv = this.getTasks();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function0 it = (Function0)element$iv;
                boolean bl = false;
                it.invoke();
            }
        }
        finally {
            boolean markAsRelatedLines = this.hasNewLines;
            this.hasNewLines = false;
            if (markAsRelatedLines) {
                int endOffset = this.consoleView.getContentSize();
                this.gutterProvider.getRelatedLines$intellij_javascript_debugger().add(startOffset, endOffset);
            }
        }
    }

    public static final /* synthetic */ ConsoleView access$getConsoleView$p(EditorConsoleMessageBuilder $this) {
        return $this.consoleView;
    }

    public static final /* synthetic */ void access$setHasNewLines$p(EditorConsoleMessageBuilder $this, boolean bl) {
        $this.hasNewLines = bl;
    }

    public static final /* synthetic */ int access$getIndentLevel$p(EditorConsoleMessageBuilder $this) {
        return $this.indentLevel;
    }

    public static final /* synthetic */ void access$setIndentLevel$p(EditorConsoleMessageBuilder $this, int n) {
        $this.indentLevel = n;
    }

    public static final /* synthetic */ EditorConsoleGutterProvider access$getGutterProvider$p(EditorConsoleMessageBuilder $this) {
        return $this.gutterProvider;
    }

    public static final /* synthetic */ void access$doPrintIndent(EditorConsoleMessageBuilder $this) {
        $this.doPrintIndent();
    }
}

