/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.console;

import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.console.ConsoleHtmlPanel;
import com.intellij.javascript.debugger.console.jcef.JCEFConsoleHtmlPanel;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.jcef.JBCefApp;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/intellij/javascript/debugger/console/ConsoleHtmlPanelProvider;", "", "()V", "Companion", "intellij.javascript.debugger"})
public final class ConsoleHtmlPanelProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u00020\u0004H\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lcom/intellij/javascript/debugger/console/ConsoleHtmlPanelProvider$Companion;", "", "()V", "webConsoleAvailable", "", "getWebConsoleAvailable", "()Z", "createHtmlPanel", "Lcom/intellij/javascript/debugger/console/ConsoleHtmlPanel;", "project", "Lcom/intellij/openapi/project/Project;", "isJcefAvailable", "intellij.javascript.debugger"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getWebConsoleAvailable() {
            return Registry.is((String)"js.debugger.webconsole") && this.isJcefAvailable();
        }

        @Nullable
        public final ConsoleHtmlPanel createHtmlPanel(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            boolean useWebConsoleSetting = Registry.is((String)"js.debugger.webconsole");
            if (useWebConsoleSetting && !this.isJcefAvailable()) {
                NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("JavaScript Debugger Console");
                String string = JSDebuggerBundle.message("js.console.jcef.check.notification", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                Notification notification = notificationGroup.createNotification(string, NotificationType.WARNING);
                notification.notify(project);
            }
            return useWebConsoleSetting && this.isJcefAvailable() ? (ConsoleHtmlPanel)new JCEFConsoleHtmlPanel() : null;
        }

        private final boolean isJcefAvailable() {
            return JBCefApp.isSupported();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

