/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.javascript.debugger.GlobalVariablesHolder;
import com.intellij.javascript.debugger.VariablesHolder;
import com.intellij.javascript.debugger.VariablesHolderKt;
import com.intellij.javascript.debugger.console.JavaScriptDebuggerConsoleExecuteActionHandler;
import com.intellij.openapi.application.ActionsKt;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.AsyncValueLoader;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.Value;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/javascript/debugger/GlobalVariablesHolder;", "Lcom/intellij/javascript/debugger/VariablesHolder;", "vmSupplier", "Ljava/util/function/Supplier;", "Lorg/jetbrains/debugger/Vm;", "(Ljava/util/function/Supplier;)V", "variablesLoader", "Lorg/jetbrains/concurrency/AsyncValueLoader;", "", "getVariablesLoader", "()Lorg/jetbrains/concurrency/AsyncValueLoader;", "intellij.javascript.debugger"})
public final class GlobalVariablesHolder
extends VariablesHolder {
    @NotNull
    private final AsyncValueLoader<Boolean> variablesLoader;

    public GlobalVariablesHolder(@NotNull Supplier<Vm> vmSupplier2) {
        Intrinsics.checkNotNullParameter(vmSupplier2, (String)"vmSupplier");
        this.variablesLoader = (AsyncValueLoader)new AsyncValueLoader<Boolean>(vmSupplier2, this){
            final /* synthetic */ Supplier<Vm> $vmSupplier;
            final /* synthetic */ GlobalVariablesHolder this$0;
            {
                this.$vmSupplier = $vmSupplier;
                this.this$0 = $receiver;
            }

            protected boolean isCancelOnReject() {
                return true;
            }

            @NotNull
            protected Promise<Boolean> load(@NotNull AsyncPromise<Boolean> promise2) {
                Intrinsics.checkNotNullParameter(promise2, (String)"promise");
                Vm vm = this.$vmSupplier.get();
                if (vm == null) {
                    promise2.setError("vm disconnected");
                    return (Promise)promise2;
                }
                EvaluateContext globalEvaluateContext = vm.getEvaluateContext();
                if (globalEvaluateContext == null) {
                    promise2.setError("vm global evaluate unsupported");
                    return (Promise)promise2;
                }
                String string = JavaScriptDebuggerConsoleExecuteActionHandler.class.getSimpleName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
                EvaluateContext evaluateContext = globalEvaluateContext.withValueManager(string);
                Promise promise3 = EvaluateContext.evaluate$default((EvaluateContext)evaluateContext, (String)"this", null, (boolean)false, null, (int)14, null).thenAsync(arg_0 -> variablesLoader.1.load$lambda$0((Function1)new Function1<EvaluateResult, Promise<Boolean>>(this.$vmSupplier, this.this$0){
                    final /* synthetic */ Supplier<Vm> $vmSupplier;
                    final /* synthetic */ GlobalVariablesHolder this$0;
                    {
                        this.$vmSupplier = $vmSupplier;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final Promise<Boolean> invoke(EvaluateResult it) {
                        Value value = it.getValue();
                        if (!(value instanceof ObjectValue)) {
                            return Promises.resolvedPromise((Object)true);
                        }
                        return ((ObjectValue)value).getProperties().then(arg_0 -> variablesLoader.load.1.invoke$lambda$0((Function1)new Function1<List<? extends Variable>, Boolean>(this.$vmSupplier, this.this$0){
                            final /* synthetic */ Supplier<Vm> $vmSupplier;
                            final /* synthetic */ GlobalVariablesHolder this$0;
                            {
                                this.$vmSupplier = $vmSupplier;
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final Boolean invoke(List<? extends Variable> variables) {
                                if (this.$vmSupplier.get() == null || variables.isEmpty()) {
                                    return true;
                                }
                                ActionsKt.runReadAction((Function0)((Function0)new Function0<Unit>(variables, this.this$0){
                                    final /* synthetic */ List<Variable> $variables;
                                    final /* synthetic */ GlobalVariablesHolder this$0;
                                    {
                                        this.$variables = $variables;
                                        this.this$0 = $receiver;
                                        super(0);
                                    }

                                    public final void invoke() {
                                        for (Variable variable : this.$variables) {
                                            LookupElementBuilder lookupItem;
                                            String psiTypeName;
                                            String name;
                                            Intrinsics.checkNotNullExpressionValue((Object)variable.getName(), (String)"getName(...)");
                                            if (VariablesHolderKt.backendTypeNameToPsiTypeName(variable.getValue()) == null || this.this$0.getNameToPsiTypeName().put(name, psiTypeName) != null) continue;
                                            Intrinsics.checkNotNullExpressionValue((Object)LookupElementBuilder.create((String)name), (String)"create(...)");
                                            if (variable.getValue() != null) {
                                                Value it;
                                                boolean bl = false;
                                                lookupItem.withIcon(VariableView.Companion.getIcon(it));
                                            }
                                            this.this$0.getLookupElements().add((LookupElement)lookupItem);
                                        }
                                    }
                                }));
                                return true;
                            }
                        }, arg_0));
                    }

                    private static final Boolean invoke$lambda$0(Function1 $tmp0, Object p0) {
                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                        return (Boolean)$tmp0.invoke(p0);
                    }
                }, arg_0)).onProcessed(arg_0 -> variablesLoader.1.load$lambda$1((Function1)new Function1<Boolean, Unit>(evaluateContext){
                    final /* synthetic */ EvaluateContext $evaluateContext;
                    {
                        this.$evaluateContext = $evaluateContext;
                        super(1);
                    }

                    public final void invoke(Boolean it) {
                        this.$evaluateContext.releaseObjects();
                    }
                }, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)promise3, (String)"onProcessed(...)");
                return promise3;
            }

            private static final Promise load$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Promise)$tmp0.invoke(p0);
            }

            private static final void load$lambda$1(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        };
    }

    @NotNull
    protected AsyncValueLoader<Boolean> getVariablesLoader() {
        return this.variablesLoader;
    }
}

