/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.javascript.debugger.FileUrlMapper;
import com.jetbrains.plugins.webDeployment.actions.PublishedFileBrowserUrlProvider;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.LocalFileFinder;

class DeploymentServerFileUrlMapper
extends FileUrlMapper {
    DeploymentServerFileUrlMapper() {
    }

    @Override
    @NotNull
    public List<Url> getUrls(@NotNull VirtualFile file2, @NotNull Project project, @Nullable String currentAuthority) {
        if (file2 == null) {
            DeploymentServerFileUrlMapper.$$$reportNull$$$0(0);
        }
        if (project == null) {
            DeploymentServerFileUrlMapper.$$$reportNull$$$0(1);
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)PublishedFileBrowserUrlProvider.getUrl((Project)project, (VirtualFile)file2));
        if (list == null) {
            DeploymentServerFileUrlMapper.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    public VirtualFile getFile(@NotNull Url url, @NotNull Project project, @Nullable Url requestor) {
        if (url == null) {
            DeploymentServerFileUrlMapper.$$$reportNull$$$0(3);
        }
        if (project == null) {
            DeploymentServerFileUrlMapper.$$$reportNull$$$0(4);
        }
        if (url.isInLocalFileSystem()) {
            return null;
        }
        List servers = GroupedServersConfigManager.getInstance((Project)project).getFlattenedServers();
        String authority = url.getAuthority();
        if (StringUtil.isEmpty((String)authority) || servers.isEmpty()) {
            return null;
        }
        PublishConfig publishConfig = PublishConfig.getInstance((Project)project);
        List defaultServers = publishConfig.findDefaultServers();
        VirtualFile result = DeploymentServerFileUrlMapper.findFile(defaultServers, url, authority, publishConfig);
        if (result == null) {
            result = DeploymentServerFileUrlMapper.findFile(servers, url, authority, publishConfig);
        }
        return result;
    }

    @Nullable
    private static VirtualFile findFile(@NotNull List<WebServerConfig> servers, @NotNull Url url, @NotNull String authority, @NotNull PublishConfig publishConfig) {
        if (servers == null) {
            DeploymentServerFileUrlMapper.$$$reportNull$$$0(5);
        }
        if (url == null) {
            DeploymentServerFileUrlMapper.$$$reportNull$$$0(6);
        }
        if (authority == null) {
            DeploymentServerFileUrlMapper.$$$reportNull$$$0(7);
        }
        if (publishConfig == null) {
            DeploymentServerFileUrlMapper.$$$reportNull$$$0(8);
        }
        if (servers.isEmpty()) {
            return null;
        }
        if (servers.size() == 1) {
            WebServerConfig serverConfig = servers.get(0);
            return serverConfig.validateUrl() != null ? null : DeploymentServerFileUrlMapper.urlToFile(url, serverConfig, authority, publishConfig);
        }
        TreeMap sortedServers = new TreeMap(Comparator.reverseOrder());
        for (WebServerConfig server : servers) {
            if (server.validateUrl() != null) continue;
            sortedServers.put(server.getUrl(), server);
        }
        for (WebServerConfig server : sortedServers.values()) {
            VirtualFile result = DeploymentServerFileUrlMapper.urlToFile(url, server, authority, publishConfig);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    private static VirtualFile urlToFile(Url url, WebServerConfig server, String authority, PublishConfig publishConfig) {
        DeploymentPathMapping mapping;
        URL javaUrl;
        try {
            javaUrl = new URL(server.getUrl());
            if (!authority.equalsIgnoreCase(javaUrl.getAuthority())) {
                return null;
            }
        }
        catch (MalformedURLException ignored) {
            return null;
        }
        String path = url.getPath();
        if (!StringUtil.isEmpty((String)javaUrl.getPath())) {
            if (!path.startsWith(javaUrl.getPath())) {
                return null;
            }
            path = path.substring(javaUrl.getPath().length());
        }
        if ((mapping = publishConfig.getNearestMappingForWeb(path, false, true, false, (Mappable)server)) != null) {
            VirtualFile parent = LocalFileFinder.findFile((String)mapping.getLocalPath());
            String pathRemainderForWeb = parent == null ? null : mapping.getPathRemainderForWeb(path);
            return pathRemainderForWeb == null ? null : parent.findFileByRelativePath(pathRemainderForWeb);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/debugger/DeploymentServerFileUrlMapper";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "servers";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authority";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "publishConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/debugger/DeploymentServerFileUrlMapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUrls";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

