/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.breakpoints.JavaScriptExceptionBreakpointProperties;
import com.intellij.javascript.debugger.breakpoints.JavaScriptExceptionBreakpointType;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.ExceptionCatchMode;
import org.jetbrains.debugger.ExceptionData;
import org.jetbrains.debugger.RejectErrorReporter;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.Value;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u0011\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00022\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u001c\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J \u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0002J\u0016\u0010\u0017\u001a\u00020\u00182\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016J\u001e\u0010\u0019\u001a\u00020\u00182\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u001a\u001a\u00020\u0015H\u0016R*\u0010\u0007\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\bj\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/javascript/debugger/ChromeExceptionBreakpointHandler;", "Lcom/intellij/xdebugger/breakpoints/XBreakpointHandler;", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "Lcom/intellij/javascript/debugger/breakpoints/JavaScriptExceptionBreakpointProperties;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "(Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;)V", "activeBreakpoints", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "exceptionCatchMode", "Lorg/jetbrains/debugger/ExceptionCatchMode;", "findActiveBreakpoint", "exceptionName", "", "findBreakpoint", "Lorg/jetbrains/concurrency/Promise;", "exceptionData", "Lorg/jetbrains/debugger/ExceptionData;", "getResult", "isSuitable", "", "breakpoint", "registerBreakpoint", "", "unregisterBreakpoint", "temporary", "intellij.javascript.debugger"})
public final class ChromeExceptionBreakpointHandler
extends XBreakpointHandler<XBreakpoint<JavaScriptExceptionBreakpointProperties>> {
    @NotNull
    private final JavaScriptDebugProcess<?> debugProcess;
    @NotNull
    private final HashSet<XBreakpoint<JavaScriptExceptionBreakpointProperties>> activeBreakpoints;
    @NotNull
    private volatile ExceptionCatchMode exceptionCatchMode;

    public ChromeExceptionBreakpointHandler(@NotNull JavaScriptDebugProcess<?> debugProcess) {
        Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
        super(JavaScriptExceptionBreakpointType.class);
        this.debugProcess = debugProcess;
        this.activeBreakpoints = new HashSet();
        this.exceptionCatchMode = ExceptionCatchMode.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerBreakpoint(@NotNull XBreakpoint<JavaScriptExceptionBreakpointProperties> breakpoint) {
        ExceptionCatchMode exceptionCatchMode;
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        HashSet<XBreakpoint<JavaScriptExceptionBreakpointProperties>> hashSet = this.activeBreakpoints;
        synchronized (hashSet) {
            boolean bl = false;
            this.activeBreakpoints.add(breakpoint);
            exceptionCatchMode = ((JavaScriptExceptionBreakpointProperties)breakpoint.getProperties()).getUncaughtOnly() ? ExceptionCatchMode.UNCAUGHT : ExceptionCatchMode.ALL;
        }
        ExceptionCatchMode newMode = exceptionCatchMode;
        if (newMode == this.exceptionCatchMode || this.exceptionCatchMode == ExceptionCatchMode.ALL) {
            return;
        }
        this.exceptionCatchMode = newMode;
        Vm vm = this.debugProcess.getActiveOrMainVm();
        Intrinsics.checkNotNull((Object)vm);
        Promise promise2 = vm.setBreakOnException(newMode);
        XDebugSession xDebugSession = this.debugProcess.getSession();
        Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"getSession(...)");
        promise2.onError((Consumer)new RejectErrorReporter(xDebugSession, JSDebuggerBundle.message("chrome.breakpoint.error.cannot.set.exception.catch.mode", new Object[0])));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterBreakpoint(@NotNull XBreakpoint<JavaScriptExceptionBreakpointProperties> breakpoint, boolean temporary) {
        ExceptionCatchMode exceptionCatchMode;
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        HashSet<XBreakpoint<JavaScriptExceptionBreakpointProperties>> hashSet = this.activeBreakpoints;
        synchronized (hashSet) {
            boolean bl = false;
            ExceptionCatchMode newMode = null;
            this.activeBreakpoints.remove(breakpoint);
            if (this.activeBreakpoints.isEmpty()) {
                newMode = ExceptionCatchMode.NONE;
            } else {
                newMode = ExceptionCatchMode.UNCAUGHT;
                for (XBreakpoint<JavaScriptExceptionBreakpointProperties> activeBreakpoint : this.activeBreakpoints) {
                    if (((JavaScriptExceptionBreakpointProperties)activeBreakpoint.getProperties()).getUncaughtOnly()) continue;
                    newMode = ExceptionCatchMode.ALL;
                    break;
                }
            }
            exceptionCatchMode = newMode;
        }
        ExceptionCatchMode newMode = exceptionCatchMode;
        if (newMode != this.exceptionCatchMode) {
            this.exceptionCatchMode = newMode;
            Vm vm = this.debugProcess.getActiveOrMainVm();
            Intrinsics.checkNotNull((Object)vm);
            vm.setBreakOnException(newMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Promise<XBreakpoint<?>> findBreakpoint(@Nullable ExceptionData exceptionData) {
        if (exceptionData == null) {
            return Promises.rejectedPromise((String)"Internal error");
        }
        Value exceptionValue = exceptionData.getExceptionValue();
        if (!(exceptionValue instanceof ObjectValue)) {
            return Promises.resolvedPromise(this.getResult(exceptionData, null));
        }
        ObjectValue object = (ObjectValue)exceptionValue;
        String className = object.getClassName();
        if (className != null) {
            HashSet<XBreakpoint<JavaScriptExceptionBreakpointProperties>> hashSet = this.activeBreakpoints;
            synchronized (hashSet) {
                boolean bl = false;
                for (XBreakpoint<JavaScriptExceptionBreakpointProperties> breakpoint : this.activeBreakpoints) {
                    if (!Intrinsics.areEqual((Object)className, (Object)((JavaScriptExceptionBreakpointProperties)breakpoint.getProperties()).getExceptionName())) continue;
                    Intrinsics.checkNotNull(breakpoint);
                    if (!this.isSuitable(exceptionData, breakpoint)) continue;
                    Promise promise2 = Promises.resolvedPromise(breakpoint);
                    return promise2;
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        Promise promise3 = object.getProperties().then(arg_0 -> ChromeExceptionBreakpointHandler.findBreakpoint$lambda$3((Function1)new Function1<List<? extends Variable>, XBreakpoint<?>>(this, exceptionData){
            final /* synthetic */ ChromeExceptionBreakpointHandler this$0;
            final /* synthetic */ ExceptionData $exceptionData;
            {
                this.this$0 = $receiver;
                this.$exceptionData = $exceptionData;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final XBreakpoint<?> invoke(List<? extends Variable> it) {
                void var5_8;
                Value value;
                Variable variable;
                Variable name = null;
                Variable type = null;
                for (Variable variable2 : it) {
                    if (Intrinsics.areEqual((Object)"name", (Object)variable2.getName())) {
                        name = variable2;
                    } else if (Intrinsics.areEqual((Object)"type", (Object)variable2.getName())) {
                        type = variable2;
                    }
                    if (name == null) continue;
                }
                if ((variable = name) == null) {
                    variable = type;
                }
                Variable nameProperty = variable;
                Object var5_6 = null;
                if (nameProperty != null && (value = nameProperty.getValue()) != null) {
                    String string = value.getValueString();
                }
                return ChromeExceptionBreakpointHandler.access$getResult(this.this$0, this.$exceptionData, (String)var5_8);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise3, (String)"then(...)");
        return promise3;
    }

    private final XBreakpoint<?> getResult(ExceptionData exceptionData, String exceptionName) {
        XBreakpoint<JavaScriptExceptionBreakpointProperties> breakpoint = this.findActiveBreakpoint(exceptionName);
        return breakpoint != null && this.isSuitable(exceptionData, breakpoint) ? breakpoint : null;
    }

    private final boolean isSuitable(ExceptionData exceptionData, XBreakpoint<JavaScriptExceptionBreakpointProperties> breakpoint) {
        return !((JavaScriptExceptionBreakpointProperties)breakpoint.getProperties()).getUncaughtOnly() || exceptionData.isUncaught() != ThreeState.NO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final XBreakpoint<JavaScriptExceptionBreakpointProperties> findActiveBreakpoint(String exceptionName) {
        HashSet<XBreakpoint<JavaScriptExceptionBreakpointProperties>> hashSet = this.activeBreakpoints;
        synchronized (hashSet) {
            XBreakpoint<JavaScriptExceptionBreakpointProperties> breakpoint;
            boolean bl = false;
            XBreakpoint<JavaScriptExceptionBreakpointProperties> defaultBreakpoint = null;
            Iterator<XBreakpoint<JavaScriptExceptionBreakpointProperties>> iterator = this.activeBreakpoints.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return defaultBreakpoint;
                }
                breakpoint = iterator.next();
                String name = ((JavaScriptExceptionBreakpointProperties)breakpoint.getProperties()).getExceptionName();
                if (name == null) {
                    defaultBreakpoint = breakpoint;
                    if (exceptionName != null) continue;
                    return defaultBreakpoint;
                }
                if (Intrinsics.areEqual((Object)name, (Object)exceptionName)) break;
            }
            return breakpoint;
        }
    }

    private static final XBreakpoint findBreakpoint$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (XBreakpoint)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ XBreakpoint access$getResult(ChromeExceptionBreakpointHandler $this, ExceptionData exceptionData, String exceptionName) {
        return $this.getResult(exceptionData, exceptionName);
    }
}

