/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.ChromeEvaluator;
import com.intellij.javascript.debugger.ExpressionInfoFactory;
import com.intellij.javascript.debugger.GlobalEvaluator;
import com.intellij.javascript.debugger.JSDebuggerSupportUtils;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JavaScriptDebuggerViewSupportKt;
import com.intellij.javascript.debugger.JavaScriptNameMapper;
import com.intellij.javascript.debugger.JavaScriptNameMapperKt;
import com.intellij.javascript.debugger.NameMapper;
import com.intellij.javascript.debugger.NameMapperKt;
import com.intellij.javascript.debugger.SegmentList;
import com.intellij.javascript.debugger.scripts.VmScriptFileSystemKt;
import com.intellij.javascript.debugger.sourcemap.ScriptMappingEntriesInLine;
import com.intellij.javascript.debugger.sourcemap.SourceMapHelperKt;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Url;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.jetbrains.javascript.debugger.JavaScriptDebugAware;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.PromiseDebuggerEvaluator;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.ScopeType;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.ScriptManager;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.frame.CallFrameView;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.Mappings;
import org.jetbrains.debugger.sourcemap.MappingsProcessorInLine;
import org.jetbrains.debugger.sourcemap.SourceFileResolver;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.debugger.values.ObjectValue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00072\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0014J4\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J0\u0010\u0017\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002J0\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0006\u0010 \u001a\u00020!2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J \u0010&\u001a\u0004\u0018\u00010\u001b2\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00192\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u00a8\u0006'"}, d2={"Lcom/intellij/javascript/debugger/ChromeEvaluator;", "Lorg/jetbrains/debugger/PromiseDebuggerEvaluator;", "Lcom/intellij/javascript/debugger/ExpressionInfoFactory;", "context", "Lorg/jetbrains/debugger/VariableContext;", "(Lorg/jetbrains/debugger/VariableContext;)V", "create", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/xdebugger/evaluation/ExpressionInfo;", "element", "Lcom/intellij/psi/PsiElement;", "document", "Lcom/intellij/openapi/editor/Document;", "createNameMapper", "Lcom/intellij/javascript/debugger/NameMapper;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "evaluate", "Lorg/jetbrains/debugger/EvaluateResult;", "expression", "", "expressionPosition", "Lcom/intellij/xdebugger/XSourcePosition;", "getEvaluationInfoBySourceMap", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "script", "Lorg/jetbrains/debugger/Script;", "mappings", "", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "getExpressionInfoAtOffsetAsync", "project", "Lcom/intellij/openapi/project/Project;", "offset", "", "sideEffectsAllowed", "", "getPreferredScript", "intellij.javascript.debugger"})
public class ChromeEvaluator
extends PromiseDebuggerEvaluator
implements ExpressionInfoFactory {
    public ChromeEvaluator(@NotNull VariableContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Promise<ExpressionInfo> getExpressionInfoAtOffsetAsync(@NotNull Project project, @NotNull Document document, int offset, boolean sideEffectsAllowed) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        JavaScriptDebugProcess<?> debugProcess = JavaScriptDebuggerViewSupportKt.getDebugProcess(this.getContext());
        if (!debugProcess.checkCanPerformCommands()) {
            return Promises.resolvedPromise();
        }
        GlobalEvaluator evaluator = debugProcess.getGlobalEvaluator();
        if (evaluator.isDocumentForEvaluation(document)) {
            SegmentList.SegmentListWithData<Pair<String, ObjectValue>> segmentListWithData = evaluator.getValues();
            synchronized (segmentListWithData) {
                int rangeIndex;
                block9: {
                    boolean bl = false;
                    rangeIndex = evaluator.getValues().getRangeIndex(offset);
                    if (rangeIndex != -1) break block9;
                    Promise promise2 = Promises.resolvedPromise();
                    return promise2;
                }
                Promise promise3 = Promises.resolvedPromise((Object)new ExpressionInfo(evaluator.getValues().createRange(rangeIndex), (String)evaluator.getValues().getValueByIndex(rangeIndex).getFirst()));
                return promise3;
            }
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (psiFile == null) {
            return Promises.resolvedPromise();
        }
        PsiFile file2 = psiFile;
        for (JavaScriptDebugAware debugAware : (JavaScriptDebugAware[])JavaScriptDebugAware.Companion.getEP_NAME().getExtensions()) {
            PsiElement element;
            if (!debugAware.canGetEvaluationInfo(file2)) continue;
            if (file2.findElementAt(offset) == null) {
                return Promises.resolvedPromise();
            }
            Promise<ExpressionInfo> promise4 = debugAware.getEvaluationInfo(element, document, this);
            if (promise4 == null) continue;
            Promise<ExpressionInfo> it = promise4;
            boolean bl = false;
            return it;
        }
        Ref.IntRef attempts = new Ref.IntRef();
        CancellablePromise cancellablePromise = ReadAction.nonBlocking(() -> ChromeEvaluator.getExpressionInfoAtOffsetAsync$lambda$2(attempts, document, file2, offset)).expireWhen(() -> ChromeEvaluator.getExpressionInfoAtOffsetAsync$lambda$3(attempts)).submit((Executor)AppExecutorUtil.getAppExecutorService());
        Intrinsics.checkNotNullExpressionValue((Object)cancellablePromise, (String)"submit(...)");
        return (Promise)cancellablePromise;
    }

    @Override
    @NotNull
    public Promise<ExpressionInfo> create(@NotNull PsiElement element, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        JavaScriptDebugProcess<?> javaScriptDebugProcess = JavaScriptDebuggerViewSupportKt.getDebugProcess(this.getContext());
        VirtualFile virtualFile = element.getContainingFile().getVirtualFile();
        Intrinsics.checkNotNull((Object)virtualFile);
        Promise promise2 = this.getEvaluationInfoBySourceMap(element, document, javaScriptDebugProcess, virtualFile).then(arg_0 -> ChromeEvaluator.create$lambda$4((Function1)new Function1<ExpressionInfo, ExpressionInfo>(element){
            final /* synthetic */ PsiElement $element;
            {
                this.$element = $element;
                super(1);
            }

            public final ExpressionInfo invoke(@Nullable ExpressionInfo it) {
                ExpressionInfo expressionInfo = it;
                if (expressionInfo == null) {
                    expressionInfo = new ExpressionInfo(this.$element.getTextRange());
                }
                return expressionInfo;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"then(...)");
        return promise2;
    }

    @Override
    @Nullable
    public NameMapper createNameMapper(@NotNull VirtualFile file2, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        JavaScriptDebugProcess<?> debugProcess = JavaScriptDebuggerViewSupportKt.getDebugProcess(this.getContext());
        List<Url> urls = debugProcess.getFinder().getRemoteUrls(file2);
        Ref.ObjectRef result = new Ref.ObjectRef();
        Project project = debugProcess.getSession().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Lazy<SourceFileResolver> resolver = SourceMapHelperKt.createResolver(project, file2);
        Function1 processor2 = (Function1)new Function1<Script, Boolean>(urls, file2, resolver, (Ref.ObjectRef<NameMapper>)result, debugProcess, document){
            final /* synthetic */ List<Url> $urls;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ Lazy<SourceFileResolver> $resolver;
            final /* synthetic */ Ref.ObjectRef<NameMapper> $result;
            final /* synthetic */ JavaScriptDebugProcess<?> $debugProcess;
            final /* synthetic */ Document $document;
            {
                this.$urls = $urls;
                this.$file = $file;
                this.$resolver = $resolver;
                this.$result = $result;
                this.$debugProcess = $debugProcess;
                this.$document = $document;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Boolean invoke(@NotNull Script script) {
                Intrinsics.checkNotNullParameter((Object)script, (String)"script");
                SourceMap sourceMap = script.getSourceMap();
                if (sourceMap == null) {
                    return true;
                }
                SourceMap map = sourceMap;
                for (Url url : this.$urls) {
                    Mappings mappings = map.findSourceMappings(url, this.$file, this.$resolver, false);
                    if (mappings == null) continue;
                    Ref.ObjectRef<NameMapper> objectRef = this.$result;
                    if (JavaScriptDebugProcess.findFile$default(this.$debugProcess, script.getUrl(), false, null, 6, null) != null) {
                        JavaScriptNameMapper javaScriptNameMapper;
                        void file2;
                        VirtualFile virtualFile;
                        Document document = this.$document;
                        VirtualFile virtualFile2 = virtualFile;
                        Ref.ObjectRef<NameMapper> objectRef2 = objectRef;
                        boolean bl = false;
                        if (FileDocumentManager.getInstance().getDocument((VirtualFile)file2) != null) {
                            Document it;
                            boolean bl2 = false;
                            Intrinsics.checkNotNull((Object)it);
                            javaScriptNameMapper = new JavaScriptNameMapper(document, it, mappings, map, (VirtualFile)file2);
                        } else {
                            javaScriptNameMapper = null;
                        }
                        v3 = javaScriptNameMapper;
                        objectRef = objectRef2;
                    } else {
                        v3 = objectRef.element = null;
                    }
                    if (this.$result.element == null) continue;
                    return false;
                }
                return true;
            }
        };
        Script preferredScript = this.getPreferredScript(debugProcess, file2);
        if (preferredScript == null) {
            Vm vm = debugProcess.getActiveOrMainVm();
            if (vm != null && (vm = vm.getScriptManager()) != null) {
                vm.forEachScript(processor2);
            }
        } else {
            processor2.invoke((Object)preferredScript);
        }
        return (NameMapper)result.element;
    }

    private final Promise<ExpressionInfo> getEvaluationInfoBySourceMap(PsiElement element, Document document, JavaScriptDebugProcess<?> debugProcess, VirtualFile file2) {
        int elementOffset = element.getTextOffset();
        int line = document.getLineNumber(elementOffset);
        int elementColumn = elementOffset - document.getLineStartOffset(line);
        int elementEndColumn = elementColumn + element.getTextLength() - 1;
        MultiMap multiMap = MultiMap.createLinked();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"createLinked(...)");
        MultiMap scriptToMappings = multiMap;
        Script preferredScript = this.getPreferredScript(debugProcess, file2);
        AtomicReference<Object> currentScriptOrUrl = new AtomicReference<Object>();
        MappingsProcessorInLine processor2 = new MappingsProcessorInLine(elementColumn, elementEndColumn, (MultiMap<Object, MappingEntry>)scriptToMappings, currentScriptOrUrl){
            final /* synthetic */ int $elementColumn;
            final /* synthetic */ int $elementEndColumn;
            final /* synthetic */ MultiMap<Object, MappingEntry> $scriptToMappings;
            final /* synthetic */ AtomicReference<Object> $currentScriptOrUrl;
            {
                this.$elementColumn = $elementColumn;
                this.$elementEndColumn = $elementEndColumn;
                this.$scriptToMappings = $scriptToMappings;
                this.$currentScriptOrUrl = $currentScriptOrUrl;
            }

            public boolean process(@NotNull MappingEntry entry, @Nullable MappingEntry nextEntry) {
                boolean isSuitable;
                Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                int entryColumn = entry.getSourceColumn();
                boolean bl = nextEntry == null || entryColumn == 0 && nextEntry.getSourceColumn() == 0 ? entryColumn <= this.$elementColumn : (this.$elementColumn <= entryColumn ? entryColumn <= this.$elementEndColumn : (isSuitable = false));
                if (isSuitable) {
                    this.$scriptToMappings.putValue(this.$currentScriptOrUrl.get(), (Object)entry);
                }
                return true;
            }
        };
        List<Url> sourceUrls = debugProcess.getFinder().getRemoteUrls(file2);
        Script script = preferredScript;
        if ((script != null ? script.getSourceMap() : null) == null) {
            for (ScriptMappingEntriesInLine scriptMappingEntries : SourceMapHelperKt.getMappingsInLine(debugProcess, debugProcess.getActiveOrMainVm(), sourceUrls, file2, line)) {
                Script script2 = scriptMappingEntries.getScript();
                if (script2 == null) {
                    script2 = scriptMappingEntries.getUrlOrFromScript();
                }
                currentScriptOrUrl.set(script2);
                processor2.processIterable(scriptMappingEntries.getEntries());
            }
        } else {
            currentScriptOrUrl.set(preferredScript.getUrl());
            Project project = debugProcess.getSession().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Lazy<SourceFileResolver> resolver = SourceMapHelperKt.createResolver(project, file2);
            for (Url sourceUrl : sourceUrls) {
                SourceMap sourceMap = preferredScript.getSourceMap();
                Intrinsics.checkNotNull((Object)sourceMap);
                processor2.processIterable(sourceMap.getSourceMappingsInLine(sourceUrl, line, file2, resolver, false));
            }
        }
        if (scriptToMappings.isEmpty()) {
            return Promises.resolvedPromise();
        }
        for (Object object : scriptToMappings.entrySet()) {
            Intrinsics.checkNotNull((Object)object);
            Object key = object.getKey();
            Collection value = (Collection)object.getValue();
            Intrinsics.checkNotNull((Object)debugProcess.getActiveOrMainVm());
            Script script3 = key instanceof Script ? (Script)key : null;
            if (script3 == null) {
                Vm vm;
                ScriptManager scriptManager = vm.getScriptManager();
                Intrinsics.checkNotNull(key, (String)"null cannot be cast to non-null type com.intellij.util.Url");
                script3 = scriptManager.findScriptByUrl((Url)key);
                if (script3 == null) continue;
            }
            Script script4 = script3;
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<org.jetbrains.debugger.sourcemap.MappingEntry>");
            Promise<ExpressionInfo> expressionInfo = this.getEvaluationInfoBySourceMap(element, script4, TypeIntrinsics.asMutableList((Object)value));
            if (expressionInfo == null) continue;
            return expressionInfo;
        }
        return Promises.resolvedPromise();
    }

    private final Script getPreferredScript(JavaScriptDebugProcess<?> debugProcess, VirtualFile file2) {
        CallFrameView topFrameView = (CallFrameView)debugProcess.getSession().getCurrentStackFrame();
        if (topFrameView != null) {
            SourceInfo topFrameSourceInfo;
            SourceInfo sourceInfo = topFrameSourceInfo = topFrameView.getSourcePosition();
            if (Intrinsics.areEqual((Object)(sourceInfo != null ? sourceInfo.getFile() : null), (Object)file2)) {
                return topFrameView.getScript();
            }
        }
        return null;
    }

    private final Promise<ExpressionInfo> getEvaluationInfoBySourceMap(PsiElement element, Script script, List<MappingEntry> mappings) {
        boolean isNamedElement = element.getParent() instanceof PsiNamedElement;
        if (mappings.size() > 1 && isNamedElement) {
            NameMapperKt.warnSeveralMapping(element);
            return null;
        }
        Comparator<Object> comparator = Comparator.comparing(arg_0 -> ChromeEvaluator.getEvaluationInfoBySourceMap$lambda$5((Function1)getEvaluationInfoBySourceMap.1.INSTANCE, arg_0)).thenComparing(arg_0 -> ChromeEvaluator.getEvaluationInfoBySourceMap$lambda$6((Function1)getEvaluationInfoBySourceMap.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"thenComparing(...)");
        CollectionsKt.sortWith(mappings, comparator);
        return VmScriptFileSystemKt.getVmFile(script).ensureDownloaded().then(arg_0 -> ChromeEvaluator.getEvaluationInfoBySourceMap$lambda$7((Function1)new Function1<VirtualFile, ExpressionInfo>(element, script, mappings){
            final /* synthetic */ PsiElement $element;
            final /* synthetic */ Script $script;
            final /* synthetic */ List<MappingEntry> $mappings;
            {
                this.$element = $element;
                this.$script = $script;
                this.$mappings = $mappings;
                super(1);
            }

            @Nullable
            public final ExpressionInfo invoke(VirtualFile it) {
                ExpressionInfo expressionInfo;
                String generatedName;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.intellij.testFramework.LightVirtualFile");
                Document document = (Document)new DocumentImpl(((LightVirtualFile)it).getContent(), true);
                SourceMap sourceMap = this.$script.getSourceMap();
                Intrinsics.checkNotNull((Object)sourceMap);
                String string = generatedName = JavaScriptNameMapperKt.computeGeneratedName(this.$element, document, sourceMap, this.$mappings);
                if (string != null) {
                    String string2 = string;
                    PsiElement psiElement = this.$element;
                    String it2 = string2;
                    boolean bl = false;
                    expressionInfo = new ExpressionInfo(psiElement.getTextRange(), generatedName, null);
                } else {
                    expressionInfo = null;
                }
                return expressionInfo;
            }
        }, arg_0));
    }

    @Override
    @NotNull
    protected Promise<EvaluateResult> evaluate(@NotNull String expression, @Nullable XSourcePosition expressionPosition) {
        Promise promise2;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Promise promise3 = null;
        VariableContext context = this.getContext();
        if (context instanceof CallFrameView) {
            for (Scope scope : ((CallFrameView)context).getCallFrame().getVariableScopes()) {
                if (scope.getType() != ScopeType.LOCAL) continue;
                promise3 = ((CallFrameView)context).getMemberFilter(scope).thenAsync(arg_0 -> ChromeEvaluator.evaluate$lambda$8((Function1)new Function1<MemberFilter, Promise<EvaluateResult>>(context, expression){
                    final /* synthetic */ VariableContext $context;
                    final /* synthetic */ String $expression;
                    {
                        this.$context = $context;
                        this.$expression = $expression;
                        super(1);
                    }

                    public final Promise<EvaluateResult> invoke(MemberFilter it) {
                        EvaluateContext evaluateContext = this.$context.getEvaluateContext();
                        String string = it.sourceNameToRaw(this.$expression);
                        if (string == null) {
                            string = this.$expression;
                        }
                        return EvaluateContext.evaluate$default((EvaluateContext)evaluateContext, (String)string, null, (boolean)false, (Project)JavaScriptDebuggerViewSupportKt.getDebugProcess(this.$context).getSession().getProject(), (int)6, null);
                    }
                }, arg_0));
                break;
            }
            if (((CallFrameView)context).getCallFrame().isFromAsyncStack()) {
                return Promises.rejectedPromise((String)"Can't be evaluated in async context");
            }
        }
        if ((promise2 = promise3) == null) {
            promise2 = EvaluateContext.evaluate$default((EvaluateContext)context.getEvaluateContext(), (String)expression, null, (boolean)false, (Project)JavaScriptDebuggerViewSupportKt.getDebugProcess(context).getSession().getProject(), (int)6, null);
        }
        Promise promise4 = promise2.thenAsync(arg_0 -> ChromeEvaluator.evaluate$lambda$9(evaluate.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise4, (String)"thenAsync(...)");
        return promise4;
    }

    private static final ExpressionInfo getExpressionInfoAtOffsetAsync$lambda$2(Ref.IntRef $attempts, Document $document, PsiFile $file, int $offset) {
        Intrinsics.checkNotNullParameter((Object)$attempts, (String)"$attempts");
        Intrinsics.checkNotNullParameter((Object)$document, (String)"$document");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        ++$attempts.element;
        return JSDebuggerSupportUtils.getExpressionAtOffset($document, $file, $offset);
    }

    private static final boolean getExpressionInfoAtOffsetAsync$lambda$3(Ref.IntRef $attempts) {
        Intrinsics.checkNotNullParameter((Object)$attempts, (String)"$attempts");
        return $attempts.element > 1;
    }

    private static final ExpressionInfo create$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ExpressionInfo)$tmp0.invoke(p0);
    }

    private static final Integer getEvaluationInfoBySourceMap$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0);
    }

    private static final Integer getEvaluationInfoBySourceMap$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0);
    }

    private static final ExpressionInfo getEvaluationInfoBySourceMap$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ExpressionInfo)$tmp0.invoke(p0);
    }

    private static final Promise evaluate$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Promise)$tmp0.invoke(p0);
    }

    private static final Promise evaluate$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Promise)$tmp0.invoke(p0);
    }
}

