/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.calculation;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class V8ImportantStringsHolder
implements Externalizable {
    public static final String SLOPPY = "sloppy_function_map";
    public static final String SYSTEM_NATIVE = "system / NativeContext";
    public static final String MAP_DESCRIPTORS = "(map descriptors)";
    public static final String DETACHED_TREE = "(Detached DOM trees)";
    public static final String DOCUMENT_TREE = "(Document DOM trees)";
    public static final String GC_ROOTS = "(GC roots)";
    private static final Logger LOG = Logger.getInstance(V8ImportantStringsHolder.class);
    private final Map<String, Long> myMap = Collections.synchronizedMap(new HashMap());
    private final Set<Long> myWindowStrings;
    private int myCnt;
    private boolean myIsFrontend;

    public V8ImportantStringsHolder() {
        this.myMap.put(SLOPPY, -1L);
        this.myMap.put(SYSTEM_NATIVE, -1L);
        this.myMap.put(MAP_DESCRIPTORS, -1L);
        this.myMap.put(DETACHED_TREE, -1L);
        this.myMap.put(DOCUMENT_TREE, -1L);
        this.myMap.put(GC_ROOTS, -1L);
        this.myCnt = this.myMap.size();
        this.myWindowStrings = new HashSet<Long>();
    }

    public void accept(long id, String str) {
        String window;
        if (this.myCnt > 0 && this.myMap.containsKey(str)) {
            this.myMap.put(str, id);
            --this.myCnt;
        }
        if (str.startsWith(window = "Window")) {
            this.myWindowStrings.add(id);
        }
    }

    public boolean isWindowString(long id) {
        return this.myWindowStrings.contains(id);
    }

    public long get(String str) {
        Long id = this.myMap.get(str);
        return id == null ? -1L : id;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.myMap.size());
        for (Map.Entry<String, Long> entry : this.myMap.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeLong(entry.getValue());
        }
        out.writeInt(this.myWindowStrings.size());
        for (Long id : this.myWindowStrings) {
            out.writeLong(id);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.myMap.put(in.readUTF(), in.readLong());
        }
        int winSize = in.readInt();
        for (int i = 0; i < winSize; ++i) {
            this.myWindowStrings.add(in.readLong());
        }
    }

    public boolean isFrontend() {
        return this.myIsFrontend;
    }

    public void onFinish() {
        this.myIsFrontend = true;
        if (this.myCnt > 0) {
            if (this.myCnt == 2 && this.myMap.get(DETACHED_TREE) == -1L && this.myMap.get(DOCUMENT_TREE) == -1L) {
                this.myIsFrontend = false;
                this.myCnt = 0;
            } else {
                String values = StringUtil.join((Collection)ContainerUtil.map(this.myMap.entrySet(), entry -> (String)entry.getKey() + ":" + entry.getValue()), (String)", ");
                LOG.info("V8 strings holder: some of the important strings were not found: " + values);
            }
        }
    }
}

