/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.boilerplate.express;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.ide.browsers.StartBrowserSettings;
import com.intellij.ide.file.BatchFileChangeListener;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.javascript.nodejs.execution.NodeProgressUtil;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.execution.NodeTargetRunOptions;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.library.core.codeInsight.ToggleNodeCoreCodingAssistanceAction;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.packageJson.PackageJsonDependenciesExternalUpdateManager;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.boilerplate.NpmPackageProjectGenerator;
import com.intellij.lang.javascript.boilerplate.NpxPackageDescriptor;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunProfileState;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.platform.ProjectGeneratorPeer;
import com.intellij.terminal.TerminalExecutionConsole;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.messages.Topic;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.SwingHelper;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.boilerplate.express.ExpressAppGeneratorPeerHelper;
import com.jetbrains.nodejs.boilerplate.express.ExpressAppSettings;
import com.jetbrains.nodejs.boilerplate.express.ExpressStylesheetEngine;
import com.jetbrains.nodejs.boilerplate.express.ExpressTemplateEngine;
import com.jetbrains.nodejs.run.NodeJsRunConfiguration;
import com.jetbrains.nodejs.run.NodeJsRunConfigurationType;
import icons.JavaScriptLanguageIcons;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExpressAppProjectGenerator
extends NpmPackageProjectGenerator {
    private static final Logger LOG = Logger.getInstance(ExpressAppProjectGenerator.class);
    private ProcessHandler myCurrentProcessHandler;

    public String getId() {
        return "ExpressApp";
    }

    @NotNull
    @NlsContexts.Label
    public String getName() {
        String string = NodeJSBundle.message("label.node.js.express.app", new Object[0]);
        if (string == null) {
            ExpressAppProjectGenerator.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NlsContexts.DetailedDescription
    public String getDescription() {
        return NodeJSBundle.message("text.html.express.js.application.skeleton", new Object[0]);
    }

    public Icon getIcon() {
        return JavaScriptLanguageIcons.Nodejs.Express;
    }

    @Nullable
    public String getHelpId() {
        return "create.from.express-js.skeleton";
    }

    @NotNull
    protected List<NpxPackageDescriptor.NpxCommand> getNpxCommands() {
        List<NpxPackageDescriptor.NpxCommand> list = Collections.singletonList(new NpxPackageDescriptor.NpxCommand("express-generator", "express"));
        if (list == null) {
            ExpressAppProjectGenerator.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    protected String executable(@NotNull NodePackage pkg) {
        File binFile;
        if (pkg == null) {
            ExpressAppProjectGenerator.$$$reportNull$$$0(2);
        }
        return (binFile = pkg.findBinFile("express", "bin" + File.separator + "express-cli.js")) != null ? binFile.getAbsolutePath() : "not-found-express-bin";
    }

    protected Filter @NotNull [] filters(@NotNull Project project, @NotNull VirtualFile baseDir) {
        if (project == null) {
            ExpressAppProjectGenerator.$$$reportNull$$$0(3);
        }
        if (baseDir == null) {
            ExpressAppProjectGenerator.$$$reportNull$$$0(4);
        }
        if (Filter.EMPTY_ARRAY == null) {
            ExpressAppProjectGenerator.$$$reportNull$$$0(5);
        }
        return Filter.EMPTY_ARRAY;
    }

    protected String @NotNull [] generatorArgs(@NotNull Project project, @NotNull VirtualFile baseDir) {
        if (project == null) {
            ExpressAppProjectGenerator.$$$reportNull$$$0(6);
        }
        if (baseDir == null) {
            ExpressAppProjectGenerator.$$$reportNull$$$0(7);
        }
        if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
            ExpressAppProjectGenerator.$$$reportNull$$$0(8);
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    protected String @NotNull [] generatorArgs(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull NpmPackageProjectGenerator.Settings settings) {
        if (project == null) {
            ExpressAppProjectGenerator.$$$reportNull$$$0(9);
        }
        if (baseDir == null) {
            ExpressAppProjectGenerator.$$$reportNull$$$0(10);
        }
        if (settings == null) {
            ExpressAppProjectGenerator.$$$reportNull$$$0(11);
        }
        String[] stringArray = ArrayUtil.toStringArray(ExpressAppProjectGenerator.getExpressParams(settings));
        if (stringArray == null) {
            ExpressAppProjectGenerator.$$$reportNull$$$0(12);
        }
        return stringArray;
    }

    protected void customizeModule(@NotNull VirtualFile baseDir, ContentEntry entry) {
        if (baseDir == null) {
            ExpressAppProjectGenerator.$$$reportNull$$$0(13);
        }
    }

    @NotNull
    protected String packageName() {
        return "express-generator";
    }

    @NotNull
    protected String presentablePackageName() {
        return "express-&generator:";
    }

    @NotNull
    public ProjectGeneratorPeer<NpmPackageProjectGenerator.Settings> createPeer() {
        final ExpressAppGeneratorPeerHelper helper = new ExpressAppGeneratorPeerHelper();
        return new NpmPackageProjectGenerator.NpmPackageGeneratorPeer(){

            protected JPanel createPanel() {
                return SwingHelper.newLeftAlignedVerticalPanel((Component[])new Component[]{super.createPanel(), helper.getOptionsPanel()});
            }

            protected void addExtraFields(@NotNull SettingsStep settingsStep) {
                if (settingsStep == null) {
                    1.$$$reportNull$$$0(0);
                }
                helper.buildUI(settingsStep);
            }

            @NotNull
            protected NodePackageField createAndInitPackageField(@NotNull NodeJsInterpreterField interpreterField) {
                if (interpreterField == null) {
                    1.$$$reportNull$$$0(1);
                }
                NodePackageField packageField = super.createAndInitPackageField(interpreterField);
                helper.setPackageField(packageField);
                NodePackageField nodePackageField = packageField;
                if (nodePackageField == null) {
                    1.$$$reportNull$$$0(2);
                }
                return nodePackageField;
            }

            @NotNull
            public NpmPackageProjectGenerator.Settings getSettings() {
                NpmPackageProjectGenerator.Settings settings = helper.getSettings(super.getSettings());
                if (settings == null) {
                    1.$$$reportNull$$$0(3);
                }
                return settings;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "settingsStep";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "interpreterField";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/nodejs/boilerplate/express/ExpressAppProjectGenerator$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/nodejs/boilerplate/express/ExpressAppProjectGenerator$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createAndInitPackageField";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSettings";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "addExtraFields";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "createAndInitPackageField";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    protected Runnable postInstall(@NotNull Project project, @NotNull VirtualFile baseDir, File workingDir) {
        if (project == null) {
            ExpressAppProjectGenerator.$$$reportNull$$$0(14);
        }
        if (baseDir == null) {
            ExpressAppProjectGenerator.$$$reportNull$$$0(15);
        }
        Runnable runnable = () -> {
            try {
                this.doPostInstall(project, baseDir, Objects.requireNonNull(workingDir));
            }
            catch (ExecutionException e) {
                @NlsSafe String message = ExceptionUtil.getMessage((Throwable)e);
                this.getNotificationGroup().createNotification(NodeJSBundle.message("generator.express.cannot_generate.notification.title", this.getName()), StringUtil.notNullize((String)message), NotificationType.ERROR).notify(project);
                LOG.warn((Throwable)e);
            }
            super.postInstall(project, baseDir, workingDir).run();
        };
        if (runnable == null) {
            ExpressAppProjectGenerator.$$$reportNull$$$0(16);
        }
        return runnable;
    }

    private void doPostInstall(final @NotNull Project project, final @NotNull VirtualFile baseDir, @NotNull File workingDir) throws ExecutionException {
        ProcessHandler generatorProcessHandler;
        int exitCode;
        if (project == null) {
            ExpressAppProjectGenerator.$$$reportNull$$$0(17);
        }
        if (baseDir == null) {
            ExpressAppProjectGenerator.$$$reportNull$$$0(18);
        }
        if (workingDir == null) {
            ExpressAppProjectGenerator.$$$reportNull$$$0(19);
        }
        if ((exitCode = ((Integer)ObjectUtils.notNull((Object)(generatorProcessHandler = Objects.requireNonNull(this.myCurrentProcessHandler)).getExitCode(), (Object)-1)).intValue()) != 0) {
            throw new ExecutionException(NodeJSBundle.message("generator.express.see_errors_in_console.dialog.message", exitCode));
        }
        String npmInstallText = NpmManager.getInstance((Project)project).getNpmInstallPresentableText();
        ProcessHandler processHandler = (ProcessHandler)NodeProgressUtil.withBackgroundProgress((Project)project, (String)NodeProgressUtil.starting((String)npmInstallText), () -> ExpressAppProjectGenerator.startProcess(project, workingDir));
        ((BatchFileChangeListener)BackgroundTaskUtil.syncPublisher((Topic)BatchFileChangeListener.TOPIC)).batchChangeStarted(project, npmInstallText);
        final Runnable installDone = PackageJsonDependenciesExternalUpdateManager.getInstance((Project)project).externalUpdateStarted(null, null);
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        ApplicationManager.getApplication().invokeLater(() -> {
            TerminalExecutionConsole console = this.findConsole(project);
            this.myCurrentProcessHandler = null;
            if (console != null) {
                console.attachToProcess(processHandler);
            }
            processHandler.notifyTextAvailable("\nInstalling dependencies...\n\n", (Key)ProcessOutputType.SYSTEM);
            processHandler.startNotify();
        });
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                ((BatchFileChangeListener)BackgroundTaskUtil.syncPublisher((Topic)BatchFileChangeListener.TOPIC)).batchChangeCompleted(project);
                installDone.run();
                RefreshQueue.getInstance().refresh(true, true, () -> {
                    if (!project.isDisposed()) {
                        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> ExpressAppProjectGenerator.configureProject(project, baseDir));
                    }
                }, new VirtualFile[]{baseDir});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/nodejs/boilerplate/express/ExpressAppProjectGenerator$2", "processTerminated"));
            }
        });
    }

    @NotNull
    private static ProcessHandler startProcess(@NotNull Project project, @NotNull File workingDir) throws ExecutionException {
        if (project == null) {
            ExpressAppProjectGenerator.$$$reportNull$$$0(20);
        }
        if (workingDir == null) {
            ExpressAppProjectGenerator.$$$reportNull$$$0(21);
        }
        NodeJsInterpreterRef interpreterRef2 = NodeJsInterpreterManager.getInstance((Project)project).getInterpreterRef();
        NodeJsInterpreter interpreter = interpreterRef2.resolveNotNull(project);
        NodeTargetRun targetRun = new NodeTargetRun(interpreter, project, null, NodeTargetRunOptions.of((Boolean)true));
        NpmRunProfileState.configureCommandLine((NodeTargetRun)targetRun, (String)"", (NodePackageRef)NpmManager.getInstance((Project)project).getPackageRef(), (String)(workingDir + File.separator + "package.json"), (NpmCommand)NpmCommand.INSTALL, List.of(), (String)"", (EnvironmentVariablesData)EnvironmentVariablesData.DEFAULT, null);
        ProcessHandler processHandler = targetRun.startProcess();
        if (processHandler == null) {
            ExpressAppProjectGenerator.$$$reportNull$$$0(22);
        }
        return processHandler;
    }

    private static void configureProject(@NotNull Project project, @NotNull VirtualFile baseDir) {
        if (project == null) {
            ExpressAppProjectGenerator.$$$reportNull$$$0(23);
        }
        if (baseDir == null) {
            ExpressAppProjectGenerator.$$$reportNull$$$0(24);
        }
        ToggleNodeCoreCodingAssistanceAction.enableNodeCoreLibrary((Project)project, null);
        ExpressAppProjectGenerator.createRunConfiguration(project, baseDir);
    }

    private static void createRunConfiguration(@NotNull Project project, @NotNull VirtualFile baseDir) {
        if (project == null) {
            ExpressAppProjectGenerator.$$$reportNull$$$0(25);
        }
        if (baseDir == null) {
            ExpressAppProjectGenerator.$$$reportNull$$$0(26);
        }
        Ref appFileRef = Ref.create();
        String name = FileUtil.toSystemDependentName((String)"bin/www");
        ApplicationManager.getApplication().runReadAction(() -> {
            for (RunnerAndConfigurationSettings settings : RunManager.getInstance((Project)project).getAllSettings()) {
                if (!name.equals(settings.getName())) continue;
                return;
            }
            appFileRef.set((Object)VfsUtil.findRelativeFile((VirtualFile)baseDir, (String[])new String[]{"bin", "www"}));
        });
        if (appFileRef.isNull()) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            RunnerAndConfigurationSettings rac = RunManager.getInstance((Project)project).createConfiguration("", (ConfigurationFactory)NodeJsRunConfigurationType.getInstance());
            NodeJsRunConfiguration runConfig = (NodeJsRunConfiguration)((Object)((Object)ObjectUtils.tryCast((Object)rac.getConfiguration(), NodeJsRunConfiguration.class)));
            if (runConfig == null) {
                return;
            }
            VirtualFile appFile = (VirtualFile)appFileRef.get();
            runConfig.setName(name);
            runConfig.setWorkingDirectory(baseDir.getPath());
            runConfig.setMainScriptFilePath(VfsUtilCore.getRelativePath((VirtualFile)appFile, (VirtualFile)baseDir, (char)File.separatorChar));
            LinkedHashMap<String, String> env = new LinkedHashMap<String, String>();
            env.putAll(runConfig.getEnvs());
            env.put("DEBUG", ExpressAppProjectGenerator.createAppName(baseDir.getName()) + ":*");
            runConfig.setEnvs(env);
            StartBrowserSettings browserSettings = new StartBrowserSettings();
            browserSettings.setUrl("http://localhost:3000/");
            runConfig.setStartBrowserSettings(browserSettings);
            RunManager runManager = RunManager.getInstance((Project)project);
            rac.storeInDotIdeaFolder();
            runManager.addConfiguration(rac);
            runManager.setSelectedConfiguration(rac);
        });
    }

    @NotNull
    public static String createAppName(@NotNull String directoryName) {
        if (directoryName == null) {
            ExpressAppProjectGenerator.$$$reportNull$$$0(27);
        }
        String string = StringUtil.toLowerCase((String)directoryName.replaceAll("[^A-Za-z0-9.-]+", "-").replaceAll("^[-_.]+|-+$", ""));
        if (string == null) {
            ExpressAppProjectGenerator.$$$reportNull$$$0(28);
        }
        return string;
    }

    protected void onProcessHandlerCreated(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            ExpressAppProjectGenerator.$$$reportNull$$$0(29);
        }
        this.myCurrentProcessHandler = processHandler;
    }

    @Nullable
    private TerminalExecutionConsole findConsole(@NotNull Project project) {
        if (project == null) {
            ExpressAppProjectGenerator.$$$reportNull$$$0(30);
        }
        List descriptors = RunContentManager.getInstance((Project)project).getAllDescriptors();
        for (RunContentDescriptor descriptor : descriptors) {
            TerminalExecutionConsole console = (TerminalExecutionConsole)ObjectUtils.tryCast((Object)descriptor.getExecutionConsole(), TerminalExecutionConsole.class);
            if (console == null || descriptor.getProcessHandler() != this.myCurrentProcessHandler) continue;
            return console;
        }
        return null;
    }

    @NotNull
    private static List<String> getExpressParams(@NotNull NpmPackageProjectGenerator.Settings settings) {
        if (settings == null) {
            ExpressAppProjectGenerator.$$$reportNull$$$0(31);
        }
        ArrayList<String> params = new ArrayList<String>();
        params.add("--force");
        ExpressAppSettings expressSettings = ExpressAppGeneratorPeerHelper.getExpressSettings(settings);
        ExpressStylesheetEngine stylesheetEngine = expressSettings.getStylesheetEngine();
        String option = stylesheetEngine.getCliOption();
        if (option != null) {
            params.add("--css");
            params.add(option);
        }
        ExpressTemplateEngine templateEngine = expressSettings.getTemplateEngine();
        SemVer version = expressSettings.getPackageVersion();
        if (version == null || version.isGreaterOrEqualThan(4, 15, 0)) {
            if (templateEngine == ExpressTemplateEngine.NO_VIEW) {
                params.add("--no-view");
            } else {
                params.add("--view");
                params.add(templateEngine.getCliOption());
            }
        } else if (templateEngine != ExpressTemplateEngine.JADE) {
            if (templateEngine == ExpressTemplateEngine.EJS) {
                params.add("--ejs");
            } else if (templateEngine == ExpressTemplateEngine.HBS) {
                params.add("--hbs");
            } else if (templateEngine == ExpressTemplateEngine.HOGAN) {
                params.add("--hogan");
            } else {
                throw new RuntimeException("Unexpected template option: " + templateEngine);
            }
        }
        ArrayList<String> arrayList = params;
        if (arrayList == null) {
            ExpressAppProjectGenerator.$$$reportNull$$$0(32);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 6, 7, 9, 10, 11, 13, 14, 15, 17, 18, 19, 20, 21, 23, 24, 25, 26, 27, 29, 30, 31 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/boilerplate/express/ExpressAppProjectGenerator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 14: 
            case 17: 
            case 20: 
            case 23: 
            case 25: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 18: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 11: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryName";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNpxCommands";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/boilerplate/express/ExpressAppProjectGenerator";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "filters";
                break;
            }
            case 8: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "generatorArgs";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "postInstall";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createAppName";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressParams";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "executable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "filters";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "generatorArgs";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "customizeModule";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "postInstall";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "doPostInstall";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "startProcess";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "configureProject";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createRunConfiguration";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createAppName";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "onProcessHandlerCreated";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findConsole";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getExpressParams";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 6, 7, 9, 10, 11, 13, 14, 15, 17, 18, 19, 20, 21, 23, 24, 25, 26, 27, 29, 30, 31 -> new IllegalArgumentException(string);
        };
    }
}

