/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsc;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGenericOrMappedTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSBigIntLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSUniqueSymbolTypeImpl;
import com.intellij.lang.javascript.psi.types.JSUnknownType;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptIndexedAccessJSTypeImplNoSubstitute;
import com.intellij.lang.javascript.psi.types.TypeScriptJSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptObjectJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTemplateLiteralJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeOperatorJSTypeImplNoSubstitute;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptEnumNumberLiteralType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptEnumStringLiteralType;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptGenericDeclarationTypeImpl;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptGenericParameterImpl;
import com.intellij.lang.javascript.service.DocumentOffsetsManager;
import com.intellij.lang.typescript.tsc.TypeScriptCompilerTypeConverter;
import com.intellij.lang.typescript.tsc.gen.ConditionalType;
import com.intellij.lang.typescript.tsc.gen.Declaration;
import com.intellij.lang.typescript.tsc.gen.FreshableIntrinsicType;
import com.intellij.lang.typescript.tsc.gen.IndexType;
import com.intellij.lang.typescript.tsc.gen.IndexedAccessType;
import com.intellij.lang.typescript.tsc.gen.IntersectionType;
import com.intellij.lang.typescript.tsc.gen.IntrinsicType;
import com.intellij.lang.typescript.tsc.gen.LiteralType;
import com.intellij.lang.typescript.tsc.gen.Node;
import com.intellij.lang.typescript.tsc.gen.NodeObjectProperty;
import com.intellij.lang.typescript.tsc.gen.NumberLiteralType;
import com.intellij.lang.typescript.tsc.gen.ObjectType;
import com.intellij.lang.typescript.tsc.gen.PseudoBigInt;
import com.intellij.lang.typescript.tsc.gen.Signature;
import com.intellij.lang.typescript.tsc.gen.SourceFile;
import com.intellij.lang.typescript.tsc.gen.StringLiteralType;
import com.intellij.lang.typescript.tsc.gen.Symbol;
import com.intellij.lang.typescript.tsc.gen.TemplateLiteralType;
import com.intellij.lang.typescript.tsc.gen.TscObject;
import com.intellij.lang.typescript.tsc.gen.Type;
import com.intellij.lang.typescript.tsc.gen.TypeBase;
import com.intellij.lang.typescript.tsc.gen.TypeFlagsValues;
import com.intellij.lang.typescript.tsc.gen.TypeObjectKt;
import com.intellij.lang.typescript.tsc.gen.TypeObjectProperty;
import com.intellij.lang.typescript.tsc.gen.TypeParameter;
import com.intellij.lang.typescript.tsc.gen.TypeScriptServerTypeCheckerContextKt;
import com.intellij.lang.typescript.tsc.gen.UnionType;
import com.intellij.lang.typescript.tsc.types.JSGenericTypeImplNoSubstitute;
import com.intellij.lang.typescript.tsc.types.TypeScriptCompilerConditionalTypeImpl;
import com.intellij.lang.typescript.tsc.types.TypeScriptCompilerIntersectionType;
import com.intellij.lang.typescript.tsc.types.TypeScriptCompilerObjectTypeImpl;
import com.intellij.lang.typescript.tsc.types.TypeScriptCompilerSymbolType;
import com.intellij.lang.typescript.tsc.types.TypeScriptCompilerUnionType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u001e\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020\rH\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\rJ\u000e\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0015\u001a\u00020\rR\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/lang/typescript/tsc/TypeScriptCompilerTypeConverter;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "documentOffsetsManager", "Lcom/intellij/lang/javascript/service/DocumentOffsetsManager;", "getDocumentOffsetsManager", "()Lcom/intellij/lang/javascript/service/DocumentOffsetsManager;", "convertTypeArguments", "", "Lcom/intellij/lang/javascript/psi/JSType;", "typeArguments", "Lcom/intellij/lang/typescript/tsc/gen/Type;", "findPsiElement", "Lcom/intellij/psi/PsiElement;", "declaration", "Lcom/intellij/lang/typescript/tsc/gen/Declaration;", "getEnumAndFieldNames", "Lkotlin/Pair;", "", "tscType", "isSourceFile", "", "node", "Lcom/intellij/lang/typescript/tsc/gen/Node;", "loadTypeProperties", "", "type", "toJSType", "signature", "Lcom/intellij/lang/typescript/tsc/gen/Signature;", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nTypeScriptCompilerTypeConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptCompilerTypeConverter.kt\ncom/intellij/lang/typescript/tsc/TypeScriptCompilerTypeConverter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 5 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,328:1\n1549#2:329\n1620#2,3:330\n1726#2,3:334\n1603#2,9:337\n1855#2:346\n1856#2:348\n1612#2:349\n1549#2:352\n1620#2,3:353\n1603#2,9:356\n1855#2:365\n1856#2:367\n1612#2:368\n1549#2:369\n1620#2,3:370\n1#3:333\n1#3:347\n1#3:366\n13#4:350\n14#5:351\n*S KotlinDebug\n*F\n+ 1 TypeScriptCompilerTypeConverter.kt\ncom/intellij/lang/typescript/tsc/TypeScriptCompilerTypeConverter\n*L\n103#1:329\n103#1:330,3\n104#1:334,3\n172#1:337,9\n172#1:346\n172#1:348\n172#1:349\n272#1:352\n272#1:353,3\n292#1:356,9\n292#1:365\n292#1:367\n292#1:368\n324#1:369\n324#1:370,3\n172#1:347\n292#1:366\n179#1:350\n271#1:351\n*E\n"})
public final class TypeScriptCompilerTypeConverter {
    @NotNull
    private final Project project;

    public TypeScriptCompilerTypeConverter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final JSType toJSType(@NotNull Type tscType) {
        JSType jSType;
        int n;
        PsiElement psiElement;
        Declaration declaration;
        Intrinsics.checkNotNullParameter((Object)tscType, (String)"tscType");
        JSTypeSource typeSource = JSTypeSource.EMPTY_TS_EXPLICITLY_DECLARED;
        Object object = tscType.getSymbol();
        Declaration declaration2 = object != null && (object = object.getDeclarations()) != null ? (Declaration)CollectionsKt.getOrNull((List)object, (int)0) : (declaration = null);
        if (declaration != null && (psiElement = this.findPsiElement(declaration)) != null) {
            typeSource = JSTypeSourceFactory.createTypeSource(psiElement, true);
        }
        if ((n = tscType.getFlags()) == TypeFlagsValues.INSTANCE.getAny()) {
            jSType = JSAnyType.get(typeSource);
        } else if (n == TypeFlagsValues.INSTANCE.getUnknown()) {
            jSType = JSUnknownType.TS_INSTANCE;
        } else if (n == TypeFlagsValues.INSTANCE.getString()) {
            jSType = JSNamedTypeFactory.createStringPrimitiveType(typeSource);
        } else if (n == TypeFlagsValues.INSTANCE.getNumber()) {
            jSType = JSNamedTypeFactory.createNumberPrimitiveType(typeSource);
        } else if (n == TypeFlagsValues.INSTANCE.getBoolean() ? true : n == (TypeFlagsValues.INSTANCE.getBoolean() | TypeFlagsValues.INSTANCE.getUnion())) {
            jSType = JSNamedTypeFactory.createBooleanPrimitiveType(typeSource);
        } else if (n == TypeFlagsValues.INSTANCE.getEnum()) {
            jSType = null;
        } else if (n == TypeFlagsValues.INSTANCE.getBigInt()) {
            jSType = JSNamedTypeFactory.createBigIntPrimitiveType(typeSource);
        } else if (n == TypeFlagsValues.INSTANCE.getStringLiteral()) {
            jSType = new JSStringLiteralTypeImpl(((StringLiteralType)tscType).getValue(), false, typeSource);
        } else if (n == (TypeFlagsValues.INSTANCE.getStringLiteral() | TypeFlagsValues.INSTANCE.getEnumLiteral())) {
            Pair<String, String> pair = this.getEnumAndFieldNames(tscType);
            if (pair == null) {
                return null;
            }
            Pair<String, String> pair2 = pair;
            String enumName = (String)pair2.component1();
            String fieldName = (String)pair2.component2();
            jSType = new TypeScriptEnumStringLiteralType(((StringLiteralType)tscType).getValue(), enumName, fieldName, typeSource);
        } else if (n == TypeFlagsValues.INSTANCE.getNumberLiteral() ? true : n == (TypeFlagsValues.INSTANCE.getNumberLiteral() | TypeFlagsValues.INSTANCE.getEnumLiteral())) {
            JSNumberLiteralTypeImpl jSNumberLiteralTypeImpl;
            String valueAsString;
            double d;
            Number value = ((NumberLiteralType)tscType).getValue();
            if (value instanceof Integer) {
                d = value.doubleValue();
            } else {
                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Double");
                d = (Double)value;
            }
            double doubleValue = d;
            String string = valueAsString = value instanceof Integer ? value.toString() : null;
            if (tscType.getFlags() == (TypeFlagsValues.INSTANCE.getNumberLiteral() | TypeFlagsValues.INSTANCE.getEnumLiteral())) {
                Pair<String, String> pair = this.getEnumAndFieldNames(tscType);
                if (pair == null) {
                    return null;
                }
                Pair<String, String> pair3 = pair;
                String enumName = (String)pair3.component1();
                String fieldName = (String)pair3.component2();
                jSNumberLiteralTypeImpl = new TypeScriptEnumNumberLiteralType(doubleValue, enumName, fieldName, typeSource, valueAsString);
            } else {
                boolean isFreshLiteralType = Intrinsics.areEqual((Object)((NumberLiteralType)tscType).getFreshType(), (Object)tscType);
                jSNumberLiteralTypeImpl = new JSNumberLiteralTypeImpl(doubleValue, isFreshLiteralType, typeSource, valueAsString);
            }
            jSType = jSNumberLiteralTypeImpl;
        } else if (n == TypeFlagsValues.INSTANCE.getBooleanLiteral() ? true : n == (TypeFlagsValues.INSTANCE.getBooleanLiteral() | TypeFlagsValues.INSTANCE.getEnumLiteral())) {
            FreshableIntrinsicType freshableIntrinsicType = TypeObjectKt.asFreshableIntrinsicType(tscType);
            boolean isFreshLiteralType = Intrinsics.areEqual((Object)freshableIntrinsicType.getFreshType(), (Object)tscType);
            jSType = new JSBooleanLiteralTypeImpl(Boolean.parseBoolean(freshableIntrinsicType.getIntrinsicName()), isFreshLiteralType, typeSource);
        } else if (n == TypeFlagsValues.INSTANCE.getBigIntLiteral()) {
            boolean isFreshLiteralType = Intrinsics.areEqual((Object)((LiteralType)tscType).getFreshType(), (Object)tscType);
            Object object2 = ((LiteralType)tscType).getValue();
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.lang.typescript.tsc.gen.PseudoBigInt");
            BigInteger positiveValue = new BigInteger(((PseudoBigInt)object2).getBase10Value());
            Object object3 = ((LiteralType)tscType).getValue();
            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type com.intellij.lang.typescript.tsc.gen.PseudoBigInt");
            BigInteger value = ((PseudoBigInt)object3).getNegative() ? positiveValue.negate() : positiveValue;
            jSType = new JSBigIntLiteralTypeImpl(value, isFreshLiteralType, typeSource, value.toString(10));
        } else if (n == TypeFlagsValues.INSTANCE.getESSymbol()) {
            jSType = JSNamedTypeFactory.createSymbolPrimitiveType(typeSource);
        } else if (n == TypeFlagsValues.INSTANCE.getVoid()) {
            jSType = JSNamedTypeFactory.createVoidType(typeSource);
        } else if (n == TypeFlagsValues.INSTANCE.getUndefined()) {
            jSType = JSNamedTypeFactory.createUndefinedType(typeSource);
        } else if (n == TypeFlagsValues.INSTANCE.getNull()) {
            jSType = JSNamedTypeFactory.createNullType(typeSource);
        } else if (n == TypeFlagsValues.INSTANCE.getNever()) {
            jSType = JSNamedTypeFactory.createNeverType(typeSource);
        } else if (n == TypeFlagsValues.INSTANCE.getUniqueESSymbol()) {
            jSType = new JSUniqueSymbolTypeImpl(typeSource, JSTypeContext.INSTANCE, false);
        } else if (n == TypeFlagsValues.INSTANCE.getTypeParameter()) {
            JSTypeBaseImpl jSTypeBaseImpl;
            JSType constraintType;
            Type type2 = ((TypeParameter)tscType).getConstraint();
            if (type2 != null) {
                Type it = type2;
                boolean bl = false;
                v11 = this.toJSType(it);
            } else {
                v11 = constraintType = null;
            }
            if (Intrinsics.areEqual((Object)((TypeParameter)tscType).isThisType(), (Object)true)) {
                JSGenericTypeImpl genericTypeWithThis = null;
                if (constraintType instanceof TypeScriptCompilerObjectTypeImpl) {
                    List typeArguments;
                    boolean bl;
                    List $this$map$iv;
                    Symbol symbol;
                    block83: {
                        void $this$mapTo$iv$iv;
                        Pair value = TypeScriptCompilerObjectTypeImpl.getSymbolAndTypeArguments$default((TypeScriptCompilerObjectTypeImpl)constraintType, false, 1, null);
                        symbol = (Symbol)value.component1();
                        List tscTypeArguments = (List)value.component2();
                        Iterable fieldName = tscTypeArguments;
                        boolean $i$f$map = false;
                        void var13_52 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            Type type3 = (Type)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl2 = false;
                            collection.add(this.toJSType((Type)it));
                        }
                        List it = $this$map$iv = (List)destination$iv$iv;
                        boolean bl3 = false;
                        Iterable $this$all$iv = it;
                        boolean $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (Object element$iv : $this$all$iv) {
                                JSType jsType = (JSType)element$iv;
                                boolean bl4 = false;
                                if (jsType != null) continue;
                                bl = false;
                                break block83;
                            }
                            bl = true;
                        }
                    }
                    List list2 = typeArguments = bl ? $this$map$iv : null;
                    if (symbol != null) {
                        JSType baseType;
                        List list3 = typeArguments;
                        boolean bl5 = list3 != null ? !((Collection)list3).isEmpty() : false;
                        if (bl5 && (baseType = ((TypeScriptCompilerObjectTypeImpl)constraintType).buildBaseType(symbol)) != null) {
                            JSTypeSource jSTypeSource = typeSource;
                            Intrinsics.checkNotNull((Object)jSTypeSource);
                            genericTypeWithThis = new JSGenericTypeImplNoSubstitute(jSTypeSource, new TypeScriptGenericThisTypeImpl(((TypeScriptCompilerObjectTypeImpl)constraintType).getSource(), baseType), typeArguments, this.project, tscType);
                        }
                    }
                }
                JSGenericTypeImpl jSGenericTypeImpl = genericTypeWithThis;
                jSTypeBaseImpl = jSGenericTypeImpl != null ? (JSTypeBaseImpl)jSGenericTypeImpl : (JSTypeBaseImpl)new TypeScriptGenericThisTypeImpl(typeSource, constraintType);
            } else {
                TypeScriptGenericParameterImpl typeScriptGenericParameterImpl;
                Object[] value = new PsiElement[2];
                value[0] = typeSource.getSourceElement();
                PsiElement psiElement2 = typeSource.getSourceElement();
                value[1] = psiElement2 != null ? psiElement2.getParent() : null;
                TypeScriptGenericOrMappedTypeParameter typeParamSrcElement2 = (TypeScriptGenericOrMappedTypeParameter)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.sequenceOf((Object[])value), (Function1)toJSType.typeParamSrcElement.1.INSTANCE));
                if (typeParamSrcElement2 != null) {
                    TypeScriptTypeParameter typeScriptTypeParameter = typeParamSrcElement2 instanceof TypeScriptTypeParameter ? (TypeScriptTypeParameter)typeParamSrcElement2 : null;
                    typeScriptGenericParameterImpl = new TypeScriptGenericParameterImpl(typeParamSrcElement2.getGenericId(), typeSource, constraintType, typeScriptTypeParameter != null ? typeScriptTypeParameter.isConst() : false);
                } else {
                    typeScriptGenericParameterImpl = null;
                }
                jSTypeBaseImpl = typeScriptGenericParameterImpl;
            }
            jSType = jSTypeBaseImpl;
        } else if (n == TypeFlagsValues.INSTANCE.getObject()) {
            jSType = new TypeScriptCompilerObjectTypeImpl((ObjectType)tscType, this.project);
        } else if (n == TypeFlagsValues.INSTANCE.getUnion() ? true : n == (TypeFlagsValues.INSTANCE.getUnion() | TypeFlagsValues.INSTANCE.getEnumLiteral())) {
            UnionType unionType = (UnionType)tscType;
            JSTypeSource constraintType = typeSource;
            Intrinsics.checkNotNull((Object)constraintType);
            jSType = new TypeScriptCompilerUnionType(unionType, this.project, constraintType);
        } else if (n == TypeFlagsValues.INSTANCE.getIntersection()) {
            IntersectionType intersectionType = (IntersectionType)tscType;
            JSTypeSource constraintType = typeSource;
            Intrinsics.checkNotNull((Object)constraintType);
            jSType = new TypeScriptCompilerIntersectionType(intersectionType, this.project, constraintType);
        } else if (n == TypeFlagsValues.INSTANCE.getIndex()) {
            JSType referencedType = this.toJSType(((IndexType)tscType).getType());
            jSType = referencedType != null ? new TypeScriptTypeOperatorJSTypeImplNoSubstitute(referencedType, typeSource) : null;
        } else if (n == TypeFlagsValues.INSTANCE.getIndexedAccess()) {
            JSType jSType2;
            JSType jSType3;
            Type type4 = ((IndexedAccessType)tscType).getObjectType();
            if (type4 != null) {
                Type it = type4;
                boolean bl = false;
                jSType3 = this.toJSType(it);
            } else {
                jSType3 = null;
            }
            JSType objectType = jSType3;
            Type type5 = ((IndexedAccessType)tscType).getIndexType();
            if (type5 != null) {
                Type it = type5;
                boolean bl = false;
                jSType2 = this.toJSType(it);
            } else {
                jSType2 = null;
            }
            JSType indexType = jSType2;
            jSType = objectType != null && indexType != null ? new TypeScriptIndexedAccessJSTypeImplNoSubstitute(objectType, indexType, typeSource) : null;
        } else if (n == TypeFlagsValues.INSTANCE.getConditional()) {
            ConditionalType conditionalType = (ConditionalType)tscType;
            JSTypeSource objectType = typeSource;
            Intrinsics.checkNotNull((Object)objectType);
            jSType = new TypeScriptCompilerConditionalTypeImpl(conditionalType, this.project, objectType);
        } else if (n == TypeFlagsValues.INSTANCE.getSubstitution()) {
            jSType = null;
        } else if (n == TypeFlagsValues.INSTANCE.getNonPrimitive()) {
            jSType = Intrinsics.areEqual((Object)((IntrinsicType)tscType).getIntrinsicName(), (Object)"object") ? new TypeScriptObjectJSTypeImpl(typeSource, JSTypeContext.INSTANCE) : null;
        } else if (n == TypeFlagsValues.INSTANCE.getTemplateLiteral()) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable objectType = ((TemplateLiteralType)tscType).getTypes();
            List<String> list4 = ((TemplateLiteralType)tscType).getTexts();
            boolean $i$f$mapNotNull = false;
            void value = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                JSType it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Type it = (Type)element$iv$iv;
                boolean bl6 = false;
                if (this.toJSType(it) == null) continue;
                boolean bl7 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            jSType = TypeScriptTemplateLiteralJSTypeImpl.createType(list4, (List)destination$iv$iv, false, typeSource);
        } else if (n == TypeFlagsValues.INSTANCE.getStringMapping()) {
            jSType = null;
        } else {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(TypeScriptCompilerTypeConverter.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Unknown TypeScript compiler type with flags " + tscType.getFlags());
            jSType = null;
        }
        return jSType;
    }

    private final Pair<String, String> getEnumAndFieldNames(Type tscType) {
        Intrinsics.checkNotNull((Object)tscType, (String)"null cannot be cast to non-null type com.intellij.lang.typescript.tsc.gen.TypeBase");
        Object object = ((TypeBase)tscType).getData().get(TypeObjectProperty.nameType);
        String enumQualifiedName = object instanceof String ? (String)object : null;
        Symbol symbol = tscType.getSymbol();
        String fieldName = symbol != null ? symbol.getEscapedName() : null;
        CharSequence charSequence = enumQualifiedName;
        return charSequence == null || charSequence.length() == 0 || (charSequence = (CharSequence)fieldName) == null || charSequence.length() == 0 ? null : TuplesKt.to((Object)enumQualifiedName, (Object)fieldName);
    }

    /*
     * Unable to fully structure code
     */
    @RequiresReadLock
    @Nullable
    public final PsiElement findPsiElement(@NotNull Declaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        fileName = null;
        for (parent = (Node)declaration; parent != null; parent = parent.getParent()) {
            if (!this.isSourceFile(parent)) continue;
            fileName = ((SourceFile)parent).getFileName();
            break;
        }
        if (fileName == null) {
            return null;
        }
        v0 = LocalFileSystem.getInstance().findFileByPath(fileName);
        if (v0 == null) {
            return null;
        }
        virtualFile = v0;
        v1 = PsiManager.getInstance((Project)this.project).findFile(virtualFile);
        if (v1 == null) {
            return null;
        }
        psiFile = v1;
        if (this.isSourceFile(declaration)) {
            return (PsiElement)psiFile;
        }
        v2 = PsiDocumentManager.getInstance((Project)this.project).getDocument(psiFile);
        if (v2 == null) {
            return null;
        }
        document = v2;
        convertedPos = this.getDocumentOffsetsManager().getConvertedOffset(document, declaration.getPos());
        convertedEnd = this.getDocumentOffsetsManager().getConvertedOffset(document, declaration.getEnd());
        injectedLanguageManager = InjectedLanguageManager.getInstance((Project)this.project);
        elementAtStartPos = new Ref.ObjectRef();
        elementAtEndPos = new Ref.ObjectRef();
        AstLoadingFilter.forceAllowTreeLoading((PsiFile)psiFile, (ThrowableRunnable)(ThrowableRunnable)LambdaMetafactory.metafactory(null, null, null, ()V, findPsiElement$lambda$7(com.intellij.lang.injection.InjectedLanguageManager com.intellij.psi.PsiFile int int kotlin.jvm.internal.Ref$ObjectRef kotlin.jvm.internal.Ref$ObjectRef ), ()V)((InjectedLanguageManager)injectedLanguageManager, (PsiFile)psiFile, (int)convertedPos, (int)convertedEnd, (Ref.ObjectRef)elementAtStartPos, (Ref.ObjectRef)elementAtEndPos));
        var13_12 = (PsiElement)elementAtStartPos.element;
        if (var13_12 != null) {
            it = var13_12;
            $i$a$-let-TypeScriptCompilerTypeConverter$findPsiElement$startEl$1 = false;
            v3 = it instanceof PsiWhiteSpace || it instanceof PsiComment ? PsiTreeUtil.nextCodeLeaf((PsiElement)it) : it;
        } else {
            v3 = null;
        }
        startEl = v3;
        var14_17 = (PsiElement)elementAtEndPos.element;
        if (var14_17 == null) ** GOTO lbl-1000
        it = var14_17;
        $i$a$-let-TypeScriptCompilerTypeConverter$findPsiElement$endEl$1 = false;
        it = (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)JSTokenTypes.SEMICOLON) || Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)JSTokenTypes.COMMA)) && it.getPrevSibling() != null ? it.getPrevSibling() : it;
        if (it == null) ** GOTO lbl-1000
        it = it;
        $i$a$-let-TypeScriptCompilerTypeConverter$findPsiElement$endEl$2 = false;
        var16_15 = it instanceof PsiWhiteSpace || it instanceof PsiComment ? PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)it) : it;
        if (var16_15 != null) {
            it = var16_15;
            $i$a$-let-TypeScriptCompilerTypeConverter$findPsiElement$endEl$3 = false;
            v4 = PsiTreeUtil.getDeepestLast((PsiElement)it);
        } else lbl-1000:
        // 3 sources

        {
            v4 = null;
        }
        endEl = v4;
        it = new PsiElement[]{startEl, endEl};
        commonParent = PsiTreeUtil.findCommonParent((PsiElement[])it);
        while (commonParent != null && Intrinsics.areEqual((Object)(commonParentParent = commonParent.getParent()).getTextRange(), (Object)commonParent.getTextRange()) && (commonParentParent instanceof JSReferenceExpression || commonParentParent instanceof JSProperty || commonParentParent instanceof JSFieldVariable)) {
            commonParent = commonParentParent;
        }
        return commonParent;
    }

    private final DocumentOffsetsManager getDocumentOffsetsManager() {
        Object object = this.project.getService(DocumentOffsetsManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
        return (DocumentOffsetsManager)object;
    }

    private final boolean isSourceFile(Node node) {
        Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type com.intellij.lang.typescript.tsc.gen.TscObject<*>");
        return ((Map)((TscObject)((Object)node)).getData()).get(NodeObjectProperty.fileName) != null;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final JSType toJSType(@NotNull Signature signature) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        v0 = signature.getDeclaration();
        if (v0 == null) ** GOTO lbl-1000
        $this$asSafely$iv = v0;
        $i$f$asSafely = false;
        v1 = $this$asSafely$iv;
        if (!(v1 instanceof Declaration)) {
            v1 = null;
        }
        if ((v0 = (Declaration)v1) != null) {
            it = v0;
            $i$a$-let-TypeScriptCompilerTypeConverter$toJSType$declaration$1 = false;
            v2 = this.findPsiElement((Declaration)it);
        } else lbl-1000:
        // 2 sources

        {
            v2 = null;
        }
        declaration = v2;
        $this$map$iv = signature.getParameters();
        $i$f$map = false;
        it = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var11_16 = (Symbol)item$iv$iv;
            var30_36 = destination$iv$iv;
            $i$a$-map-TypeScriptCompilerTypeConverter$toJSType$parameters$1 = false;
            declarations = it.getDeclarations();
            isOptional = false;
            isRest = false;
            if (declarations != null && declarations.size() == 1 && (psiElement = this.findPsiElement(declarations.get(0))) instanceof JSParameter) {
                isOptional = ((JSParameter)psiElement).isOptional();
                isRest = ((JSParameter)psiElement).isRest();
            }
            compilerType = new TypeScriptCompilerSymbolType((Symbol)it, this.project);
            $i$a$-let-TypeScriptCompilerTypeConverter$toJSType$parameters$1$parameterType$1 = false;
            if (isRest) {
                substituted = compilerType.substitute();
                $i$a$-let-TypeScriptCompilerTypeConverter$toJSType$parameters$1$parameterType$1$1 = false;
                v3 = substituted instanceof JSArrayType != false ? (JSArrayType)substituted : null;
                if (v3 == null || (v3 = v3.getType()) == null) {
                    v3 = substituted;
                }
            } else {
                v3 = compilerType;
            }
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"let(...)");
            parameterType = v3;
            var30_36.add(new JSParameterTypeDecoratorImpl(it.getEscapedName(), parameterType, isOptional, isRest, true));
        }
        parameters = (List)destination$iv$iv;
        v4 = signature.getTypeParameters();
        if (v4 != null) {
            $this$mapNotNull$iv = v4;
            $i$f$mapNotNull = false;
            var9_13 = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            var14_23 = $this$forEach$iv$iv$iv.iterator();
            while (var14_23.hasNext()) {
                element$iv$iv = element$iv$iv$iv = var14_23.next();
                $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                typeParam = (TypeParameter)element$iv$iv;
                $i$a$-mapNotNull-TypeScriptCompilerTypeConverter$toJSType$typeParameters$1 = false;
                var20_35 = this.toJSType(typeParam);
                if ((var20_35 instanceof TypeScriptGenericParameterImpl != false ? (TypeScriptGenericParameterImpl)var20_35 : null) != null) {
                    it = it;
                    $i$a$-let-TypeScriptCompilerTypeConverter$toJSType$typeParameters$1$1 = false;
                    v5 = it.getGenericId();
                    if (it.getConstraintType() != null) {
                        var24_41 = v5;
                        $i$a$-let-TypeScriptCompilerTypeConverter$toJSType$typeParameters$1$1$1 = false;
                        v6 = NotNullLazyValue.createConstantValue((Object)type);
                        v5 = var24_41;
                    } else {
                        v6 = null;
                    }
                    if ((v7 = typeParam.getResolvedDefaultType()) == null) {
                        v7 = typeParam.getDefault();
                    }
                    if (v7 != null) {
                        type = v7;
                        var26_43 = v6;
                        var24_41 = v5;
                        $i$a$-let-TypeScriptCompilerTypeConverter$toJSType$typeParameters$1$1$2 = false;
                        var27_44 = NotNullLazyValue.atomicLazy((Supplier<JSType>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toJSType$lambda$20$lambda$19$lambda$18$lambda$17(com.intellij.lang.typescript.tsc.TypeScriptCompilerTypeConverter com.intellij.lang.typescript.tsc.gen.Type com.intellij.lang.javascript.psi.types.typescript.TypeScriptGenericParameterImpl ), ()Lcom/intellij/lang/javascript/psi/JSType;)((TypeScriptCompilerTypeConverter)this, (Type)type, (TypeScriptGenericParameterImpl)it));
                        v5 = var24_41;
                        v6 = var26_43;
                        v8 = var27_44;
                    } else {
                        v8 = null;
                    }
                    var31_47 = it.isConst();
                    var32_48 = JSTypeSource.EMPTY_TS_EXPLICITLY_DECLARED;
                    var33_49 = v8;
                    var34_50 = v6;
                    var35_51 = v5;
                    v9 = new TypeScriptGenericDeclarationTypeImpl(var35_51, (NotNullLazyValue<? extends JSType>)var34_50, (NotNullLazyValue<? extends JSType>)var33_49, var32_48, var31_47);
                } else {
                    v9 = null;
                }
                if (v9 == null) continue;
                it$iv$iv = v9;
                $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                destination$iv$iv.add(it$iv$iv);
            }
            v10 = (List)destination$iv$iv;
        } else {
            v10 = CollectionsKt.emptyList();
        }
        typeParameters = v10;
        source = declaration != null ? JSTypeSourceFactory.createTypeSource(declaration, true) : JSTypeSource.EMPTY_TS_EXPLICITLY_DECLARED;
        v11 = signature.getResolvedReturnType();
        if (v11 != null) {
            it = v11;
            $i$a$-let-TypeScriptCompilerTypeConverter$toJSType$returnType$1 = false;
            v12 = this.toJSType(it);
        } else {
            v12 = returnType = null;
        }
        if (((Collection)typeParameters).isEmpty() == false) {
            return new TypeScriptJSFunctionTypeImpl(source, typeParameters, parameters, null, returnType);
        }
        return new JSFunctionTypeImpl(source, parameters, returnType);
    }

    public final void loadTypeProperties(@NotNull Type type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        TypeScriptServerTypeCheckerContextKt.getIdeTypeCheckerContext(type2).getService().getTypeEvaluationSupport().loadTypeProperties(type2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<JSType> convertTypeArguments(@NotNull List<? extends Type> typeArguments) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(typeArguments, (String)"typeArguments");
        Iterable $this$map$iv = typeArguments;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Type type2 = (Type)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            JSType jSType = this.toJSType((Type)it);
            if (jSType == null) {
                return CollectionsKt.emptyList();
            }
            collection.add(jSType);
        }
        return (List)destination$iv$iv;
    }

    private static final void findPsiElement$lambda$7(InjectedLanguageManager $injectedLanguageManager, PsiFile $psiFile, int $convertedPos, int $convertedEnd, Ref.ObjectRef $elementAtStartPos, Ref.ObjectRef $elementAtEndPos) {
        Intrinsics.checkNotNullParameter((Object)$psiFile, (String)"$psiFile");
        Intrinsics.checkNotNullParameter((Object)$elementAtStartPos, (String)"$elementAtStartPos");
        Intrinsics.checkNotNullParameter((Object)$elementAtEndPos, (String)"$elementAtEndPos");
        PsiElement injectedAtStartPos = $injectedLanguageManager.findInjectedElementAt($psiFile, $convertedPos);
        PsiElement injectedAtEndPos = $injectedLanguageManager.findInjectedElementAt($psiFile, $convertedEnd);
        if (injectedAtStartPos != null && injectedAtEndPos != null && Intrinsics.areEqual((Object)injectedAtStartPos.getContainingFile(), (Object)injectedAtEndPos.getContainingFile())) {
            $elementAtStartPos.element = injectedAtStartPos;
            $elementAtEndPos.element = injectedAtEndPos;
        } else {
            $elementAtStartPos.element = $psiFile.findElementAt($convertedPos);
            $elementAtEndPos.element = $psiFile.findElementAt($convertedEnd - 1);
        }
    }

    private static final JSType toJSType$lambda$20$lambda$19$lambda$18$lambda$17(TypeScriptCompilerTypeConverter this$0, Type $type, TypeScriptGenericParameterImpl $it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$type, (String)"$type");
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        JSType jSType = this$0.toJSType($type);
        if (jSType == null) {
            JSAnyType jSAnyType = JSAnyType.get($it.getSource());
            Intrinsics.checkNotNullExpressionValue((Object)jSAnyType, (String)"get(...)");
            jSType = jSAnyType;
        }
        return jSType;
    }
}

