/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsc;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.JSDocDecoratedType;
import com.intellij.lang.javascript.psi.ecma6.JSDocFunctionType;
import com.intellij.lang.javascript.psi.ecma6.JSDocFunctionTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.impl.jsdoc.JSDocSingleTypeImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.TypeScriptService;
import com.intellij.lang.typescript.lsp.BaseLspTypeScriptService;
import com.intellij.lang.typescript.resolve.TypeScriptCompilerEvaluationFacade;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\bH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/lang/typescript/tsc/TypeScriptCompilerEvaluationFacadeImpl;", "Lcom/intellij/lang/typescript/resolve/TypeScriptCompilerEvaluationFacade;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "useTypesFromServerStateLogged", "Ljava/util/concurrent/atomic/AtomicBoolean;", "canAcceptElement", "", "element", "Lcom/intellij/psi/PsiElement;", "getTypeFromService", "Lcom/intellij/lang/javascript/psi/JSType;", "isEnabled", "isFromJSDoc", "throwIfUnitTestMode", "", "message", "", "Companion", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nTypeScriptCompilerEvaluationFacadeImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptCompilerEvaluationFacadeImpl.kt\ncom/intellij/lang/typescript/tsc/TypeScriptCompilerEvaluationFacadeImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,96:1\n13#2:97\n*S KotlinDebug\n*F\n+ 1 TypeScriptCompilerEvaluationFacadeImpl.kt\ncom/intellij/lang/typescript/tsc/TypeScriptCompilerEvaluationFacadeImpl\n*L\n31#1:97\n*E\n"})
public final class TypeScriptCompilerEvaluationFacadeImpl
implements TypeScriptCompilerEvaluationFacade {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final AtomicBoolean useTypesFromServerStateLogged;
    @NotNull
    private static final Logger LOG;

    public TypeScriptCompilerEvaluationFacadeImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.useTypesFromServerStateLogged = new AtomicBoolean(false);
    }

    @Override
    public boolean isEnabled() {
        boolean result2;
        TypeScriptCompilerSettings settings2 = TypeScriptCompilerSettings.getSettings(this.project);
        boolean bl = result2 = settings2.useService() && settings2.isUseTypesFromServer();
        if (this.useTypesFromServerStateLogged.compareAndSet(false, true)) {
            LOG.info("TypeScript 'Use types from server' option state: " + result2);
        }
        return result2;
    }

    @Override
    @Nullable
    public JSType getTypeFromService(@NotNull PsiElement element) {
        PsiElement psiElement;
        Object object;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!this.canAcceptElement(element)) {
            return null;
        }
        if (JSTypeEvaluationLocationProvider.isCalculatingGists()) {
            this.throwIfUnitTestMode("Cannot evaluate GIST types on server");
        }
        PsiElement psiElement2 = CompletionUtil.getOriginalOrSelf((PsiElement)element);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getOriginalOrSelf(...)");
        PsiElement adjustedElement = psiElement2;
        PsiElement psiElement3 = JSTypeEvaluationLocationProvider.getTypeEvaluationLocation();
        Object object2 = object = psiElement3 != null ? psiElement3.getOriginalElement() : null;
        if (object == null) {
            TypeScriptCompilerEvaluationFacadeImpl $this$getTypeFromService_u24lambda_u240 = this;
            boolean bl = false;
            $this$getTypeFromService_u24lambda_u240.throwIfUnitTestMode("Type evaluation location has not been provided. Use JSTypeEvaluationLocationProvider.withTypeEvaluationLocation to provide information about evaluation location.");
            psiElement = adjustedElement;
        } else {
            psiElement = object;
        }
        PsiElement evaluationLocation = psiElement;
        TypeScriptService.VirtualFileAndTypeScriptService virtualFileAndTypeScriptService = JSLanguageServiceUtil.nonBlockingReadActionWithTimeout(() -> TypeScriptCompilerEvaluationFacadeImpl.getTypeFromService$lambda$1(adjustedElement, evaluationLocation));
        if (virtualFileAndTypeScriptService == null) {
            return null;
        }
        object = virtualFileAndTypeScriptService;
        VirtualFile virtualFile = ((TypeScriptService.VirtualFileAndTypeScriptService)object).component1();
        TypeScriptService service2 = ((TypeScriptService.VirtualFileAndTypeScriptService)object).component2();
        if (!(service2 instanceof BaseLspTypeScriptService) && !(service2 instanceof TypeScriptCompilerService)) {
            return null;
        }
        if (!service2.supportsTypeEvaluation(virtualFile, adjustedElement)) {
            return null;
        }
        VirtualFile virtualFile2 = TypeScriptService.Companion.getServiceAwareVirtualFile(evaluationLocation);
        if (virtualFile2 == null || (virtualFile2 = (VirtualFile)virtualFile2.getFirst()) == null) {
            TypeScriptCompilerEvaluationFacadeImpl $this$getTypeFromService_u24lambda_u242 = this;
            boolean bl = false;
            $this$getTypeFromService_u24lambda_u242.throwIfUnitTestMode("Type evaluation location is not in the local file system. Cannot evaluate types in file " + evaluationLocation.getContainingFile() + ".");
            virtualFile2 = virtualFile;
        }
        VirtualFile evaluationLocationFile = virtualFile2;
        JSType typeFromService = service2.getTypeEvaluationSupport().getElementType(adjustedElement, virtualFile, evaluationLocationFile);
        if (typeFromService == null && Registry.is((String)"typescript.compiler.evaluation.fallback")) {
            return null;
        }
        JSType jSType = typeFromService;
        if (jSType == null) {
            jSType = JSAnyType.get(JSTypeSource.EMPTY_TS);
        }
        return jSType;
    }

    private final boolean canAcceptElement(PsiElement element) {
        return !this.isFromJSDoc(element);
    }

    private final boolean isFromJSDoc(PsiElement element) {
        KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(JSDocComment.class), Reflection.getOrCreateKotlinClass(JSDocFunctionType.class), Reflection.getOrCreateKotlinClass(JSDocFunctionTypeParameter.class), Reflection.getOrCreateKotlinClass(JSDocSingleTypeImpl.class), Reflection.getOrCreateKotlinClass(JSDocDecoratedType.class)};
        return PsiTreeUtilKt.parentOfTypes$default((PsiElement)element, (KClass[])kClassArray, (boolean)false, (int)2, null) != null;
    }

    private final void throwIfUnitTestMode(String message) {
        IllegalStateException error = new IllegalStateException(message);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw error;
        }
        LOG.warn((Throwable)error);
    }

    private static final TypeScriptService.VirtualFileAndTypeScriptService getTypeFromService$lambda$1(PsiElement $adjustedElement, PsiElement $evaluationLocation) {
        Intrinsics.checkNotNullParameter((Object)$adjustedElement, (String)"$adjustedElement");
        Intrinsics.checkNotNullParameter((Object)$evaluationLocation, (String)"$evaluationLocation");
        return TypeScriptService.Companion.getForElement($adjustedElement, $evaluationLocation);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TypeScriptCompilerEvaluationFacadeImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/lang/typescript/tsc/TypeScriptCompilerEvaluationFacadeImpl$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

