/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.lsp;

import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.lsp.LspServerActivationRule;
import com.intellij.lang.typescript.lsp.LspServerDownloader;
import com.intellij.lang.typescript.lsp.TSPluginDownloader;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0004J\u0016\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/intellij/lang/typescript/lsp/JSServiceSetActivationRule;", "Lcom/intellij/lang/typescript/lsp/LspServerActivationRule;", "lspServerDownloader", "Lcom/intellij/lang/typescript/lsp/LspServerDownloader;", "tsPluginDownloader", "Lcom/intellij/lang/typescript/lsp/TSPluginDownloader;", "(Lcom/intellij/lang/typescript/lsp/LspServerDownloader;Lcom/intellij/lang/typescript/lsp/TSPluginDownloader;)V", "getTsPluginDownloader", "()Lcom/intellij/lang/typescript/lsp/TSPluginDownloader;", "isEnabledByEnvironment", "", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lcom/intellij/openapi/vfs/VirtualFile;", "isTypeScriptPluginEnabledAndAvailable", "intellij.javascript.impl"})
@ApiStatus.Experimental
public abstract class JSServiceSetActivationRule
extends LspServerActivationRule {
    @Nullable
    private final TSPluginDownloader tsPluginDownloader;

    public JSServiceSetActivationRule(@NotNull LspServerDownloader lspServerDownloader, @Nullable TSPluginDownloader tsPluginDownloader) {
        Intrinsics.checkNotNullParameter((Object)lspServerDownloader, (String)"lspServerDownloader");
        super(lspServerDownloader);
        this.tsPluginDownloader = tsPluginDownloader;
    }

    @Nullable
    public final TSPluginDownloader getTsPluginDownloader() {
        return this.tsPluginDownloader;
    }

    public final boolean isTypeScriptPluginEnabledAndAvailable(@NotNull Project project, @NotNull VirtualFile context2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (this.tsPluginDownloader == null) {
            throw new NotImplementedError(this.getClass().getSimpleName() + " doesn't support TS Plugin");
        }
        return this.isEnabledByContextAndSettings(project, context2) && this.tsPluginDownloader.getExecutableOrRefresh(project) != null;
    }

    @Override
    protected final boolean isEnabledByEnvironment(@NotNull Project project, @NotNull VirtualFile context2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return TypeScriptLanguageServiceUtil.isServiceEnabled(project) && !TypeScriptLibraryProvider.isLibraryOrBundledLibraryFile(project, context2);
    }
}

