/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.library.download;

import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class TypeScriptDefinitionFilesDirectory {
    private static volatile Supplier<VirtualFile> myTypesDirectory;

    @NotNull
    public static String getGlobalTypesTargetPath(String name) {
        String string = TypeScriptDefinitionFilesDirectory.getGlobalTypesDirectoryPath() + File.separator + name;
        if (string == null) {
            TypeScriptDefinitionFilesDirectory.$$$reportNull$$$0(0);
        }
        return string;
    }

    @TestOnly
    public static void forceTypesDirectory(Disposable disposable, VirtualFile types2) {
        myTypesDirectory = () -> types2;
        Disposer.register((Disposable)disposable, () -> {
            myTypesDirectory = null;
        });
    }

    @Nullable
    public static VirtualFile getGlobalAutoDownloadTypesDirectory() {
        return LocalFileSystem.getInstance().findFileByPath(TypeScriptDefinitionFilesDirectory.getGlobalAutoDownloadTypesDirectoryPath());
    }

    @Nullable
    public static VirtualFile getGlobalTypesDirectory() {
        VirtualFile file;
        Supplier<VirtualFile> ref = myTypesDirectory;
        VirtualFile virtualFile = file = ref == null ? null : ref.get();
        if (file != null) {
            if (!file.isValid()) {
                myTypesDirectory = null;
            }
            return file;
        }
        String typesDirectory = TypeScriptDefinitionFilesDirectory.getGlobalTypesDirectoryPath();
        VirtualFile result2 = LocalFileSystem.getInstance().findFileByPath(typesDirectory);
        if (result2 == null) {
            return null;
        }
        if (result2.isValid()) {
            SoftReference<VirtualFile> reference = new SoftReference<VirtualFile>(result2);
            myTypesDirectory = reference::get;
        }
        return result2;
    }

    @NotNull
    public static String getGlobalTypesTopDirectory() {
        String targetDirPath = JSUtils.getExtLibsDirPath();
        String string = targetDirPath + File.separator + "global-types";
        if (string == null) {
            TypeScriptDefinitionFilesDirectory.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String getGlobalAutoDownloadTypesDirectoryPath() {
        String string = PathManager.getSystemPath() + File.separatorChar + "javascript" + File.separatorChar + "typings";
        if (string == null) {
            TypeScriptDefinitionFilesDirectory.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String getGlobalTypesDirectoryPath() {
        String string = TypeScriptDefinitionFilesDirectory.getGlobalTypesTopDirectory() + File.separator + "node_modules" + File.separator + "@types";
        if (string == null) {
            TypeScriptDefinitionFilesDirectory.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/typescript/library/download/TypeScriptDefinitionFilesDirectory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalTypesTargetPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalTypesTopDirectory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalAutoDownloadTypesDirectoryPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalTypesDirectoryPath";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

