/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.editing;

import com.intellij.codeInsight.hints.declarative.InlayHintsCollector;
import com.intellij.codeInsight.hints.declarative.InlayTreeSink;
import com.intellij.codeInsight.hints.declarative.OwnBypassCollector;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.editing.JSDeclarativeTypeHintsInlayProvider;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.TypeScriptService;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptQuickInfoResponse;
import com.intellij.lang.typescript.documentation.TypeScriptServiceQuickInfoParser;
import com.intellij.lang.typescript.editing.BuildHintFromServiceItemKt;
import com.intellij.lang.typescript.editing.TypeScriptInlayHintsSupportedService;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0002\u001a\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\"\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u00020\u00142\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0014\u00a8\u0006\u001c"}, d2={"Lcom/intellij/lang/typescript/editing/TypeScriptDeclarativeTypeTypeHintsInlayProvider;", "Lcom/intellij/lang/javascript/editing/JSDeclarativeTypeHintsInlayProvider;", "()V", "createCollector", "Lcom/intellij/codeInsight/hints/declarative/InlayHintsCollector;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getLanguageServiceUsage", "Lcom/intellij/lang/javascript/editing/JSDeclarativeTypeHintsInlayProvider$LanguageServiceUsage;", "getTypeFromService", "", "element", "Lcom/intellij/lang/javascript/psi/JSElement;", "kind", "Lcom/intellij/lang/javascript/editing/JSDeclarativeTypeHintsInlayProvider$HintFromServiceKind;", "serviceTimeoutMs", "", "isLanguageSupported", "", "language", "Lcom/intellij/lang/Language;", "isSupportedDialect", "dialectOfElement", "Lcom/intellij/lang/javascript/DialectOptionHolder;", "Companion", "OnlyToggleIntentionsCollector", "intellij.javascript.impl"})
public final class TypeScriptDeclarativeTypeTypeHintsInlayProvider
extends JSDeclarativeTypeHintsInlayProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String LANGUAGE_SERVICE_USAGE_KEY = "typescript.inlayTypeHints.languageServiceUsage";
    @NotNull
    public static final String ONLY_SERVICE_OPTION = "Only service";
    @NotNull
    public static final String ONLY_INTERNAL_OPTION = "Only internal";

    @Override
    public boolean isLanguageSupported(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return language instanceof JSLanguageDialect && ((JSLanguageDialect)language).getOptionHolder().isTypeScript;
    }

    @Override
    protected boolean isSupportedDialect(@Nullable DialectOptionHolder dialectOfElement) {
        return dialectOfElement != null && dialectOfElement.isTypeScript;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public JSDeclarativeTypeHintsInlayProvider.LanguageServiceUsage getLanguageServiceUsage() {
        block5: {
            block4: {
                var1_1 = Registry.get((String)"typescript.inlayTypeHints.languageServiceUsage").getSelectedOption();
                if (var1_1 == null) break block4;
                switch (var1_1.hashCode()) {
                    case -628909935: {
                        if (var1_1.equals("Only internal")) break;
                        ** break;
                    }
                    case -271291807: {
                        if (!var1_1.equals("Only service")) ** break;
                        v0 = JSDeclarativeTypeHintsInlayProvider.LanguageServiceUsage.ONLY_SERVICE;
                        break block5;
                    }
                }
                v0 = JSDeclarativeTypeHintsInlayProvider.LanguageServiceUsage.ONLY_INTERNAL;
                break block5;
            }
            v0 = JSDeclarativeTypeHintsInlayProvider.LanguageServiceUsage.SERVICE_THEN_INTERNAL;
        }
        return v0;
    }

    @Override
    @Nullable
    public InlayHintsCollector createCollector(@NotNull PsiFile file, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return ((TypeScriptInlayHintsSupportedService)file.getProject().getService(TypeScriptInlayHintsSupportedService.class)).isSupported(file) ? (InlayHintsCollector)new OnlyToggleIntentionsCollector() : super.createCollector(file, editor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public String getTypeFromService(@NotNull JSElement element, @NotNull JSDeclarativeTypeHintsInlayProvider.HintFromServiceKind kind, long serviceTimeoutMs) {
        JSType resultType;
        JSType jSType;
        Object object;
        TypeScriptQuickInfoResponse serviceResponse;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        TypeScriptCompilerSettings typeScriptCompilerSettings = TypeScriptCompilerSettings.getSettings(element.getProject());
        if (typeScriptCompilerSettings == null) {
            return null;
        }
        TypeScriptCompilerSettings settings2 = typeScriptCompilerSettings;
        if (!settings2.useService()) {
            return null;
        }
        PsiFile psiFile2 = element.getContainingFile();
        if (psiFile2 == null) return null;
        VirtualFile virtualFile = psiFile2.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        if (virtualFile2 instanceof VirtualFileWindow) {
            return null;
        }
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        TypeScriptService typeScriptService = TypeScriptService.Companion.getForFile(project, virtualFile2);
        if (typeScriptService == null) {
            return null;
        }
        TypeScriptService service2 = typeScriptService;
        PsiElement psiElement = element.getOriginalElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getOriginalElement(...)");
        VirtualFile virtualFile3 = element.getOriginalElement().getContainingFile().getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"getVirtualFile(...)");
        TypeScriptQuickInfoResponse typeScriptQuickInfoResponse = serviceResponse = JSLanguageServiceUtil.awaitFuture(service2.getQuickInfoAt(psiElement, virtualFile3), serviceTimeoutMs);
        if (typeScriptQuickInfoResponse == null) return null;
        String string = typeScriptQuickInfoResponse.displayString;
        if (string == null) {
            return null;
        }
        String quickInfoStr = string;
        TypeScriptServiceQuickInfoParser.ParsedInfo parsedInfo = TypeScriptServiceQuickInfoParser.parseServiceTextAsInfo(quickInfoStr);
        if (parsedInfo == null) {
            return null;
        }
        TypeScriptServiceQuickInfoParser.ParsedInfo parsedQuickInfo = parsedInfo;
        String string2 = parsedQuickInfo.myRestPart;
        if (string2 == null) {
            return null;
        }
        String restPart = string2;
        if (kind == JSDeclarativeTypeHintsInlayProvider.HintFromServiceKind.FIELD_OR_VAR_TYPE && StringsKt.startsWith$default((String)restPart, (String)": ", (boolean)false, (int)2, null)) {
            String string3 = restPart.substring(2);
            object = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        } else {
            if (kind != JSDeclarativeTypeHintsInlayProvider.HintFromServiceKind.FUNCTION_RETURN_TYPE) return null;
            String string4 = parsedQuickInfo.myKeywords;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"myKeywords");
            if (!StringsKt.contains$default((CharSequence)string4, (CharSequence)"function", (boolean)false, (int)2, null)) {
                String string5 = parsedQuickInfo.myKindPrefix;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"myKindPrefix");
                if (!StringsKt.contains$default((CharSequence)string5, (CharSequence)"function", (boolean)false, (int)2, null)) {
                    String string6 = parsedQuickInfo.myKindPrefix;
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"myKindPrefix");
                    if (!StringsKt.contains$default((CharSequence)string6, (CharSequence)"method", (boolean)false, (int)2, null)) return null;
                }
            }
            object = "function " + restPart;
        }
        String typeStr = object;
        JSType jSType2 = JSTypeParser.createTypeFromJSDoc(element.getProject(), typeStr, JSTypeSource.EMPTY);
        if (jSType2 == null) {
            return null;
        }
        JSType elementType = jSType2;
        if (kind == JSDeclarativeTypeHintsInlayProvider.HintFromServiceKind.FUNCTION_RETURN_TYPE) {
            if (!(elementType instanceof JSFunctionType)) return null;
            JSFunctionType jSFunctionType = (JSFunctionType)elementType;
            jSType = jSFunctionType;
            if (jSFunctionType == null) return null;
            if ((jSType = jSType.getReturnType()) == null) {
                return null;
            }
        } else {
            jSType = elementType;
        }
        if (this.isSuitableType(resultType = jSType)) return resultType.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
        return "";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/lang/typescript/editing/TypeScriptDeclarativeTypeTypeHintsInlayProvider$Companion;", "", "()V", "LANGUAGE_SERVICE_USAGE_KEY", "", "ONLY_INTERNAL_OPTION", "ONLY_SERVICE_OPTION", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J&\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/lang/typescript/editing/TypeScriptDeclarativeTypeTypeHintsInlayProvider$OnlyToggleIntentionsCollector;", "Lcom/intellij/codeInsight/hints/declarative/OwnBypassCollector;", "()V", "collectHintsForFile", "", "file", "Lcom/intellij/psi/PsiFile;", "sink", "Lcom/intellij/codeInsight/hints/declarative/InlayTreeSink;", "getOptionsToToggle", "", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isFunctionPossiblyHavingReturnTypeHint", "", "element", "Lcom/intellij/psi/PsiElement;", "isUntypedParameter", "isVarStatementPossiblyHavingHint", "intellij.javascript.impl"})
    @ApiStatus.Internal
    @SourceDebugExtension(value={"SMAP\nTypeScriptDeclarativeTypeTypeHintsInlayProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptDeclarativeTypeTypeHintsInlayProvider.kt\ncom/intellij/lang/typescript/editing/TypeScriptDeclarativeTypeTypeHintsInlayProvider$OnlyToggleIntentionsCollector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,153:1\n1#2:154\n*E\n"})
    public static final class OnlyToggleIntentionsCollector
    implements OwnBypassCollector {
        public void collectHintsForFile(@NotNull PsiFile file, @NotNull InlayTreeSink sink) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        }

        @NotNull
        public Set<String> getOptionsToToggle(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            PsiElement psiElement = file.findElementAt(editor.getCaretModel().getOffset());
            if (psiElement == null) {
                return SetsKt.emptySet();
            }
            PsiElement element = psiElement;
            return BuildHintFromServiceItemKt.isSingleNonParenthesizedParam(element) ? SetsKt.setOf((Object)"non.paren.single.param") : (this.isUntypedParameter(element) ? SetsKt.setOf((Object)"parameters.in.parens") : (this.isVarStatementPossiblyHavingHint(element) ? SetsKt.setOf((Object)"variables.and.fields") : (this.isFunctionPossiblyHavingReturnTypeHint(element) ? SetsKt.setOf((Object)"function.returns") : SetsKt.emptySet())));
        }

        private final boolean isUntypedParameter(PsiElement element) {
            TypeScriptParameter typeScriptParameter = BuildHintFromServiceItemKt.getSimpleTypeScriptParameter(element);
            if (typeScriptParameter == null) {
                return false;
            }
            TypeScriptParameter parameter = typeScriptParameter;
            return parameter.getTypeElement() == null;
        }

        private final boolean isVarStatementPossiblyHavingHint(PsiElement element) {
            Object object;
            JSVarStatement varStatement;
            block7: {
                JSVarStatement jSVarStatement = (JSVarStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSVarStatement.class);
                if (jSVarStatement == null) {
                    return false;
                }
                varStatement = jSVarStatement;
                JSVariable[] jSVariableArray = varStatement.getVariables();
                Intrinsics.checkNotNullExpressionValue((Object)jSVariableArray, (String)"getVariables(...)");
                for (Object object2 : (Object[])jSVariableArray) {
                    JSVariable it = (JSVariable)object2;
                    boolean bl = false;
                    if (!PsiTreeUtil.isAncestor((PsiElement)it.getNameIdentifier(), (PsiElement)element, (boolean)false)) continue;
                    object = object2;
                    break block7;
                }
                object = null;
            }
            JSVariable jSVariable = (JSVariable)object;
            if (jSVariable == null) {
                return false;
            }
            JSVariable jsVar = jSVariable;
            TypeScriptVariable typeScriptVariable = jsVar instanceof TypeScriptVariable ? (TypeScriptVariable)jsVar : null;
            if ((typeScriptVariable != null ? typeScriptVariable.getTypeElement() : null) != null) {
                return false;
            }
            JSVarStatement.VarKeyword varKeyword = varStatement.getVarKeyword();
            if (varKeyword == null) {
                return false;
            }
            JSVarStatement.VarKeyword keyword = varKeyword;
            JSExpression jSExpression = jsVar.getInitializer();
            if (jSExpression == null) {
                return false;
            }
            JSExpression initializer = jSExpression;
            if (keyword == JSVarStatement.VarKeyword.VAR || keyword == JSVarStatement.VarKeyword.LET) {
                return true;
            }
            return !(initializer instanceof JSObjectLiteralExpression) && !(initializer instanceof JSLiteralExpression);
        }

        private final boolean isFunctionPossiblyHavingReturnTypeHint(PsiElement element) {
            JSFunction jSFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)element, JSFunction.class);
            if (jSFunction == null) {
                return false;
            }
            JSFunction function2 = jSFunction;
            if (function2.getReturnTypeElement() != null) {
                return false;
            }
            JSParameterList jSParameterList = function2.getParameterList();
            return Intrinsics.areEqual(jSParameterList != null && (jSParameterList = jSParameterList.getNode()) != null && (jSParameterList = jSParameterList.getFirstChildNode()) != null ? jSParameterList.getElementType() : null, (Object)JSTokenTypes.LPAR);
        }
    }
}

