/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptServiceCommandClean;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigFileType;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigLibraryUpdater;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigServiceImpl;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptVfsListener
implements AsyncFileListener {
    @Nullable
    public AsyncFileListener.ChangeApplier prepareChange(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
        if (events == null) {
            TypeScriptVfsListener.$$$reportNull$$$0(0);
        }
        SmartList fileWithChangedContent = null;
        boolean cleanAllCache = false;
        boolean shouldUpdateLibraries = false;
        HashSet<VirtualFile> changedConfigs = null;
        boolean hasCreateTsFileEvent = false;
        for (VFileEvent vFileEvent : events) {
            boolean isStructureModification;
            ProgressManager.checkCanceled();
            if (!(vFileEvent.getFileSystem() instanceof LocalFileSystem)) continue;
            VirtualFile file = vFileEvent.getFile();
            if (file == null) {
                VFileCreateEvent e;
                if (!(vFileEvent instanceof VFileCreateEvent) || !(e = (VFileCreateEvent)vFileEvent).isDirectory() || e.getChildren() != null) continue;
                shouldUpdateLibraries = true;
                continue;
            }
            boolean bl = isStructureModification = vFileEvent instanceof VFileDeleteEvent || vFileEvent instanceof VFileMoveEvent || vFileEvent instanceof VFileCopyEvent;
            if (isStructureModification && (Boolean.TRUE.equals(file.getUserData(JSLanguageServiceQueue.Holder.GENERATED_FILE_MARKER)) || file.isDirectory())) {
                cleanAllCache = true;
                continue;
            }
            if (file.isDirectory()) continue;
            CharSequence sequence = file.getNameSequence();
            if (TypeScriptUtil.isTypeScriptFile(sequence)) {
                TypeScriptVfsListener.logTypeScriptEvent(vFileEvent, file);
                hasCreateTsFileEvent |= vFileEvent instanceof VFileCreateEvent || vFileEvent instanceof VFileCopyEvent || vFileEvent instanceof VFileMoveEvent;
                if (fileWithChangedContent == null) {
                    fileWithChangedContent = new SmartList();
                }
                TypeScriptVfsListener.fillCreateAndChangeFiles(fileWithChangedContent, vFileEvent);
                continue;
            }
            if (!TypeScriptVfsListener.isConfigFile(sequence)) continue;
            if (changedConfigs == null) {
                changedConfigs = new HashSet<VirtualFile>();
            }
            changedConfigs.add(file);
        }
        TypeScriptVfsListener.afterProcessing(fileWithChangedContent == null ? ContainerUtil.emptyList() : fileWithChangedContent, (Collection<VirtualFile>)(changedConfigs == null ? ContainerUtil.emptyList() : changedConfigs), cleanAllCache, hasCreateTsFileEvent, shouldUpdateLibraries);
        return null;
    }

    private static void afterProcessing(@NotNull List<TypeScriptCompilerService.UpdateFileInfo> filesToProcess, @NotNull Collection<VirtualFile> changedConfigs, boolean cleanAllCache, boolean hasCreateTsFileEvent, boolean shouldUpdateLibraries) {
        Project[] projects;
        if (filesToProcess == null) {
            TypeScriptVfsListener.$$$reportNull$$$0(1);
        }
        if (changedConfigs == null) {
            TypeScriptVfsListener.$$$reportNull$$$0(2);
        }
        if (changedConfigs.isEmpty() && !cleanAllCache && !shouldUpdateLibraries && ContainerUtil.isEmpty(filesToProcess)) {
            return;
        }
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            TypeScriptCompilerSettings settings2 = TypeScriptCompilerSettings.getSettings(project);
            ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project);
            if (cleanAllCache || hasCreateTsFileEvent && TypeScriptVfsListener.hasConfigParameter(settings2)) {
                TypeScriptCompilerService.sendCleanCommandToCompiler(project, new TypeScriptServiceCommandClean(true));
            } else if (!changedConfigs.isEmpty()) {
                for (VirtualFile config : changedConfigs) {
                    if (!fileIndex.isInContent(config)) continue;
                    TypeScriptCompilerService.sendCleanCommandToCompiler(project, new TypeScriptServiceCommandClean(TypeScriptCompilerConfigUtil.getConfigIdByConfig(config)));
                }
                TypeScriptConfigService configService = TypeScriptConfigService.Provider.get(project);
                TypeScriptConfigServiceImpl configServiceImpl = (TypeScriptConfigServiceImpl)ObjectUtils.tryCast((Object)configService, TypeScriptConfigServiceImpl.class);
                if (configServiceImpl != null) {
                    configServiceImpl.afterUpdate(changedConfigs);
                }
            } else if (shouldUpdateLibraries) {
                ((TypeScriptConfigLibraryUpdater)project.getService(TypeScriptConfigLibraryUpdater.class)).queueToUpdate();
            }
            if (ContainerUtil.isEmpty(filesToProcess)) continue;
            List filtered = ((StreamEx)StreamEx.of(filesToProcess).filter(el -> fileIndex.isInContent(el.getFile()))).toList();
            TypeScriptCompilerService.processVfsChangesForFiles(project, filtered);
        }
    }

    private static void logTypeScriptEvent(@NotNull VFileEvent event, @NotNull VirtualFile file) {
        if (event == null) {
            TypeScriptVfsListener.$$$reportNull$$$0(3);
        }
        if (file == null) {
            TypeScriptVfsListener.$$$reportNull$$$0(4);
        }
        if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
            JSLanguageServiceQueue.Holder.LOGGER.debug("TypeScript Vfs Events Processing: " + event.getClass() + " file " + file + " " + event.getRequestor());
        }
    }

    private static boolean isConfigFile(@NotNull CharSequence fileNameSequence) {
        if (fileNameSequence == null) {
            TypeScriptVfsListener.$$$reportNull$$$0(5);
        }
        if (!StringUtil.endsWith((CharSequence)fileNameSequence, (CharSequence)".json")) {
            return false;
        }
        return FileTypeManager.getInstance().getFileTypeByFileName(fileNameSequence) instanceof TypeScriptConfigFileType;
    }

    private static boolean hasConfigParameter(@NotNull TypeScriptCompilerSettings settings2) {
        if (settings2 == null) {
            TypeScriptVfsListener.$$$reportNull$$$0(6);
        }
        if (!settings2.useService()) {
            return true;
        }
        String params = settings2.getDefaultServiceOptions();
        if (StringUtil.isEmpty((String)params)) {
            return false;
        }
        for (String s : ParametersListUtil.parse((String)params)) {
            if (StringUtil.isEmpty((String)s) || !ArrayUtil.contains((String)s, (String[])TypeScriptCompilerSettings.CONFIG_PARAMS)) continue;
            return true;
        }
        return false;
    }

    private static void fillCreateAndChangeFiles(@NotNull List<? super TypeScriptCompilerService.UpdateFileInfo> filesToUpdateState, @NotNull VFileEvent event) {
        VirtualFile file;
        if (filesToUpdateState == null) {
            TypeScriptVfsListener.$$$reportNull$$$0(7);
        }
        if (event == null) {
            TypeScriptVfsListener.$$$reportNull$$$0(8);
        }
        if ((file = event.getFile()) == null) {
            return;
        }
        if (event instanceof VFileContentChangeEvent) {
            filesToUpdateState.add(new TypeScriptCompilerService.UpdateFileInfo(file, false));
        } else if (event instanceof VFileCreateEvent || event instanceof VFileCopyEvent || event instanceof VFileMoveEvent) {
            filesToUpdateState.add(new TypeScriptCompilerService.UpdateFileInfo(file, true));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToProcess";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedConfigs";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNameSequence";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToUpdateState";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/compiler/TypeScriptVfsListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareChange";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "afterProcessing";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "logTypeScriptEvent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isConfigFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "hasConfigParameter";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCreateAndChangeFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

