/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service.highlighting;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.BackgroundUpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.highlighting.JSLanguageServiceAnnotationProvider;
import com.intellij.lang.javascript.service.highlighting.JSLanguageServiceHighlightingStateHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLanguageServiceHighlightingPass
extends TextEditorHighlightingPass {
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final JSLanguageServiceHighlightingStateHolder myFutureState;
    @Nullable
    private final JSLanguageService myLanguageService;
    @NotNull
    private final String myServiceName;

    JSLanguageServiceHighlightingPass(@NotNull Project project, @Nullable JSLanguageService languageService, @NotNull PsiFile file, @NotNull JSLanguageServiceHighlightingStateHolder myStateHolder, @NotNull Document document2, @NotNull String serviceName) {
        if (project == null) {
            JSLanguageServiceHighlightingPass.$$$reportNull$$$0(0);
        }
        if (file == null) {
            JSLanguageServiceHighlightingPass.$$$reportNull$$$0(1);
        }
        if (myStateHolder == null) {
            JSLanguageServiceHighlightingPass.$$$reportNull$$$0(2);
        }
        if (document2 == null) {
            JSLanguageServiceHighlightingPass.$$$reportNull$$$0(3);
        }
        if (serviceName == null) {
            JSLanguageServiceHighlightingPass.$$$reportNull$$$0(4);
        }
        super(project, document2, false);
        this.myFile = file;
        this.myFutureState = myStateHolder;
        this.myLanguageService = languageService;
        this.myServiceName = serviceName;
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            JSLanguageServiceHighlightingPass.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        List<HighlightInfo> result2 = this.needProcessHighlight() ? this.awaitResults(progress) : this.setResults(ContainerUtil.emptyList());
        if (result2 != null) {
            JSLanguageServiceAnnotationProvider.updateWolfTheProblemSolver(this.myFile, this.myServiceName, result2);
            BackgroundUpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (PsiFile)this.myFile, (Document)this.myDocument, (int)0, (int)this.myFile.getTextLength(), result2, (int)this.getId());
        }
    }

    public void doApplyInformationToEditor() {
    }

    @Nullable
    private List<HighlightInfo> awaitResults(@NotNull ProgressIndicator progress) {
        Future<List<JSAnnotationError>> future;
        if (progress == null) {
            JSLanguageServiceHighlightingPass.$$$reportNull$$$0(6);
        }
        long docTimeStamp = this.myDocument.getModificationStamp();
        JSLanguageServiceHighlightingStateHolder.CalcState runningState = this.myFutureState.getState(this.myFile);
        if (runningState != null) {
            future = runningState.future();
            if (future.isDone()) {
                @Nullable List<HighlightInfo> result2 = this.setResults(JSLanguageServiceHighlightingPass.awaitResults(future, progress));
                if (docTimeStamp == runningState.docTimeStamp() && result2 != null) {
                    return result2;
                }
            } else {
                if (docTimeStamp == runningState.docTimeStamp()) {
                    return this.setResults(JSLanguageServiceHighlightingPass.awaitResults(future, progress));
                }
                this.myFutureState.reset(this.myFile);
                future.cancel(false);
            }
        }
        if ((future = Objects.requireNonNull(this.myLanguageService).highlight(this.myFile)) == null) {
            return List.of();
        }
        this.myFutureState.saveState(this.myFile, new JSLanguageServiceHighlightingStateHolder.CalcState(future, docTimeStamp));
        return this.setResults(JSLanguageServiceHighlightingPass.awaitResults(future, progress));
    }

    @Nullable
    private List<HighlightInfo> setResults(@Nullable List<? extends JSAnnotationError> annotationErrors) {
        if (annotationErrors == null) {
            return null;
        }
        List<HighlightInfo> result2 = annotationErrors.isEmpty() || this.myLanguageService == null ? List.of() : JSLanguageServiceAnnotationProvider.convertToHighlightingInfos(this.myFile, annotationErrors, this.myLanguageService);
        this.myFutureState.reset(this.myFile);
        return result2;
    }

    @Nullable
    private static List<JSAnnotationError> awaitResults(@Nullable Future<? extends List<JSAnnotationError>> future, @NotNull ProgressIndicator progress) {
        if (progress == null) {
            JSLanguageServiceHighlightingPass.$$$reportNull$$$0(7);
        }
        return JSLanguageServiceUtil.awaitFuture(future, JSLanguageServiceUtil.getTimeout(), 5L, progress);
    }

    private boolean needProcessHighlight() {
        return this.myLanguageService != null && this.myLanguageService.isAcceptable(this.myFile.getVirtualFile()) && this.myLanguageService.canHighlight(this.myFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myStateHolder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceName";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/service/highlighting/JSLanguageServiceHighlightingPass";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "doCollectInformation";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "awaitResults";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

