/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.lang.javascript.service.JSLanguageServiceBase;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceResponse;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceSimpleCommand;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLanguageServiceFileCommandCache {
    public static final Key<CachedValue<ConcurrentMap<JSLanguageServiceSimpleCommand, JSLanguageServiceResponse>>> KEY = Key.create((String)"js.service.commands.file.cache");
    @NotNull
    private final JSLanguageServiceBase myService;

    public JSLanguageServiceFileCommandCache(@NotNull JSLanguageServiceBase service2) {
        if (service2 == null) {
            JSLanguageServiceFileCommandCache.$$$reportNull$$$0(0);
        }
        this.myService = service2;
    }

    @NotNull
    public JSLanguageServiceBase getService() {
        JSLanguageServiceBase jSLanguageServiceBase = this.myService;
        if (jSLanguageServiceBase == null) {
            JSLanguageServiceFileCommandCache.$$$reportNull$$$0(1);
        }
        return jSLanguageServiceBase;
    }

    @Nullable
    public JSLanguageServiceResponse getCachedValue(@NotNull PsiFile psiFile2, @NotNull JSLanguageServiceSimpleCommand command) {
        ConcurrentMap<JSLanguageServiceSimpleCommand, JSLanguageServiceResponse> map;
        JSLanguageServiceResponse response;
        if (psiFile2 == null) {
            JSLanguageServiceFileCommandCache.$$$reportNull$$$0(2);
        }
        if (command == null) {
            JSLanguageServiceFileCommandCache.$$$reportNull$$$0(3);
        }
        return (response = (JSLanguageServiceResponse)(map = this.getCachedMap(psiFile2)).get(command)) instanceof LoadingResponse ? null : response;
    }

    @NotNull
    public ConcurrentMap<JSLanguageServiceSimpleCommand, JSLanguageServiceResponse> getCachedMap(@NotNull PsiFile psiFile2) {
        if (psiFile2 == null) {
            JSLanguageServiceFileCommandCache.$$$reportNull$$$0(4);
        }
        ConcurrentMap concurrentMap = (ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)psiFile2, KEY, () -> CachedValueProvider.Result.create(new ConcurrentHashMap(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (concurrentMap == null) {
            JSLanguageServiceFileCommandCache.$$$reportNull$$$0(5);
        }
        return concurrentMap;
    }

    @Nullable
    public <T extends JSLanguageServiceResponse> T calculateWithCache(@NotNull PsiFile psiFile2, @NotNull JSLanguageServiceSimpleCommand command, JSLanguageServiceCommandProcessor<T> processor, long timeout) {
        if (psiFile2 == null) {
            JSLanguageServiceFileCommandCache.$$$reportNull$$$0(6);
        }
        if (command == null) {
            JSLanguageServiceFileCommandCache.$$$reportNull$$$0(7);
        }
        if (!this.myService.checkCanUseService() || !this.myService.isServiceCreated()) {
            return null;
        }
        ConcurrentMap<JSLanguageServiceSimpleCommand, JSLanguageServiceResponse> cachedMap = this.getCachedMap(psiFile2);
        JSLanguageServiceResponse response = (JSLanguageServiceResponse)cachedMap.get(command);
        if (response != null) {
            return JSLanguageServiceFileCommandCache.returnResponseOrAwait(null, response, timeout);
        }
        Project project = psiFile2.getProject();
        CompletableFuture<JSLanguageServiceResponse> future = this.myService.sendCommand(command, (serviceObject, answer) -> (JSLanguageServiceResponse)ReadAction.compute(() -> {
            if (!psiFile2.isValid() || project.isDisposed() || !this.myService.isServiceCreated()) {
                return null;
            }
            JSLanguageServiceResponse process = (JSLanguageServiceResponse)processor.process(serviceObject, answer);
            ConcurrentMap<JSLanguageServiceSimpleCommand, JSLanguageServiceResponse> newMap = this.getCachedMap(psiFile2);
            if (newMap == cachedMap) {
                cachedMap.put(command, process);
            } else {
                cachedMap.remove(command);
            }
            return process;
        }));
        if (future == null) {
            return null;
        }
        JSLanguageServiceResponse result2 = cachedMap.putIfAbsent(command, new LoadingResponse<JSLanguageServiceResponse>(future));
        return (T)JSLanguageServiceFileCommandCache.returnResponseOrAwait(future, result2, timeout);
    }

    @Nullable
    private static <T extends JSLanguageServiceResponse> T returnResponseOrAwait(@Nullable Future<T> future, @Nullable JSLanguageServiceResponse result2, long timeout) {
        if (result2 != null) {
            if (!(result2 instanceof LoadingResponse)) {
                return (T)result2;
            }
            future = ((LoadingResponse)result2).myFuture;
        }
        return (T)((JSLanguageServiceResponse)JSLanguageServiceUtil.awaitFuture(future, timeout, 5L, null, false, null, true));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/service/JSLanguageServiceFileCommandCache";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/service/JSLanguageServiceFileCommandCache";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getService";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCachedValue";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCachedMap";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "calculateWithCache";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5 -> new IllegalStateException(string);
        };
    }

    private static class LoadingResponse<T>
    implements JSLanguageServiceResponse {
        @NotNull
        private final Future<T> myFuture;

        LoadingResponse(@NotNull Future<T> future) {
            if (future == null) {
                LoadingResponse.$$$reportNull$$$0(0);
            }
            this.myFuture = future;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "future", "com/intellij/lang/javascript/service/JSLanguageServiceFileCommandCache$LoadingResponse", "<init>"));
        }
    }
}

