/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.integration.JSAnnotationRangeError;
import com.intellij.openapi.util.NlsSafe;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLanguageServiceAnnotationResult
implements JSAnnotationRangeError {
    protected final int myColumn;
    protected final int myLine;
    protected final int myEndLine;
    protected final int myEndColumn;
    @NlsSafe
    @NotNull
    protected final String myErrorText;
    @NlsSafe
    @Nullable
    protected final String myTooltipText;
    @NlsSafe
    @Nullable
    protected final String myCategory;
    @NlsSafe
    @Nullable
    protected final String myFileAbsoluteSystemDependPath;

    @Override
    public int getColumn() {
        return this.myColumn;
    }

    @Override
    public int getLine() {
        return this.myLine;
    }

    @Override
    @NotNull
    public String getDescription() {
        String string = this.myErrorText;
        if (string == null) {
            JSLanguageServiceAnnotationResult.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    public String getTooltipText() {
        return this.myTooltipText;
    }

    @Override
    @Nullable
    public String getCategory() {
        return this.myCategory;
    }

    @Override
    @Nullable
    public String getAbsoluteFilePath() {
        return this.myFileAbsoluteSystemDependPath;
    }

    @Override
    public int getEndLine() {
        return this.myEndLine;
    }

    @Override
    public int getEndColumn() {
        return this.myEndColumn;
    }

    public static List<JSAnnotationError> buildError(String errorText) {
        return List.of(new JSLanguageServiceAnnotationResult(errorText, null, null, null, 0, 0, 0, 0));
    }

    public JSLanguageServiceAnnotationResult(@NotNull String errorText, @Nullable String tooltipText, @Nullable String fileAbsolutePath, @Nullable String category, int line, int column, int lineEnd, int columnEnd) {
        if (errorText == null) {
            JSLanguageServiceAnnotationResult.$$$reportNull$$$0(1);
        }
        this.myCategory = category;
        this.myColumn = column - 1;
        this.myLine = line - 1;
        this.myEndLine = lineEnd - 1;
        this.myEndColumn = columnEnd - 1;
        this.myErrorText = errorText;
        this.myTooltipText = tooltipText;
        this.myFileAbsoluteSystemDependPath = fileAbsolutePath;
    }

    public String toString() {
        return "JSLanguageCompilerResult{myColumn=" + this.myColumn + ", myLine=" + this.myLine + ", myEndLine=" + this.myEndLine + ", myEndColumn=" + this.myEndColumn + ", myErrorText='" + this.myErrorText + "', myCategory='" + this.myCategory + "', myFileAbsoluteSystemDependPath='" + this.myFileAbsoluteSystemDependPath + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSLanguageServiceAnnotationResult result2 = (JSLanguageServiceAnnotationResult)o;
        return this.myColumn == result2.myColumn && this.myLine == result2.myLine && this.myEndLine == result2.myEndLine && this.myEndColumn == result2.myEndColumn && Objects.equals(this.myErrorText, result2.myErrorText) && Objects.equals(this.myTooltipText, result2.myTooltipText) && Objects.equals(this.myCategory, result2.myCategory) && Objects.equals(this.myFileAbsoluteSystemDependPath, result2.myFileAbsoluteSystemDependPath);
    }

    public int hashCode() {
        return Objects.hash(this.myColumn, this.myLine, this.myEndLine, this.myEndColumn, this.myErrorText, this.myTooltipText, this.myCategory, this.myFileAbsoluteSystemDependPath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/service/JSLanguageServiceAnnotationResult";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/service/JSLanguageServiceAnnotationResult";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

