/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.impl.FileOffsetsManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.text.CharArrayUtil;
import java.nio.CharBuffer;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u000eJ\u0012\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\u0016\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u000eJ\u0012\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/lang/javascript/service/DocumentOffsetsManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "myOffsets", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/openapi/editor/Document;", "Lcom/intellij/openapi/fileEditor/impl/FileOffsetsManager$LineOffsets;", "createWritableCharBuffer", "Ljava/nio/CharBuffer;", "charSequence", "", "getConvertedOffset", "", "document", "originalOffset", "getLineOffsets", "getOriginalOffset", "convertedOffset", "loadLineOffsets", "intellij.javascript.impl"})
public final class DocumentOffsetsManager {
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentMap<Document, FileOffsetsManager.LineOffsets> myOffsets;

    public DocumentOffsetsManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentWeakMap(...)");
        this.myOffsets = concurrentMap;
    }

    public final int getConvertedOffset(@NotNull Document document2, int originalOffset) {
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        FileOffsetsManager.LineOffsets offsets = this.getLineOffsets(document2);
        if (offsets == null || offsets.myLineOffsetsAreTheSame) {
            return originalOffset;
        }
        return FileOffsetsManager.getCorrespondingOffset((int[])offsets.myOriginalLineOffsets, (int[])offsets.myConvertedLineOffsets, (int)originalOffset);
    }

    public final int getOriginalOffset(@NotNull Document document2, int convertedOffset) {
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        FileOffsetsManager.LineOffsets offsets = this.getLineOffsets(document2);
        if (offsets == null || offsets.myLineOffsetsAreTheSame) {
            return convertedOffset;
        }
        return FileOffsetsManager.getCorrespondingOffset((int[])offsets.myConvertedLineOffsets, (int[])offsets.myOriginalLineOffsets, (int)convertedOffset);
    }

    private final FileOffsetsManager.LineOffsets getLineOffsets(Document document2) {
        FileOffsetsManager.LineOffsets cachedOffsets;
        FileOffsetsManager.LineOffsets lineOffsets = cachedOffsets = (FileOffsetsManager.LineOffsets)this.myOffsets.get(document2);
        boolean bl = lineOffsets != null ? lineOffsets.myFileModificationStamp == document2.getModificationStamp() : false;
        if (bl) {
            return cachedOffsets;
        }
        FileOffsetsManager.LineOffsets lineOffsets2 = this.loadLineOffsets(document2);
        if (lineOffsets2 == null) {
            return null;
        }
        FileOffsetsManager.LineOffsets newOffsets = lineOffsets2;
        return this.myOffsets.compute(document2, (arg_0, arg_1) -> DocumentOffsetsManager.getLineOffsets$lambda$0((Function2)new Function2<Document, FileOffsetsManager.LineOffsets, FileOffsetsManager.LineOffsets>(newOffsets){
            final /* synthetic */ FileOffsetsManager.LineOffsets $newOffsets;
            {
                this.$newOffsets = $newOffsets;
                super(2);
            }

            @Nullable
            public final FileOffsetsManager.LineOffsets invoke(Document doc, @Nullable FileOffsetsManager.LineOffsets offsets) {
                FileOffsetsManager.LineOffsets lineOffsets = offsets;
                return (lineOffsets != null ? lineOffsets.myFileModificationStamp == doc.getModificationStamp() : false) ? offsets : (this.$newOffsets.myFileModificationStamp == doc.getModificationStamp() ? this.$newOffsets : null);
            }
        }, arg_0, arg_1));
    }

    private final FileOffsetsManager.LineOffsets loadLineOffsets(Document document2) {
        VirtualFile virtualFile;
        PsiFile psiFile2 = PsiDocumentManager.getInstance((Project)this.project).getPsiFile(document2);
        Object object = virtualFile = psiFile2 != null ? psiFile2.getVirtualFile() : null;
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        virtualFile = (Pair)ReadAction.compute(() -> DocumentOffsetsManager.loadLineOffsets$lambda$1(document2));
        CharSequence content = (CharSequence)virtualFile.component1();
        long modificationStamp = ((Number)virtualFile.component2()).longValue();
        CharSequence charSequence = JSLanguageServiceUtil.convertLineSeparatorsToFileOriginal(this.project, content, file);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"convertLineSeparatorsToFileOriginal(...)");
        CharSequence convertedContent = charSequence;
        return FileOffsetsManager.loadLineOffsets((CharBuffer)this.createWritableCharBuffer(convertedContent), (long)modificationStamp);
    }

    private final CharBuffer createWritableCharBuffer(CharSequence charSequence) {
        char[] arr = new char[charSequence.length()];
        CharArrayUtil.getChars((CharSequence)charSequence, (char[])arr, (int)0);
        CharBuffer charBuffer = CharBuffer.wrap(arr);
        Intrinsics.checkNotNullExpressionValue((Object)charBuffer, (String)"wrap(...)");
        return charBuffer;
    }

    private static final FileOffsetsManager.LineOffsets getLineOffsets$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FileOffsetsManager.LineOffsets)$tmp0.invoke(p0, p1);
    }

    private static final Pair loadLineOffsets$lambda$1(Document $document) {
        Intrinsics.checkNotNullParameter((Object)$document, (String)"$document");
        return TuplesKt.to((Object)$document.getCharsSequence(), (Object)$document.getModificationStamp());
    }
}

