/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.javascript.JSFlexAdapter;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.TypeScriptLanguageDialect;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.ecmascript6.parsing.JSDocTypeParser;
import com.intellij.lang.javascript.ecmascript6.parsing.TypeScriptPsiTypeParser;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSDocFunctionTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentList;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSDecoratedType;
import com.intellij.lang.javascript.psi.types.JSDecoratedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSUnknownType;
import com.intellij.lang.javascript.psi.types.recordImpl.CallSignatureImpl;
import com.intellij.lang.javascript.psi.types.recordImpl.PropertySignatureImpl;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Matcher;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSTypeParser {
    public static final char SERIALIZED_TYPE_MARK = '\u001d';
    @NotNull
    private final String myTypeString;
    @Nullable
    private final JSTypeVisitor myVisitor;
    @NotNull
    private final JSTypeSource mySource;
    @Nullable
    private final Project myProject;
    private final boolean myIsFromJSDoc;
    private int myCurrentOffset;
    private boolean myParsingFunction;
    private final List<SingleTypeInfo> myVisitingInfos;

    @Contract(value="_,null, _ -> null; _,!null, _ -> !null")
    @Nullable
    public static JSType parseSerializedOrJSDocType(@NotNull Project project, @Nullable String typeString, @NotNull JSTypeSource source) {
        if (project == null) {
            JSTypeParser.$$$reportNull$$$0(0);
        }
        if (source == null) {
            JSTypeParser.$$$reportNull$$$0(1);
        }
        try {
            return JSTypeParser.createType(project, typeString, source);
        }
        catch (JSTypeSerializer.JSTypeDeserializationException e) {
            JSTypeParser.logTypeSerializationError(typeString, e);
            return JSAnyType.get(source);
        }
    }

    @Nullable
    public static JSType createType(@NotNull Project project, @Nullable String typeString, @NotNull JSTypeSource source) {
        if (project == null) {
            JSTypeParser.$$$reportNull$$$0(2);
        }
        if (source == null) {
            JSTypeParser.$$$reportNull$$$0(3);
        }
        return JSTypeParser.createType(project, typeString, source, false);
    }

    @Nullable
    public static JSType createType(@NotNull Project project, @Nullable String typeString, @NotNull JSTypeSource source, boolean allowCommentAfterType) {
        if (project == null) {
            JSTypeParser.$$$reportNull$$$0(4);
        }
        if (source == null) {
            JSTypeParser.$$$reportNull$$$0(5);
        }
        if (StringUtil.isEmpty((String)typeString)) {
            return null;
        }
        JSTypeParser parser2 = new JSTypeParser(project, typeString, source);
        return parser2.parse(allowCommentAfterType);
    }

    @Nullable
    public static JSType createTypeFromJSDoc(@NotNull Project project, @Nullable String typeString, @NotNull JSTypeSource source) {
        if (project == null) {
            JSTypeParser.$$$reportNull$$$0(6);
        }
        if (source == null) {
            JSTypeParser.$$$reportNull$$$0(7);
        }
        if (StringUtil.isEmpty((String)typeString)) {
            return null;
        }
        JSTypeParser parser2 = new JSTypeParser(project, typeString, source, true);
        return parser2.parse(false);
    }

    @Contract(value="_,null, _ -> null; _,!null, _ -> !null")
    @Nullable
    public static JSType parseSerializedType(@NotNull Project project, @Nullable String typeString, @NotNull JSTypeSource source) {
        if (project == null) {
            JSTypeParser.$$$reportNull$$$0(8);
        }
        if (source == null) {
            JSTypeParser.$$$reportNull$$$0(9);
        }
        JSTypeParser.logIfNotSerialized(typeString);
        return JSTypeParser.parseSerializedOrJSDocType(project, typeString, source);
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static JSType parseSerializedType(@Nullable String typeString, @NotNull JSTypeSource source) {
        if (source == null) {
            JSTypeParser.$$$reportNull$$$0(10);
        }
        JSTypeParser.logIfNotSerialized(typeString);
        return JSTypeParser.createType(typeString, source, false);
    }

    private static void logIfNotSerialized(@Nullable String typeString) {
        if (typeString != null && typeString.length() > 0 && typeString.charAt(0) != '\u001d') {
            JSTypeParser.logTypeSerializationError(typeString, null);
        }
    }

    private static void logTypeSerializationError(@Nullable String typeString, @Nullable Exception e) {
        Logger.getInstance(JSTypeParser.class).error("Expected serialized type", (Throwable)e, new Attachment[]{new Attachment("type", StringUtil.escapeStringCharacters((String)StringUtil.notNullize((String)typeString)))});
    }

    @Nullable
    public static JSType createType(@Nullable String typeString, @NotNull JSTypeSource source) {
        if (source == null) {
            JSTypeParser.$$$reportNull$$$0(11);
        }
        return JSTypeParser.createType(typeString, source, false);
    }

    @Nullable
    private static JSType createType(@Nullable String typeString, @NotNull JSTypeSource source, boolean allowCommentAfterType) {
        if (source == null) {
            JSTypeParser.$$$reportNull$$$0(12);
        }
        if (StringUtil.isEmpty((String)typeString)) {
            return null;
        }
        JSTypeParser parser2 = new JSTypeParser(source.getProject(), typeString, source, null, false);
        return parser2.parse(allowCommentAfterType);
    }

    @Nullable
    public static JSParameterTypeDecorator createParameterType(@NotNull Project project, @Nullable String typeString, @NotNull JSTypeSource source) {
        if (project == null) {
            JSTypeParser.$$$reportNull$$$0(13);
        }
        if (source == null) {
            JSTypeParser.$$$reportNull$$$0(14);
        }
        return JSTypeParser.createParameterType(project, typeString, source, false, false);
    }

    @Nullable
    public static JSParameterTypeDecorator createParameterType(@NotNull Project project, @Nullable String typeString, @NotNull JSTypeSource source, boolean allowCommentAfterType, boolean isFromJSDoc) {
        if (project == null) {
            JSTypeParser.$$$reportNull$$$0(15);
        }
        if (source == null) {
            JSTypeParser.$$$reportNull$$$0(16);
        }
        if (StringUtil.isEmpty((String)typeString)) {
            return null;
        }
        JSTypeParser parser2 = new JSTypeParser(project, typeString, source, isFromJSDoc);
        return parser2.parseParameterType(allowCommentAfterType);
    }

    public JSTypeParser(@NotNull Project project, @NotNull String typeString, @NotNull JSTypeSource source) {
        if (project == null) {
            JSTypeParser.$$$reportNull$$$0(17);
        }
        if (typeString == null) {
            JSTypeParser.$$$reportNull$$$0(18);
        }
        if (source == null) {
            JSTypeParser.$$$reportNull$$$0(19);
        }
        this(project, typeString, source, null, false);
    }

    public JSTypeParser(@NotNull Project project, @NotNull String typeString, @NotNull JSTypeSource source, boolean isFromJSDoc) {
        if (project == null) {
            JSTypeParser.$$$reportNull$$$0(20);
        }
        if (typeString == null) {
            JSTypeParser.$$$reportNull$$$0(21);
        }
        if (source == null) {
            JSTypeParser.$$$reportNull$$$0(22);
        }
        this(project, typeString, source, null, isFromJSDoc);
    }

    public JSTypeParser(@NotNull Project project, @NotNull String typeString, JSTypeVisitor visitor) {
        if (project == null) {
            JSTypeParser.$$$reportNull$$$0(23);
        }
        if (typeString == null) {
            JSTypeParser.$$$reportNull$$$0(24);
        }
        this(project, typeString, JSTypeSource.EMPTY, visitor, true);
    }

    public JSTypeParser(@Nullable Project project, @NotNull String typeString, @NotNull JSTypeSource typeSource, @Nullable JSTypeVisitor visitor, boolean isFromJSDoc) {
        if (typeString == null) {
            JSTypeParser.$$$reportNull$$$0(25);
        }
        if (typeSource == null) {
            JSTypeParser.$$$reportNull$$$0(26);
        }
        this.myVisitingInfos = new SmartList();
        this.myTypeString = typeString;
        this.myIsFromJSDoc = isFromJSDoc;
        this.mySource = typeSource;
        this.myVisitor = visitor;
        this.myCurrentOffset = 0;
        this.myProject = project;
    }

    @Nullable
    public JSType parse() {
        return this.parse(false);
    }

    @Nullable
    public JSParameterTypeDecorator parseParameterType() {
        return this.parseParameterType(false);
    }

    @Nullable
    public JSType parse(boolean allowCommentAfterType) {
        return this.handleParseResult(this.parseAsPsiType(), allowCommentAfterType);
    }

    @Nullable
    public JSParameterTypeDecorator parseParameterType(boolean allowCommentAfterType) {
        return this.handleParseResult(this.parseAsPsiJSDocParameter(), allowCommentAfterType);
    }

    @Nullable
    private JSType parseAsPsiType() {
        if (this.myProject == null) {
            return this.parseComposite(true);
        }
        if (!this.myIsFromJSDoc && this.getSymbol() == '\u001d') {
            return this.deserialize();
        }
        PsiElement psi = this.createTypeOrJSDocFunctionParameterPsi(false);
        if (!(psi instanceof JSTypeDeclaration)) {
            return null;
        }
        JSType jsType = ((JSTypeDeclaration)psi).calculateType();
        return this.prepareParsedType(jsType);
    }

    @Nullable
    private JSParameterTypeDecorator parseAsPsiJSDocParameter() {
        if (this.myProject == null) {
            return this.parseInnerParameterType(true);
        }
        PsiElement psi = this.createTypeOrJSDocFunctionParameterPsi(true);
        if (!(psi instanceof JSDocFunctionTypeParameter)) {
            return null;
        }
        JSDocFunctionTypeParameter parameter = (JSDocFunctionTypeParameter)psi;
        JSParameterTypeDecorator decorator = parameter.getTypeDecorator();
        JSType jsType = decorator.getSimpleType();
        JSType newJSType = this.prepareParsedType(jsType);
        return new JSParameterTypeDecoratorImpl(newJSType, decorator.isOptional(), decorator.isRest(), this.mySource.isStrict());
    }

    @Nullable
    private JSType prepareParsedType(@Nullable JSType jsType) {
        if (this.mySource.getLanguage() == JSTypeSource.SourceLanguage.AS && jsType != null) {
            jsType = jsType.transformTypeHierarchy((Function<? super JSType, ? extends JSType>)((Function)t -> {
                JSType jSType;
                if (t instanceof JSTypeImpl) {
                    JSTypeImpl typeImpl = (JSTypeImpl)t;
                    jSType = JSNamedTypeFactory.createType(typeImpl.getTypeText(), this.mySource, typeImpl.getTypeContext());
                } else {
                    jSType = t;
                }
                return jSType;
            }));
        }
        this.fillVisitInfos(jsType);
        return JSTypeBaseImpl.replaceSourceRecursive(jsType, this.mySource);
    }

    private void fillVisitInfos(JSType jsType) {
        if (this.myVisitor == null || jsType == null) {
            return;
        }
        jsType.accept(new JSRecursiveTypeVisitor(JSRecursiveTypeVisitor.Checks.DISABLED){

            @Override
            public void visitJSType(@NotNull JSType type2) {
                PsiElement element;
                if (type2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (type2 instanceof JSNamespace && !(type2 instanceof JSLiteralType) && (element = type2.getSourceElement()) instanceof TypeScriptType) {
                    PsiElement prev;
                    PsiElement lastChild;
                    PsiElement next;
                    PsiElement firstChild = element.getFirstChild();
                    if (((JSNamespace)type2).getTypeContext() == JSTypeContext.STATIC && firstChild.getNode().getElementType() == JSTokenTypes.TYPEOF_KEYWORD && (next = PsiTreeUtil.skipWhitespacesForward((PsiElement)firstChild)) != null) {
                        firstChild = next;
                    }
                    if ((lastChild = element.getLastChild()) instanceof TypeScriptTypeArgumentList && (prev = PsiTreeUtil.skipWhitespacesBackward((PsiElement)lastChild)) != null) {
                        lastChild = prev;
                    }
                    String text2 = element.getText().substring(firstChild.getStartOffsetInParent(), lastChild.getStartOffsetInParent() + lastChild.getTextLength());
                    JSTypeParser.this.myVisitingInfos.add(new SingleTypeInfo(firstChild.getNode().getStartOffset(), type2, text2));
                }
                super.visitJSType(type2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/types/JSTypeParser$1", "visitJSType"));
            }
        });
    }

    @Nullable
    private PsiElement createTypeOrJSDocFunctionParameterPsi(boolean jsdocFunctionParameter) {
        if (this.myProject == null) {
            return null;
        }
        PsiManager instance = PsiManager.getInstance((Project)this.myProject);
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)JavaScriptSupportLoader.TYPESCRIPT);
        PsiBuilder builder2 = PsiBuilderFactory.getInstance().createBuilder(parserDefinition, (Lexer)new JSFlexAdapter(TypeScriptLanguageDialect.DIALECT_OPTION_HOLDER, false, true), (CharSequence)this.myTypeString);
        JSDocTypeParser parser2 = new JSDocTypeParser(builder2);
        PsiBuilder.Marker mark = builder2.mark();
        TypeScriptPsiTypeParser typeParser = (TypeScriptPsiTypeParser)parser2.getTypeParser();
        if (jsdocFunctionParameter) {
            typeParser.parseJSDocFunctionTypeParameter();
        } else {
            typeParser.parseType();
        }
        if (!builder2.eof()) {
            this.myCurrentOffset = builder2.getCurrentOffset();
            while (!builder2.eof()) {
                builder2.advanceLexer();
            }
        } else {
            this.myCurrentOffset = this.myTypeString.length();
        }
        mark.done(JSStubElementTypes.EMBEDDED_EXPRESSION);
        ASTNode parent = builder2.getTreeBuilt();
        if (!(parent instanceof TreeElement)) {
            return null;
        }
        ASTNode toReturn = parent.getFirstChildNode();
        if (toReturn == null) {
            return null;
        }
        while (toReturn != null && toReturn.getElementType() == JSTokenTypes.WHITE_SPACE) {
            toReturn = toReturn.getTreeNext();
        }
        if (!(toReturn instanceof TreeElement)) {
            return null;
        }
        new DummyHolder(instance, (TreeElement)parent, null, null, null, (Language)JavaScriptSupportLoader.TYPESCRIPT);
        PsiElement psi = toReturn.getPsi();
        return PsiTreeUtil.hasErrorElements((PsiElement)psi) ? null : psi;
    }

    @Nullable
    public JSType parseNamepath() {
        return this.handleParseResult(this.parseSingleType(true), false);
    }

    private <T> T handleParseResult(T result2, boolean allowCommentAfterType) {
        if (!allowCommentAfterType && this.myCurrentOffset != this.myTypeString.length()) {
            if (this.myVisitor != null) {
                this.myVisitingInfos.clear();
            }
            return null;
        }
        if (this.myVisitor != null) {
            if (result2 != null) {
                for (SingleTypeInfo info2 : this.myVisitingInfos) {
                    this.myVisitor.visitSingleType(info2.offset, info2.type, info2.name);
                }
            } else {
                this.myVisitingInfos.clear();
            }
        }
        return result2;
    }

    public int getTypeStringLength() {
        return this.myCurrentOffset;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private JSParameterTypeDecorator parseInnerParameterType(boolean allowComma) {
        JSType type2;
        this.advanceSpaces();
        boolean rest = false;
        if (this.startsWith("...")) {
            char afterDotsChar;
            rest = true;
            this.advanceBy("...".length());
            this.advanceSpaces();
            if (!this.hasSymbol() || (afterDotsChar = this.getSymbol()) == ',' || afterDotsChar == ')' || afterDotsChar == '}') {
                type2 = JSAnyType.get(this.mySource);
            } else {
                boolean parseBrackets;
                boolean bl = parseBrackets = this.myParsingFunction && this.checkCurrentSymbol('[');
                if (parseBrackets) {
                    this.advance();
                }
                type2 = this.parseComposite(false);
                if (parseBrackets) {
                    if (!this.checkCurrentSymbol(']')) return null;
                    this.advance();
                }
            }
        } else {
            type2 = this.parseComposite(allowComma);
        }
        this.advanceSpaces();
        boolean optional = false;
        if (this.hasSymbol()) {
            char symbol = this.getSymbol();
            if (symbol == '?' || symbol == '=') {
                optional = true;
                this.advance();
                this.advanceSpaces();
                while (this.hasSymbol() && (this.getSymbol() == '\"' || StringUtil.isJavaIdentifierPart((char)this.getSymbol()))) {
                    this.advance();
                }
            } else if (symbol == ',') {
                int beforeCommaOffset = this.myCurrentOffset;
                this.advance();
                this.advanceSpaces();
                if (this.startsWith("optional")) {
                    this.advanceBy("optional".length());
                    optional = true;
                } else {
                    this.myCurrentOffset = beforeCommaOffset;
                }
            }
        }
        this.advanceSpaces();
        if (type2 == null && !optional) {
            if (!rest) return null;
        }
        JSParameterTypeDecoratorImpl jSParameterTypeDecoratorImpl = new JSParameterTypeDecoratorImpl(type2, optional, rest, this.mySource.isStrict());
        return jSParameterTypeDecoratorImpl;
    }

    private JSType parseComposite(boolean allowComma) {
        return this.parseComposite(allowComma, "|/", true);
    }

    @Nullable
    private JSType parseComposite(boolean allowComma, @NotNull String delimiters, boolean isUnion) {
        if (delimiters == null) {
            JSTypeParser.$$$reportNull$$$0(27);
        }
        this.advanceSpaces();
        if (!this.hasSymbol()) {
            return null;
        }
        JSType type2 = this.parseTypeFromComposite(isUnion);
        this.advanceSpaces();
        ArrayList<JSType> addedUnionOptions = null;
        while (this.hasSymbol() && (delimiters.indexOf(this.getSymbol()) != -1 || allowComma && ',' == this.getSymbol())) {
            JSType unionOption;
            int commaOffset = ',' != this.getSymbol() ? -1 : this.myCurrentOffset;
            this.advance();
            if (addedUnionOptions == null) {
                addedUnionOptions = new ArrayList<JSType>();
            }
            if ((unionOption = this.parseTypeFromComposite(isUnion)) == null) continue;
            this.advanceSpaces();
            if (commaOffset >= 0 && unionOption instanceof JSTypeImpl && "optional".equals(unionOption.getTypeText(JSType.TypeTextFormat.SIMPLE))) {
                this.myCurrentOffset = commaOffset;
                break;
            }
            addedUnionOptions.add(unionOption);
        }
        if (addedUnionOptions != null && !addedUnionOptions.isEmpty()) {
            if (type2 != null) {
                addedUnionOptions.add(0, type2);
            }
            type2 = isUnion ? JSCompositeTypeFactory.createUnionType(this.mySource, (Collection<? extends JSType>)addedUnionOptions) : JSCompositeTypeFactory.createIntersectionType((Collection<? extends JSType>)addedUnionOptions, this.mySource);
        }
        return type2;
    }

    private JSType parseTypeFromComposite(boolean isUnion) {
        if (isUnion) {
            return this.parseComposite(false, "&", false);
        }
        return this.parseType();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private JSType parseType() {
        void var1_13;
        boolean decorationsAdded;
        this.advanceSpaces();
        if (!this.hasSymbol()) {
            return null;
        }
        if (!this.myIsFromJSDoc && this.getSymbol() == '\u001d') {
            return this.deserialize();
        }
        char c2 = this.getSymbol();
        if (c2 == '{') {
            JSRecordType jSRecordType = this.parseRecordType();
            if (jSRecordType == null) {
                return null;
            }
        } else if (c2 == '(') {
            this.advance();
            JSType jSType = this.parseComposite(true);
            this.advanceSpaces();
            if (!this.hasSymbol() || this.getSymbol() != ')') return null;
            this.advance();
        } else if (c2 == '[') {
            this.advance();
            JSType jSType = this.parseComposite(true);
            this.advanceSpaces();
            if (!this.hasSymbol() || this.getSymbol() != ']') {
                return null;
            }
            this.advance();
            JSArrayTypeImpl jSArrayTypeImpl = new JSArrayTypeImpl(jSType, this.mySource);
        } else if (c2 == 'f' && this.startsWith("function")) {
            int funcStartOffset = this.myCurrentOffset;
            this.advanceBy("function".length());
            this.advanceSpaces();
            if (this.hasSymbol() && (this.getSymbol() == ':' || this.getSymbol() == '(')) {
                Pair<@NotNull JSFunctionTypeImpl, @Nullable JSType> functionTypes = this.parseFunctionAfterKeyword();
                if (functionTypes != null && functionTypes.second != null) {
                    ArrayList<JSRecordType.TypeMember> members = new ArrayList<JSRecordType.TypeMember>(2);
                    this.addMembersFromFunctionParsingResult(functionTypes, members);
                    JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(this.mySource, members);
                } else {
                    JSType jSType = functionTypes != null ? (JSType)functionTypes.first : null;
                }
            } else {
                this.myCurrentOffset = funcStartOffset;
                JSType jSType = this.parseSingleType(false);
            }
        } else if (JSTypeParser.isQuote(c2)) {
            JSStringLiteralTypeImpl jSStringLiteralTypeImpl = this.parseStringLiteralType();
        } else {
            JSType jSType = this.parseSingleType(false);
        }
        do {
            this.advanceSpaces();
            decorationsAdded = true;
            if (this.startsWith("[]")) {
                JSArrayTypeImpl jSArrayTypeImpl = new JSArrayTypeImpl((JSType)var1_13, this.mySource);
                this.advanceBy("[]".length());
                continue;
            }
            if (this.checkCurrentSymbol('!')) {
                JSType jSType = this.addTypeDecoration((JSType)var1_13, JSDecoratedType.TypeDecoration.JSDOC_NOTNULL);
                this.advance();
                continue;
            }
            if (this.checkCurrentSymbol('<')) {
                this.advance();
                while (this.hasSymbol() && this.getSymbol() != '>') {
                    int typeStart = this.myCurrentOffset;
                    JSType jSType = this.addGenericArgument((JSType)var1_13, this.parseComposite(false));
                    this.advanceSpaces();
                    if (this.checkCurrentSymbol(',')) {
                        this.advance();
                        this.advanceSpaces();
                    }
                    if (typeStart != this.myCurrentOffset) continue;
                    return null;
                }
                if (!this.hasSymbol()) {
                    return null;
                }
                this.advance();
                continue;
            }
            if (this.checkCurrentSymbol('.')) {
                this.advance();
                continue;
            }
            decorationsAdded = false;
        } while (decorationsAdded);
        return var1_13;
    }

    @Nullable
    private JSType deserialize() {
        String string = this.myTypeString;
        StringCharacterIterator inputStream = new StringCharacterIterator(string, this.myCurrentOffset);
        try {
            JSType read = JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.read(this.mySource, inputStream);
            this.myCurrentOffset = inputStream.getIndex();
            return read;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            Logger.getInstance(JSTypeUtils.class).error("Can't deserialize type", (Throwable)e, new Attachment[]{new Attachment("type", StringUtil.escapeStringCharacters((String)string))});
            return null;
        }
    }

    private void addMembersFromFunctionParsingResult(@NotNull @NotNull Pair<@NotNull JSFunctionTypeImpl, @Nullable JSType> functionTypes, List<JSRecordType.TypeMember> members) {
        if (functionTypes == null) {
            JSTypeParser.$$$reportNull$$$0(28);
        }
        if (((JSFunctionTypeImpl)functionTypes.first).getReturnType() != null) {
            members.add(new CallSignatureImpl(false, (JSFunctionType)functionTypes.first));
        }
        if (functionTypes.second != null) {
            JSFunctionTypeImpl newType2 = new JSFunctionTypeImpl(this.mySource, ((JSFunctionTypeImpl)functionTypes.first).getParameters(), (JSType)functionTypes.second, ((JSFunctionTypeImpl)functionTypes.first).getThisType());
            members.add(new CallSignatureImpl(true, newType2));
        }
    }

    private JSRecordType parseRecordType() {
        ArrayList<JSRecordType.TypeMember> typeMembers = new ArrayList<JSRecordType.TypeMember>();
        this.advance();
        this.advanceSpaces();
        while (this.hasSymbol() && this.getSymbol() != '}') {
            int labelStart = this.myCurrentOffset;
            if (this.checkCurrentSymbol('(')) {
                Pair<JSFunctionTypeImpl, JSType> functionTypes = this.parseFunctionAfterKeyword();
                if (functionTypes != null) {
                    this.addMembersFromFunctionParsingResult(functionTypes, typeMembers);
                }
            } else {
                boolean optional = false;
                char startSymbol = this.getSymbol();
                boolean isSymbol = startSymbol == '[' && this.startsWith("[Symbol.");
                boolean isQuoted = JSTypeParser.isQuote(startSymbol);
                if (!isSymbol && !isQuoted && startSymbol == '[') {
                    optional = true;
                    this.advance();
                    this.advanceSpaces();
                }
                labelStart = this.myCurrentOffset;
                if (isSymbol || isQuoted) {
                    this.advance();
                }
                while (this.hasSymbol() && (StringUtil.isJavaIdentifierPart((char)this.getSymbol()) || '.' == this.getSymbol() || isQuoted && this.getSymbol() != startSymbol)) {
                    this.advance();
                }
                if (isSymbol && this.checkCurrentSymbol(']')) {
                    this.advance();
                }
                if (isQuoted && this.checkCurrentSymbol(startSymbol)) {
                    this.advance();
                }
                String recordLabel = this.myTypeString.substring(labelStart, this.myCurrentOffset);
                if (isQuoted) {
                    recordLabel = JSStringUtil.unquoteAndUnescapeString(recordLabel);
                }
                this.advanceSpaces();
                if (optional && this.checkCurrentSymbol(']')) {
                    this.advance();
                    this.advanceSpaces();
                }
                if (!optional && !isQuoted && "new".equals(recordLabel) && this.checkCurrentSymbol('(')) {
                    Pair<JSFunctionTypeImpl, JSType> functionTypes = this.parseFunctionAfterKeyword();
                    if (functionTypes != null) {
                        typeMembers.add(new CallSignatureImpl(true, (JSFunctionType)functionTypes.first));
                    }
                } else {
                    JSParameterItem recordPropertyType = null;
                    if (this.checkCurrentSymbol('?')) {
                        optional = true;
                        this.advance();
                        this.advanceSpaces();
                    }
                    if (this.checkCurrentSymbol(':')) {
                        this.advance();
                        this.advanceSpaces();
                        recordPropertyType = this.parseInnerParameterType(false);
                        this.advanceSpaces();
                    }
                    JSType type2 = recordPropertyType != null ? recordPropertyType.getSimpleType() : null;
                    typeMembers.add(new PropertySignatureImpl(recordLabel, type2, optional |= recordPropertyType != null && recordPropertyType.isOptional(), false));
                }
            }
            if (this.hasSymbol() && this.getSymbol() == ',') {
                this.advance();
                this.advanceSpaces();
            }
            if (labelStart != this.myCurrentOffset) continue;
            break;
        }
        if (!this.hasSymbol() || this.getSymbol() != '}') {
            return null;
        }
        this.advance();
        return new JSRecordTypeImpl(this.mySource, typeMembers);
    }

    @Nullable
    private JSStringLiteralTypeImpl parseStringLiteralType() {
        String literalValue = this.parseStringLiteral();
        return literalValue == null ? null : new JSStringLiteralTypeImpl(literalValue, false, this.mySource);
    }

    @Nullable
    private String parseStringLiteral() {
        char quote = this.getSymbol();
        this.advance();
        int literalStart = this.myCurrentOffset;
        boolean screened = false;
        while (this.hasSymbol()) {
            char c2 = this.getSymbol();
            if (c2 == '\\') {
                screened = !screened;
            } else if (!screened && c2 == quote) {
                this.advance();
                return this.myTypeString.substring(literalStart, this.myCurrentOffset - 1);
            }
            this.advance();
        }
        return null;
    }

    @Nullable
    private JSType addTypeDecoration(@Nullable JSType type2, JSDecoratedType.TypeDecoration decoration) {
        JSDecoratedTypeImpl decoratedType;
        if (type2 == null) {
            return null;
        }
        if (type2 instanceof JSDecoratedTypeImpl) {
            EnumSet<JSDecoratedType.TypeDecoration> decorations = EnumSet.copyOf(((JSDecoratedTypeImpl)type2).getDecorations());
            decorations.add(decoration);
            decoratedType = new JSDecoratedTypeImpl(this.mySource, ((JSDecoratedTypeImpl)type2).getType(), decorations);
        } else {
            decoratedType = new JSDecoratedTypeImpl(this.mySource, type2, EnumSet.of(decoration));
        }
        return decoratedType;
    }

    @Nullable
    private JSType addGenericArgument(JSType type2, JSType genericArgument) {
        if (type2 == null || genericArgument == null) {
            return null;
        }
        if (type2 instanceof JSGenericTypeImpl) {
            List<JSType> arguments = ((JSGenericTypeImpl)type2).getArguments();
            ArrayList<JSType> newArgs = new ArrayList<JSType>(arguments);
            newArgs.add(genericArgument);
            return new JSGenericTypeImpl(type2.getSource(), ((JSGenericTypeImpl)type2).getType(), newArgs);
        }
        return new JSGenericTypeImpl(this.mySource, type2, genericArgument);
    }

    @Nullable
    private @Nullable Pair<@NotNull JSFunctionTypeImpl, @Nullable JSType> parseFunctionAfterKeyword() {
        SmartList decorators = new SmartList();
        JSType newType2 = null;
        JSType thisType = null;
        this.myParsingFunction = true;
        if (this.checkCurrentSymbol('(')) {
            this.advance();
            this.advanceSpaces();
            while (this.hasSymbol() && this.getSymbol() != ')') {
                JSType paramType;
                int paramStart = this.myCurrentOffset;
                while (this.hasSymbol() && StringUtil.isJavaIdentifierPart((char)this.getSymbol())) {
                    this.advance();
                }
                int identifierEnd = this.myCurrentOffset;
                this.advanceSpaces();
                String recordLabel = null;
                if (this.checkCurrentSymbol(':')) {
                    this.advance();
                    recordLabel = this.myTypeString.substring(paramStart, identifierEnd);
                } else {
                    this.myCurrentOffset = paramStart;
                }
                JSParameterTypeDecorator paramTypeDecorator = this.parseInnerParameterType(false);
                JSType jSType = paramType = paramTypeDecorator != null ? paramTypeDecorator.getSimpleType() : null;
                if ("this".equals(recordLabel)) {
                    thisType = paramType;
                } else if ("new".equals(recordLabel)) {
                    newType2 = paramType;
                } else {
                    boolean optional = paramTypeDecorator != null && paramTypeDecorator.isOptional();
                    boolean rest = paramTypeDecorator != null && paramTypeDecorator.isRest();
                    JSParameterTypeDecoratorImpl decorator = new JSParameterTypeDecoratorImpl(recordLabel, paramType, optional, rest, true);
                    decorators.add(decorator);
                }
                this.advanceSpaces();
                if (this.checkCurrentSymbol(',')) {
                    this.advance();
                    this.advanceSpaces();
                }
                if (this.myCurrentOffset != paramStart) continue;
                return null;
            }
            if (!this.hasSymbol()) {
                return null;
            }
            this.advance();
        }
        this.advanceSpaces();
        JSType returnType = null;
        if (this.checkCurrentSymbol(':')) {
            this.advance();
            returnType = this.parseType();
        }
        return Pair.create((Object)new JSFunctionTypeImpl(this.mySource, (List<? extends JSParameterTypeDecorator>)decorators, returnType, thisType), newType2);
    }

    @Nullable
    private JSType parseSingleType(boolean isNamepathOnly) {
        char c2;
        this.advanceSpaces();
        char c3 = c2 = this.hasSymbol() ? this.getSymbol() : (char)'\u0000';
        if (c2 == '?') {
            this.advance();
            this.advanceSpaces();
            int afterQuestOffset = this.myCurrentOffset;
            JSType type2 = this.parseType();
            return type2 == null && afterQuestOffset == this.myCurrentOffset ? JSNamedTypeFactory.createType("unknown", this.mySource, JSTypeContext.UNKNOWN) : this.addTypeDecoration(type2, JSDecoratedType.TypeDecoration.JSDOC_NULLABLE);
        }
        if (c2 == '!') {
            this.advance();
            JSType type3 = this.parseType();
            return this.addTypeDecoration(type3, JSDecoratedType.TypeDecoration.JSDOC_NOTNULL);
        }
        if (c2 == '*') {
            this.advance();
            return JSAnyType.get(this.mySource);
        }
        int typeTextStartOffset = this.myCurrentOffset;
        JSContext jsContext = JSContext.INSTANCE;
        if (c2 == 't' && this.startsWith("typeof ")) {
            this.advanceBy("typeof".length());
            this.advanceSpaces();
            if (this.hasSymbol() && this.getSymbol() == 'i' && this.startsWith("import(")) {
                return this.parseImportType(typeTextStartOffset);
            }
            if (this.hasSymbol() && StringUtil.isJavaIdentifierPart((char)this.getSymbol())) {
                jsContext = JSContext.STATIC;
                typeTextStartOffset = this.myCurrentOffset;
            } else {
                this.myCurrentOffset = typeTextStartOffset;
            }
        } else if (c2 == 'i' && this.startsWith("import(")) {
            return this.parseImportType(typeTextStartOffset);
        }
        Matcher matcher = (isNamepathOnly ? JSDocumentationUtils.NAMEPATH_PATTERN : JSDocumentationUtils.NAMEPATH_IN_TYPE_PATTERN).matcher(this.myTypeString.substring(typeTextStartOffset));
        if (!matcher.lookingAt()) {
            return null;
        }
        int typeTextEndOffset = this.fixGenericArgumentPosition(typeTextStartOffset + matcher.end());
        return this.createTypeForOffsets(typeTextStartOffset, typeTextEndOffset, jsContext);
    }

    private int fixGenericArgumentPosition(int typeTextEndOffset) {
        if (typeTextEndOffset < this.myTypeString.length() && this.myTypeString.charAt(typeTextEndOffset) == '<' && typeTextEndOffset > 0 && this.myTypeString.charAt(typeTextEndOffset - 1) == '.') {
            --typeTextEndOffset;
        }
        return typeTextEndOffset;
    }

    @Nullable
    private JSType createTypeForOffsets(int typeTextStartOffset, int typeTextEndOffset, @NotNull JSContext jsContext) {
        if (jsContext == null) {
            JSTypeParser.$$$reportNull$$$0(29);
        }
        assert (typeTextEndOffset >= typeTextStartOffset);
        this.myCurrentOffset = typeTextEndOffset;
        if (typeTextEndOffset > typeTextStartOffset) {
            JSAnyType type2;
            boolean isTypeScript;
            String name = this.myTypeString.substring(typeTextStartOffset, typeTextEndOffset);
            if ("keyof".equals(name)) {
                return null;
            }
            if (name.charAt(name.length() - 1) == '.') {
                jsContext = JSContext.STATIC;
            }
            boolean bl = isTypeScript = this.mySource.getLanguage() == JSTypeSource.SourceLanguage.TS;
            JSType jSType = isTypeScript && "any".equals(name) ? JSAnyType.get(this.mySource) : (type2 = isTypeScript && "unknown".equals(name) ? JSUnknownType.TS_INSTANCE : JSNamedTypeFactory.createType(name, this.mySource, JSTypeContext.fromJSContext(jsContext), this.myIsFromJSDoc, this.myIsFromJSDoc));
            if (this.myVisitor != null) {
                this.myVisitingInfos.add(new SingleTypeInfo(typeTextStartOffset, type2, name));
            }
            return type2;
        }
        return null;
    }

    @Nullable
    private JSType parseImportType(int identifierStartOffset) {
        this.advanceBy("import(".length());
        while (this.hasSymbol() && this.getSymbol() != ')') {
            this.advance();
        }
        if (!this.checkCurrentSymbol(')')) {
            return null;
        }
        this.advance();
        int typeTextEndOffset = this.myCurrentOffset;
        if (this.checkCurrentSymbol('.') && !this.startsWith(".<")) {
            this.advance();
            int startNamespaceMatching = this.myCurrentOffset;
            Matcher matcher = JSDocumentationUtils.NAMEPATH_IN_TYPE_PATTERN.matcher(this.myTypeString.substring(this.myCurrentOffset));
            if (!matcher.lookingAt()) {
                return null;
            }
            typeTextEndOffset = startNamespaceMatching + matcher.end();
        }
        typeTextEndOffset = this.fixGenericArgumentPosition(typeTextEndOffset);
        return this.createTypeForOffsets(identifierStartOffset, typeTextEndOffset, JSContext.INSTANCE);
    }

    private static boolean isQuote(char c2) {
        return c2 == '\"' || c2 == '\'';
    }

    private char getSymbol() {
        return this.myTypeString.charAt(this.myCurrentOffset);
    }

    private boolean checkCurrentSymbol(char ch) {
        return this.hasSymbol() && this.getSymbol() == ch;
    }

    private void advance() {
        ++this.myCurrentOffset;
    }

    private void advanceBy(int count) {
        this.myCurrentOffset += count;
    }

    private boolean hasSymbol() {
        return this.myCurrentOffset < this.myTypeString.length();
    }

    private boolean startsWith(String prefix) {
        return this.myTypeString.startsWith(prefix, this.myCurrentOffset);
    }

    private void advanceSpaces() {
        while (this.myCurrentOffset < this.myTypeString.length() && StringUtil.isWhiteSpace((char)this.getSymbol())) {
            this.advance();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 18: 
            case 21: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeString";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delimiters";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionTypes";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "parseSerializedOrJSDocType";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "createType";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createTypeFromJSDoc";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "parseSerializedType";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "createParameterType";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "parseComposite";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "addMembersFromFunctionParsingResult";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "createTypeForOffsets";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class SingleTypeInfo {
        int offset;
        JSType type;
        String name;

        public SingleTypeInfo(int offset, JSType type2, String name) {
            this.offset = offset;
            this.type = type2;
            this.name = name;
        }
    }

    private static final class Chars {
        private static final char LPAREN = '(';
        private static final char RPAREN = ')';
        private static final char LBRACE = '{';
        private static final char RBRACE = '}';
        private static final char LBRACKET = '[';
        private static final char RBRACKET = ']';
        private static final char COMMA = ',';
        private static final char QUESTION = '?';
        private static final char EQ = '=';
        private static final char LT = '<';
        private static final char GT = '>';
        private static final char DOT = '.';
        private static final char EXCLAMATION = '!';
        private static final char COLON = ':';

        private Chars() {
        }
    }
}

