/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptServiceResolveFacade;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSIndexBasedResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeInfo;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.WalkUpResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.statistics.JSResolveStatisticsCollector;
import com.intellij.lang.typescript.TypeScriptResolveHelper;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSReferenceExpressionResolver
implements ResolveCache.PolyVariantResolver<JSReferenceExpressionImpl> {
    private static final Key<ParameterizedCachedValue<Map<String, ResolveResult[]>, PsiFile>> TOP_LEVEL_RESULTS_KEY = Key.create((String)"top.level.cached.results");
    private static final Key<ParameterizedCachedValue<Map<String, ResolveResult[]>, PsiFile>> TOP_LEVEL_RESULTS_WITH_IGNORE_PERF_LIMITS_KEY = Key.create((String)"top.level.cached.results.with.ignore.perf.limits");
    private static final Function<ResolveResult, PsiElement> RESOLVE_RESULT_TO_VALID_ELEMENT = el -> el.isValidResult() ? el.getElement() : null;
    public static final int MAX_RESULTS_COUNT_TO_KEEP = Integer.parseInt(System.getProperty("js.max.results.count.to.keep", "20"));
    private static final Logger LOG = Logger.getInstance(JSReferenceExpressionResolver.class);
    @NotNull
    protected final JSReferenceExpressionImpl myRef;
    protected final PsiElement myParent;
    @NotNull
    protected final PsiFile myContainingFile;
    @Nullable
    protected final String myReferencedName;
    protected final JSExpression myQualifier;
    protected final boolean myIgnorePerformanceLimits;
    protected final boolean myPrivateNameResolve;
    @Nullable
    private PsiFile myLimitingScopeFile;

    public JSReferenceExpressionResolver(@NotNull JSReferenceExpressionImpl expression, boolean ignorePerformanceLimits) {
        if (expression == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(0);
        }
        this.myRef = expression;
        this.myContainingFile = expression.getContainingFile();
        this.myReferencedName = this.adjustReferencedName(this.myRef);
        this.myParent = this.myRef.getParent();
        this.myQualifier = this.myRef.getQualifier();
        this.myIgnorePerformanceLimits = ignorePerformanceLimits;
        this.myPrivateNameResolve = JSUtils.isPrivateNameReference((PsiElement)this.myRef);
        this.myLimitingScopeFile = null;
    }

    public ResolveResult @NotNull [] resolve(@NotNull JSReferenceExpressionImpl expression, boolean incompleteCode) {
        ResolveResult[] resultsFromService;
        if (expression == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(1);
        }
        if (this.myReferencedName == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                JSReferenceExpressionResolver.$$$reportNull$$$0(2);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        PsiElement currentParent = JSResolveUtil.getTopReferenceParent(this.myParent);
        if (this.myPrivateNameResolve) {
            ResolveResult[] resolveResultArray = this.resolvePrivateNameReference();
            if (resolveResultArray == null) {
                JSReferenceExpressionResolver.$$$reportNull$$$0(3);
            }
            return resolveResultArray;
        }
        if (JSResolveUtil.isSelfReference(currentParent, (PsiElement)this.myRef)) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{new JSResolveResult(currentParent)};
            if (resolveResultArray == null) {
                JSReferenceExpressionResolver.$$$reportNull$$$0(4);
            }
            return resolveResultArray;
        }
        ResolveResult[] resultsFromProviders = this.resolveFromProviders();
        if (resultsFromProviders != null) {
            if (resultsFromProviders == null) {
                JSReferenceExpressionResolver.$$$reportNull$$$0(5);
            }
            return resultsFromProviders;
        }
        QualifiedItemProcessor<ResolveResultSink> processor = JSDialectSpecificHandlersFactory.forElement((PsiElement)this.myRef).createResolveProcessor(this.myReferencedName, (PsiElement)this.myRef, incompleteCode);
        if (this.myQualifier == null || this.myQualifier instanceof JSSuperExpression) {
            processor.setToProcessHierarchy(true);
            JSReferenceExpressionImpl.doProcessLocalDeclarations((PsiElement)this.myRef, this.myQualifier, processor, false, false, null);
            PsiElement jsElement = processor.getResult();
            if (jsElement != null) {
                ResolveResult[] results = processor.getResultsAsResolveResults();
                if (jsElement instanceof JSImplicitElement && ((JSImplicitElement)jsElement).hasMinorImportance()) {
                    return this.mergeIncompleteLocalResolveWithGlobal(results, incompleteCode);
                }
                JSResolveStatisticsCollector.getInstance().consume((Object)JSResolveStatisticsCollector.ResolveSource.LOCAL, (Object)results.length);
                if (results == null) {
                    JSReferenceExpressionResolver.$$$reportNull$$$0(6);
                }
                return results;
            }
            if (this.myQualifier == null) {
                ResolveResult[] globalResults = this.resolveGlobalReference(incompleteCode);
                if (this.isDummyResolve(processor, globalResults)) {
                    ResolveResult[] resolveResultArray = this.dummyResult(this.myRef);
                    if (resolveResultArray == null) {
                        JSReferenceExpressionResolver.$$$reportNull$$$0(7);
                    }
                    return resolveResultArray;
                }
                if (globalResults == null) {
                    JSReferenceExpressionResolver.$$$reportNull$$$0(8);
                }
                return globalResults;
            }
        } else {
            processor.evaluateExpressionOrElementType((PsiElement)this.myQualifier, this.myContainingFile);
            ResolveResult[] results = processor.getResultsIfResolveCompleted();
            if (results != null) {
                JSResolveStatisticsCollector.getInstance().consume((Object)JSResolveStatisticsCollector.ResolveSource.QUALIFIED, (Object)results.length);
                if (results == null) {
                    JSReferenceExpressionResolver.$$$reportNull$$$0(9);
                }
                return results;
            }
        }
        if ((resultsFromService = TypeScriptServiceResolveFacade.resolve(this.myRef, this.myReferencedName, incompleteCode)) != null) {
            if (resultsFromService == null) {
                JSReferenceExpressionResolver.$$$reportNull$$$0(10);
            }
            return resultsFromService;
        }
        ResolveResult[] results = this.resolveFromIndices(processor, false, false);
        if (this.isDummyResolve(processor, results = TypeScriptPsiUtil.removeDuplicates(Arrays.asList(results), RESOLVE_RESULT_TO_VALID_ELEMENT, (PsiElement)this.myRef).toArray(ResolveResult.EMPTY_ARRAY))) {
            ResolveResult[] resolveResultArray = this.dummyResult(this.myRef);
            if (resolveResultArray == null) {
                JSReferenceExpressionResolver.$$$reportNull$$$0(11);
            }
            return resolveResultArray;
        }
        if (results == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(12);
        }
        return results;
    }

    protected ResolveResult[] resolvePrivateNameReference() {
        JSExpression expr;
        JSType qualifierType;
        JSClass classOfPrivateMember = JSResolveUtil.getClassOfContextForPrivateMemberReference(this.myRef);
        if (classOfPrivateMember == null) {
            return ResolveResult.EMPTY_ARRAY;
        }
        if (this.myQualifier instanceof JSThisExpression && (qualifierType = JSResolveUtil.getElementJSType((PsiElement)this.myQualifier)) != null && qualifierType.getSource().getSourceElement() == classOfPrivateMember) {
            return this.getResolveResultForPrivateClassMember(classOfPrivateMember);
        }
        JSType classOfPrivateMemberType = classOfPrivateMember.getJSType();
        boolean isPrivateBrandCheck = JSUtils.isPrivateBrandCheckReference(this.myRef);
        JSExpression jSExpression = expr = isPrivateBrandCheck ? JSUtils.getPrivateBrandCheckRhsByLhs(this.myRef) : this.myQualifier;
        if (expr == null) {
            return ResolveResult.EMPTY_ARRAY;
        }
        JSType exprType = (JSType)ObjectUtils.notNull((Object)JSResolveUtil.getElementJSType((PsiElement)expr), (Object)JSAnyType.get(JSTypeSource.EMPTY));
        ProcessingContext ctx = JSTypeComparingContextService.createProcessingContextWithCache((PsiElement)this.myRef);
        return JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)this.myRef, () -> {
            if (classOfPrivateMemberType.isDirectlyAssignableType(exprType, ctx) || isPrivateBrandCheck && exprType.isDirectlyAssignableType(classOfPrivateMemberType, ctx)) {
                return this.getResolveResultForPrivateClassMember(classOfPrivateMember);
            }
            return ResolveResult.EMPTY_ARRAY;
        });
    }

    protected ResolveResult[] getResolveResultForPrivateClassMember(@Nullable JSClass classOfPrivateMember) {
        if (this.myReferencedName == null) {
            LOG.error("myReferencedName is null");
            return ResolveResult.EMPTY_ARRAY;
        }
        if (classOfPrivateMember == null) {
            return ResolveResult.EMPTY_ARRAY;
        }
        Collection<? extends JSElement> members = classOfPrivateMember.findPrivateMembersByName(this.myReferencedName);
        if (members.isEmpty()) {
            LOG.error(classOfPrivateMember.getName() + " does not contain " + this.myReferencedName);
            return ResolveResult.EMPTY_ARRAY;
        }
        return JSResolveResult.toResolveResults(members);
    }

    private boolean isDummyResolve(@NotNull SinkResolveProcessor<ResolveResultSink> localProcessor, ResolveResult @Nullable [] results) {
        if (localProcessor == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(13);
        }
        if (this.undefinedResolve(results)) {
            return true;
        }
        if (results != null && results.length != 0) {
            return false;
        }
        return localProcessor.isEncounteredXmlLiteral() || this.isGlobalThis();
    }

    protected boolean isGlobalThis() {
        return this.myQualifier == null && "globalThis".equals(this.myReferencedName);
    }

    private ResolveResult @NotNull [] mergeIncompleteLocalResolveWithGlobal(ResolveResult @NotNull [] localResults, boolean incompleteCode) {
        PsiElement resolve2;
        ResolveResult[] globalResults;
        if (localResults == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(14);
        }
        if ((globalResults = this.resolveGlobalReference(incompleteCode)).length == 0) {
            if (localResults == null) {
                JSReferenceExpressionResolver.$$$reportNull$$$0(15);
            }
            return localResults;
        }
        if (globalResults.length == 1 && (resolve2 = globalResults[0].getElement()) != null && JSResolveUtil.isSameReference(this.myRef, resolve2)) {
            if (localResults == null) {
                JSReferenceExpressionResolver.$$$reportNull$$$0(16);
            }
            return localResults;
        }
        if (globalResults == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(17);
        }
        return globalResults;
    }

    private ResolveResult @NotNull [] resolveGlobalReference(boolean incompleteCode) {
        ResolveResult[] results;
        Map<String, ResolveResult[]> cachedResultsMap = null;
        if (!(this.myParent instanceof JSDefinitionExpression) && TypeScriptSignatureChooser.getCallLikeExpression((PsiElement)this.myRef) == null && JSPsiImplUtils.getWithStatementContexts(this.myRef).isEmpty() && (cachedResultsMap = this.getCachedTopLevelResultsMap()) != null && (results = cachedResultsMap.get(this.myReferencedName)) != null) {
            if (results == null) {
                JSReferenceExpressionResolver.$$$reportNull$$$0(18);
            }
            return results;
        }
        results = this.doResolveGlobalReference(incompleteCode);
        if (cachedResultsMap != null) {
            cachedResultsMap.put(this.myReferencedName, results);
        }
        if (results == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(19);
        }
        return results;
    }

    private ResolveResult @NotNull [] doResolveGlobalReference(boolean incompleteCode) {
        assert (this.myReferencedName != null);
        QualifiedItemProcessor<ResolveResultSink> processor = JSReferenceExpressionResolver.processGlobalDeclarations(this.myReferencedName, (PsiElement)this.myRef, incompleteCode);
        ResolveResult[] results = this.resolveFromIndices(processor, true, false);
        if ((results = TypeScriptPsiUtil.removeDuplicates(Arrays.asList(results), RESOLVE_RESULT_TO_VALID_ELEMENT, (PsiElement)this.myRef).toArray(ResolveResult.EMPTY_ARRAY)) == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(20);
        }
        return results;
    }

    @NotNull
    private static QualifiedItemProcessor<ResolveResultSink> processGlobalDeclarations(@NotNull String referenceName, @NotNull PsiElement place, boolean incompleteCode) {
        if (referenceName == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(21);
        }
        if (place == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(22);
        }
        ResolveResultSink sink = new ResolveResultSink(place, referenceName, false, incompleteCode);
        QualifiedItemProcessor<ResolveResultSink> processor = JSDialectSpecificHandlersFactory.forElement(place).createQualifiedItemProcessor(sink, place);
        processor.setTypeContext(true);
        TypeScriptResolveHelper.processGlobalThings(processor, ResolveState.initial(), place);
        QualifiedItemProcessor<ResolveResultSink> qualifiedItemProcessor = processor;
        if (qualifiedItemProcessor == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(23);
        }
        return qualifiedItemProcessor;
    }

    public static ResolveResult @NotNull [] resolveGlobalReference(@NotNull String referenceName, @NotNull PsiElement place, boolean incompleteCode, boolean includeTypeOnlyContextSymbols) {
        if (referenceName == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(24);
        }
        if (place == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(25);
        }
        QualifiedItemProcessor<ResolveResultSink> processor = JSReferenceExpressionResolver.processGlobalDeclarations(referenceName, place, incompleteCode);
        ResolveResult[] processorResults = processor.getResultsAsResolveResults();
        GlobalSearchScope scope2 = TypeScriptClassResolver.excludeGlobalTypeScript(JSResolveUtil.getResolveScope(place));
        if (!JSIndexBasedResolveUtil.cheapEnoughToProcessByQName(scope2, JSClassResolver.IncludeLocalMembersOptions.ALL, place.getProject(), referenceName)) {
            if (processorResults == null) {
                JSReferenceExpressionResolver.$$$reportNull$$$0(26);
            }
            return processorResults;
        }
        PsiFile containingFile2 = place.getContainingFile();
        WalkUpResolveProcessor walkUpResolveProcessor = new WalkUpResolveProcessor(referenceName, containingFile2, (PsiElement)containingFile2){

            @Override
            @NotNull
            public JSTypeInfo.GlobalStatusHint initGlobalStatusHint(@Nullable PsiElement context2) {
                JSTypeInfo.GlobalStatusHint globalStatusHint = JSTypeInfo.GlobalStatusHint.GLOBAL;
                if (globalStatusHint == null) {
                    1.$$$reportNull$$$0(0);
                }
                return globalStatusHint;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSReferenceExpressionResolver$1", "initGlobalStatusHint"));
            }
        };
        walkUpResolveProcessor.addLocalResults(processor);
        JSIndexBasedResolveUtil.processAllSymbols(walkUpResolveProcessor, false, null, false, includeTypeOnlyContextSymbols);
        ResolveResult[] results = walkUpResolveProcessor.getResults();
        results = TypeScriptPsiUtil.removeDuplicates(Arrays.asList(results), RESOLVE_RESULT_TO_VALID_ELEMENT, place).toArray(ResolveResult.EMPTY_ARRAY);
        if (results == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(27);
        }
        return results;
    }

    protected ResolveResult @Nullable [] resolveFromProviders() {
        for (PsiReference reference : ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this.myRef)) {
            if (reference instanceof PsiPolyVariantReference) {
                ResolveResult[] results = ((PsiPolyVariantReference)reference).multiResolve(false);
                if (results.length <= 0) continue;
                return results;
            }
            PsiElement resolve2 = reference.resolve();
            if (resolve2 == null) continue;
            return new ResolveResult[]{new JSResolveResult(resolve2)};
        }
        return null;
    }

    protected ResolveResult[] resolveFromIndices(@NotNull SinkResolveProcessor<ResolveResultSink> localProcessor) {
        if (localProcessor == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(28);
        }
        return this.resolveFromIndices(localProcessor, false, true);
    }

    protected ResolveResult[] resolveFromIndices(@NotNull SinkResolveProcessor<ResolveResultSink> localProcessor, boolean excludeGlobalTypeScript, boolean includeTypeOnlyContextSymbols) {
        if (localProcessor == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(29);
        }
        assert (this.myReferencedName != null);
        WalkUpResolveProcessor processor = new WalkUpResolveProcessor(this.myReferencedName, this.myContainingFile, (PsiElement)this.myRef);
        excludeGlobalTypeScript &= processor.myTypeInfo.isGlobalContext();
        processor.addLocalResults(localProcessor);
        if (this.prepareProcessor(processor, localProcessor)) {
            JSResolveUtil.tryProcessXmlFileImplicitElements((PsiElement)this.myRef, processor);
            JSResolveUtil.tryProcessAllElementsInInjectedContext(this.myContainingFile, (Processor<? super JSPsiElementBase>)((Processor)element -> {
                if (this.myReferencedName.equals(element.getName())) {
                    processor.doQualifiedCheck((JSPsiElementBase)element);
                }
                return true;
            }));
            JSIndexBasedResolveUtil.processAllSymbols(processor, this.myIgnorePerformanceLimits, this.myLimitingScopeFile, excludeGlobalTypeScript, includeTypeOnlyContextSymbols);
        }
        ResolveResult[] results = this.getResultsFromProcessor(processor);
        JSResolveStatisticsCollector.getInstance().consume((Object)JSResolveStatisticsCollector.ResolveSource.SYMBOL, (Object)results.length);
        if (results.length == 0 && (this.myParent instanceof JSDefinitionExpression || JSDestructuringUtil.parentIsDestructuringAssignmentLHS(this.myRef))) {
            return this.getResultsForDefinition();
        }
        return this.myIgnorePerformanceLimits || results.length <= MAX_RESULTS_COUNT_TO_KEEP ? results : JSResolveResult.tooManyCandidatesResult();
    }

    protected ResolveResult[] getResultsFromProcessor(WalkUpResolveProcessor processor) {
        return processor.getResults();
    }

    public boolean undefinedResolve(ResolveResult[] resolveResults) {
        if ("undefined".equals(this.myReferencedName) && this.myQualifier == null) {
            if (resolveResults == null) {
                return true;
            }
            for (ResolveResult result2 : resolveResults) {
                if (!result2.isValidResult()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Nullable
    protected String adjustReferencedName(@NotNull JSReferenceExpression ref) {
        if (ref == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(30);
        }
        return ref.getReferenceName();
    }

    protected boolean prepareProcessor(WalkUpResolveProcessor processor, @NotNull SinkResolveProcessor<ResolveResultSink> localProcessor) {
        if (localProcessor == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(31);
        }
        boolean searchInIndexes = true;
        boolean inDefinition = this.myParent instanceof JSDefinitionExpression;
        if (processor.myContext instanceof JSReferenceExpression && inDefinition) {
            JSExpression qualifier = ((JSReferenceExpression)processor.myContext).getQualifier();
            if (qualifier == null) {
                processor.setSkipDefinitions(true);
            } else {
                JSType _qualifierType = JSResolveUtil.getExpressionJSType(qualifier);
                searchInIndexes = JSTypeUtils.isInstanceOrPrototype(_qualifierType);
            }
        }
        if (inDefinition) {
            processor.forceSetAddOnlyCompleteMatches();
        }
        return searchInIndexes;
    }

    protected ResolveResult[] getResultsForDefinition() {
        if (this.myQualifier == null && JSResolveUtil.isEcmaScript5((PsiElement)this.myRef)) {
            return ResolveResult.EMPTY_ARRAY;
        }
        return new ResolveResult[]{new JSResolveResult(this.myParent)};
    }

    protected ResolveResult[] dummyResult(JSReferenceExpression expression) {
        return new ResolveResult[]{new JSResolveResult((PsiElement)expression)};
    }

    @Nullable
    private Map<String, ResolveResult[]> getCachedTopLevelResultsMap() {
        if (this.myLimitingScopeFile != null) {
            return null;
        }
        Key<ParameterizedCachedValue<Map<String, ResolveResult[]>, PsiFile>> key2 = this.myIgnorePerformanceLimits ? TOP_LEVEL_RESULTS_WITH_IGNORE_PERF_LIMITS_KEY : TOP_LEVEL_RESULTS_KEY;
        return (Map)CachedValuesManager.getManager((Project)this.myContainingFile.getProject()).getParameterizedCachedValue((UserDataHolder)this.myContainingFile, key2, p -> new CachedValueProvider.Result(Collections.synchronizedMap(new HashMap()), new Object[]{p, PsiModificationTracker.MODIFICATION_COUNT}), false, (Object)this.myContainingFile);
    }

    public void setLimitingScopeFile(@Nullable PsiFile limitingScopeFile) {
        if (!this.myIgnorePerformanceLimits) {
            throw new IllegalStateException("To ensure that all elements in limitingScopeFile will be checked, myIgnorePerformanceLimits must be set.");
        }
        this.myLimitingScopeFile = limitingScopeFile;
    }

    public String toString() {
        String simpleName = this.getClass().getSimpleName();
        return simpleName + "{myQualifier=" + this.myQualifier + ", myRef=" + this.myRef + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 15, 16, 17, 18, 19, 20, 23, 26, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSReferenceExpressionResolver";
                break;
            }
            case 13: 
            case 28: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localProcessor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localResults";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSReferenceExpressionResolver";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeIncompleteLocalResolveWithGlobal";
                break;
            }
            case 18: 
            case 19: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveGlobalReference";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolveGlobalReference";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "processGlobalDeclarations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 26: 
            case 27: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isDummyResolve";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "mergeIncompleteLocalResolveWithGlobal";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "processGlobalDeclarations";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "resolveGlobalReference";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "resolveFromIndices";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "adjustReferencedName";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "prepareProcessor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 15, 16, 17, 18, 19, 20, 23, 26, 27 -> new IllegalStateException(string);
        };
    }
}

