/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.evaluation.JSCodeBasedTypeFactory;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.resolve.JSCompleteTypeEvaluationProcessor;
import com.intellij.lang.javascript.psi.resolve.JSComplexityAwareRecursionGuard;
import com.intellij.lang.javascript.psi.resolve.JSEvaluableTypeResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationRecursionGuard;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationStatisticsCollector;
import com.intellij.lang.javascript.psi.resolve.JSEvaluatorComplexityTracker;
import com.intellij.lang.javascript.psi.resolve.JSSimpleTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluationResultProcessor;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationResultElement;
import com.intellij.lang.javascript.psi.types.JSPsiBasedTypeOfType;
import com.intellij.lang.javascript.psi.util.SoftlyCachedValue;
import com.intellij.lang.typescript.resolve.TypeScriptCompilerEvaluationFacade;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.CollectionFactory;
import java.util.Map;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSEvaluationCache {
    private static final Key<JSEvaluationCache> CACHE_KEY_EXPRESSION_TYPE = Key.create((String)"js.evaluator.expression.type");
    private static final CacheProviderExpressionType CACHE_PROVIDER_EXPRESSION_TYPE = new CacheProviderExpressionType();
    @NotNull
    private final Map<JSEvaluateContext, SoftlyCachedValue<JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue<JSTypeEvaluationResult>>> myResults = CollectionFactory.createConcurrentSoftMap();

    @Nullable
    public static JSTypeEvaluationResult getElementType(@NotNull PsiElement element, @NotNull JSEvaluateContext context2) {
        JSEvaluationCache data;
        if (element == null) {
            JSEvaluationCache.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            JSEvaluationCache.$$$reportNull$$$0(1);
        }
        if ((data = (JSEvaluationCache)element.getUserData(CACHE_KEY_EXPRESSION_TYPE)) == null) {
            data = new JSEvaluationCache();
            element.putUserData(CACHE_KEY_EXPRESSION_TYPE, (Object)data);
        }
        JSEvaluationCache finalData = data;
        return JSTypeEvaluationLocationProvider.withTypeEvaluationLocation(element, () -> finalData.doGetElementType(element, context2));
    }

    @Nullable
    private JSTypeEvaluationResult doGetElementType(@NotNull PsiElement element, @NotNull JSEvaluateContext context2) {
        if (element == null) {
            JSEvaluationCache.$$$reportNull$$$0(2);
        }
        if (context2 == null) {
            JSEvaluationCache.$$$reportNull$$$0(3);
        }
        JSEvaluationRecursionGuard.JSEvaluationKey evaluationKey = new JSEvaluationRecursionGuard.JSEvaluationKey(element, context2, CACHE_PROVIDER_EXPRESSION_TYPE.getClass());
        return JSEvaluationRecursionGuard.getGuard().getCachedValue(evaluationKey, JSEvaluatorComplexityTracker.getDefaultInstance(), () -> {
            SoftlyCachedValue<JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue<JSTypeEvaluationResult>> value = this.myResults.get(context2);
            return value != null ? value.getUpToDateOrNull() : null;
        }, value -> this.myResults.put(context2, new SoftlyCachedValue<JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue>((JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue)value, (ModificationTracker)PsiModificationTracker.getInstance((Project)element.getProject()))), key2 -> CACHE_PROVIDER_EXPRESSION_TYPE.apply((PsiElement)key2.myElement, key2.myContext));
    }

    @Nullable
    private static JSTypeEvaluationResult getResultFromService(@NotNull PsiElement element, @NotNull JSEvaluateContext context2) {
        TypeScriptCompilerEvaluationFacade instance;
        if (element == null) {
            JSEvaluationCache.$$$reportNull$$$0(4);
        }
        if (context2 == null) {
            JSEvaluationCache.$$$reportNull$$$0(5);
        }
        if ((instance = JSEvaluationCache.getFacadeIfCanGetType(element, context2)) != null) {
            JSType typeFromService = instance.getTypeFromService(element);
            if (typeFromService != null) {
                JSTypeEvaluationResult result2 = new JSTypeEvaluationResult();
                result2.addResultElement(new JSEvaluationResultElement(typeFromService, false, context2));
                return result2;
            }
            return null;
        }
        return null;
    }

    static boolean canGetTypeFromService(@NotNull PsiElement element, @NotNull JSEvaluateContext context2) {
        if (element == null) {
            JSEvaluationCache.$$$reportNull$$$0(6);
        }
        if (context2 == null) {
            JSEvaluationCache.$$$reportNull$$$0(7);
        }
        return JSEvaluationCache.getFacadeIfCanGetType(element, context2) != null;
    }

    @Nullable
    private static TypeScriptCompilerEvaluationFacade getFacadeIfCanGetType(@NotNull PsiElement element, @NotNull JSEvaluateContext context2) {
        if (element == null) {
            JSEvaluationCache.$$$reportNull$$$0(8);
        }
        if (context2 == null) {
            JSEvaluationCache.$$$reportNull$$$0(9);
        }
        if (element instanceof PsiFile || element instanceof JSEmbeddedContent) {
            return null;
        }
        TypeScriptCompilerEvaluationFacade instance = TypeScriptCompilerEvaluationFacade.getInstance(element.getProject());
        if (instance != null && (new JSEvaluateContext(element.getContainingFile(), false).equals(context2) || new JSEvaluateContext(element.getContainingFile(), true).equals(context2))) {
            return instance;
        }
        return null;
    }

    @NotNull
    private static JSTypeEvaluationResult getResultFromEvaluator(@NotNull PsiElement element, @NotNull JSEvaluateContext context2) {
        if (element == null) {
            JSEvaluationCache.$$$reportNull$$$0(10);
        }
        if (context2 == null) {
            JSEvaluationCache.$$$reportNull$$$0(11);
        }
        JSPsiBasedTypeOfType type2 = JSCodeBasedTypeFactory.getPsiBasedType(element, context2);
        JSTypeEvaluationResult result2 = JSEvaluableTypeResolver.FOR_CACHING.doUnwrapRecursively(type2, false, context2);
        JSTypeEvaluationResultProcessor processor = new JSTypeEvaluationResultProcessor();
        result2.applyToProcessor(new JSCompleteTypeEvaluationProcessor(processor, JSEvaluableTypeResolver.FOR_CACHING));
        JSTypeEvaluationResult completeResult = processor.getResult();
        Application application = ApplicationManager.getApplication();
        if (application.isInternal()) {
            ((JSEvaluationStatisticsCollector)application.getService(JSEvaluationStatisticsCollector.class)).typeEvaluated();
        }
        JSTypeEvaluationResult jSTypeEvaluationResult = completeResult;
        if (jSTypeEvaluationResult == null) {
            JSEvaluationCache.$$$reportNull$$$0(12);
        }
        return jSTypeEvaluationResult;
    }

    @Nullable
    public static JSType getTypeFromEvaluator(@NotNull PsiElement element) {
        if (element == null) {
            JSEvaluationCache.$$$reportNull$$$0(13);
        }
        JSSimpleTypeProcessor processor = new JSSimpleTypeProcessor();
        JSEvaluationCache.getResultFromEvaluator(element, new JSEvaluateContext(element.getContainingFile(), false)).applyToProcessor(processor);
        return processor.getType();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSEvaluationCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSEvaluationCache";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultFromEvaluator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getElementType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doGetElementType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getResultFromService";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canGetTypeFromService";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFacadeIfCanGetType";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getResultFromEvaluator";
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromEvaluator";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12 -> new IllegalStateException(string);
        };
    }

    private static final class CacheProviderExpressionType
    implements BiFunction<PsiElement, JSEvaluateContext, JSTypeEvaluationResult> {
        private CacheProviderExpressionType() {
        }

        @Override
        public JSTypeEvaluationResult apply(PsiElement element, JSEvaluateContext context2) {
            JSTypeEvaluationResult typeFromService = JSEvaluationCache.getResultFromService(element, context2);
            if (typeFromService != null) {
                return typeFromService;
            }
            return JSEvaluationCache.getResultFromEvaluator(element, context2);
        }
    }
}

