/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.jsdoc.impl;

import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.jsdoc.JSDocBlockTags;
import com.intellij.lang.javascript.psi.jsdoc.JSDocInlineTag;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagDefinition;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagNamepath;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocTagReferencesHolderImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSDocTagNamepathImpl
extends JSDocTagReferencesHolderImpl
implements JSDocTagNamepath {
    public JSDocTagNamepathImpl(IElementType elementType) {
        super(elementType);
    }

    @Override
    protected PsiReference @NotNull [] createRefs() {
        PsiElement parent = this.getParent();
        JSDocTagDefinition definition2 = null;
        if (parent instanceof JSDocTag) {
            definition2 = ((JSDocTag)parent).getTagDefinition();
        } else if (parent instanceof JSDocInlineTag) {
            definition2 = ((JSDocInlineTag)parent).getTagDefinition();
        }
        if (definition2 != null) {
            String text2 = this.getText();
            boolean isEnclosed = JSDocTagNamepathImpl.indexOfOptionalDelimiter(text2) == 0 || JSDocTagNamepathImpl.isWithinBackticksOrBraces(text2);
            int equals = text2.indexOf(61);
            if (equals < 0) {
                equals = text2.length();
            }
            text2 = isEnclosed ? text2.substring(1, Math.min(equals, text2.length() - 1)) : text2.substring(0, equals);
            PsiReference[] psiReferenceArray = this.createReferencesFromText(StringUtil.trimTrailing((String)text2, (char)'.'), isEnclosed ? 1 : 0, definition2, true, JSDocTagNamepathImpl.isSeeTagWithHardNamepathReference(text2, definition2));
            if (psiReferenceArray == null) {
                JSDocTagNamepathImpl.$$$reportNull$$$0(0);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            JSDocTagNamepathImpl.$$$reportNull$$$0(1);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSDocTagNamepathImpl.$$$reportNull$$$0(2);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSDocTagNamepath(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    @NotNull
    public String getNamepathText() {
        Object result2 = this.getNamepathPrefixForConfigTag();
        String text2 = this.getTextWithoutLeadingAsterisks();
        int optionalDelimiter = JSDocTagNamepathImpl.indexOfOptionalDelimiter(text2);
        boolean isEnclosed = JSDocTagNamepathImpl.isWithinBackticksOrBraces(text2);
        int equals = text2.indexOf(61);
        result2 = equals > 0 ? (String)result2 + text2.substring(isEnclosed || optionalDelimiter >= 0 ? 1 : 0, equals).trim() : (optionalDelimiter >= 0 ? (String)result2 + text2.substring(0, optionalDelimiter) + text2.substring(optionalDelimiter + 1, text2.length() - 1).trim() : (isEnclosed ? (String)result2 + text2.substring(1, text2.length() - 1).trim() : (String)result2 + text2));
        String string = StringUtil.trimTrailing((String)result2, (char)'.');
        if (string == null) {
            JSDocTagNamepathImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public boolean isOptional() {
        JSDocTag nextTag = JSDocumentationUtils.getNextJSDocTag((PsiElement)this);
        if (nextTag != null && nextTag.is(JSDocBlockTags.OPTIONAL)) {
            return true;
        }
        String text2 = this.getTextWithoutLeadingAsterisks();
        return JSDocTagNamepathImpl.indexOfOptionalDelimiter(text2) >= 0 || text2.contains("=");
    }

    @Override
    public boolean isRest() {
        return this.getText().endsWith("...");
    }

    @Override
    @Nullable
    public String getDefaultValue() {
        String text2 = this.getTextWithoutLeadingAsterisks();
        int equals = text2.indexOf(61);
        if (equals > 0) {
            if (JSDocTagNamepathImpl.indexOfOptionalDelimiter(text2) >= 0 || JSDocTagNamepathImpl.isWithinBackticksOrBraces(text2)) {
                return text2.substring(equals + 1, text2.length() - 1).trim();
            }
            return text2.substring(equals + 1).trim();
        }
        return null;
    }

    @NotNull
    private String getNamepathPrefixForConfigTag() {
        JSDocTag tag = JSDocumentationUtils.getPreviousParamTagForConfigTag((JSDocTag)ObjectUtils.tryCast((Object)this.getParent(), JSDocTag.class));
        if (tag != null) {
            String namepath = tag.getNamepathText();
            return namepath != null ? namepath + "." : "";
        }
        return "";
    }

    private static boolean isSeeTagWithHardNamepathReference(String text2, JSDocTagDefinition definition2) {
        if (definition2 != JSDocBlockTags.SEE) {
            return false;
        }
        if (text2.indexOf(35) != -1) {
            return true;
        }
        int dotPos = text2.lastIndexOf(46);
        return dotPos != -1 && dotPos + 1 < text2.length() && Character.isUpperCase(text2.charAt(dotPos + 1));
    }

    private static boolean isWithinBackticksOrBraces(@NotNull String text2) {
        if (text2 == null) {
            JSDocTagNamepathImpl.$$$reportNull$$$0(4);
        }
        return text2.startsWith("`") && text2.endsWith("`") || text2.startsWith("{") && text2.endsWith("}");
    }

    private static int indexOfOptionalDelimiter(@NotNull String text2) {
        int index;
        if (text2 == null) {
            JSDocTagNamepathImpl.$$$reportNull$$$0(5);
        }
        if ((index = text2.indexOf(91)) >= 0) {
            return text2.endsWith("]") ? index : -1;
        }
        index = text2.indexOf(40);
        if (index == 0) {
            return text2.endsWith(")") ? index : -1;
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocTagNamepathImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createRefs";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocTagNamepathImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamepathText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isWithinBackticksOrBraces";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "indexOfOptionalDelimiter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

