/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.javascript.psi.JSFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\u0005\u001a\u00020\u0006R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/lang/javascript/psi/impl/JsTestFileInfo;", "", "jsFile", "Lcom/intellij/lang/javascript/psi/JSFile;", "(Lcom/intellij/lang/javascript/psi/JSFile;)V", "isNamedAsTest", "", "Ljava/lang/Boolean;", "clearCaches", "", "Companion", "intellij.javascript.psi.impl"})
public final class JsTestFileInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JSFile jsFile;
    @Nullable
    private Boolean isNamedAsTest;
    private static final Pattern JS_TEST_FILE_NAMES_PATTERN = Pattern.compile("\\.(spec|test|cy)\\.(js|ts)x?$");

    public JsTestFileInfo(@NotNull JSFile jsFile) {
        Intrinsics.checkNotNullParameter((Object)jsFile, (String)"jsFile");
        this.jsFile = jsFile;
    }

    public final boolean isNamedAsTest() {
        Boolean namedAsTest = this.isNamedAsTest;
        if (namedAsTest == null) {
            String string = this.jsFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            this.isNamedAsTest = namedAsTest = Boolean.valueOf(Companion.isTestFileName(string));
        }
        return namedAsTest;
    }

    public final void clearCaches() {
        this.isNamedAsTest = null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/lang/javascript/psi/impl/JsTestFileInfo$Companion;", "", "()V", "JS_TEST_FILE_NAMES_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "isTestFileName", "", "fileName", "", "intellij.javascript.psi.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isTestFileName(@NotNull String fileName) {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Matcher matcher = JS_TEST_FILE_NAMES_PATTERN.matcher(fileName);
            return matcher.find();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

