/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSPsiTypeParser<P extends JavaScriptParser>
extends JavaScriptParserBase<P> {
    protected JSPsiTypeParser(P parser2) {
        super(parser2);
    }

    public boolean parseQualifiedTypeName() {
        return this.parseQualifiedTypeName(false);
    }

    public boolean parseType() {
        IElementType tokenType = this.builder.getTokenType();
        if (JSKeywordSets.PRIMITIVE_TYPES.contains(tokenType)) {
            this.builder.advanceLexer();
        } else if (!this.parseQualifiedTypeName()) {
            this.builder.error(this.getTypeNameExpectedMessage());
        }
        return true;
    }

    public boolean tryParseType() {
        if (this.builder.getTokenType() == JSTokenTypes.COLON && this.isECMAL4()) {
            IElementType tokenType;
            this.builder.advanceLexer();
            boolean b = this.parseType();
            if (b && ((tokenType = this.builder.getTokenType()) == JSTokenTypes.QUEST || tokenType == JSTokenTypes.EXCL)) {
                this.builder.advanceLexer();
            }
            return b;
        }
        return false;
    }

    public boolean tryParseArrowFunctionReturnType() {
        return this.tryParseType();
    }

    public boolean tryParseFunctionReturnType() {
        return this.tryParseType();
    }

    public boolean tryParseTypeParameterList() {
        return true;
    }

    public boolean tryParseTypeArgumentList(boolean revert, boolean allowNewLine, boolean isExpression) {
        return true;
    }

    public final boolean parseQualifiedTypeName(boolean allowStar) {
        PsiBuilder.Marker expr = this.parseIdentifierPart();
        if (expr == null) {
            return false;
        }
        return this.parseQualifiedTypeNameRest(allowStar, expr);
    }

    @Nullable
    private PsiBuilder.Marker parseIdentifierPart() {
        if (!this.isIdentifierToken(this.builder.getTokenType())) {
            return null;
        }
        PsiBuilder.Marker expr = this.builder.mark();
        this.myJavaScriptParser.buildTokenElement(JSElementTypes.REFERENCE_EXPRESSION);
        return expr;
    }

    public boolean parseQualifiedTypeNameRest(boolean allowStar, PsiBuilder.Marker expr) {
        while (this.isAcceptableQualifierSeparator()) {
            IElementType separator = this.builder.getTokenType();
            this.builder.advanceLexer();
            Ref ref = Ref.create((Object)expr);
            boolean stop = this.parseAfterDotInQualifiedTypeNameRest(allowStar, (Ref<PsiBuilder.Marker>)ref, separator);
            expr = (PsiBuilder.Marker)ref.get();
            if (!stop) continue;
            break;
        }
        return this.parseQualifiedTypeNameTail(expr);
    }

    protected boolean isAcceptableQualifierSeparator() {
        return this.builder.getTokenType() == JSTokenTypes.DOT;
    }

    protected boolean parseAfterDotInQualifiedTypeNameRest(boolean allowStar, @NotNull Ref<PsiBuilder.Marker> marker, @NotNull IElementType separator) {
        if (marker == null) {
            JSPsiTypeParser.$$$reportNull$$$0(0);
        }
        if (separator == null) {
            JSPsiTypeParser.$$$reportNull$$$0(1);
        }
        IElementType tokenType = this.builder.getTokenType();
        PsiBuilder.Marker expr = (PsiBuilder.Marker)marker.get();
        boolean stop = this.parseAfterDotInQualifiedTypeNameRest(allowStar, tokenType, separator);
        expr.done(JSElementTypes.REFERENCE_EXPRESSION);
        marker.set((Object)expr.precede());
        return stop;
    }

    protected boolean parseAfterDotInQualifiedTypeNameRest(boolean allowStar, IElementType tokenType, @NotNull IElementType separator) {
        if (separator == null) {
            JSPsiTypeParser.$$$reportNull$$$0(2);
        }
        if (tokenType == JSTokenTypes.ANY_IDENTIFIER && allowStar) {
            this.builder.advanceLexer();
            return true;
        }
        if (tokenType != JSTokenTypes.IDENTIFIER && this.myJavaScriptParser.isIdentifierName(tokenType)) {
            this.builder.advanceLexer();
        } else {
            JSPsiTypeParser.checkMatches(this.builder, JSTokenTypes.IDENTIFIER, "javascript.parser.message.expected.name");
        }
        return false;
    }

    protected boolean parseQualifiedTypeNameTail(PsiBuilder.Marker expr) {
        if (this.isECMAL4() && this.builder.getTokenType() == JSTokenTypes.LT) {
            this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.dot", new Object[0]));
            this.parseECMA4GenericSignature();
            expr.done(JSElementTypes.REFERENCE_EXPRESSION);
        } else {
            expr.drop();
        }
        return true;
    }

    public void parseECMA4GenericSignature() {
        assert (this.builder.getTokenType() == JSTokenTypes.LT || this.builder.getTokenType() == JSTokenTypes.GENERIC_SIGNATURE_START);
        PsiBuilder.Marker genericTypeSignature = this.builder.mark();
        this.builder.advanceLexer();
        this.parseType();
        JSPsiTypeParser.checkMatches(this.builder, JSTokenTypes.GT, "javascript.parser.message.expected.gt");
        genericTypeSignature.done(JSElementTypes.GENERIC_SIGNATURE);
    }

    public boolean parseTypeAliasType() {
        throw new UnsupportedOperationException("Not supported");
    }

    @NotNull
    @NlsContexts.ParsingError
    protected String getTypeNameExpectedMessage() {
        String string = JavaScriptBundle.message("javascript.parser.message.expected.typename.or.*", new Object[0]);
        if (string == null) {
            JSPsiTypeParser.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/parsing/JSPsiTypeParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/parsing/JSPsiTypeParser";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeNameExpectedMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseAfterDotInQualifiedTypeNameRest";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

