/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.remote;

import com.intellij.lang.javascript.index.HtmlScriptSrcIndex;
import com.intellij.lang.javascript.modules.remote.JSRemoteModulesChangeEvent;
import com.intellij.lang.javascript.modules.remote.JSRemoteModulesChangeListener;
import com.intellij.lang.javascript.modules.remote.JSRemoteModulesLibraryManager;
import com.intellij.lang.javascript.modules.remote.JSRemoteModulesRegistry;
import com.intellij.lang.javascript.psi.stubs.JSUsedRemoteModulesIndex;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiManager;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
@State(name="JSRemoteModulesUsagesDetector", storages={@Storage(value="$CACHE_FILE$")})
public final class JSRemoteModulesUsagesDetector
implements PersistentStateComponent<JSRemoteModulesUsagesDetectorState>,
JSRemoteModulesChangeListener,
Disposable {
    private static final int PERIODIC_TIMEOUT_MS = ApplicationManager.getApplication().isUnitTestMode() ? 500 : 20000;
    private static final int IMMEDIATE_TIMEOUT_MS = 100;
    private final Project myProject;
    private final Alarm myAlarm;
    private final AtomicReference<ReferencedModulesSnapshot> mySnapshot;
    private final Set<String> myExplicitModules;
    private final SimpleModificationTracker myModificationTracker;

    public static JSRemoteModulesUsagesDetector getInstance(@NotNull Project project) {
        if (project == null) {
            JSRemoteModulesUsagesDetector.$$$reportNull$$$0(0);
        }
        return (JSRemoteModulesUsagesDetector)project.getService(JSRemoteModulesUsagesDetector.class);
    }

    public JSRemoteModulesUsagesDetector(@NotNull Project project) {
        if (project == null) {
            JSRemoteModulesUsagesDetector.$$$reportNull$$$0(1);
        }
        this.mySnapshot = new AtomicReference<ReferencedModulesSnapshot>(new ReferencedModulesSnapshot(Set.of(), -1L));
        this.myExplicitModules = ConcurrentHashMap.newKeySet();
        this.myModificationTracker = new SimpleModificationTracker();
        this.myProject = project;
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        connection.subscribe(JSRemoteModulesRegistry.TOPIC, (Object)this);
    }

    @NotNull
    public Set<String> getCachedReferencedModules() {
        ReferencedModulesSnapshot snapshot = this.mySnapshot.get();
        Set<String> set = snapshot.getModules();
        if (set == null) {
            JSRemoteModulesUsagesDetector.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    private Set<String> findAllUsedModules() {
        HashSet<String> usages = new HashSet<String>(JSUsedRemoteModulesIndex.getUsedModules(this.myProject));
        usages.addAll(HtmlScriptSrcIndex.getReferencedUrls(this.myProject));
        usages.addAll(this.myExplicitModules);
        Set<String> set = Collections.unmodifiableSet(usages);
        if (set == null) {
            JSRemoteModulesUsagesDetector.$$$reportNull$$$0(3);
        }
        return set;
    }

    public void detect() {
        this.scheduleUpdate(100);
    }

    private void schedulePeriodic() {
        this.scheduleUpdate(PERIODIC_TIMEOUT_MS);
    }

    private void scheduleUpdate(int timeoutMs) {
        if (this.myProject.isDisposed()) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            DumbService.getInstance((Project)this.myProject).smartInvokeLater(this::performSyncUpdate, ModalityState.nonModal());
            return;
        }
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(this::performNonBlockingUpdate, timeoutMs);
    }

    private void performSyncUpdate() {
        this.setUpdatedSnapshot(this.computeUpdatedModulesSnapshot());
    }

    private void performNonBlockingUpdate() {
        if (this.myProject.isDisposed()) {
            return;
        }
        ReadAction.nonBlocking(this::computeUpdatedModulesSnapshot).expireWith((Disposable)this).inSmartMode(this.myProject).finishOnUiThread(ModalityState.defaultModalityState(), snapshots -> {
            this.setUpdatedSnapshot((Pair<ReferencedModulesSnapshot, ReferencedModulesSnapshot>)snapshots);
            this.schedulePeriodic();
        }).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    @Nullable
    private Pair<ReferencedModulesSnapshot, ReferencedModulesSnapshot> computeUpdatedModulesSnapshot() {
        long modificationStamp;
        ReferencedModulesSnapshot previousSnapshot = this.mySnapshot.get();
        long previousStamp = previousSnapshot.getModificationStamp();
        if (previousStamp != (modificationStamp = this.getModificationStamp())) {
            Set<String> modules2 = this.findAllUsedModules();
            ReferencedModulesSnapshot snapshot = new ReferencedModulesSnapshot(modules2, modificationStamp);
            return Pair.create((Object)previousSnapshot, (Object)snapshot);
        }
        return null;
    }

    private void setUpdatedSnapshot(@Nullable Pair<ReferencedModulesSnapshot, ReferencedModulesSnapshot> snapshots) {
        if (snapshots == null) {
            return;
        }
        ReferencedModulesSnapshot prev = (ReferencedModulesSnapshot)snapshots.first;
        ReferencedModulesSnapshot curr = (ReferencedModulesSnapshot)snapshots.second;
        if (this.mySnapshot.compareAndSet(prev, curr) && !prev.getModules().equals(curr.getModules())) {
            JSRemoteModulesLibraryManager.getInstance(this.myProject).scheduleUpdate();
        }
    }

    private long getModificationStamp() {
        long modificationCount = this.myModificationTracker.getModificationCount();
        modificationCount += VirtualFileManager.getInstance().getModificationCount();
        return modificationCount += PsiManager.getInstance((Project)this.myProject).getModificationTracker().getModificationCount();
    }

    @Override
    public void onRemoteModuleChanged(@NotNull JSRemoteModulesChangeEvent event) {
        if (event == null) {
            JSRemoteModulesUsagesDetector.$$$reportNull$$$0(4);
        }
        String url = event.getModule().getUrl();
        switch (event.getType()) {
            case CREATED: 
            case MODIFIED: {
                this.myExplicitModules.add(url);
                break;
            }
            case REMOVED: {
                this.myExplicitModules.remove(url);
            }
        }
        this.myModificationTracker.incModificationCount();
        this.detect();
    }

    @TestOnly
    public void clear() {
        this.myExplicitModules.clear();
        this.mySnapshot.set(new ReferencedModulesSnapshot(Set.of(), -1L));
    }

    @NotNull
    public JSRemoteModulesUsagesDetectorState getState() {
        ReferencedModulesSnapshot snapshot = this.mySnapshot.get();
        JSRemoteModulesUsagesDetectorState state = new JSRemoteModulesUsagesDetectorState();
        state.myModules = snapshot.getModules();
        JSRemoteModulesUsagesDetectorState jSRemoteModulesUsagesDetectorState = state;
        if (jSRemoteModulesUsagesDetectorState == null) {
            JSRemoteModulesUsagesDetector.$$$reportNull$$$0(5);
        }
        return jSRemoteModulesUsagesDetectorState;
    }

    public void loadState(@NotNull JSRemoteModulesUsagesDetectorState state) {
        if (state == null) {
            JSRemoteModulesUsagesDetector.$$$reportNull$$$0(6);
        }
        this.myExplicitModules.addAll(state.myModules);
        this.mySnapshot.set(new ReferencedModulesSnapshot(state.myModules, -1L));
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/remote/JSRemoteModulesUsagesDetector";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/remote/JSRemoteModulesUsagesDetector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedReferencedModules";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllUsedModules";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onRemoteModuleChanged";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5 -> new IllegalStateException(string);
        };
    }

    private static class ReferencedModulesSnapshot {
        private final Set<String> myModules;
        private final long myModificationStamp;

        private ReferencedModulesSnapshot(@NotNull Set<String> modules2, long modificationStamp) {
            if (modules2 == null) {
                ReferencedModulesSnapshot.$$$reportNull$$$0(0);
            }
            this.myModules = modules2;
            this.myModificationStamp = modificationStamp;
        }

        @NotNull
        private Set<String> getModules() {
            Set<String> set = this.myModules;
            if (set == null) {
                ReferencedModulesSnapshot.$$$reportNull$$$0(1);
            }
            return set;
        }

        private long getModificationStamp() {
            return this.myModificationStamp;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modules";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/modules/remote/JSRemoteModulesUsagesDetector$ReferencedModulesSnapshot";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/modules/remote/JSRemoteModulesUsagesDetector$ReferencedModulesSnapshot";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModules";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class JSRemoteModulesUsagesDetectorState {
        @XCollection(propertyElementName="modules", elementName="module", valueAttributeName="url")
        private Set<String> myModules = Collections.emptySet();
    }
}

