/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.remote;

import com.intellij.lang.javascript.frameworks.modules.JSUrlImportsUtil;
import com.intellij.lang.javascript.modules.remote.JSRemoteModule;
import com.intellij.lang.javascript.modules.remote.JSRemoteModulesChangeEvent;
import com.intellij.lang.javascript.modules.remote.JSRemoteModulesChangeListener;
import com.intellij.lang.javascript.modules.remote.JSRemoteModulesEventType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service
@State(name="JSRemoteModulesRegistry", storages={@Storage(value="$CACHE_FILE$", roamingType=RoamingType.DISABLED)})
public final class JSRemoteModulesRegistry
implements PersistentStateComponent<JSRemoteModulesRegistryState>,
Disposable {
    @Topic.AppLevel
    public static final Topic<JSRemoteModulesChangeListener> TOPIC = new Topic(JSRemoteModulesChangeListener.class, Topic.BroadcastDirection.NONE);
    private static final int UPDATE_TIMEOUT = 500;
    private final Queue<JSRemoteModulesChangeEvent> myModuleEvents = new ConcurrentLinkedQueue<JSRemoteModulesChangeEvent>();
    private final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
    @NotNull
    private volatile Map<String, JSRemoteModule> myModules = Collections.emptyMap();

    public static JSRemoteModulesRegistry getInstance() {
        return (JSRemoteModulesRegistry)ApplicationManager.getApplication().getService(JSRemoteModulesRegistry.class);
    }

    public JSRemoteModulesRegistry() {
        VirtualFileManager.getInstance().addAsyncFileListener((AsyncFileListener)new MyFileListener(), (Disposable)this);
    }

    @Nullable
    public JSRemoteModule getModule(@NotNull String url) {
        if (url == null) {
            JSRemoteModulesRegistry.$$$reportNull$$$0(0);
        }
        return this.myModules.get(url);
    }

    @NotNull
    public Set<String> getModuleNames() {
        return new HashSet<String>(this.myModules.keySet());
    }

    public void registerModule(@NotNull JSRemoteModule module) {
        JSRemoteModule previousModule;
        if (module == null) {
            JSRemoteModulesRegistry.$$$reportNull$$$0(1);
        }
        if ((previousModule = this.myModules.get(module.getUrl())) == null) {
            this.myModuleEvents.offer(new JSRemoteModulesChangeEvent(JSRemoteModulesEventType.CREATED, module));
        } else {
            this.myModuleEvents.offer(new JSRemoteModulesChangeEvent(JSRemoteModulesEventType.MODIFIED, module));
        }
        this.scheduleEventProcessing();
    }

    public void unregisterModule(@NotNull JSRemoteModule module) {
        if (module == null) {
            JSRemoteModulesRegistry.$$$reportNull$$$0(2);
        }
        this.myModuleEvents.offer(new JSRemoteModulesChangeEvent(JSRemoteModulesEventType.REMOVED, module));
        this.scheduleEventProcessing();
    }

    private void scheduleEventProcessing() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.processScheduledEvents();
        } else {
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest(() -> BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this, this::processScheduledEvents), 500);
        }
    }

    private void processScheduledEvents() {
        HashMap<String, JSRemoteModulesChangeEvent> events = new HashMap<String, JSRemoteModulesChangeEvent>();
        Map<String, JSRemoteModule> previousModules = this.myModules;
        HashMap<String, JSRemoteModule> newModules = null;
        for (JSRemoteModule module : previousModules.values()) {
            ProgressManager.checkCanceled();
            if (module.isValid()) continue;
            events.put(module.getUrl(), new JSRemoteModulesChangeEvent(JSRemoteModulesEventType.REMOVED, module));
            if (newModules == null) {
                newModules = new HashMap<String, JSRemoteModule>(previousModules);
            }
            newModules.remove(module.getUrl());
        }
        while (!this.myModuleEvents.isEmpty()) {
            JSRemoteModule module;
            ProgressManager.checkCanceled();
            JSRemoteModulesChangeEvent event = this.myModuleEvents.poll();
            if (event == null) continue;
            if (newModules == null) {
                newModules = new HashMap<String, JSRemoteModule>(previousModules);
            }
            module = event.getModule();
            String url = module.getUrl();
            events.put(url, event);
            switch (event.getType()) {
                case CREATED: 
                case MODIFIED: {
                    newModules.put(url, module);
                    break;
                }
                case REMOVED: {
                    newModules.remove(url);
                }
            }
        }
        if (events.isEmpty()) {
            return;
        }
        this.myModules = Collections.unmodifiableMap(Objects.requireNonNull(newModules));
        Application application = ApplicationManager.getApplication();
        application.invokeLater(() -> {
            MessageBus bus = application.getMessageBus();
            for (JSRemoteModulesChangeEvent event : events.values()) {
                ((JSRemoteModulesChangeListener)bus.syncPublisher(TOPIC)).onRemoteModuleChanged(event);
            }
        }, application.getDisposed());
    }

    @TestOnly
    public void clear() {
        this.myModuleEvents.clear();
        this.myModules = Collections.emptyMap();
    }

    @NotNull
    public JSRemoteModulesRegistryState getState() {
        Map<String, JSRemoteModule> modules2 = this.myModules;
        return new JSRemoteModulesRegistryState(ContainerUtil.mapNotNull(modules2.values(), module -> JSRemoteModule.toModuleState(module)));
    }

    public void loadState(@NotNull JSRemoteModulesRegistryState state) {
        if (state == null) {
            JSRemoteModulesRegistry.$$$reportNull$$$0(3);
        }
        HashMap<String, JSRemoteModule> modules2 = new HashMap<String, JSRemoteModule>();
        for (JSRemoteModuleState moduleState : state.modules) {
            JSRemoteModule module = JSRemoteModule.fromModuleState(moduleState);
            if (module == null) continue;
            modules2.put(moduleState.myUrl, module);
        }
        this.myModules = Collections.unmodifiableMap(modules2);
    }

    public void noStateLoaded() {
        this.myModules = Collections.emptyMap();
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/modules/remote/JSRemoteModulesRegistry";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getModule";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "registerModule";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "unregisterModule";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyFileListener
    implements AsyncFileListener {
        private MyFileListener() {
        }

        @Nullable
        public AsyncFileListener.ChangeApplier prepareChange(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
            if (events == null) {
                MyFileListener.$$$reportNull$$$0(0);
            }
            String modulesDirUrl = VfsUtilCore.pathToUrl((String)JSUrlImportsUtil.getRemoteModulesDirPath());
            Set<String> roots = Collections.singleton(modulesDirUrl);
            boolean updateIsRequired = false;
            for (VFileEvent vFileEvent : events) {
                VFileDeleteEvent deleteEvent;
                ProgressManager.checkCanceled();
                if (!(vFileEvent instanceof VFileDeleteEvent) || !VfsUtilCore.isUnder((String)(deleteEvent = (VFileDeleteEvent)vFileEvent).getFile().getUrl(), roots)) continue;
                updateIsRequired = true;
                break;
            }
            if (!updateIsRequired) {
                return null;
            }
            return new AsyncFileListener.ChangeApplier(){

                public void afterVfsChange() {
                    JSRemoteModulesRegistry.this.scheduleEventProcessing();
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/lang/javascript/modules/remote/JSRemoteModulesRegistry$MyFileListener", "prepareChange"));
        }
    }

    public static final class JSRemoteModulesRegistryState {
        @XCollection(propertyElementName="modules")
        private final List<JSRemoteModuleState> modules;

        public JSRemoteModulesRegistryState() {
            this.modules = new ArrayList<JSRemoteModuleState>();
        }

        public JSRemoteModulesRegistryState(List<JSRemoteModuleState> modules2) {
            this.modules = modules2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JSRemoteModulesRegistryState state = (JSRemoteModulesRegistryState)o;
            return Objects.equals(this.modules, state.modules);
        }

        public int hashCode() {
            return Objects.hash(this.modules);
        }
    }

    @Tag(value="module")
    public static class JSRemoteModuleState {
        @Tag(value="url")
        public String myUrl;
        @Tag(value="entry")
        public String myEntry;
        @Tag(value="root")
        public String myRoot;
        @XCollection(propertyElementName="dependencies", elementName="dependency", valueAttributeName="url")
        public Set<String> myDependencies;

        public JSRemoteModuleState() {
            this.myDependencies = Collections.emptySet();
        }

        public JSRemoteModuleState(@NotNull String url, @NotNull String entry, @NotNull String root, @NotNull Set<String> dependencies) {
            if (url == null) {
                JSRemoteModuleState.$$$reportNull$$$0(0);
            }
            if (entry == null) {
                JSRemoteModuleState.$$$reportNull$$$0(1);
            }
            if (root == null) {
                JSRemoteModuleState.$$$reportNull$$$0(2);
            }
            if (dependencies == null) {
                JSRemoteModuleState.$$$reportNull$$$0(3);
            }
            this.myDependencies = Collections.emptySet();
            this.myUrl = url;
            this.myEntry = entry;
            this.myRoot = root;
            this.myDependencies = dependencies;
        }

        public boolean isValid() {
            return !StringUtil.isEmpty((String)this.myUrl) && !StringUtil.isEmpty((String)this.myEntry) && !StringUtil.isEmpty((String)this.myRoot);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JSRemoteModuleState state = (JSRemoteModuleState)o;
            return Objects.equals(this.myUrl, state.myUrl) && Objects.equals(this.myEntry, state.myEntry) && Objects.equals(this.myRoot, state.myRoot) && Objects.equals(this.myDependencies, state.myDependencies);
        }

        public int hashCode() {
            return Objects.hash(this.myUrl, this.myEntry, this.myRoot, this.myDependencies);
        }

        public String toString() {
            return "JSRemoteModuleState{myUrl='" + this.myUrl + "', myEntry='" + this.myEntry + "', myRoot='" + this.myRoot + "', myDependencies=" + this.myDependencies + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "url";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "entry";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "root";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dependencies";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/modules/remote/JSRemoteModulesRegistry$JSRemoteModuleState";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

