/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.imports.filter;

import com.intellij.lang.javascript.modules.imports.JSImportCandidate;
import com.intellij.lang.javascript.modules.imports.JSImportDescriptor;
import com.intellij.lang.javascript.modules.imports.JSImportExportType;
import com.intellij.lang.javascript.modules.imports.filter.CandidateKey;
import com.intellij.lang.javascript.modules.imports.filter.JSImportCandidatesFilter;
import com.intellij.psi.PsiElement;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/lang/javascript/modules/imports/filter/DuplicatedCandidatesFilter;", "Lcom/intellij/lang/javascript/modules/imports/filter/JSImportCandidatesFilter;", "()V", "acceptedKeys", "", "Lcom/intellij/lang/javascript/modules/imports/filter/CandidateKey;", "accept", "", "candidate", "Lcom/intellij/lang/javascript/modules/imports/JSImportCandidate;", "Factory", "intellij.javascript.impl"})
public final class DuplicatedCandidatesFilter
implements JSImportCandidatesFilter {
    @NotNull
    private Set<CandidateKey> acceptedKeys = new LinkedHashSet();

    @Override
    public boolean accept(@NotNull JSImportCandidate candidate) {
        Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
        PsiElement psiElement = candidate.getElement();
        if (psiElement == null) {
            return true;
        }
        PsiElement element = psiElement;
        JSImportDescriptor jSImportDescriptor = candidate.getDescriptor();
        if (jSImportDescriptor == null) {
            return true;
        }
        JSImportDescriptor descriptor = jSImportDescriptor;
        String string = descriptor.getModuleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getModuleName(...)");
        String newModuleName = string;
        boolean isRelative = StringsKt.startsWith$default((String)newModuleName, (String)".", (boolean)false, (int)2, null);
        JSImportExportType jSImportExportType = descriptor.getImportType();
        Intrinsics.checkNotNullExpressionValue((Object)jSImportExportType, (String)"getImportType(...)");
        CandidateKey key2 = new CandidateKey(element, jSImportExportType, isRelative);
        return this.acceptedKeys.add(key2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/lang/javascript/modules/imports/filter/DuplicatedCandidatesFilter$Factory;", "Lcom/intellij/lang/javascript/modules/imports/filter/JSImportCandidatesFilter$FilterFactory;", "()V", "createFilter", "Lcom/intellij/lang/javascript/modules/imports/filter/JSImportCandidatesFilter;", "candidates", "", "Lcom/intellij/lang/javascript/modules/imports/JSImportCandidate;", "intellij.javascript.impl"})
    public static final class Factory
    implements JSImportCandidatesFilter.FilterFactory {
        @Override
        @Nullable
        public JSImportCandidatesFilter createFilter(@NotNull List<? extends JSImportCandidate> candidates) {
            Intrinsics.checkNotNullParameter(candidates, (String)"candidates");
            return candidates.size() > 1 ? (JSImportCandidatesFilter)new DuplicatedCandidatesFilter() : null;
        }
    }
}

