/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.liveTemplates.typescript;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.javascript.liveTemplates.typescript.JSLiveTemplateContextMigration;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Service(value={Service.Level.APP})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007J\b\u0010\u0007\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/lang/javascript/liveTemplates/typescript/JSLiveTemplateContextMigration;", "", "()V", "isMigrated", "Ljava/util/concurrent/atomic/AtomicBoolean;", "checkAndMigrate", "", "doMigrate", "Companion", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nJSLiveTemplateContextMigration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSLiveTemplateContextMigration.kt\ncom/intellij/lang/javascript/liveTemplates/typescript/JSLiveTemplateContextMigration\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,87:1\n23#2:88\n*S KotlinDebug\n*F\n+ 1 JSLiveTemplateContextMigration.kt\ncom/intellij/lang/javascript/liveTemplates/typescript/JSLiveTemplateContextMigration\n*L\n82#1:88\n*E\n"})
public final class JSLiveTemplateContextMigration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicBoolean isMigrated = new AtomicBoolean(false);
    @NotNull
    private static final String JS_CONTEXTS_MIGRATED_PROPERTY = "js.live.template.contexts.migrated";
    @NotNull
    private static final Lazy<Map<TemplateContextType, TemplateContextType>> contextTypeMap$delegate = LazyKt.lazy((Function0)Companion.contextTypeMap.2.INSTANCE);

    @RequiresReadLock(generateAssertion=false)
    public final void checkAndMigrate() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (ApplicationInfo.getInstance().getBuild().getBaselineVersion() > 241) {
            return;
        }
        if (PropertiesComponent.getInstance().isTrueValue(JS_CONTEXTS_MIGRATED_PROPERTY)) {
            return;
        }
        ProgressManager.getInstance().executeNonCancelableSection(() -> JSLiveTemplateContextMigration.checkAndMigrate$lambda$0(this));
    }

    @VisibleForTesting
    public final void doMigrate() {
        TemplateSettings templateSettings = TemplateSettings.getInstance();
        TemplateImpl[] templateImplArray = templateSettings.getTemplates();
        Intrinsics.checkNotNullExpressionValue((Object)templateImplArray, (String)"getTemplates(...)");
        for (TemplateImpl template : templateImplArray) {
            if (templateSettings.findPluginForPredefinedTemplate(template) != null) continue;
            for (Map.Entry entry : JSLiveTemplateContextMigration.Companion.getContextTypeMap().entrySet()) {
                if (!Intrinsics.areEqual((Object)template.getTemplateContext().getOwnValue((TemplateContextType)entry.getKey()), (Object)true) || template.getTemplateContext().isEnabled((TemplateContextType)entry.getValue())) continue;
                template.getTemplateContext().setEnabled((TemplateContextType)entry.getValue(), true);
                JSLiveTemplateContextMigration $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(JSLiveTemplateContextMigration.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.info(((TemplateContextType)entry.getValue()).getPresentableName() + " context was added to template " + template.getPresentation());
            }
        }
    }

    private static final void checkAndMigrate$lambda$0(JSLiveTemplateContextMigration this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.isMigrated.compareAndSet(false, true)) {
            PropertiesComponent.getInstance().setValue(JS_CONTEXTS_MIGRATED_PROPERTY, true);
            this$0.doMigrate();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R'\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/intellij/lang/javascript/liveTemplates/typescript/JSLiveTemplateContextMigration$Companion;", "", "()V", "JS_CONTEXTS_MIGRATED_PROPERTY", "", "contextTypeMap", "", "Lcom/intellij/codeInsight/template/TemplateContextType;", "getContextTypeMap", "()Ljava/util/Map;", "contextTypeMap$delegate", "Lkotlin/Lazy;", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final Map<TemplateContextType, TemplateContextType> getContextTypeMap() {
            Lazy lazy = contextTypeMap$delegate;
            return (Map)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

