/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterManager;
import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.linter.JSLinterDescriptor;
import com.intellij.lang.javascript.linter.JSLinterGuesser;
import com.intellij.lang.javascript.linter.JSLinterGuesserService;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.JSLintersData;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ReadAndWriteScope;
import com.intellij.openapi.application.ReadConstraint;
import com.intellij.openapi.application.ReadResult;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0003J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014R\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/lang/javascript/linter/JSLinterGuesserService;", "", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getCs", "()Lkotlinx/coroutines/CoroutineScope;", "doGuessLinters", "Lcom/intellij/lang/javascript/linter/JSLintersData;", "descriptor", "Lcom/intellij/lang/javascript/linter/JSLinterDescriptor;", "doLog", "", "enableCase", "Lcom/intellij/lang/javascript/linter/JSLinterGuesser$EnableCase;", "guessAndSetUp", "Lcom/intellij/openapi/application/ReadResult;", "importSettings", "", "guessLinters", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nJSLinterGuesserService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSLinterGuesserService.kt\ncom/intellij/lang/javascript/linter/JSLinterGuesserService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n1549#2:146\n1620#2,3:147\n*S KotlinDebug\n*F\n+ 1 JSLinterGuesserService.kt\ncom/intellij/lang/javascript/linter/JSLinterGuesserService\n*L\n100#1:146\n100#1:147,3\n*E\n"})
public final class JSLinterGuesserService {
    @NotNull
    private final Project project;
    @VisibleForTesting
    @NotNull
    private final CoroutineScope cs;

    public JSLinterGuesserService(@NotNull Project project, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.project = project;
        this.cs = cs;
    }

    @NotNull
    public final CoroutineScope getCs() {
        return this.cs;
    }

    public final void guessLinters(boolean importSettings) {
        if (this.project.isDefault()) {
            return;
        }
        if (Registry.is((String)"javascript.linters.prevent.detection")) {
            JSLinterGuesser.LOG.info("Linters detection disabled");
            return;
        }
        JSLinterGuesser.LOG.debug("Detecting linters for project");
        for (JSLinterDescriptor descriptor : JSLinterDescriptor.EP_NAME.getExtensionList()) {
            BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, descriptor, importSettings, null){
                int label;
                final /* synthetic */ JSLinterGuesserService this$0;
                final /* synthetic */ JSLinterDescriptor $descriptor;
                final /* synthetic */ boolean $importSettings;
                {
                    this.this$0 = $receiver;
                    this.$descriptor = $descriptor;
                    this.$importSettings = $importSettings;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            ReadConstraint[] readConstraintArray = new ReadConstraint[]{ReadConstraint.Companion.inSmartMode(JSLinterGuesserService.access$getProject$p(this.this$0))};
                            this.label = 1;
                            Object object3 = CoroutinesKt.constrainedReadAndWriteAction((ReadConstraint[])readConstraintArray, (Function1)((Function1)new Function1<ReadAndWriteScope, ReadResult<? extends Unit>>(this.this$0, this.$descriptor, this.$importSettings){
                                final /* synthetic */ JSLinterGuesserService this$0;
                                final /* synthetic */ JSLinterDescriptor $descriptor;
                                final /* synthetic */ boolean $importSettings;
                                {
                                    this.this$0 = $receiver;
                                    this.$descriptor = $descriptor;
                                    this.$importSettings = $importSettings;
                                    super(1);
                                }

                                @NotNull
                                public final ReadResult<Unit> invoke(@NotNull ReadAndWriteScope $this$constrainedReadAndWriteAction) {
                                    Intrinsics.checkNotNullParameter((Object)$this$constrainedReadAndWriteAction, (String)"$this$constrainedReadAndWriteAction");
                                    JSLinterDescriptor jSLinterDescriptor = this.$descriptor;
                                    Intrinsics.checkNotNullExpressionValue((Object)jSLinterDescriptor, (String)"$descriptor");
                                    return JSLinterGuesserService.access$guessAndSetUp(this.this$0, jSLinterDescriptor, this.$importSettings);
                                }
                            }), (Continuation)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    private final ReadResult<Unit> guessAndSetUp(JSLinterDescriptor descriptor, boolean importSettings) {
        List<NodePackage> list2;
        JSLintersData linters = this.doGuessLinters(this.project, descriptor);
        if (linters.getEnableCases().isEmpty()) {
            return ReadResult.Companion.value((Object)Unit.INSTANCE);
        }
        String packageName = descriptor.packageName();
        if (packageName == null || linters.getEnableCases().contains((Object)JSLinterGuesser.EnableCase.dependency)) {
            list2 = null;
        } else {
            NodeJsInterpreter interpreter2 = ApplicationManager.getApplication().isUnitTestMode() ? NodeJsInterpreterManager.getInstance(this.project).getInterpreter() : (NodeJsInterpreter)NodeJsLocalInterpreterManager.getInstance().detectMostRelevant();
            list2 = new NodePackageDescriptor(packageName).listAvailable(this.project, interpreter2, this.project.getBaseDir());
        }
        List<NodePackage> available = list2;
        return ReadResult.Companion.writeAction((Function0)new Function0<Unit>(available, descriptor, linters, this, importSettings){
            final /* synthetic */ List<NodePackage> $available;
            final /* synthetic */ JSLinterDescriptor $descriptor;
            final /* synthetic */ JSLintersData $linters;
            final /* synthetic */ JSLinterGuesserService this$0;
            final /* synthetic */ boolean $importSettings;
            {
                this.$available = $available;
                this.$descriptor = $descriptor;
                this.$linters = $linters;
                this.this$0 = $receiver;
                this.$importSettings = $importSettings;
                super(0);
            }

            public final void invoke() {
                if (this.$available != null) {
                    LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
                    Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
                    LocalFileSystem lfs = localFileSystem;
                    Iterator<NodePackage> iterator = this.$available.iterator();
                    while (iterator.hasNext()) {
                        NodePackage nodePackage = iterator.next();
                        if (lfs.refreshAndFindFileByPath(nodePackage.getSystemIndependentPath()) != null) continue;
                        iterator.remove();
                    }
                    if (!this.$available.isEmpty()) {
                        String string = "For %s %s found, and linter in %s.";
                        Object[] objectArray = new Object[]{this.$descriptor.getDisplayName(), CollectionsKt.joinToString$default((Iterable)this.$linters.getEnableCases(), (CharSequence)",\n", null, null, (int)0, null, (Function1)guessAndSetUp.1.INSTANCE, (int)30, null), this.$available.get(0).getSystemDependentPath()};
                        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                        JSLinterGuesser.LOG.info(string2);
                    }
                    if (this.$available.isEmpty()) {
                        return;
                    }
                }
                if (!this.$descriptor.enable(JSLinterGuesserService.access$getProject$p(this.this$0), (Collection<PackageJsonData>)this.$linters.getPackageJsonFiles())) {
                    return;
                }
                JSLinterGuesser.EnableCase enableCase = JSLinterGuesser.EnableCase.select(this.$linters.getEnableCases());
                Intrinsics.checkNotNullExpressionValue((Object)((Object)enableCase), (String)"select(...)");
                JSLinterGuesser.EnableCase selectedCase = enableCase;
                JSLinterGuesserService.access$doLog(this.this$0, JSLinterGuesserService.access$getProject$p(this.this$0), selectedCase, this.$descriptor);
                if (this.$importSettings) {
                    this.$descriptor.importSettings(JSLinterGuesserService.access$getProject$p(this.this$0), selectedCase);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    @RequiresReadLock
    private final JSLintersData doGuessLinters(Project project, JSLinterDescriptor descriptor) {
        String string;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Set<VirtualFile> set = PackageJsonFileManager.getInstance(project).getValidPackageJsonFiles();
        Intrinsics.checkNotNullExpressionValue(set, (String)"getValidPackageJsonFiles(...)");
        Iterable iterable = set;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PackageJsonData.getOrCreate((VirtualFile)it));
        }
        List packageJsonFiles = (List)destination$iv$iv;
        EnumSet<JSLinterGuesser.EnableCase> enumSet = EnumSet.noneOf(JSLinterGuesser.EnableCase.class);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"noneOf(...)");
        Set enableCases = enumSet;
        String packageName = descriptor.packageName();
        if (descriptor.supportsMultipleRoots() || packageJsonFiles.size() == 1) {
            for (PackageJsonData packageJsonFile : packageJsonFiles) {
                if (packageJsonFile.getTopLevelProperties().contains(descriptor.packageJsonSectionName())) {
                    enableCases.add(JSLinterGuesser.EnableCase.configSection);
                }
                if (packageName == null || !packageJsonFile.isDependencyOfAnyType(packageName)) continue;
                enableCases.add(JSLinterGuesser.EnableCase.dependency);
            }
        }
        if (enableCases.isEmpty() && descriptor.hasConfigFiles(project)) {
            enableCases.add(JSLinterGuesser.EnableCase.configFile);
        }
        String string2 = "For %s linter found %s";
        Object[] objectArray = new Object[2];
        objectArray[0] = descriptor.getDisplayName();
        if (enableCases.isEmpty()) {
            string = "<not found>";
        } else {
            String string3 = StringUtil.join((Collection)enableCases, arg_0 -> JSLinterGuesserService.doGuessLinters$lambda$1((Function1)doGuessLinters.1.INSTANCE, arg_0), (String)",");
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"join(...)");
        }
        objectArray[1] = string;
        String string4 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        JSLinterGuesser.LOG.debug(string4);
        return new JSLintersData(packageJsonFiles, enableCases);
    }

    private final void doLog(Project project, JSLinterGuesser.EnableCase enableCase, JSLinterDescriptor descriptor) {
        String message = enableCase.getMessage(descriptor);
        Intrinsics.checkNotNull((Object)message);
        MessageType messageType = MessageType.INFO;
        Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"INFO");
        Object[] objectArray = new Object[]{descriptor.getDisplayName()};
        String string = JavaScriptBundle.message("action.name.disable.category", objectArray);
        JSLinterUtil.NOTIFICATION_GROUP.createNotification(message, messageType).addAction((AnAction)new NotificationAction(descriptor, project, string){
            final /* synthetic */ JSLinterDescriptor $descriptor;
            final /* synthetic */ Project $project;
            {
                this.$descriptor = $descriptor;
                this.$project = $project;
                super($super_call_param$1);
            }

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                JSLinterGuesser.LOG.info(this.$descriptor.getDisplayName() + " disabled by user");
                this.$descriptor.disable(this.$project);
                Object[] objectArray = new Object[]{this.$descriptor.getDisplayName()};
                String string = JavaScriptBundle.message("js.linter.guesser.linter.disabled", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                MessageType messageType = MessageType.INFO;
                Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"INFO");
                JSLinterUtil.NOTIFICATION_GROUP.createNotification(string, messageType).notify(this.$project);
            }
        }).notify(project);
        JSLinterGuesser.LOG.info(message);
    }

    private static final String doGuessLinters$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Project access$getProject$p(JSLinterGuesserService $this) {
        return $this.project;
    }

    public static final /* synthetic */ ReadResult access$guessAndSetUp(JSLinterGuesserService $this, JSLinterDescriptor descriptor, boolean importSettings) {
        return $this.guessAndSetUp(descriptor, importSettings);
    }

    public static final /* synthetic */ void access$doLog(JSLinterGuesserService $this, Project project, JSLinterGuesser.EnableCase enableCase, JSLinterDescriptor descriptor) {
        $this.doLog(project, enableCase, descriptor);
    }
}

