/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library.download;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterManager;
import com.intellij.javascript.nodejs.library.FileIndexExtensionRecursionGuard;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.library.download.JSDownloadManager;
import com.intellij.lang.javascript.library.download.TypeScriptDefinitionFilesRootsProvider;
import com.intellij.lang.javascript.library.download.TypeScriptRelatedPackagesCollector;
import com.intellij.lang.javascript.library.download.TypeScriptRelatedPackagesStorage;
import com.intellij.lang.javascript.library.typings.TypeScriptDefinitionsSyntheticLibrary;
import com.intellij.lang.javascript.library.ui.JSScriptingContextProvider;
import com.intellij.lang.javascript.modules.PackageInstaller;
import com.intellij.lang.typescript.library.download.TypeScriptDefinitionFilesDirectory;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.NavigatableWithText;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.packaging.PackageManagementService;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000f\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/lang/javascript/library/download/TypeScriptDefinitionFilesRootsProvider;", "Lcom/intellij/openapi/roots/AdditionalLibraryRootsProvider;", "()V", "refreshed", "", "buildLibraries", "", "Lcom/intellij/openapi/roots/SyntheticLibrary;", "project", "Lcom/intellij/openapi/project/Project;", "getAdditionalProjectLibraries", "startRefresh", "", "directory", "Lcom/intellij/openapi/vfs/VirtualFile;", "LibraryCreator", "TypesSyntheticLibrary", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nTypeScriptDefinitionFilesRootsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptDefinitionFilesRootsProvider.kt\ncom/intellij/lang/javascript/library/download/TypeScriptDefinitionFilesRootsProvider\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,338:1\n11383#2,9:339\n13309#2:348\n13310#2:350\n11392#2:351\n1#3:349\n1#3:364\n1855#4,2:352\n1603#4,9:354\n1855#4:363\n1856#4:365\n1612#4:366\n*S KotlinDebug\n*F\n+ 1 TypeScriptDefinitionFilesRootsProvider.kt\ncom/intellij/lang/javascript/library/download/TypeScriptDefinitionFilesRootsProvider\n*L\n64#1:339,9\n64#1:348\n64#1:350\n64#1:351\n64#1:349\n89#1:364\n86#1:352,2\n89#1:354,9\n89#1:363\n89#1:365\n89#1:366\n*E\n"})
public final class TypeScriptDefinitionFilesRootsProvider
extends AdditionalLibraryRootsProvider {
    @NotNull
    public static final LibraryCreator LibraryCreator = new LibraryCreator(null);
    private volatile boolean refreshed;

    @NotNull
    public Collection<SyntheticLibrary> getAdditionalProjectLibraries(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Collection collection = (Collection)FileIndexExtensionRecursionGuard.Companion.getInstance(project).computeFileIndexExtensionPreventingRecursion(TypeScriptDefinitionFilesRootsProvider.class, () -> TypeScriptDefinitionFilesRootsProvider.getAdditionalProjectLibraries$lambda$0(this, project));
        if (collection == null) {
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<SyntheticLibrary> buildLibraries(Project project) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNullTo$iv$iv2;
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable();
        Intrinsics.checkNotNullExpressionValue((Object)libraryTable, (String)"getLibraryTable(...)");
        LibraryTable libTable = libraryTable;
        JSLibraryMappings jSLibraryMappings = JSLibraryMappings.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)jSLibraryMappings), (String)"getInstance(...)");
        JSLibraryMappings mappings = jSLibraryMappings;
        Library[] libraryArray = libTable.getLibraries();
        Intrinsics.checkNotNullExpressionValue((Object)libraryArray, (String)"getLibraries(...)");
        Object[] $this$mapNotNull$iv = libraryArray;
        boolean $i$f$mapNotNull = false;
        Object[] objectArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            String string;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            Library it = (Library)element$iv$iv;
            boolean bl2 = false;
            String name = it.getName();
            if (name != null && StringsKt.startsWith$default((String)name, (String)"@types/", (boolean)false, (int)2, null) && mappings.isAssociatedWithProject(name)) {
                String string2 = name.substring(7);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                string = null;
            }
            if (string == null) continue;
            String it$iv$iv = string;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List fileNames2 = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        if (fileNames2.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        VirtualFile virtualFile = TypeScriptDefinitionFilesDirectory.getGlobalTypesDirectory();
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile directory = virtualFile;
        if (!directory.isValid()) {
            if (!this.refreshed) {
                this.startRefresh(directory, project);
            }
            return CollectionsKt.emptyList();
        }
        HashSet<String> result2 = new HashSet<String>(fileNames2);
        TypeScriptRelatedPackagesStorage typeScriptRelatedPackagesStorage = TypeScriptRelatedPackagesStorage.getStorage(project);
        if (typeScriptRelatedPackagesStorage != null) {
            TypeScriptRelatedPackagesStorage storage = typeScriptRelatedPackagesStorage;
            boolean bl = false;
            Iterable $this$forEach$iv = fileNames2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl4 = false;
                result2.addAll(storage.getRelatedPackageNames(directory, it));
            }
        }
        Iterable $this$mapNotNull$iv2 = result2;
        boolean $i$f$mapNotNull2 = false;
        Iterable bl = $this$mapNotNull$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach3 = false;
        Iterator iterator = $this$forEach$iv$iv$iv2.iterator();
        while (iterator.hasNext()) {
            VirtualFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl5 = false;
            String it = (String)element$iv$iv;
            boolean bl6 = false;
            if (directory.findChild(it) == null) continue;
            boolean bl7 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List files2 = CollectionsKt.toList((Iterable)((List)destination$iv$iv2));
        if (files2.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        SyntheticLibrary syntheticLibrary = SyntheticLibrary.newImmutableLibrary((List)files2);
        Intrinsics.checkNotNullExpressionValue((Object)syntheticLibrary, (String)"newImmutableLibrary(...)");
        SyntheticLibrary delegate = syntheticLibrary;
        return CollectionsKt.listOf((Object)((Object)new TypesSyntheticLibrary(delegate)));
    }

    private final void startRefresh(VirtualFile directory, Project project) {
        this.refreshed = true;
        VirtualFile[] virtualFileArray = new VirtualFile[]{directory};
        VfsUtil.markDirty((boolean)true, (boolean)true, (VirtualFile[])virtualFileArray);
        LocalFileSystem.getInstance().refreshFiles((Iterable)CollectionsKt.listOf((Object)directory), true, true, () -> TypeScriptDefinitionFilesRootsProvider.startRefresh$lambda$6(project));
    }

    private static final Collection getAdditionalProjectLibraries$lambda$0(TypeScriptDefinitionFilesRootsProvider this$0, Project $project) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        return this$0.buildLibraries($project);
    }

    private static final void startRefresh$lambda$6$lambda$5(Project $project) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        ProjectRootManagerEx.getInstanceEx((Project)$project).makeRootsChange(EmptyRunnable.getInstance(), RootsChangeRescanningInfo.RESCAN_DEPENDENCIES_IF_NEEDED);
    }

    private static final void startRefresh$lambda$6(Project $project) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        if ($project.isDisposed()) {
            return;
        }
        WriteAction.run(() -> TypeScriptDefinitionFilesRootsProvider.startRefresh$lambda$6$lambda$5($project));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0016\b\u0002\u0010\r\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0004\u0012\u00020\u00040\u000eJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J4\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J*\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ<\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J6\u0010\u001d\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u001f\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u001e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0007\u001a\u00020\bH\u0002J0\u0010\"\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\n\b\u0001\u0010#\u001a\u0004\u0018\u00010!2\b\b\u0001\u0010$\u001a\u00020!H\u0002J\u0018\u0010%\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006&"}, d2={"Lcom/intellij/lang/javascript/library/download/TypeScriptDefinitionFilesRootsProvider$LibraryCreator;", "", "()V", "collectRelatedPackagesAndCreateLibrary", "", "project", "Lcom/intellij/openapi/project/Project;", "description", "Lcom/intellij/util/download/DownloadableFileSetDescription;", "globalTypesDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "onLibraryCreated", "Ljava/lang/Runnable;", "onModelComputed", "Lkotlin/Function1;", "Lcom/intellij/webcore/libraries/ScriptingLibraryModel;", "createRequiredDirectories", "", "file", "Ljava/io/File;", "downloadByUrl", "notificationAreaComponent", "Ljava/awt/Component;", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "downloadTypesLibrary", "downloadUsingNpm", "interpreter", "Lcom/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter;", "getCreateLibraryCallback", "Lcom/intellij/util/Function;", "", "getNameForLibrary", "", "logInstallingError", "message", "dialogTitle", "removeExistingPackageAndRelatedDirectories", "intellij.javascript.impl"})
    @SourceDebugExtension(value={"SMAP\nTypeScriptDefinitionFilesRootsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptDefinitionFilesRootsProvider.kt\ncom/intellij/lang/javascript/library/download/TypeScriptDefinitionFilesRootsProvider$LibraryCreator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,338:1\n1603#2,9:339\n1855#2:348\n1856#2:350\n1612#2:351\n1#3:349\n*S KotlinDebug\n*F\n+ 1 TypeScriptDefinitionFilesRootsProvider.kt\ncom/intellij/lang/javascript/library/download/TypeScriptDefinitionFilesRootsProvider$LibraryCreator\n*L\n280#1:339,9\n280#1:348\n280#1:350\n280#1:351\n280#1:349\n*E\n"})
    public static final class LibraryCreator {
        private LibraryCreator() {
        }

        public final void downloadTypesLibrary(@NotNull Project project, @NotNull DownloadableFileSetDescription description, @Nullable Component notificationAreaComponent, @Nullable Runnable onLibraryCreated) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            ThreadingAssertions.assertEventDispatchThread();
            ModalityState modalityState = ModalityState.current();
            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"current(...)");
            ModalityState modalityState2 = modalityState;
            NodeJsInterpreter projectInterpreter = NodeJsInterpreterManager.getInstance(project).getInterpreter();
            NodeJsLocalInterpreter nodeJsLocalInterpreter = projectInterpreter instanceof NodeJsLocalInterpreter ? (NodeJsLocalInterpreter)projectInterpreter : null;
            if (nodeJsLocalInterpreter == null) {
                nodeJsLocalInterpreter = NodeJsLocalInterpreterManager.getInstance().detectMostRelevant();
            }
            NodeJsLocalInterpreter interpreter2 = nodeJsLocalInterpreter;
            ApplicationManager.getApplication().executeOnPooledThread(() -> LibraryCreator.downloadTypesLibrary$lambda$0(project, description, interpreter2, onLibraryCreated, notificationAreaComponent, modalityState2));
        }

        private final void downloadUsingNpm(DownloadableFileSetDescription description, Project project, NodeJsLocalInterpreter interpreter2, Runnable onLibraryCreated, Component notificationAreaComponent, ModalityState modalityState) {
            String string = TypeScriptDefinitionFilesDirectory.getGlobalTypesTopDirectory();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getGlobalTypesTopDirectory(...)");
            String globalTypesTargetPath = string;
            File file = new File(globalTypesTargetPath);
            if (!this.createRequiredDirectories(file)) {
                String string2 = JavaScriptBundle.message("npm.modules.install.global.types.directory.error", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                String message = string2;
                String string3 = JavaScriptBundle.message("npm.modules.install.global.types.dialog.title", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                String dialogTitle = string3;
                this.logInstallingError(project, notificationAreaComponent, message, dialogTitle);
                return;
            }
            PackageManagementService.Listener listener2 = new PackageManagementService.Listener(project, notificationAreaComponent, description, onLibraryCreated){
                final /* synthetic */ Project $project;
                final /* synthetic */ Component $notificationAreaComponent;
                final /* synthetic */ DownloadableFileSetDescription $description;
                final /* synthetic */ Runnable $onLibraryCreated;
                {
                    this.$project = $project;
                    this.$notificationAreaComponent = $notificationAreaComponent;
                    this.$description = $description;
                    this.$onLibraryCreated = $onLibraryCreated;
                }

                public void operationStarted(@Nullable String packageName) {
                }

                public void operationFinished(@Nullable String packageName, @Nullable PackageManagementService.ErrorDescription errorDescription) {
                    ApplicationManager.getApplication().invokeLater(() -> downloadUsingNpm.listener.1.operationFinished$lambda$1(this.$project, errorDescription, this.$notificationAreaComponent, this.$description, this.$onLibraryCreated));
                }

                private static final VirtualFile operationFinished$lambda$1$lambda$0(File $ioFile) {
                    Intrinsics.checkNotNullParameter((Object)$ioFile, (String)"$ioFile");
                    return VfsUtil.findFileByIoFile((File)$ioFile, (boolean)true);
                }

                private static final void operationFinished$lambda$1(Project $project, PackageManagementService.ErrorDescription $errorDescription, Component $notificationAreaComponent, DownloadableFileSetDescription $description, Runnable $onLibraryCreated) {
                    Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
                    Intrinsics.checkNotNullParameter((Object)$description, (String)"$description");
                    if ($project.isDisposed()) {
                        return;
                    }
                    if ($errorDescription != null) {
                        Object[] objectArray = new Object[]{$errorDescription.getMessage()};
                        String string = JavaScriptBundle.message("node.js.quickfix.install.node.module.error.prefix.text", objectArray);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        String message = string;
                        String string2 = JavaScriptBundle.message("node.js.quickfix.install.node.module.error.no.interpreter.title", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                        String dialogTitle = string2;
                        com.intellij.lang.javascript.library.download.TypeScriptDefinitionFilesRootsProvider$LibraryCreator.access$logInstallingError(TypeScriptDefinitionFilesRootsProvider.LibraryCreator, $project, $notificationAreaComponent, message, dialogTitle);
                        return;
                    }
                    String string = TypeScriptDefinitionFilesDirectory.getGlobalTypesDirectoryPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getGlobalTypesDirectoryPath(...)");
                    String globalTypesDirectoryPath = string;
                    File ioFile = new File(globalTypesDirectoryPath);
                    VirtualFile globalTypesDirectory = (VirtualFile)WriteAction.compute(() -> downloadUsingNpm.listener.1.operationFinished$lambda$1$lambda$0(ioFile));
                    if (globalTypesDirectory == null) {
                        return;
                    }
                    com.intellij.lang.javascript.library.download.TypeScriptDefinitionFilesRootsProvider$LibraryCreator.collectRelatedPackagesAndCreateLibrary$default(TypeScriptDefinitionFilesRootsProvider.LibraryCreator, $project, $description, globalTypesDirectory, $onLibraryCreated, null, 16, null);
                }
            };
            PackageInstaller packageInstaller = new PackageInstaller(project, interpreter2, "@types/" + description.getName(), null, file, listener2, "--ignore-scripts");
            ApplicationManager.getApplication().invokeLater(() -> LibraryCreator.downloadUsingNpm$lambda$1(project, packageInstaller), modalityState);
        }

        private final void removeExistingPackageAndRelatedDirectories(Project project, DownloadableFileSetDescription description) {
            VirtualFile targetPackageDirectory;
            VirtualFile typesDirectory = TypeScriptDefinitionFilesDirectory.getGlobalTypesDirectory();
            if (typesDirectory != null && typesDirectory.isValid() && (targetPackageDirectory = typesDirectory.findChild(description.getName())) != null && targetPackageDirectory.isValid()) {
                TypeScriptRelatedPackagesStorage typeScriptRelatedPackagesStorage = TypeScriptRelatedPackagesStorage.getStorage(project);
                if (typeScriptRelatedPackagesStorage == null) {
                    return;
                }
                TypeScriptRelatedPackagesStorage storage = typeScriptRelatedPackagesStorage;
                Collection<String> collection = storage.getRelatedPackageNames(typesDirectory, description.getName());
                Intrinsics.checkNotNullExpressionValue(collection, (String)"getRelatedPackageNames(...)");
                Collection<String> relatedPackageNames = collection;
                ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(relatedPackageNames, targetPackageDirectory, typesDirectory){
                    final /* synthetic */ Collection<String> $relatedPackageNames;
                    final /* synthetic */ VirtualFile $targetPackageDirectory;
                    final /* synthetic */ VirtualFile $typesDirectory;
                    {
                        this.$relatedPackageNames = $relatedPackageNames;
                        this.$targetPackageDirectory = $targetPackageDirectory;
                        this.$typesDirectory = $typesDirectory;
                        super(0);
                    }

                    public final void invoke() {
                        WriteAction.run(() -> removeExistingPackageAndRelatedDirectories.1.invoke$lambda$3(this.$relatedPackageNames, this.$targetPackageDirectory, this.$typesDirectory));
                    }

                    /*
                     * WARNING - void declaration
                     */
                    private static final void invoke$lambda$3(Collection $relatedPackageNames, VirtualFile $targetPackageDirectory, VirtualFile $typesDirectory) {
                        void $this$filterTo$iv$iv;
                        VirtualFile it;
                        Iterable $this$mapTo$iv$iv;
                        Intrinsics.checkNotNullParameter((Object)$relatedPackageNames, (String)"$relatedPackageNames");
                        Iterable $this$map$iv = $relatedPackageNames;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            String string = (String)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add($typesDirectory.findChild((String)it));
                        }
                        Iterable $this$filter$iv = (List)destination$iv$iv;
                        boolean $i$f$filter = false;
                        $this$mapTo$iv$iv = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (VirtualFile)element$iv$iv;
                            boolean bl = false;
                            if (!(it != null && it.isValid())) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        Iterable $this$forEach$iv = (List)destination$iv$iv;
                        boolean $i$f$forEach = false;
                        for (E element$iv : $this$forEach$iv) {
                            VirtualFile it2 = (VirtualFile)element$iv;
                            boolean bl = false;
                            VirtualFile virtualFile = it2;
                            if (virtualFile == null) continue;
                            virtualFile.delete(null);
                        }
                        $targetPackageDirectory.delete(null);
                    }
                }), (int)1, null);
            }
        }

        public final void collectRelatedPackagesAndCreateLibrary(@NotNull Project project, @NotNull DownloadableFileSetDescription description, @NotNull VirtualFile globalTypesDirectory, @Nullable Runnable onLibraryCreated, @NotNull Function1<? super ScriptingLibraryModel, Unit> onModelComputed) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter((Object)globalTypesDirectory, (String)"globalTypesDirectory");
            Intrinsics.checkNotNullParameter(onModelComputed, (String)"onModelComputed");
            Function<List<File>, ScriptingLibraryModel> callback = this.getCreateLibraryCallback(project, description, onLibraryCreated);
            String string = TypeScriptDefinitionFilesDirectory.getGlobalTypesTargetPath(description.getName());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getGlobalTypesTargetPath(...)");
            String typesTargetPath = string;
            VirtualFile packageDir = (VirtualFile)WriteAction.compute(() -> LibraryCreator.collectRelatedPackagesAndCreateLibrary$lambda$2(typesTargetPath));
            ApplicationManager.getApplication().executeOnPooledThread(() -> LibraryCreator.collectRelatedPackagesAndCreateLibrary$lambda$5(packageDir, globalTypesDirectory, project, description, typesTargetPath, onModelComputed, callback));
        }

        public static /* synthetic */ void collectRelatedPackagesAndCreateLibrary$default(LibraryCreator libraryCreator, Project project, DownloadableFileSetDescription downloadableFileSetDescription, VirtualFile virtualFile, Runnable runnable, Function1 function1, int n, Object object) {
            if ((n & 0x10) != 0) {
                function1 = collectRelatedPackagesAndCreateLibrary.1.INSTANCE;
            }
            libraryCreator.collectRelatedPackagesAndCreateLibrary(project, downloadableFileSetDescription, virtualFile, runnable, (Function1<? super ScriptingLibraryModel, Unit>)function1);
        }

        private final void logInstallingError(Project project, Component notificationAreaComponent, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String dialogTitle) {
            if (notificationAreaComponent != null) {
                Messages.showErrorDialog((Component)notificationAreaComponent, (String)message, (String)dialogTitle);
            } else {
                Messages.showErrorDialog((Project)project, (String)message, (String)dialogTitle);
            }
        }

        private final boolean createRequiredDirectories(File file) {
            if (!file.exists() && !FileUtil.createDirectory((File)file)) {
                return false;
            }
            File nodeModulesDir = new File(file, "node_modules");
            return nodeModulesDir.exists() || FileUtil.createDirectory((File)nodeModulesDir);
        }

        /*
         * WARNING - void declaration
         */
        private final void downloadByUrl(DownloadableFileSetDescription description, Project project, Runnable onLibraryCreated, Component notificationAreaComponent, ModalityState modalityState) {
            try {
                void $this$mapNotNullTo$iv$iv;
                List list2 = description.getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getFiles(...)");
                Iterable $this$mapNotNull$iv = list2;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    String it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    DownloadableFileDescription it = (DownloadableFileDescription)element$iv$iv;
                    boolean bl2 = false;
                    if (it.getDownloadUrl() == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List urls2 = (List)destination$iv$iv;
                Function<List<File>, ScriptingLibraryModel> callback = this.getCreateLibraryCallback(project, description, onLibraryCreated);
                ApplicationManager.getApplication().invokeLater(() -> LibraryCreator.downloadByUrl$lambda$8(project, urls2, notificationAreaComponent, description, callback), modalityState);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private final Function<List<File>, ScriptingLibraryModel> getCreateLibraryCallback(Project project, DownloadableFileSetDescription description, Runnable onLibraryCreated) {
            return arg_0 -> LibraryCreator.getCreateLibraryCallback$lambda$10(description, project, onLibraryCreated, arg_0);
        }

        private final String getNameForLibrary(DownloadableFileSetDescription description) {
            return description.getVersionString() + "/" + description.getName();
        }

        private static final void downloadTypesLibrary$lambda$0(Project $project, DownloadableFileSetDescription $description, NodeJsLocalInterpreter $interpreter, Runnable $onLibraryCreated, Component $notificationAreaComponent, ModalityState $modalityState) {
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            Intrinsics.checkNotNullParameter((Object)$description, (String)"$description");
            Intrinsics.checkNotNullParameter((Object)$modalityState, (String)"$modalityState");
            LibraryCreator.removeExistingPackageAndRelatedDirectories($project, $description);
            if ($interpreter != null && $interpreter.isValid()) {
                LibraryCreator.downloadUsingNpm($description, $project, $interpreter, $onLibraryCreated, $notificationAreaComponent, $modalityState);
            } else {
                LibraryCreator.downloadByUrl($description, $project, $onLibraryCreated, $notificationAreaComponent, $modalityState);
            }
        }

        private static final void downloadUsingNpm$lambda$1(Project $project, PackageInstaller $packageInstaller) {
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            Intrinsics.checkNotNullParameter((Object)((Object)$packageInstaller), (String)"$packageInstaller");
            if ($project.isDisposed()) {
                return;
            }
            ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)$packageInstaller, (ProgressIndicator)new BackgroundableProcessIndicator((Task.Backgroundable)$packageInstaller));
        }

        private static final VirtualFile collectRelatedPackagesAndCreateLibrary$lambda$2(String $typesTargetPath) {
            Intrinsics.checkNotNullParameter((Object)$typesTargetPath, (String)"$typesTargetPath");
            return VfsUtil.findFileByIoFile((File)new File($typesTargetPath), (boolean)true);
        }

        private static final void collectRelatedPackagesAndCreateLibrary$lambda$5$lambda$4(Set $relatedPackages, Project $project, VirtualFile $globalTypesDirectory, DownloadableFileSetDescription $description, String $typesTargetPath, Function1 $onModelComputed, Function $callback) {
            Intrinsics.checkNotNullParameter((Object)$relatedPackages, (String)"$relatedPackages");
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            Intrinsics.checkNotNullParameter((Object)$globalTypesDirectory, (String)"$globalTypesDirectory");
            Intrinsics.checkNotNullParameter((Object)$description, (String)"$description");
            Intrinsics.checkNotNullParameter((Object)$typesTargetPath, (String)"$typesTargetPath");
            Intrinsics.checkNotNullParameter((Object)$onModelComputed, (String)"$onModelComputed");
            Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
            if (!((Collection)$relatedPackages).isEmpty()) {
                TypeScriptRelatedPackagesStorage typeScriptRelatedPackagesStorage = TypeScriptRelatedPackagesStorage.getStorage($project);
                if (typeScriptRelatedPackagesStorage != null) {
                    typeScriptRelatedPackagesStorage.writeData($globalTypesDirectory, $description.getName(), $relatedPackages);
                }
            }
            File packageFile = new File($typesTargetPath);
            $onModelComputed.invoke($callback.fun((Object)CollectionsKt.listOf((Object)packageFile)));
        }

        private static final void collectRelatedPackagesAndCreateLibrary$lambda$5(VirtualFile $packageDir, VirtualFile $globalTypesDirectory, Project $project, DownloadableFileSetDescription $description, String $typesTargetPath, Function1 $onModelComputed, Function $callback) {
            Set<String> set;
            Set<String> set2;
            Intrinsics.checkNotNullParameter((Object)$globalTypesDirectory, (String)"$globalTypesDirectory");
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            Intrinsics.checkNotNullParameter((Object)$description, (String)"$description");
            Intrinsics.checkNotNullParameter((Object)$typesTargetPath, (String)"$typesTargetPath");
            Intrinsics.checkNotNullParameter((Object)$onModelComputed, (String)"$onModelComputed");
            Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
            VirtualFile virtualFile = $packageDir;
            if (virtualFile != null) {
                VirtualFile it = virtualFile;
                boolean bl = false;
                set2 = new TypeScriptRelatedPackagesCollector($packageDir, $globalTypesDirectory).collectShortPackageNames();
            } else {
                set2 = set = null;
            }
            if (set2 == null) {
                set = SetsKt.emptySet();
            }
            Set<String> relatedPackages = set;
            ApplicationManager.getApplication().invokeLater(() -> LibraryCreator.collectRelatedPackagesAndCreateLibrary$lambda$5$lambda$4(relatedPackages, $project, $globalTypesDirectory, $description, $typesTargetPath, $onModelComputed, $callback));
        }

        private static final void downloadByUrl$lambda$8$lambda$7(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        private static final void downloadByUrl$lambda$8(Project $project, List $urls, Component $notificationAreaComponent, DownloadableFileSetDescription $description, Function $callback) {
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            Intrinsics.checkNotNullParameter((Object)$urls, (String)"$urls");
            Intrinsics.checkNotNullParameter((Object)$description, (String)"$description");
            Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
            String string = TypeScriptDefinitionFilesDirectory.getGlobalTypesTargetPath($description.getName());
            JSScriptingContextProvider.doDownload($project, CollectionsKt.toMutableList((Collection)new LinkedHashSet($urls)), JavaScriptBundle.message("progress.title.downloading.typings", new Object[0]), $notificationAreaComponent, (Consumer<? super List<File>>)((Consumer)arg_0 -> LibraryCreator.downloadByUrl$lambda$8$lambda$7((Function1)new Function1<List<File>, Unit>((Function<List<File>, ScriptingLibraryModel>)$callback){
                final /* synthetic */ Function<List<File>, ScriptingLibraryModel> $callback;
                {
                    this.$callback = $callback;
                    super(1);
                }

                public final void invoke(List<File> it) {
                    this.$callback.fun(it);
                }
            }, arg_0)), new JSDownloadManager(string){

                @NotNull
                protected String getResultFileName(@NotNull String location, @NotNull String extension, boolean adjustLocation) {
                    CharSequence charSequence;
                    Intrinsics.checkNotNullParameter((Object)location, (String)"location");
                    Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                    String string = PathUtil.getFileName((String)location);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
                    CharSequence charSequence2 = string;
                    if (charSequence2.length() == 0) {
                        boolean bl = false;
                        charSequence = extension;
                    } else {
                        charSequence = charSequence2;
                    }
                    return (String)charSequence;
                }
            });
        }

        private static final ScriptingLibraryModel getCreateLibraryCallback$lambda$10$lambda$9(DownloadableFileSetDescription $description, Project $project, Runnable $onLibraryCreated) {
            ScriptingLibraryModel result2;
            block1: {
                Intrinsics.checkNotNullParameter((Object)$description, (String)"$description");
                Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
                ThreadingAssertions.assertEventDispatchThread();
                String libName = LibraryCreator.getNameForLibrary($description);
                JSLibraryManager jSLibraryManager = JSLibraryManager.getInstance($project);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)jSLibraryManager), (String)"getInstance(...)");
                JSLibraryManager libraryManager = jSLibraryManager;
                LibraryTable libraryTable = libraryManager.getLibraryTable(ScriptingLibraryModel.LibraryLevel.GLOBAL);
                Intrinsics.checkNotNullExpressionValue((Object)libraryTable, (String)"getLibraryTable(...)");
                LibraryTable libTable = libraryTable;
                if (libTable.getLibraryByName(libName) != null) {
                    return null;
                }
                ScriptingLibraryModel scriptingLibraryModel = libraryManager.createLibrary(libName, VirtualFile.EMPTY_ARRAY, VirtualFile.EMPTY_ARRAY, ArrayUtil.EMPTY_STRING_ARRAY, ScriptingLibraryModel.LibraryLevel.GLOBAL, false);
                Intrinsics.checkNotNullExpressionValue((Object)scriptingLibraryModel, (String)"createLibrary(...)");
                result2 = scriptingLibraryModel;
                JSLibraryMappings jSLibraryMappings = JSLibraryMappings.getInstance($project);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)jSLibraryMappings), (String)"getInstance(...)");
                JSLibraryMappings mappings = jSLibraryMappings;
                mappings.associate(null, libName, false);
                libraryManager.commitChanges(RootsChangeRescanningInfo.RESCAN_DEPENDENCIES_IF_NEEDED);
                Runnable runnable = $onLibraryCreated;
                if (runnable == null) break block1;
                runnable.run();
            }
            return result2;
        }

        private static final ScriptingLibraryModel getCreateLibraryCallback$lambda$10(DownloadableFileSetDescription $description, Project $project, Runnable $onLibraryCreated, List list2) {
            Intrinsics.checkNotNullParameter((Object)$description, (String)"$description");
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            if (list2.isEmpty()) {
                return null;
            }
            return (ScriptingLibraryModel)WriteAction.compute(() -> LibraryCreator.getCreateLibraryCallback$lambda$10$lambda$9($description, $project, $onLibraryCreated));
        }

        public static final /* synthetic */ void access$logInstallingError(LibraryCreator $this, Project project, Component notificationAreaComponent, String message, String dialogTitle) {
            $this.logInstallingError(project, notificationAreaComponent, message, dialogTitle);
        }

        public /* synthetic */ LibraryCreator(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\nH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/lang/javascript/library/download/TypeScriptDefinitionFilesRootsProvider$TypesSyntheticLibrary;", "Lcom/intellij/lang/javascript/library/typings/TypeScriptDefinitionsSyntheticLibrary;", "Lcom/intellij/navigation/ItemPresentation;", "Lcom/intellij/pom/NavigatableWithText;", "delegateLibrary", "Lcom/intellij/openapi/roots/SyntheticLibrary;", "(Lcom/intellij/openapi/roots/SyntheticLibrary;)V", "getIcon", "Ljavax/swing/Icon;", "unused", "", "getLocationString", "", "getNavigateActionText", "focusEditor", "getPresentableText", "intellij.javascript.impl"})
    public static final class TypesSyntheticLibrary
    extends TypeScriptDefinitionsSyntheticLibrary
    implements ItemPresentation,
    NavigatableWithText {
        public TypesSyntheticLibrary(@NotNull SyntheticLibrary delegateLibrary) {
            Intrinsics.checkNotNullParameter((Object)delegateLibrary, (String)"delegateLibrary");
            super("TypesSyntheticLibrary", delegateLibrary);
        }

        @Nullable
        public String getNavigateActionText(boolean focusEditor) {
            return null;
        }

        @NotNull
        public String getPresentableText() {
            return "Global @types/*";
        }

        @NotNull
        public String getLocationString() {
            return "";
        }

        @Nullable
        public Icon getIcon(boolean unused) {
            return null;
        }
    }
}

