/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.library.JSImplicitLibrarySearchScope;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSPredefinedLibraryManager;
import com.intellij.lang.javascript.library.JSPredefinedLibraryMappings;
import com.intellij.lang.javascript.library.JSSyntheticLibraryProvider;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.library.download.TypeScriptDefinitionFilesDirectory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModelBackedBySyntheticLibrary;
import com.intellij.webcore.libraries.ScriptingLibraryUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="JavaScriptLibraryMappings", storages={@Storage(value="jsLibraryMappings.xml")})
public final class JSLibraryMappings
extends ScriptingLibraryMappings {
    static final String COMPONENT_NAME = "JavaScriptLibraryMappings";
    @Nullable
    private volatile JSLibraryManager myManager;
    @NotNull
    private final JSPredefinedLibraryMappings myPredefinedLibraryMappings;
    private JSImplicitLibrarySearchScope myImplicitLibrarySearchScope;

    public JSLibraryMappings(@NotNull Project project) {
        if (project == null) {
            JSLibraryMappings.$$$reportNull$$$0(0);
        }
        super(project);
        this.myPredefinedLibraryMappings = new JSPredefinedLibraryMappings(project);
    }

    @NotNull
    protected JSLibraryManager getLibraryManager() {
        JSLibraryManager manager = this.myManager;
        if (manager != null) {
            JSLibraryManager jSLibraryManager = manager;
            if (jSLibraryManager == null) {
                JSLibraryMappings.$$$reportNull$$$0(1);
            }
            return jSLibraryManager;
        }
        this.myManager = manager = JSLibraryManager.getInstance(this.getProject());
        JSLibraryManager jSLibraryManager = manager;
        if (jSLibraryManager == null) {
            JSLibraryMappings.$$$reportNull$$$0(2);
        }
        return jSLibraryManager;
    }

    public void noStateLoaded() {
        this.myPredefinedLibraryMappings.setMissingPredefinedLibraries(this, false);
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            JSLibraryMappings.$$$reportNull$$$0(3);
        }
        this.setMapping(null, null);
        super.loadState(state);
        this.myPredefinedLibraryMappings.loadState(this, state);
    }

    public Element getState() {
        Element e = super.getState();
        assert (e != null);
        this.myPredefinedLibraryMappings.fillState(this, e);
        return e;
    }

    public void updateMappings() {
        super.updateMappings();
        this.myPredefinedLibraryMappings.updateMappings(this);
    }

    protected void onAssociationsUpdated() {
        this.myPredefinedLibraryMappings.updateLibraryStates(this);
    }

    @NotNull
    public static JSLibraryMappings getInstance(@NotNull Project project) {
        if (project == null) {
            JSLibraryMappings.$$$reportNull$$$0(4);
        }
        JSLibraryMappings jSLibraryMappings = (JSLibraryMappings)((Object)project.getService(ScriptingLibraryMappings.class));
        if (jSLibraryMappings == null) {
            JSLibraryMappings.$$$reportNull$$$0(5);
        }
        return jSLibraryMappings;
    }

    @NotNull
    private JSImplicitLibrarySearchScope getImplicitLibrarySearchScope() {
        if (this.myImplicitLibrarySearchScope == null) {
            this.myImplicitLibrarySearchScope = JSImplicitLibrarySearchScope.createImplicitLibrarySearchScope(this.getProject(), (Disposable)this);
        }
        JSImplicitLibrarySearchScope jSImplicitLibrarySearchScope = this.myImplicitLibrarySearchScope;
        if (jSImplicitLibrarySearchScope == null) {
            JSLibraryMappings.$$$reportNull$$$0(6);
        }
        return jSImplicitLibrarySearchScope;
    }

    @NotNull
    public GlobalSearchScope getLibraryScopeForFileWithoutPredefined(@NotNull VirtualFile file, @NotNull Set<VirtualFile> includedFiles, @NotNull Set<VirtualFile> excludedFiles) {
        if (file == null) {
            JSLibraryMappings.$$$reportNull$$$0(7);
        }
        if (includedFiles == null) {
            JSLibraryMappings.$$$reportNull$$$0(8);
        }
        if (excludedFiles == null) {
            JSLibraryMappings.$$$reportNull$$$0(9);
        }
        HashSet<VirtualFile> files2 = new HashSet<VirtualFile>(includedFiles);
        HashSet<VirtualFile> syntheticLibraryRoots = new HashSet<VirtualFile>();
        this.forEachLibraryInScopeForFile(file, model -> {
            if (model instanceof ScriptingLibraryModelBackedBySyntheticLibrary) {
                syntheticLibraryRoots.addAll(((ScriptingLibraryModelBackedBySyntheticLibrary)model).getResolveRoots());
            } else {
                model.addSignificantFiles((Collection)files2);
            }
        });
        syntheticLibraryRoots.addAll(this.getJSSyntheticLibraryRoots());
        VirtualFile globalTypesRoot = TypeScriptDefinitionFilesDirectory.getGlobalTypesDirectory();
        if (globalTypesRoot != null) {
            syntheticLibraryRoots.add(globalTypesRoot);
        }
        files2.removeAll(excludedFiles);
        syntheticLibraryRoots.removeAll(excludedFiles);
        Project project = this.getProject();
        GlobalSearchScope scope2 = ScriptingLibraryUtil.getFilesAndDirectoriesScope((Project)project, files2);
        GlobalSearchScope implicitLibrariesScope = ScriptingLibraryUtil.getFilesAndDirectoriesScope((Project)project, syntheticLibraryRoots).union((SearchScope)this.getImplicitLibrarySearchScope());
        scope2 = scope2.union((SearchScope)ProjectScope.getLibrariesScope((Project)project).intersectWith(implicitLibrariesScope));
        Set<VirtualFile> customLibs = TypeScriptLibraryProvider.getService(project).getAllCustomLibraries();
        if (!customLibs.isEmpty()) {
            scope2 = scope2.intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)GlobalSearchScope.filesScope((Project)project, customLibs)));
        }
        GlobalSearchScope globalSearchScope = scope2;
        if (globalSearchScope == null) {
            JSLibraryMappings.$$$reportNull$$$0(10);
        }
        return globalSearchScope;
    }

    @NotNull
    private Collection<VirtualFile> getJSSyntheticLibraryRoots() {
        Collection collection = AdditionalLibraryRootsProvider.EP_NAME.getExtensionList().stream().filter(el -> el instanceof JSSyntheticLibraryProvider).flatMap(el -> el.getAdditionalProjectLibraries(this.getProject()).stream()).flatMap(el -> el.getSourceRoots().stream()).collect(Collectors.toList());
        if (collection == null) {
            JSLibraryMappings.$$$reportNull$$$0(11);
        }
        return collection;
    }

    @NotNull
    public GlobalSearchScope getLibraryScopeForFile(@NotNull VirtualFile file) {
        if (file == null) {
            JSLibraryMappings.$$$reportNull$$$0(12);
        }
        JSLanguageLevel level = DialectDetector.getConfiguredJSLevel(file, this.getProject());
        Set<VirtualFile> predefinedFiles = JSPredefinedLibraryManager.getPredefinedLibraryManager(this.getProject()).getRequiredLibraryFilesForResolve(level);
        GlobalSearchScope globalSearchScope = this.getLibraryScopeForFileWithoutPredefined(file, predefinedFiles, Collections.emptySet());
        if (globalSearchScope == null) {
            JSLibraryMappings.$$$reportNull$$$0(13);
        }
        return globalSearchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 5, 6, 10, 11, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/library/JSLibraryMappings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includedFiles";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/library/JSLibraryMappings";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitLibrarySearchScope";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryScopeForFileWithoutPredefined";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSSyntheticLibraryRoots";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryScopeForFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 13: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryScopeForFileWithoutPredefined";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryScopeForFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 5, 6, 10, 11, 13 -> new IllegalStateException(string);
        };
    }
}

