/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import kotlin.NotImplementedError;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JSSeparateDigitsIntention
extends JavaScriptIntention {
    @IntentionName
    private String myText = JavaScriptBundle.message("js.separate.digits", new Object[0]);

    private static int getComplicatedPartIndex(String text2) {
        return StringUtil.indexOfAny((String)text2, (String)"eE.");
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        boolean available;
        if (project == null) {
            JSSeparateDigitsIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JSSeparateDigitsIntention.$$$reportNull$$$0(1);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        PsiElement parent = element.getParent();
        boolean bl = available = parent instanceof JSLiteralExpression && ((JSLiteralExpression)parent).isNumericLiteral() && (DialectDetector.isES6(element) || DialectDetector.isTypeScript(element));
        if (!available) {
            return false;
        }
        String text2 = parent.getText();
        if (text2.indexOf(95) != -1) {
            return false;
        }
        LiteralKind kind = LiteralKind.fromLiteralText(text2);
        if (kind.isUnsupported()) {
            return false;
        }
        if (kind == LiteralKind.ComplicatedDec) {
            int index = JSSeparateDigitsIntention.getComplicatedPartIndex(text2);
            assert (index != -1);
            text2 = text2.substring(0, index);
        }
        if (text2.length() - kind.getStartOffset() <= kind.getSeparationSize()) {
            return false;
        }
        this.myText = JavaScriptBundle.message(kind.getBundleId(), new Object[0]);
        return true;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            JSSeparateDigitsIntention.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSSeparateDigitsIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            JSSeparateDigitsIntention.$$$reportNull$$$0(4);
        }
        PsiElement parent = element.getParent();
        assert (parent instanceof JSLiteralExpression);
        String text2 = parent.getText();
        LiteralKind literalKind = LiteralKind.fromLiteralText(text2);
        JSLiteralExpression result2 = JSSeparateDigitsIntention.transform(text2, literalKind, parent);
        ((JSLiteralExpression)parent).replace(result2);
    }

    private static JSLiteralExpression transform(String text2, LiteralKind kind, PsiElement context2) {
        String postfix = "";
        if (kind == LiteralKind.ComplicatedDec) {
            int index = JSSeparateDigitsIntention.getComplicatedPartIndex(text2);
            assert (index != -1);
            postfix = text2.substring(index);
            text2 = text2.substring(0, index);
        }
        int offset = text2.startsWith("-") ? 1 : 0;
        String prefix = text2.substring(0, offset += kind.getStartOffset());
        StringBuilder newString = new StringBuilder();
        int j = 0;
        for (int i = text2.length() - 1; i > offset; --i) {
            newString.insert(0, text2.charAt(i));
            if (++j % kind.getSeparationSize() != 0) continue;
            newString.insert(0, '_');
        }
        newString.insert(0, text2.charAt(offset));
        newString.insert(0, prefix);
        newString.append(postfix);
        return JSPsiElementFactory.createJSExpression(newString.toString(), context2, JSLiteralExpression.class);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("js.separate.digits", new Object[0]);
        if (string == null) {
            JSSeparateDigitsIntention.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSSeparateDigitsIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSSeparateDigitsIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5 -> new IllegalStateException(string);
        };
    }

    static enum LiteralKind {
        Boolean,
        LargeBoolean,
        Hex,
        LargeHex,
        Dec,
        Oct,
        ObsoleteOct,
        ComplicatedDec;


        public static LiteralKind fromLiteralText(String text2) {
            if (text2.startsWith("0b")) {
                return text2.length() - 2 > 16 ? LargeBoolean : Boolean;
            }
            if (text2.startsWith("0x")) {
                return text2.length() - 2 > 8 ? LargeHex : Hex;
            }
            if (text2.startsWith("0o")) {
                return Oct;
            }
            if (text2.length() >= 2 && text2.charAt(0) == '\u0000' && StringUtil.isOctalDigit((char)text2.charAt(1))) {
                return ObsoleteOct;
            }
            return JSSeparateDigitsIntention.getComplicatedPartIndex(text2) != -1 ? ComplicatedDec : Dec;
        }

        public String getBundleId() {
            return switch (this) {
                case Boolean -> "js.separate.nibbles";
                case LargeBoolean -> "js.separate.bytes";
                case Hex -> "js.separate.bytes";
                case LargeHex -> "js.separate.words";
                case Dec -> "js.separate.thousands";
                case ComplicatedDec -> "js.separate.thousands.in.integer.part";
                default -> throw new NotImplementedError(this.toString());
            };
        }

        public int getStartOffset() {
            return switch (this) {
                case Boolean, LargeBoolean, Hex, LargeHex -> 2;
                case Dec, ComplicatedDec -> 0;
                default -> throw new NotImplementedError(this.toString());
            };
        }

        public int getSeparationSize() {
            return switch (this) {
                case Boolean -> 4;
                case LargeBoolean -> 8;
                case Hex -> 2;
                case LargeHex -> 4;
                case Dec, ComplicatedDec -> 3;
                default -> throw new NotImplementedError(this.toString());
            };
        }

        public boolean isUnsupported() {
            return this == Oct || this == ObsoleteOct;
        }
    }
}

