/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.evaluation.JSParameterTypeInferrer;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSInferParametersIntention
extends JavaScriptIntention
implements LowPriorityAction {
    @IntentionName
    private String myText = JavaScriptBundle.message("js.infer.parameter.types.intention", new Object[0]);

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSInferParametersIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JSInferParametersIntention.$$$reportNull$$$0(1);
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)element.getContainingFile())) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)JavaScriptBundle.message("js.infer.parameter.types.intention.failure.readonly.text", new Object[0]), (String)JavaScriptBundle.message("js.infer.parameter.types.intention.failure.title", new Object[0]), null);
            return;
        }
        Pair<JSFunction, JSCallLikeExpression> pair = JSInferParametersIntention.findSignature(element);
        assert (pair != null);
        JSFunction signature = (JSFunction)pair.first;
        Ref inferredTypesRef = Ref.create();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> inferredTypesRef.set(JSParameterTypeInferrer.inferTypes(signature))), JavaScriptBundle.message("js.infer.parameter.types.intention.progress.text", new Object[0]), true, project);
        Map inferredTypes = (Map)inferredTypesRef.get();
        if (inferredTypes == null) {
            return;
        }
        boolean hasAny = false;
        for (JSParameterTypeInferrer.JSInferredParameterType type2 : inferredTypes.values()) {
            if (type2 == null || type2.type instanceof JSAnyType) continue;
            hasAny = true;
            break;
        }
        if (!hasAny) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)JavaScriptBundle.message("js.infer.parameter.types.intention.failure.text", new Object[0]), (String)JavaScriptBundle.message("js.infer.parameter.types.intention.failure.title", new Object[0]), null);
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> JSInferParametersIntention.setInferredTypes(signature, inferredTypes));
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static void setInferredTypes(@NotNull JSFunction signature, @NotNull Map<JSParameterListElement, JSParameterTypeInferrer.JSInferredParameterType> inferredTypes) {
        JSParameterList newList;
        if (signature == null) {
            JSInferParametersIntention.$$$reportNull$$$0(2);
        }
        if (inferredTypes == null) {
            JSInferParametersIntention.$$$reportNull$$$0(3);
        }
        boolean hasTypes = DialectDetector.hasFeature(signature, JSLanguageFeature.TYPES);
        Object[] parameters = signature.getParameters();
        JSParameterTypeInferrer.JSInferredParameterType[] inferredTypesArray = (JSParameterTypeInferrer.JSInferredParameterType[])ContainerUtil.map2Array((Object[])parameters, JSParameterTypeInferrer.JSInferredParameterType.class, p -> (JSParameterTypeInferrer.JSInferredParameterType)inferredTypes.get(p));
        JSParameterList oldList = signature.getParameterList();
        JSParameterList jSParameterList = newList = oldList == null ? null : JSChangeSignatureUtil.addParenthesesIfNeeded(oldList);
        if (newList != oldList) {
            parameters = newList.getParameters();
        }
        for (int i = 0; i < inferredTypesArray.length; ++i) {
            JSParameterTypeInferrer.JSInferredParameterType inferredType = inferredTypesArray[i];
            if (inferredType == null) continue;
            JSType type2 = inferredType.type;
            JSParameter parameter = (JSParameter)parameters[i];
            PsiElement typeAnchor = parameter.getNameIdentifier();
            PsiElement nextOne = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)typeAnchor);
            if (PsiUtilCore.getElementType((PsiElement)nextOne) == JSTokenTypes.QUEST) {
                typeAnchor = nextOne;
            }
            if (inferredType.tooManyOptions) {
                type2 = JSAnyType.get(type2.getSource());
            } else if (!hasTypes) {
                type2 = type2.transformTypeHierarchy((Function<? super JSType, ? extends JSType>)((Function)t -> t instanceof JSAnyType && !t.isJavaScript() ? JSAnyType.getWithLanguage(JSTypeSource.SourceLanguage.JS) : t));
            }
            String typeText = type2.getTypeText(JSType.TypeTextFormat.CODE);
            if (hasTypes) {
                PsiElement colon = parameter.addAfter(JSChangeUtil.createTokenElement(signature, JSTokenTypes.COLON, ":"), typeAnchor);
                parameter.addAfter(Objects.requireNonNull(JSChangeUtil.tryCreateTypeElement(typeText, signature)), colon);
                continue;
            }
            String tagText = "param {" + typeText + "} " + parameter.getName();
            JSDocumentationUtils.createOrUpdateTagsInDocComment(signature, Collections.singletonList(tagText), Collections.emptyMap(), Collections.emptySet());
        }
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("js.infer.parameter.types.intention", new Object[0]);
        if (string == null) {
            JSInferParametersIntention.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            JSInferParametersIntention.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            JSInferParametersIntention.$$$reportNull$$$0(6);
        }
        if (element == null) {
            JSInferParametersIntention.$$$reportNull$$$0(7);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        this.myText = DialectDetector.hasFeature(element, JSLanguageFeature.TYPES) ? JavaScriptBundle.message("js.infer.parameter.types.intention", new Object[0]) : JavaScriptBundle.message("js.infer.parameter.types.intention.jsdoc", new Object[0]);
        Pair<JSFunction, JSCallLikeExpression> signature = JSInferParametersIntention.findSignature(element);
        if (signature == null) {
            return false;
        }
        if (ContainerUtil.and((Object[])((JSFunction)signature.first).getParameters(), p -> JSParameterTypeInferrer.hasTypeElement(p))) {
            return false;
        }
        for (JSParameterListElement parameter : ((JSFunction)signature.first).getParameters()) {
            SearchScope scope2 = parameter.getUseScope();
            if (scope2 instanceof LocalSearchScope) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static Pair<JSFunction, JSCallLikeExpression> findSignature(@NotNull PsiElement element) {
        JSElement parent;
        if (element == null) {
            JSInferParametersIntention.$$$reportNull$$$0(8);
        }
        if ((parent = JSInferParametersIntention.findParent(element)) instanceof JSParameter) {
            parent = JSInferParametersIntention.findParent((PsiElement)parent);
        }
        if (parent instanceof JSFunction) {
            if (PsiTreeUtil.isAncestor((PsiElement)((JSFunction)parent).getBlock(), (PsiElement)element, (boolean)true)) {
                return null;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)JSPsiImplUtils.tryGetArrowFunctionReturnExpression((JSFunction)parent), (PsiElement)element, (boolean)true)) {
                return null;
            }
        }
        if (parent instanceof JSParameterList) {
            return JSInferParametersIntention.getForParameterList((JSParameterList)parent);
        }
        if (parent instanceof JSCallLikeExpression && DialectDetector.hasFeature((PsiElement)parent, JSLanguageFeature.TYPES)) {
            JSExpression methodExpression = ((JSCallLikeExpression)parent).getMethodExpression();
            if (methodExpression instanceof JSReferenceExpression) {
                JSFunction constructor;
                PsiElement resolve2 = ((JSReferenceExpression)methodExpression).resolve();
                if (resolve2 instanceof JSFunction) {
                    return Pair.create((Object)((JSFunction)resolve2), (Object)((JSCallLikeExpression)parent));
                }
                if (resolve2 instanceof JSInitializerOwner) {
                    JSExpression initializer = ((JSInitializerOwner)resolve2).getInitializerOrStub();
                    if (initializer instanceof JSFunction) {
                        return Pair.create((Object)((JSFunction)((Object)initializer)), (Object)((JSCallLikeExpression)parent));
                    }
                } else if (parent instanceof JSNewExpression && resolve2 instanceof JSClass && (constructor = ((JSClass)resolve2).getConstructor()) != null) {
                    return Pair.create((Object)constructor, (Object)((JSCallLikeExpression)parent));
                }
            }
        } else {
            JSExpression initializer;
            if (parent instanceof JSFunction) {
                return JSInferParametersIntention.getForParameterList(((JSFunction)parent).getParameterList());
            }
            if (parent instanceof JSInitializerOwner && (initializer = ((JSInitializerOwner)parent).getInitializerOrStub()) instanceof JSFunction) {
                return JSInferParametersIntention.getForParameterList(((JSFunction)((Object)initializer)).getParameterList());
            }
        }
        return null;
    }

    @Nullable
    private static JSElement findParent(@NotNull PsiElement element) {
        if (element == null) {
            JSInferParametersIntention.$$$reportNull$$$0(9);
        }
        return (JSElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JSParameterList.class, JSCallLikeExpression.class, JSFunction.class, JSInitializerOwner.class});
    }

    @Nullable
    private static Pair<JSFunction, JSCallLikeExpression> getForParameterList(@Nullable JSParameterList parent) {
        if (parent == null) {
            return null;
        }
        boolean hasTypes = DialectDetector.hasFeature((PsiElement)parent, JSLanguageFeature.TYPES);
        for (JSParameterListElement parameter : parent.getParameters()) {
            JSFunction function2;
            if (!(parameter instanceof JSParameter) || JSParameterTypeInferrer.hasTypeElement(parameter) || !hasTypes && JSDocumentationUtils.getParameterTypeFromPrecedingComment((JSParameter)parameter) != null || (function2 = (JSFunction)ObjectUtils.tryCast((Object)parent.getParent(), JSFunction.class)) == null) continue;
            return Pair.create((Object)function2, null);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inferredTypes";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSInferParametersIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSInferParametersIntention";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setInferredTypes";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findSignature";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findParent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

