/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.convertToClass.JSConvertToClassProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public class JSFunctionToES6ClassIntention
extends JavaScriptIntention {
    @TestOnly
    public boolean myGenerateTheWholeTree = false;

    public JSFunctionToES6ClassIntention() {
        this.setText(JavaScriptBundle.message("js.convert.to.es6.class", new Object[0]));
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            JSFunctionToES6ClassIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JSFunctionToES6ClassIntention.$$$reportNull$$$0(1);
        }
        if (!super.isAvailable(project, editor, element) || !DialectDetector.isES6(element) && !DialectDetector.isJSX(element)) {
            return false;
        }
        JSFunction function2 = JSFunctionToES6ClassIntention.getWrappingFunction(element);
        return function2 != null && function2.getName() != null && JSFunctionToES6ClassIntention.checkContext(function2);
    }

    private static boolean checkContext(@NotNull JSFunction function2) {
        PsiElement psiElement;
        PsiElement nameIdentifier;
        if (function2 == null) {
            JSFunctionToES6ClassIntention.$$$reportNull$$$0(2);
        }
        if ((nameIdentifier = function2.getNameIdentifier()) != null && (psiElement = nameIdentifier.getParent()) instanceof JSReferenceExpression) {
            JSReferenceExpression jsRef = (JSReferenceExpression)psiElement;
            if (jsRef.getQualifier() != null) {
                return false;
            }
            if (JSChangeUtil.isWellKnownPredefined(StringUtil.notNullize((String)jsRef.getReferenceName()))) {
                return false;
            }
        }
        if (function2.getParent() instanceof JSClass) {
            return false;
        }
        if (function2.getParent() instanceof TypeScriptObjectType && function2.getParent().getParent() instanceof JSClass) {
            return false;
        }
        return JSFunctionToES6ClassIntention.hasInstanceProperties(function2);
    }

    private static boolean hasInstanceProperties(@NotNull JSFunction function2) {
        String name;
        if (function2 == null) {
            JSFunctionToES6ClassIntention.$$$reportNull$$$0(3);
        }
        String string = name = function2.getQualifiedName() == null ? function2.getName() : function2.getQualifiedName();
        if (name == null) {
            return false;
        }
        GlobalSearchScope searchScope = GlobalSearchScopeUtil.toGlobalSearchScope((SearchScope)function2.getUseScope(), (Project)function2.getProject());
        return !JSClassResolver.getInstance().processNamespaceMembers(name, searchScope, function2.getContainingFile(), (Processor<? super JSPsiElementBase>)((Processor)base -> {
            if (base instanceof JSImplicitElement || base.equals(function2) || JSUtils.isMember((PsiElement)base)) {
                return true;
            }
            if (base.getJSContext() != JSContext.STATIC) {
                return false;
            }
            return !"prototype".equals(base.getName());
        }));
    }

    public static JSFunction getWrappingFunction(@NotNull PsiElement element) {
        JSDefinitionExpression definition2;
        PsiFile file;
        if (element == null) {
            JSFunctionToES6ClassIntention.$$$reportNull$$$0(4);
        }
        if (!((file = element.getContainingFile()) instanceof JSFile) && PsiTreeUtil.getParentOfType((PsiElement)element, JSEmbeddedContent.class) == null) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof JSParameter) {
            parent = parent.getParent();
        }
        if (parent instanceof JSParameterList) {
            parent = parent.getParent();
        }
        if (parent instanceof JSFunction) {
            return (JSFunction)parent;
        }
        if (parent instanceof JSVariable && ((JSVariable)parent).getInitializer() instanceof JSFunction) {
            return (JSFunction)((Object)((JSVariable)parent).getInitializer());
        }
        while (parent instanceof JSReferenceExpression || parent instanceof JSDefinitionExpression) {
            parent = parent.getParent();
        }
        JSDefinitionExpression jSDefinitionExpression = definition2 = parent instanceof JSAssignmentExpression ? ((JSAssignmentExpression)parent).getDefinitionExpression() : null;
        if (definition2 != null && definition2.getInitializer() instanceof JSFunction) {
            return (JSFunction)((Object)definition2.getInitializer());
        }
        return null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        JSFunction function2;
        if (project == null) {
            JSFunctionToES6ClassIntention.$$$reportNull$$$0(5);
        }
        if (element == null) {
            JSFunctionToES6ClassIntention.$$$reportNull$$$0(6);
        }
        if ((function2 = JSFunctionToES6ClassIntention.getWrappingFunction(element)) == null || function2.getName() == null || !JSFunctionToES6ClassIntention.checkContext(function2)) {
            return;
        }
        JSConvertToClassProcessor processor = new JSConvertToClassProcessor(project, EmptyRunnable.getInstance(), function2);
        if (this.myGenerateTheWholeTree) {
            processor.generateTheWholeTree();
        }
        processor.run();
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("js.convert.to.es6.class.family.name", new Object[0]);
        if (string == null) {
            JSFunctionToES6ClassIntention.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSFunctionToES6ClassIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSFunctionToES6ClassIntention";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkContext";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasInstanceProperties";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getWrappingFunction";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

