/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ES6ImportsWorker {
    @Nullable
    public static Pair<ES6ImportDeclaration, ES6ImportExportDeclarationPart> getExistingImport(@NotNull PsiElement scope2, @NotNull String fromText, @Nullable String nameToImport, boolean isFlowType) {
        if (scope2 == null) {
            ES6ImportsWorker.$$$reportNull$$$0(0);
        }
        if (fromText == null) {
            ES6ImportsWorker.$$$reportNull$$$0(1);
        }
        boolean isFlow = DialectDetector.isFlow(scope2);
        List<ES6ImportDeclaration> importDeclarations = ES6ImportPsiUtil.getImportDeclarations(scope2);
        for (ES6ImportDeclaration element : importDeclarations) {
            ASTNode node;
            boolean hasTypeKeyword;
            String quotedFromClauseText = ES6ImportPsiUtil.getFromClauseText(element);
            if (quotedFromClauseText == null || !fromText.equals(StringUtil.unquoteString((String)quotedFromClauseText)) || isFlow && (isFlowType != (hasTypeKeyword = (node = element.getNode()).findChildByType(JSTokenTypes.TYPE_KEYWORD) != null) || node.findChildByType(JSTokenTypes.TYPEOF_KEYWORD) != null)) continue;
            boolean isDefault = "default".equals(nameToImport);
            if (nameToImport != null && !isDefault) {
                ES6ImportSpecifier[] specifiers;
                for (ES6ImportSpecifier importSpecifier : specifiers = element.getImportSpecifiers()) {
                    if (!nameToImport.equals(importSpecifier.getReferenceName())) continue;
                    return Pair.create((Object)element, (Object)importSpecifier);
                }
                Pair<ES6ImportDeclaration, ES6ImportExportDeclarationPart> binding = ES6ImportsWorker.getImportedBinding(element, false);
                if (binding != null) {
                    return binding;
                }
                if (specifiers.length > 0) {
                    return Pair.create((Object)element, null);
                }
            }
            return ES6ImportsWorker.getImportedBinding(element, isDefault);
        }
        return null;
    }

    @Nullable
    private static Pair<ES6ImportDeclaration, ES6ImportExportDeclarationPart> getImportedBinding(ES6ImportDeclaration element, boolean isDefault) {
        ES6ImportedBinding[] bindings;
        for (ES6ImportedBinding binding : bindings = element.getImportedBindings()) {
            if (isDefault && binding.isNamespaceImport()) continue;
            return Pair.create((Object)element, (Object)binding);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "scope";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "fromText";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/intentions/ES6ImportsWorker";
        objectArray[2] = "getExistingImport";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

