/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.hierarchy.type;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.ide.hierarchy.HierarchyBrowser;
import com.intellij.ide.hierarchy.HierarchyProvider;
import com.intellij.ide.hierarchy.NotImplementedHierarchyBrowser;
import com.intellij.ide.hierarchy.TypeHierarchyBrowserBase;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.hierarchy.JSHierarchyUtils;
import com.intellij.lang.javascript.hierarchy.type.jsclass.JSTypeHierarchyBrowser;
import com.intellij.lang.javascript.hierarchy.type.jsfunction.JSFunctionHierarchyBrowser;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeHierarchyProvider
implements HierarchyProvider {
    public PsiElement getTarget(@NotNull DataContext dataContext) {
        PsiFile psiFile2;
        VirtualFile file;
        JSClass jsClass;
        if (dataContext == null) {
            JSTypeHierarchyProvider.$$$reportNull$$$0(0);
        }
        if ((jsClass = JSTypeHierarchyProvider.getJSClass(dataContext)) != null) {
            return jsClass;
        }
        JSPsiElementBase target = JSHierarchyUtils.getElementFromContext(dataContext, JSHierarchyUtils::getTypeHierarchyTargetElement);
        if (target != null && target.isValid() && (file = (psiFile2 = target.getContainingFile()).getVirtualFile()) != null && !"swf".equalsIgnoreCase(file.getExtension()) && !DialectDetector.isActionScript((PsiElement)psiFile2)) {
            return target;
        }
        return null;
    }

    @Nullable
    private static JSClass getJSClass(DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return null;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor != null) {
            JSExpression initializer;
            PsiElement targetElement = TargetElementUtil.findTargetElement((Editor)editor, (int)3);
            if (targetElement instanceof JSClass) {
                return (JSClass)targetElement;
            }
            if (targetElement instanceof JSInitializerOwner && (initializer = ((JSInitializerOwner)targetElement).getInitializer()) instanceof JSClass) {
                return (JSClass)((Object)initializer);
            }
            PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (file instanceof XmlFile) {
                Editor injEditor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit((Editor)editor, (PsiFile)file);
                PsiElement injTargetElement = TargetElementUtil.findTargetElement((Editor)injEditor, (int)3);
                if (injTargetElement instanceof JSClass) {
                    return (JSClass)injTargetElement;
                }
                int offset = editor.getCaretModel().getOffset();
                PsiElement element = file.findElementAt(offset);
                JSClass jsClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)element, JSClass.class);
                if (jsClass != null) {
                    return jsClass;
                }
                if (JavaScriptSupportLoader.isFlexMxmFile(file)) {
                    return XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)file);
                }
            } else if (file instanceof JSFile) {
                int offset = editor.getCaretModel().getOffset();
                PsiElement element = file.findElementAt(offset);
                return (JSClass)PsiTreeUtil.getParentOfType((PsiElement)element, JSClass.class);
            }
        } else {
            PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
            if (element instanceof JSClass) {
                return (JSClass)element;
            }
            if (element instanceof JSFile) {
                return JSPsiImplUtils.findClass((JSFile)element);
            }
            if (element instanceof XmlFile) {
                return XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)element);
            }
        }
        return null;
    }

    @NotNull
    public HierarchyBrowser createHierarchyBrowser(@NotNull PsiElement target) {
        if (target == null) {
            JSTypeHierarchyProvider.$$$reportNull$$$0(1);
        }
        if (target instanceof JSClass) {
            return new JSTypeHierarchyBrowser(target.getProject(), (JSClass)target);
        }
        if (target instanceof JSNamedElement) {
            return new JSFunctionHierarchyBrowser(target.getProject(), (JSNamedElement)target);
        }
        return new NotImplementedHierarchyBrowser(target);
    }

    public void browserActivated(@NotNull HierarchyBrowser hierarchyBrowser) {
        if (hierarchyBrowser == null) {
            JSTypeHierarchyProvider.$$$reportNull$$$0(2);
        }
        if (hierarchyBrowser instanceof JSTypeHierarchyBrowser) {
            JSTypeHierarchyBrowser browser = (JSTypeHierarchyBrowser)hierarchyBrowser;
            String typeName = browser.isInterface() ? TypeHierarchyBrowserBase.getSubtypesHierarchyType() : TypeHierarchyBrowserBase.getTypeHierarchyType();
            browser.changeView(typeName);
        } else if (hierarchyBrowser instanceof JSFunctionHierarchyBrowser) {
            ((JSFunctionHierarchyBrowser)hierarchyBrowser).changeView(TypeHierarchyBrowserBase.getTypeHierarchyType());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hierarchyBrowser";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/hierarchy/type/JSTypeHierarchyProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getTarget";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createHierarchyBrowser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "browserActivated";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

