/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.hierarchy.call;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.lang.javascript.hierarchy.JSHierarchyUtils;
import com.intellij.lang.javascript.hierarchy.call.JSCallHierarchyNodeDescriptor;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.search.JSFunctionsSearch;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public final class JSCalleeMethodsTreeStructure
extends HierarchyTreeStructure {
    private final String myScopeType;

    public JSCalleeMethodsTreeStructure(Project project, PsiElement methodOrOwner, String scopeType) {
        super(project, (HierarchyNodeDescriptor)new JSCallHierarchyNodeDescriptor(project, null, methodOrOwner, true, false));
        this.myScopeType = scopeType;
    }

    protected Object @NotNull [] buildChildren(@NotNull HierarchyNodeDescriptor descriptor) {
        PsiElement enclosingElement;
        if (descriptor == null) {
            JSCalleeMethodsTreeStructure.$$$reportNull$$$0(0);
        }
        if (!((enclosingElement = ((JSCallHierarchyNodeDescriptor)descriptor).getEnclosingElement()) instanceof JSFunction)) {
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                JSCalleeMethodsTreeStructure.$$$reportNull$$$0(1);
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        JSFunction item = (JSFunction)enclosingElement;
        ArrayList<PsiElement> jsSourceElements = new ArrayList<PsiElement>();
        JSBlockStatement block = item.getBlock();
        if (block != null) {
            JSCalleeMethodsTreeStructure.visitor(block, jsSourceElements);
        }
        PsiElement baseMethod = ((JSCallHierarchyNodeDescriptor)this.getBaseDescriptor()).getTargetElement();
        JSClass baseClass = JSResolveUtil.getClassOfContext(baseMethod);
        HashMap<PsiElement, JSCallHierarchyNodeDescriptor> methodToDescriptorMap = new HashMap<PsiElement, JSCallHierarchyNodeDescriptor>();
        ArrayList<JSCallHierarchyNodeDescriptor> result2 = new ArrayList<JSCallHierarchyNodeDescriptor>();
        for (PsiElement element : jsSourceElements) {
            if (!this.isInScope(baseClass, element, this.myScopeType)) continue;
            JSCallHierarchyNodeDescriptor d = (JSCallHierarchyNodeDescriptor)((Object)methodToDescriptorMap.get(element));
            if (d == null) {
                d = new JSCallHierarchyNodeDescriptor(this.myProject, descriptor, element, false, false);
                methodToDescriptorMap.put(element, d);
                result2.add(d);
                continue;
            }
            d.incrementUsageCount();
        }
        JSClass jsClass = JSResolveUtil.getClassOfContext(enclosingElement);
        if (jsClass != null) {
            Query<JSFunction> overridingOrImplementingMethods = jsClass.isInterface() ? JSFunctionsSearch.searchImplementingFunctions(item, true) : JSFunctionsSearch.searchOverridingFunctions(item, true);
            for (JSFunction jsFunction : (JSFunction[])overridingOrImplementingMethods.toArray((Object[])JSFunction.EMPTY_ARRAY)) {
                JSCallHierarchyNodeDescriptor node;
                if (!this.isInScope(baseClass, jsFunction, this.myScopeType) || result2.contains((Object)(node = new JSCallHierarchyNodeDescriptor(this.myProject, descriptor, jsFunction, false, false)))) continue;
                result2.add(node);
            }
        }
        Object[] objectArray = ArrayUtil.toObjectArray(result2);
        if (objectArray == null) {
            JSCalleeMethodsTreeStructure.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    private static void visitor(PsiElement psiElement, ArrayList<PsiElement> methods2) {
        PsiElement[] children;
        for (PsiElement child : children = psiElement.getChildren()) {
            PsiElement element;
            JSCalleeMethodsTreeStructure.visitor(child, methods2);
            if (!(child instanceof JSCallExpression) || (element = JSHierarchyUtils.getJSFunctionOrClass((JSCallExpression)child)) == null) continue;
            methods2.add(element);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/hierarchy/call/JSCalleeMethodsTreeStructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/hierarchy/call/JSCalleeMethodsTreeStructure";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildChildren";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

